﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Binarization
{
    using System;
    using ToolDevelopmentKit;

    [AttributeUsage(AttributeTargets.Property, Inherited = false)]
    public class DomObjectReferenceAttribute : DomCustomProcessorAttribute
    {
        private string originTag = string.Empty;
        private string originPath = string.Empty;
        private bool hasType = false;
        private bool hasOffset = false;
        private bool hasSize = false;
        private SizeType sizeType = SizeType.Size;

        public DomObjectReferenceAttribute()
            : base(typeof(DomObjectWriter))
        {
        }

        public string OriginTag
        {
            get { return this.originTag; }
            set
            {
                Ensure.Argument.NotNull(value);
                this.originTag = value;
            }
        }

        public string OriginPath
        {
            get { return this.originPath; }
            set
            {
                Ensure.Argument.NotNull(value);
                this.originPath = value;
            }
        }

        public bool HasType
        {
            get { return this.hasType; }
            set { this.hasType = value; }
        }

        public bool HasOffset
        {
            get { return this.hasOffset; }
            set { this.hasOffset = value; }
        }

        public bool HasSize
        {
            get { return this.hasSize; }
            set { this.hasSize = value; }
        }

        public SizeType SizeType
        {
            get { return this.sizeType; }
            set { this.sizeType = value; }
        }

        public Type OffsetValueType { get; set; }

        public Type SizeValueType { get; set; }

        protected override IDomObjectProcessor CreateCustomProcessor()
        {
            return new DomObjectReferenceWriter()
            {
                OriginTag = this.originTag,
                OriginPath = this.originPath,
                HasType = this.hasType,
                HasOffset = this.hasOffset,
                HasSize = this.hasSize,
                SizeType = this.sizeType,
                OffsetValueType = this.OffsetValueType,
                SizeValueType = this.SizeValueType,
            };
        }
    }
}
