﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Binarization
{
    using System;
    using ToolDevelopmentKit;
    using ToolDevelopmentKit.Reflection;

    /// <summary>
    /// バイナリファイルのDOM要素です。
    /// </summary>
    public class DomElement : DomObject
    {
        /// <summary>
        /// コンストラクタ。
        /// </summary>
        /// <param name="value">DOM 要素の値を指定します。</param>
        public DomElement(object value)
            : base(value, true)
        {
            if (this.Value is DomObject)
            {
                throw new ArgumentException("obj must not be DomObject.");
            }
        }

        public override DomObject Parent
        {
            get
            {
                // 値が DomElement の場合、リダイレクトします。
                return IsDepended ? this.DependedObject.Parent : base.Parent;
            }
            set
            {
                if (IsDepended)
                {
                    throw new Exception("internal error : this DomObject.Parent is redirected.");
                }

                base.Parent = value;
            }
        }
    }
}
