﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System.Collections.Generic;
using NintendoWare.SoundAdditionalInfoConverter.Logs;
using NintendoWare.SoundAdditionalInfoConverter.Resources;
using NintendoWare.SoundAdditionalInfoConverter.FileFormat;

namespace NintendoWare.SoundAdditionalInfoConverter.Binaries
{
    internal static class StreamJumpDataBinaryBuilder
    {
        internal static StreamJumpDataBinary Build(StreamJumpDataFile streamJumpDataFile)
        {
            StreamJumpDataBinary binary = new StreamJumpDataBinary();

            binary.FileSize = 0;

            binary.OrderCount = streamJumpDataFile.PlayRegionOrders.Count;
            binary.FileSize += sizeof(int);

            if (streamJumpDataFile.PlayRegionOrders != null && streamJumpDataFile.PlayRegionOrders.Count > 0)
            {
                Dictionary<string, int> regionIndexDictionary = new Dictionary<string, int>();
                for (int i = 0; i < streamJumpDataFile.RegionDefinitions.Count; ++i)
                {
                    regionIndexDictionary[streamJumpDataFile.RegionDefinitions[i]] = i;
                }

                foreach (string region in streamJumpDataFile.PlayRegionOrders)
                {
                    if (regionIndexDictionary.ContainsKey(region))
                    {
                        binary.Orders.Add(regionIndexDictionary[region]);
                        binary.FileSize += sizeof(int);
                    }
                    else
                    {
                        Logger.GetInstance().OutputWarning(Messages.Warning_StreamJump_NotExistRegionUsed);
                    }
                }
            }

            return binary;
        }
    }
}
