﻿namespace Opal.Windows
{
    using System;
    using System.Collections.Generic;
    using System.Diagnostics;
    using System.Linq;
    using System.Text;
    using System.Threading.Tasks;
    using System.Windows.Controls;
    using Opal.Plugins;
    using Opal.ViewModels;

    /// <summary>
    /// ウィンドウ作成プラグインの基底クラスです。
    /// </summary>
    public abstract class WindowMakerPlugin : WindowMaker, IPlugin
    {
        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="windowType">ウィンドウタイプです。</param>
        protected WindowMakerPlugin(Type windowType)
            : base(windowType, true)
        {
        }

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="windowType">ウィンドウタイプです。</param>
        /// <param name="isModal">モーダルウィンドウであればtrue、そうでなければfalseを指定します。</param>
        protected WindowMakerPlugin(Type windowType, bool isModal)
            : base(windowType, isModal)
        {
        }
    }
}
