﻿namespace Opal.Windows.Tools
{
    using System;
    using System.Collections.Generic;
    using System.Collections.ObjectModel;
    using System.ComponentModel;
    using System.Diagnostics;
    using System.Linq;
    using System.Text;
    using System.Threading.Tasks;
    using System.Windows.Data;
    using Opal.Utilities;
    using Opal.ViewModels;

    /// <summary>
    /// ツールマネージャークラスです。
    /// </summary>
    public sealed class ToolManager : GroupCacheManager<ToolMaker>, IToolManager
    {
        // TODO: GroupCacheManagerを利用するためのダミーグループ名は要らないのでグループ名がなくても動くようにする。
        private static readonly string DummyGroupName = "dummyGroup";
        private static readonly string ManagerKeyString = Enum.GetName(typeof(ManagerKey), ManagerKey.Tool);
        private readonly Dictionary<string, ToolMaker> fullNameToMaker =
            new Dictionary<string, ToolMaker>();

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        public ToolManager()
        {
        }

        /// <summary>
        /// マネージャーのキーを取得します。
        /// </summary>
        public string Key
        {
            get
            {
                return ManagerKeyString;
            }
        }

        /// <summary>
        /// キーを取得します。
        /// </summary>
        /// <param name="groupName">取得対象のグループです。</param>
        /// <returns>キーを返します。</returns>
        public IEnumerable<string> GetKeys()
        {
            return this.GetKeys(DummyGroupName);
        }

        /// <summary>
        /// ツールメーカーを追加します。
        /// </summary>
        /// <param name="groupName">追加対象のグループ名です。</param>
        /// <param name="key">グループ内のキーです。</param>
        /// <param name="maker">追加するメーカーです。</param>
        public void AddToolMaker(string key, ToolMaker maker)
        {
            lock (this.SyncRoot)
            {
                this.AddValueInternal(DummyGroupName, key, maker);
                this.fullNameToMaker.Add(maker.GetType().FullName, maker);
            }
        }

        /// <summary>
        /// ツールメーカーを取得します。
        /// </summary>
        /// <param name="key">グループ内のキーです。</param>
        /// <returns>メーカーのインスタンスを返します。</returns>
        public ToolMaker GetToolMakerFromKey(string key)
        {
            lock (this.SyncRoot)
            {
                return this.GetValueInternal(DummyGroupName, key);
            }
        }

        /// <summary>
        /// ツールメーカーを取得します。
        /// </summary>
        /// <param name="makerFullName">メーカーのフルネームです。</param>
        /// <returns>メーカーのインスタンスを返します。</returns>
        public ToolMaker GetToolMakerFromName(string makerFullName)
        {
            lock (this.SyncRoot)
            {
                if (this.fullNameToMaker.ContainsKey(makerFullName))
                {
                    return this.fullNameToMaker[makerFullName];
                }

                return null;
            }
        }

        /// <summary>
        /// 全てクリアします。
        /// </summary>
        public void ClearAll()
        {
            this.fullNameToMaker.Clear();
            this.ClearCacheInternal();
        }
    }
}
