﻿namespace Opal.Windows.Tools
{
    using System;
    using System.Collections.Generic;
    using System.Diagnostics;
    using System.Linq;
    using System.Text;
    using System.Threading.Tasks;
    using System.Windows;
    using System.Windows.Controls;
    using Opal.Utilities;
    using Opal.ViewModels;

    /// <summary>
    /// ツール作成抽象クラスです。
    /// </summary>
    public abstract class ToolMaker
    {
        private readonly string key;
        private readonly string label;
        private ToolViewModel toolViewModel = null;

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="key">ツールのキーです。</param>
        /// <param name="label">ツールのラベル名です。</param>
        protected ToolMaker(string key, string label)
        {
            Debug.Assert(!string.IsNullOrWhiteSpace(key));
            Debug.Assert(key.Length >= 3);
            Debug.Assert(label != null);

            this.key = key;
            this.label = label;
        }

        /// <summary>
        /// ツール名などに表示されるラベルを取得します。
        /// </summary>
        public string Label
        {
            get
            {
                return this.label;
            }
        }

        /// <summary>
        /// ツールのキーを取得します。
        /// </summary>
        public string Key
        {
            get
            {
                return this.key;
            }
        }

        /// <summary>
        /// ビューを生成します。
        /// </summary>
        /// <returns>ビューのインスタンスを返します。</returns>
        public abstract Control CreateView();

        /// <summary>
        /// ビューに対応するビューモデルを生成します。
        /// </summary>
        /// <returns>ビューモデルのインスタンスを返します。</returns>
        public abstract ToolViewModel CreateViewModel();

        /// <summary>
        /// ツールを生成します。
        /// </summary>
        /// <returns>ツールビューモデルのインスタンスを返します。</returns>
        internal ToolViewModel CreateTool()
        {
            if (this.toolViewModel == null)
            {
                var view = this.CreateView();
                var viewModel = this.CreateViewModel();
                viewModel.PaneView = view;
                viewModel.ContentId = this.GetType().FullName;
                this.toolViewModel = viewModel;
            }

            return this.toolViewModel;
        }
    }
}
