﻿namespace Opal.Windows.Documents
{
    using System;
    using System.Collections.Generic;
    using System.Collections.ObjectModel;
    using System.ComponentModel;
    using System.Diagnostics;
    using System.Linq;
    using System.Text;
    using System.Threading.Tasks;
    using System.Windows.Data;
    using Opal.Utilities;
    using Opal.ViewModels;

    /// <summary>
    /// ドキュメントマネージャークラスです。
    /// </summary>
    public sealed class DocumentManager : GroupCacheManager<DocumentMaker>, IDocumentManager
    {
        // TODO: GroupCacheManagerを利用するためのダミーグループ名は要らないのでグループ名がなくても動くようにする。
        private static readonly string DummyGroupName = "dummyGroup";
        private static readonly string ManagerKeyString = Enum.GetName(typeof(ManagerKey), ManagerKey.Document);

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        public DocumentManager()
        {
        }

        /// <summary>
        /// マネージャーのキーを取得します。
        /// </summary>
        public string Key
        {
            get
            {
                return ManagerKeyString;
            }
        }

        /// <summary>
        /// ドキュメントメーカーを追加します。
        /// </summary>
        /// <param name="groupName">追加対象のグループ名です。</param>
        /// <param name="key">グループ内のキーです。</param>
        /// <param name="maker">追加するメーカーです。</param>
        public void AddDocumentMaker(string key, DocumentMaker maker)
        {
            this.AddValueInternal(DummyGroupName, key, maker);
        }

        /// <summary>
        /// ドキュメントメーカーを取得します。
        /// </summary>
        /// <param name="groupName">グループ名です。</param>
        /// <param name="key">グループ内のキーです。</param>
        /// <returns>メーカーのインスタンスを返します。</returns>
        public DocumentMaker GetDocumentMaker(string key)
        {
            lock (this.SyncRoot)
            {
                return this.GetValueInternal(DummyGroupName, key);
            }
        }

        /// <summary>
        /// 全てクリアします。
        /// </summary>
        public void ClearAll()
        {
            this.ClearCacheInternal();
        }
    }
}
