﻿namespace Opal.ViewModels
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Text;
    using System.Threading.Tasks;
    using System.Windows.Controls;
    using System.Windows.Media;
    using Opal.Services;

    /// <summary>
    /// ドッキングウィンドウのドッキング単位になるビューモデルクラスです。
    /// </summary>
    public abstract class PaneViewModel : ViewModel, IPane
    {
        private string title = string.Empty;
        private ImageSource iconSource = null;
        private bool isActive = true;
        private Control paneView = null;

        /// <summary>
        /// ビューモデルにバインドするビューを取得設定します。
        /// </summary>
        public Control PaneView
        {
            get
            {
                return this.paneView;
            }

            set
            {
                this.SetProperty(ref this.paneView, value);
            }
        }

        /// <summary>
        /// ドッキング枠タイトル名を取得または設定します。
        /// </summary>
        public string Title
        {
            get
            {
                return this.title;
            }

            set
            {
                this.SetProperty(ref this.title, value);
            }
        }

        /// <summary>
        /// アイコンソースを取得設定します。
        /// </summary>
        public ImageSource IconSource
        {
            get
            {
                return this.iconSource;
            }

            set
            {
                this.SetProperty(ref this.iconSource, value);
            }
        }

        /// <summary>
        /// アクティブ状態を取得設定します。
        /// </summary>
        public bool IsActive
        {
            get
            {
                return this.isActive;
            }

            set
            {
                this.SetProperty(ref this.isActive, value);
                this.OnActiveChanged(new ActiveChangedEventArgs(this.isActive));
            }
        }

        /// <summary>
        /// アクティブ状態が変更された時に実行される処理です。
        /// </summary>
        /// <param name="e">イベント引数です。</param>
        internal virtual void OnActiveChanged(ActiveChangedEventArgs e)
        {
        }
    }
}
