﻿namespace Opal.Utilities
{
    using System;
    using System.Collections.Generic;
    using System.Diagnostics;
    using System.Linq;
    using System.Runtime.CompilerServices;
    using System.Text;
    using System.Threading.Tasks;
    using Opal.Logs;

    /// <summary>
    /// ロガーのユーティリティクラスです。
    /// </summary>
    public static class LoggerUtility
    {
        /// <summary>
        /// デバッグ用のログを追加します。
        /// </summary>
        /// <param name="logger">ログ追加対象のロガーです。</param>
        /// <param name="message">登録するメッセージです。</param>
        /// <param name="fileName">ファイル名です。記述した場所を自動的に入れるので設定不要です。</param>
        /// <param name="fileLine">ファイル行です。記述した場所を自動的に入れるので設定不要です。</param>
        /// <param name="memberName">メンバー名です。記述した場所を自動的に入れるので設定不要です。</param>
        [Conditional("DEBUG")]
        public static void AddDebug(this Logger logger, string message, [CallerFilePath] string fileName = null, [CallerLineNumber] int fileLine = 0, [CallerMemberName] string memberName = null)
        {
            logger.Debug(message, fileName, fileLine, memberName);
        }

        /// <summary>
        /// デバッグ用のログを追加します。
        /// </summary>
        /// <param name="logger">ログ追加対象のロガーです。</param>
        /// <param name="message">登録するメッセージです。</param>
        /// <param name="exception">登録する例外です。</param>
        /// <param name="fileName">ファイル名です。記述した場所を自動的に入れるので設定不要です。</param>
        /// <param name="fileLine">ファイル行です。記述した場所を自動的に入れるので設定不要です。</param>
        /// <param name="memberName">メンバー名です。記述した場所を自動的に入れるので設定不要です。</param>
        [Conditional("DEBUG")]
        public static void AddDebug(this Logger logger, string message, Exception exception, [CallerFilePath] string fileName = null, [CallerLineNumber] int fileLine = 0, [CallerMemberName] string memberName = null)
        {
            logger.Debug(message, exception, fileName, fileLine, memberName);
        }

        /// <summary>
        /// 警告用のログを追加します。
        /// </summary>
        /// <param name="logger">ログ追加対象のロガーです。</param>
        /// <param name="message">登録するメッセージです。</param>
        /// <param name="fileName">ファイル名です。記述した場所を自動的に入れるので設定不要です。</param>
        /// <param name="fileLine">ファイル行です。記述した場所を自動的に入れるので設定不要です。</param>
        /// <param name="memberName">メンバー名です。記述した場所を自動的に入れるので設定不要です。</param>
        public static void AddWarning(this Logger logger, string message, [CallerFilePath] string fileName = null, [CallerLineNumber] int fileLine = 0, [CallerMemberName] string memberName = null)
        {
            logger.Warning(message, fileName, fileLine, memberName);
        }

        /// <summary>
        /// 警告用のログを追加します。
        /// </summary>
        /// <param name="logger">ログ追加対象のロガーです。</param>
        /// <param name="message">登録するメッセージです。</param>
        /// <param name="exception">登録する例外です。</param>
        /// <param name="associatedAction">ログに関連付ける処理です。</param>
        /// <param name="fileName">ファイル名です。記述した場所を自動的に入れるので設定不要です。</param>
        /// <param name="fileLine">ファイル行です。記述した場所を自動的に入れるので設定不要です。</param>
        /// <param name="memberName">メンバー名です。記述した場所を自動的に入れるので設定不要です。</param>
        public static void AddWarning(this Logger logger, string message, Exception exception, Action associatedAction, [CallerFilePath] string fileName = null, [CallerLineNumber] int fileLine = 0, [CallerMemberName] string memberName = null)
        {
            logger.Warning(message, exception, associatedAction, fileName, fileLine, memberName);
        }

        /// <summary>
        /// エラー用のログを追加します。
        /// </summary>
        /// <param name="logger">ログ追加対象のロガーです。</param>
        /// <param name="message">登録するメッセージです。</param>
        /// <param name="fileName">ファイル名です。記述した場所を自動的に入れるので設定不要です。</param>
        /// <param name="fileLine">ファイル行です。記述した場所を自動的に入れるので設定不要です。</param>
        /// <param name="memberName">メンバー名です。記述した場所を自動的に入れるので設定不要です。</param>
        public static void AddError(this Logger logger, string message, [CallerFilePath] string fileName = null, [CallerLineNumber] int fileLine = 0, [CallerMemberName] string memberName = null)
        {
            logger.Error(message, fileName, fileLine, memberName);
        }

        /// <summary>
        /// エラー用のログを追加します。
        /// </summary>
        /// <param name="logger">ログ追加対象のロガーです。</param>
        /// <param name="message">登録するメッセージです。</param>
        /// <param name="exception">例外処理のインスタンスです。ログに例外時の情報を入力したい場合に使用します。</param>
        /// <param name="associatedAction">ログに関連付ける処理です。</param>
        /// <param name="fileName">ファイル名です。記述した場所を自動的に入れるので設定不要です。</param>
        /// <param name="fileLine">ファイル行です。記述した場所を自動的に入れるので設定不要です。</param>
        /// <param name="memberName">メンバー名です。記述した場所を自動的に入れるので設定不要です。</param>
        public static void AddError(this Logger logger, string message, Exception exception, Action associatedAction, [CallerFilePath] string fileName = null, [CallerLineNumber] int fileLine = 0, [CallerMemberName] string memberName = null)
        {
            logger.Error(message, exception, associatedAction, fileName, fileLine, memberName);
        }

        /// <summary>
        /// ユーザ通知用メッセージログを追加します。
        /// </summary>
        /// <param name="logger">ログ追加対象のロガーです。</param>
        /// <param name="message">登録するメッセージです。</param>
        /// <param name="fileName">ファイル名です。記述した場所を自動的に入れるので設定不要です。</param>
        /// <param name="fileLine">ファイル行です。記述した場所を自動的に入れるので設定不要です。</param>
        /// <param name="memberName">メンバー名です。記述した場所を自動的に入れるので設定不要です。</param>
        public static void AddUserMessage(this Logger logger, string message, [CallerFilePath] string fileName = null, [CallerLineNumber] int fileLine = 0, [CallerMemberName] string memberName = null)
        {
            logger.UserMessage(message, fileName, fileLine, memberName);
        }

        /// <summary>
        /// 情報用のログを追加します。
        /// </summary>
        /// <param name="logger">ログ追加対象のロガーです。</param>
        /// <param name="message">登録するメッセージです。</param>
        /// <param name="fileName">ファイル名です。記述した場所を自動的に入れるので設定不要です。</param>
        /// <param name="fileLine">ファイル行です。記述した場所を自動的に入れるので設定不要です。</param>
        /// <param name="memberName">メンバー名です。記述した場所を自動的に入れるので設定不要です。</param>
        public static void AddInfo(this Logger logger, string message, [CallerFilePath] string fileName = null, [CallerLineNumber] int fileLine = 0, [CallerMemberName] string memberName = null)
        {
            logger.Info(message, fileName, fileLine, memberName);
        }

        /// <summary>
        /// 情報用のログを追加します。
        /// </summary>
        /// <param name="logger">ログ追加対象のロガーです。</param>
        /// <param name="message">登録するメッセージです。</param>
        /// <param name="exception">登録する例外です。</param>
        /// <param name="fileName">ファイル名です。記述した場所を自動的に入れるので設定不要です。</param>
        /// <param name="fileLine">ファイル行です。記述した場所を自動的に入れるので設定不要です。</param>
        /// <param name="memberName">メンバー名です。記述した場所を自動的に入れるので設定不要です。</param>
        public static void AddInfo(this Logger logger, string message, Exception exception, [CallerFilePath] string fileName = null, [CallerLineNumber] int fileLine = 0, [CallerMemberName] string memberName = null)
        {
            logger.Info(message, exception, fileName, fileLine, memberName);
        }
    }
}
