﻿namespace Opal.Utilities
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Text;
    using System.Threading.Tasks;

    /// <summary>
    /// マネージャを特定するキーです。
    /// </summary>
    public enum ManagerKey
    {
        /// <summary>
        /// オペレーション管理のキーです。
        /// </summary>
        Operation,

        /// <summary>
        /// ログ管理のキーです。
        /// </summary>
        Log,

        /// <summary>
        /// ペイン管理のキーです。
        /// </summary>
        Pane,

        /// <summary>
        /// メニュー管理のキーです。
        /// </summary>
        Menu,

        /// <summary>
        /// コンフィグ管理のキーです。
        /// </summary>
        Config,

        /// <summary>
        /// ストレージ管理のキーです。
        /// </summary>
        Storage,

        /// <summary>
        /// ドキュメント管理のキーです。
        /// </summary>
        Document,

        /// <summary>
        /// ツール管理のキーです。
        /// </summary>
        Tool,

        /// <summary>
        /// ウィンドウ管理のキーです。
        /// </summary>
        Window,

        /// <summary>
        /// ジョブ管理のキーです。
        /// </summary>
        Job
    }

    /// <summary>
    /// なにかしらを管理するインターフェースです。
    /// </summary>
    public interface IAnyManager
    {
        /// <summary>
        /// マネージャーのキーを取得します。
        /// </summary>
        string Key { get; }
    }
}
