﻿namespace Opal.Utilities
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Linq.Expressions;
    using System.Text;
    using System.Threading.Tasks;

    /// <summary>
    /// エクスプレッションユーティリティクラスです。
    /// </summary>
    public static class ExpressionUtility
    {
        /// <summary>
        /// プロパティ取得のデリゲートを作成します。
        /// </summary>
        /// <typeparam name="TTarget">対象のテンプレートの型です。</typeparam>
        /// <typeparam name="TProperty">プロパティのテンプレートの型です。</typeparam>
        /// <param name="propertyName">プロパティ名です。</param>
        /// <returns>プロパティ取得のデリゲートを返します。</returns>
        public static Func<TTarget, TProperty> MakeGetterProperty<TTarget, TProperty>(string propertyName)
        {
            var type = typeof(TTarget);
            var target = Expression.Parameter(typeof(TTarget), type.Name);
            var targetExpression = Expression.Convert(target, type);
            var memberExpression = Expression.PropertyOrField(targetExpression, propertyName);
            var body = Expression.Convert(memberExpression, typeof(TProperty));
            var lambda = Expression.Lambda<Func<TTarget, TProperty>>(body, target);
            return lambda.Compile();
        }

        /// <summary>
        /// プロパティ設定のデリゲートを作成します。
        /// </summary>
        /// <typeparam name="TTarget">対象のテンプレートの型です。</typeparam>
        /// <typeparam name="TProperty">プロパティのテンプレートの型です。</typeparam>
        /// <param name="propertyName">プロパティ名です。</param>
        /// <returns>プロパティ設定のデリゲートを返します。</returns>
        public static Action<TTarget, TProperty> MakeSetterProperty<TTarget, TProperty>(string propertyName)
        {
            var type = typeof(TTarget);
            var target = Expression.Parameter(typeof(TTarget), type.Name);
            var value = Expression.Parameter(typeof(TProperty), "value");
            var targetExpression = Expression.Convert(target, type);
            var memberExpression = Expression.PropertyOrField(targetExpression, propertyName);
            var setterExpression = Expression.Convert(value, memberExpression.Type);
            var lambda = Expression.Lambda<Action<TTarget, TProperty>>(
                Expression.Assign(memberExpression, setterExpression), target, value);
            return lambda.Compile();
        }
    }
}
