﻿namespace Opal.Utilities
{
    using System.Collections.Generic;

    /// <summary>
    /// プログラムオプションを管理します。
    /// </summary>
    public class ProgramOption
    {
        private List<ArgumentOption> options = new List<ArgumentOption>();
        private List<FileOption> fileOptions = new List<FileOption>();

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        public ProgramOption()
        {
        }

        ////---------------------------------------------------------------------

        /// <summary>
        /// オプションです。
        /// </summary>
        public List<ArgumentOption> Options
        {
            get
            {
                return this.options;
            }
        }

        /// <summary>
        /// ファイルオプションです。
        /// </summary>
        public List<FileOption> FileOptions
        {
            get
            {
                return this.fileOptions;
            }
        }

        ////---------------------------------------------------------------------

        /// <summary>
        /// オプションを取得します。
        /// </summary>
        /// <param name="optionName">オプションの名前です。</param>
        /// <returns>オプションを返します。</returns>
        public ArgumentOption GetOption(string optionName)
        {
            return this.Options.Find(
                delegate(ArgumentOption mutch) { return mutch.Name == optionName; });
        }

        /// <summary>
        /// オプションの有無を取得します。
        /// </summary>
        /// <param name="optionName">オプションの名前です。</param>
        /// <returns>オプションがある場合には true を返します。</returns>
        public bool HasOption(string optionName)
        {
            return this.GetOption(optionName) != null;
        }
    }
}
