﻿namespace Opal.Storages
{
    using System;
    using System.Diagnostics;

    /// <summary>
    /// ストレージが変化した時のイベント引数クラスです。
    /// </summary>
    public class StorageChangedEventArgs : EventArgs
    {
        private readonly Storage target;
        private readonly object value;

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="target">変化対象のストレージです。</param>
        /// <param name="value">変化した値です。</param>
        internal StorageChangedEventArgs(Storage target, object value)
        {
            Debug.Assert(target != null);
            Debug.Assert(value != null);

            this.target = target;
            this.value = value;
        }

        /// <summary>
        /// 変化対象のストレージを取得します。
        /// </summary>
        public Storage Target
        {
            get
            {
                return this.target;
            }
        }

        /// <summary>
        /// 変化した値を取得します。
        /// </summary>
        public object Value
        {
            get
            {
                return this.value;
            }
        }
    }
}
