﻿namespace Opal.Services
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Text;
    using System.Threading.Tasks;
    using System.Windows.Input;

    /// <summary>
    /// ツールインターフェースです。
    /// </summary>
    public interface ITool : IPane
    {
        /// <summary>
        /// 推奨の配置を取得します。
        /// </summary>
        PaneLocation PreferredLocation { get; }

        /// <summary>
        /// 推奨の幅を取得します。
        /// </summary>
        double PreferredWidth { get; }

        /// <summary>
        /// 推奨の高さを取得します。
        /// </summary>
        double PreferredHeight { get; }

        /// <summary>
        /// 閉じる処理のコマンドを取得します。
        /// </summary>
        ICommand CloseCommand { get; }

        /// <summary>
        /// コンテントIDを取得します。
        /// </summary>
        string ContentId { get; }

        /// <summary>
        /// 選択状態を取得設定します。
        /// </summary>
        bool IsSelected { get; set; }

        /// <summary>
        /// 可視状態を取得設定します。
        /// </summary>
        bool IsVisible { get; set; }
    }
}
