﻿namespace Opal.Logs
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Text;
    using System.Threading.Tasks;
    using Opal.Utilities;

    /// <summary>
    /// ログ管理のインターフェースです。
    /// </summary>
    public interface ILogManager : IAnyManager
    {
        /// <summary>
        /// ログ処理クラスを取得します。
        /// </summary>
        /// <typeparam name="TConductor">ログ処理クラスのテンプレートの型です。</typeparam>
        /// <returns>ログ処理クラスのインスタンスを返します。</returns>
        TConductor GetConductor<TConductor>() where TConductor : LogConductor;

        /// <summary>
        /// ロガーをプッシュします。
        /// </summary>
        /// <param name="logger">プッシュ対象のロガーです。</param>
        void PushLogger(Logger logger);

        /// <summary>
        /// ログ全体をフラッシュします。
        /// </summary>
        void FlushAll();
    }
}
