﻿namespace Opal.ComponentModel
{
    using System;
    using System.Collections.Generic;
    using System.Diagnostics;
    using System.Linq;
    using System.Text;
    using System.Threading.Tasks;

    /// <summary>
    /// 破棄処理可能なオブジェクトです。
    /// </summary>
    public abstract class DisposableObject : SynchronizableObject, IDisposable
    {
        private bool disposed = false;

        /// <summary>
        /// デストラクタです。
        /// </summary>
        ~DisposableObject()
        {
            //// Dispose前に実行された場合はアサート
            Debug.Assert(!this.disposed);
        }

        /// <summary>
        /// オブジェクトを破棄します。
        /// </summary>
        public void Dispose()
        {
            this.Dispose(true);
            GC.SuppressFinalize(this);
        }

        /// <summary>
        /// オブジェクト破棄の内部処理です。継承した先で固有の処理を実装します。
        /// </summary>
        protected abstract void DisposeInternal();

        /// <summary>
        /// オブジェクトを破棄します。
        /// </summary>
        /// <param name="disposing">true時に破棄処理を行います。</param>
        protected void Dispose(bool disposing)
        {
            if (this.disposed)
            {
                return;
            }

            if (disposing)
            {
                this.DisposeInternal();
            }

            this.disposed = true;
        }
    }
}
