﻿// ========================================================================
// <copyright file="VersionInformation.cs" company="Nintendo">
//      Copyright 2013 Nintendo.  All rights reserved.
// </copyright>
//
// These coded instructions, statements, and computer programs contain
// proprietary information of Nintendo of America Inc. and/or Nintendo
// Company Ltd., and are protected by Federal copyright law.  They may
// not be disclosed to third parties or copied or duplicated in any form,
// in whole or in part, without the prior written consent of Nintendo.
// ========================================================================

namespace Opal.Tentatives.Utilities
{
    using System;
    using System.Diagnostics;
    using System.Reflection;

    /// <summary>
    /// バージョン情報です。
    /// </summary>
    public static class VersionInformation
    {
        /// <summary>
        /// 会社名を取得します。
        /// </summary>
        public const string Company = "Nintendo Co., Ltd.";

        /// <summary>
        /// コピーライトを取得します。
        /// </summary>
        public const string Copyright = "Copyright (C)2013 Nintendo Co., Ltd. All rights reserved.";

        /// <summary>
        /// 名前を取得します。
        /// </summary>
        public static string Name
        {
            get
            {
                Assembly entry = Assembly.GetEntryAssembly();
                return entry.GetName().Name;
            }
        }

        /// <summary>
        /// バージョンを取得します。
        /// </summary>
        public static string Version
        {
            get
            {
                Assembly entry = Assembly.GetEntryAssembly();
                return FileVersionInfo.GetVersionInfo(entry.Location).ProductVersion;
            }
        }

        /// <summary>
        /// ビルド日時を取得します。
        /// </summary>
        public static DateTime BuildDateTime
        {
            get
            {
                Assembly entry = Assembly.GetEntryAssembly();
                Version version = entry.GetName().Version;
                DateTime buildDate = new DateTime(2000, 1, 1, 0, 0, 0);
                buildDate = buildDate.AddDays((double)version.Build);
                buildDate = buildDate.AddSeconds((double)version.Revision * 2.0);
                return buildDate;
            }
        }

        /// <summary>
        /// リビジョンを取得します。
        /// </summary>
        public static string Revision
        {
            get
            {
                Assembly entry = Assembly.GetEntryAssembly();
                FileVersionInfo fileVersionInfo = FileVersionInfo.GetVersionInfo(entry.Location);
                string[] versions = fileVersionInfo.FileVersion.Split('.');
                Debug.Assert(versions.Length == 4);
                return versions[3];
            }
        }

        /// <summary>
        /// バージョン情報を取得します。
        /// </summary>
        /// <returns>バージョン情報を返します。</returns>
        public static string GetVersionInformation()
        {
            return string.Format(
                "{0} {1}  Rev.{2} ({3})\r\n  {4}\r\n",
                VersionInformation.Name,
                VersionInformation.Version,
                VersionInformation.Revision,
                VersionInformation.BuildDateTime,
                VersionInformation.Copyright);
        }
    }
}
