﻿using Nintendo.G3dTool.Entities;
using nw.g3d.nw4f_3dif;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Nintendo.G3dTool.Extensions
{
    public static class ShaderAssignExtensions
    {
        public static RenderInfo CreateRenderInfo(this ShaderAssign target, RenderInfoSlot renderInfoDef)
        {
            RenderInfo renderInfo = CreateRenderInfo(renderInfoDef);
            target.RenderInfos.Add(renderInfo);
            return renderInfo;
        }

        private static RenderInfo CreateRenderInfo(RenderInfoSlot renderInfoDef)
        {
            switch (renderInfoDef.Type)
            {
                case render_info_slot_typeType.@int:
                    {
                        var renderInfo = new RenderInfoInt() { Name = renderInfoDef.Name };
                        var def = renderInfoDef as RenderInfoSlotInt;
                        renderInfo.Values.Add(def.Default);
                        return renderInfo;
                    }
                case render_info_slot_typeType.@float:
                    {
                        var renderInfo = new RenderInfoFloat() { Name = renderInfoDef.Name };
                        var def = renderInfoDef as RenderInfoSlotFloat;
                        renderInfo.Values.Add(def.Default);
                        return renderInfo;
                    }
                case render_info_slot_typeType.@string:
                    {
                        var renderInfo = new RenderInfoString() { Name = renderInfoDef.Name };
                        var def = renderInfoDef as RenderInfoSlotString;
                        renderInfo.Values.Add(def.Default);
                        return renderInfo;
                    }
                default:
                    throw new Exception("Unexpected default");
            }
        }
    }
}
