﻿using Nintendo.G3dTool.Entities;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Nintendo.G3dTool.Extensions
{
    public static class AttribAssignExtensions
    {
        public static void SetToDefault(this AttribAssign target, AttribVar attrVar, IEnumerable<VtxAttrib> vtxAttribs)
        {
            target.Id = attrVar.Id;
            var defaultAttr = vtxAttribs.FirstOrDefault(x => x.Hint == attrVar.Hint);
            if (defaultAttr != null)
            {
                target.AttribName = defaultAttr.Name;
            }
        }

        public static void SetToDefault(this AttribAssign target, AttribVar attrVar, Model model, string materialName)
        {
            var vtxAttribs = model.Shapes.Where(x => x.ShapeInfo.MatName == materialName).SelectMany(x => x.ShapeInfo.Vertex.VtxAttribs);
            target.Id = attrVar.Id;
            var defaultAttr = vtxAttribs.FirstOrDefault(x => x.Hint == attrVar.Hint);
            if (defaultAttr != null)
            {
                target.AttribName = defaultAttr.Name;
            }
        }
    }
}
