﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.ComponentModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml;
using nw.g3d.nw4f_3dif;
using Opal.Security.Cryptography;
using Nintendo.ToolFoundation.Collections;
using Nintendo.ToolFoundation.Contracts;
using Nintendo.G3dTool.Entities.Internal;

namespace Nintendo.G3dTool.Entities
{
    public class SkeletalAnimInfo : ObservableEntity<skeletal_anim_infoType>, IDeepCopyable<SkeletalAnimInfo>, IDeepCopyFrom<SkeletalAnimInfo>
    {
        private int @frameCount;
        private bool @loop;
        private int @frameResolution = 1;
        private string @dccPreset = string.Empty;
        private float @dccMagnify = 1;
        private int @dccStartFrame;
        private int @dccEndFrame;
        private float @dccFps = 1;
        private bool @bakeAll;
        private skeletal_anim_info_scale_modeType @scaleMode = skeletal_anim_info_scale_modeType.standard;
        private skeletal_anim_info_rotate_modeType @rotateMode = skeletal_anim_info_rotate_modeType.euler_xyz;
        private float @bakeToleranceScale;
        private float @bakeToleranceRotate;
        private float @bakeToleranceTranslate;
        private float @quantizeToleranceScale;
        private float @quantizeToleranceRotate;
        private float @quantizeToleranceTranslate;

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        public SkeletalAnimInfo()
        {
        }

        /// <summary>
        /// コピーコンストラクタです。
        /// </summary>
        /// <param name="source">設定するデータです。</param>
        public SkeletalAnimInfo(SkeletalAnimInfo source)
            : this()
        {
            this.DeepCopyFrom(source);
        }

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="source">設定するデータです。</param>
        public SkeletalAnimInfo(skeletal_anim_infoType source)
        {
            this.@frameCount = source.@frame_count;
            this.@loop = source.@loop;
            this.@frameResolution = source.@frame_resolution;
            this.@dccPreset = source.@dcc_preset;
            this.@dccMagnify = source.@dcc_magnify;
            this.@dccStartFrame = source.@dcc_start_frame;
            this.@dccEndFrame = source.@dcc_end_frame;
            this.@dccFps = source.@dcc_fps;
            this.@bakeAll = source.@bake_all;
            this.@scaleMode = source.@scale_mode;
            this.@rotateMode = source.@rotate_mode;
            this.@bakeToleranceScale = source.@bake_tolerance_scale;
            this.@bakeToleranceRotate = source.@bake_tolerance_rotate;
            this.@bakeToleranceTranslate = source.@bake_tolerance_translate;
            this.@quantizeToleranceScale = source.@quantize_tolerance_scale;
            this.@quantizeToleranceRotate = source.@quantize_tolerance_rotate;
            this.@quantizeToleranceTranslate = source.@quantize_tolerance_translate;
        }

        public int FrameCount
        {
            get
            {
                return this.@frameCount;
            }

            set
            {
                if (this.@frameCount == value)
                {
                    return;
                }

                this.SetProperty(ref this.@frameCount, value, () => this.CalcCRC());
            }
        }

        public bool Loop
        {
            get
            {
                return this.@loop;
            }

            set
            {
                if (this.@loop == value)
                {
                    return;
                }

                this.SetProperty(ref this.@loop, value, () => this.CalcCRC());
            }
        }

        public int FrameResolution
        {
            get
            {
                return this.@frameResolution;
            }

            set
            {
                if (this.@frameResolution == value)
                {
                    return;
                }

                this.SetProperty(ref this.@frameResolution, value, () => this.CalcCRC());
            }
        }

        public string DccPreset
        {
            get
            {
                return this.@dccPreset;
            }

            set
            {
                if (this.@dccPreset == value)
                {
                    return;
                }

                Ensure.Argument.NotNull(value);
                this.SetProperty(ref this.@dccPreset, value, () => this.CalcCRC());
            }
        }

        public float DccMagnify
        {
            get
            {
                return this.@dccMagnify;
            }

            set
            {
                if (this.@dccMagnify == value)
                {
                    return;
                }

                this.SetProperty(ref this.@dccMagnify, value, () => this.CalcCRC());
            }
        }

        public int DccStartFrame
        {
            get
            {
                return this.@dccStartFrame;
            }

            set
            {
                if (this.@dccStartFrame == value)
                {
                    return;
                }

                this.SetProperty(ref this.@dccStartFrame, value, () => this.CalcCRC());
            }
        }

        public int DccEndFrame
        {
            get
            {
                return this.@dccEndFrame;
            }

            set
            {
                if (this.@dccEndFrame == value)
                {
                    return;
                }

                this.SetProperty(ref this.@dccEndFrame, value, () => this.CalcCRC());
            }
        }

        public float DccFps
        {
            get
            {
                return this.@dccFps;
            }

            set
            {
                if (this.@dccFps == value)
                {
                    return;
                }

                this.SetProperty(ref this.@dccFps, value, () => this.CalcCRC());
            }
        }

        public bool BakeAll
        {
            get
            {
                return this.@bakeAll;
            }

            set
            {
                if (this.@bakeAll == value)
                {
                    return;
                }

                this.SetProperty(ref this.@bakeAll, value, () => this.CalcCRC());
            }
        }

        public skeletal_anim_info_scale_modeType ScaleMode
        {
            get
            {
                return this.@scaleMode;
            }

            set
            {
                if (this.@scaleMode == value)
                {
                    return;
                }

                this.SetProperty(ref this.@scaleMode, value, () => this.CalcCRC());
            }
        }

        public skeletal_anim_info_rotate_modeType RotateMode
        {
            get
            {
                return this.@rotateMode;
            }

            set
            {
                if (this.@rotateMode == value)
                {
                    return;
                }

                this.SetProperty(ref this.@rotateMode, value, () => this.CalcCRC());
            }
        }

        public float BakeToleranceScale
        {
            get
            {
                return this.@bakeToleranceScale;
            }

            set
            {
                if (this.@bakeToleranceScale == value)
                {
                    return;
                }

                this.SetProperty(ref this.@bakeToleranceScale, value, () => this.CalcCRC());
            }
        }

        public float BakeToleranceRotate
        {
            get
            {
                return this.@bakeToleranceRotate;
            }

            set
            {
                if (this.@bakeToleranceRotate == value)
                {
                    return;
                }

                this.SetProperty(ref this.@bakeToleranceRotate, value, () => this.CalcCRC());
            }
        }

        public float BakeToleranceTranslate
        {
            get
            {
                return this.@bakeToleranceTranslate;
            }

            set
            {
                if (this.@bakeToleranceTranslate == value)
                {
                    return;
                }

                this.SetProperty(ref this.@bakeToleranceTranslate, value, () => this.CalcCRC());
            }
        }

        public float QuantizeToleranceScale
        {
            get
            {
                return this.@quantizeToleranceScale;
            }

            set
            {
                if (this.@quantizeToleranceScale == value)
                {
                    return;
                }

                this.SetProperty(ref this.@quantizeToleranceScale, value, () => this.CalcCRC());
            }
        }

        public float QuantizeToleranceRotate
        {
            get
            {
                return this.@quantizeToleranceRotate;
            }

            set
            {
                if (this.@quantizeToleranceRotate == value)
                {
                    return;
                }

                this.SetProperty(ref this.@quantizeToleranceRotate, value, () => this.CalcCRC());
            }
        }

        public float QuantizeToleranceTranslate
        {
            get
            {
                return this.@quantizeToleranceTranslate;
            }

            set
            {
                if (this.@quantizeToleranceTranslate == value)
                {
                    return;
                }

                this.SetProperty(ref this.@quantizeToleranceTranslate, value, () => this.CalcCRC());
            }
        }

        /// <summary>
        /// 出力データを作成します。
        /// </summary>
        /// <returns>出力データのインスタンスを返します。</returns>
        public override skeletal_anim_infoType CreateSerializableData()
        {
            var writeData = new skeletal_anim_infoType();
            writeData.@frame_count = this.FrameCount;
            writeData.@loop = this.Loop;
            writeData.@frame_resolution = this.FrameResolution;
            writeData.@dcc_preset = this.DccPreset;
            writeData.@dcc_magnify = this.DccMagnify;
            writeData.@dcc_start_frame = this.DccStartFrame;
            writeData.@dcc_end_frame = this.DccEndFrame;
            writeData.@dcc_fps = this.DccFps;
            writeData.@bake_all = this.BakeAll;
            writeData.@scale_mode = this.ScaleMode;
            writeData.@rotate_mode = this.RotateMode;
            writeData.@bake_tolerance_scale = this.BakeToleranceScale;
            writeData.@bake_tolerance_rotate = this.BakeToleranceRotate;
            writeData.@bake_tolerance_translate = this.BakeToleranceTranslate;
            writeData.@quantize_tolerance_scale = this.QuantizeToleranceScale;
            writeData.@quantize_tolerance_rotate = this.QuantizeToleranceRotate;
            writeData.@quantize_tolerance_translate = this.QuantizeToleranceTranslate;
            return writeData;
        }

        /// <summary>
        /// 現在のインスタンスをディープコピーで複製した新規インスタンスを返します。
        /// </summary>
        SkeletalAnimInfo IDeepCopyable<SkeletalAnimInfo>.DeepCopy()
        {
            return new SkeletalAnimInfo(this);
        }

        /// <summary>
        /// 入力ファイルからディープコピーします。
        /// </summary>
        /// <param name="source">コピー元となる入力ファイルです。</param>
        public void DeepCopyFrom(SkeletalAnimInfo source)
        {
            this.@frameCount = source.@frameCount;
            this.@loop = source.@loop;
            this.@frameResolution = source.@frameResolution;
            this.@dccPreset = source.@dccPreset;
            this.@dccMagnify = source.@dccMagnify;
            this.@dccStartFrame = source.@dccStartFrame;
            this.@dccEndFrame = source.@dccEndFrame;
            this.@dccFps = source.@dccFps;
            this.@bakeAll = source.@bakeAll;
            this.@scaleMode = source.@scaleMode;
            this.@rotateMode = source.@rotateMode;
            this.@bakeToleranceScale = source.@bakeToleranceScale;
            this.@bakeToleranceRotate = source.@bakeToleranceRotate;
            this.@bakeToleranceTranslate = source.@bakeToleranceTranslate;
            this.@quantizeToleranceScale = source.@quantizeToleranceScale;
            this.@quantizeToleranceRotate = source.@quantizeToleranceRotate;
            this.@quantizeToleranceTranslate = source.@quantizeToleranceTranslate;
        }

        /// <summary>
        /// エンティティの CRC を作成します。（内部処理用）
        /// </summary>
        /// <returns>CRC の値を返します。</returns>
        protected override uint CreateCRCInternal()
        {
            CRC32 crc = new CRC32();
            List<byte> buffers = new List<byte>();
            buffers.AddRange(BitConverter.GetBytes(crc.ComputeHashUInt32(this.FrameCount)));
            buffers.AddRange(BitConverter.GetBytes(crc.ComputeHashUInt32(this.Loop)));
            buffers.AddRange(BitConverter.GetBytes(crc.ComputeHashUInt32(this.FrameResolution)));
            buffers.AddRange(BitConverter.GetBytes(crc.ComputeHashUInt32(this.DccPreset)));
            buffers.AddRange(BitConverter.GetBytes(crc.ComputeHashUInt32(this.DccMagnify)));
            buffers.AddRange(BitConverter.GetBytes(crc.ComputeHashUInt32(this.DccStartFrame)));
            buffers.AddRange(BitConverter.GetBytes(crc.ComputeHashUInt32(this.DccEndFrame)));
            buffers.AddRange(BitConverter.GetBytes(crc.ComputeHashUInt32(this.DccFps)));
            buffers.AddRange(BitConverter.GetBytes(crc.ComputeHashUInt32(this.BakeAll)));
            buffers.AddRange(BitConverter.GetBytes(crc.ComputeHashUInt32(this.ScaleMode)));
            buffers.AddRange(BitConverter.GetBytes(crc.ComputeHashUInt32(this.RotateMode)));
            buffers.AddRange(BitConverter.GetBytes(crc.ComputeHashUInt32(this.BakeToleranceScale)));
            buffers.AddRange(BitConverter.GetBytes(crc.ComputeHashUInt32(this.BakeToleranceRotate)));
            buffers.AddRange(BitConverter.GetBytes(crc.ComputeHashUInt32(this.BakeToleranceTranslate)));
            buffers.AddRange(BitConverter.GetBytes(crc.ComputeHashUInt32(this.QuantizeToleranceScale)));
            buffers.AddRange(BitConverter.GetBytes(crc.ComputeHashUInt32(this.QuantizeToleranceRotate)));
            buffers.AddRange(BitConverter.GetBytes(crc.ComputeHashUInt32(this.QuantizeToleranceTranslate)));
            return crc.ComputeHashUInt32(buffers.ToArray());
        }
    }
}
