﻿namespace Nintendo.G3dTool.Entities
{
    using Nintendo.G3dTool.Entities.Internal;
    using Nintendo.ToolFoundation.Collections;
    using Nintendo.ToolFoundation.Contracts;
    using System;
    using System.Collections.Generic;
    using System.Diagnostics;
    using System.Linq;
    using System.Text;
    using System.Threading.Tasks;

    /// <summary>
    /// ルートエンティティの基底クラスです。
    /// </summary>
    /// <typeparam name="T">エンティティタイプのテンプレートの型です。</typeparam>
    public abstract class RootEntity<T> : ObservableEntity<T>, IRootEntity where T : class
    {
        private bool isStreamSerializationEnabled = true;

        // 複数種類の親を持つケースがあるので IEntity 型の親として設定する
        private IEntity parent = null;

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        public RootEntity()
        {
        }

        public bool IsStreamSerializationEnabled
        {
            get
            {
                return this.isStreamSerializationEnabled;
            }

            set
            {
                this.SetProperty(ref this.isStreamSerializationEnabled, value);
            }
        }

        public IEntity Parent
        {
            get
            {
                return (this as IChildEntity).Parent;
            }
        }

        IEntity IChildEntity.Parent
        {
            get
            {
                return parent;
            }

            set
            {
                Ensure.Argument.True((value == null) || (this is Material ? (value is IntermediateFile || value is Model) : (value is IntermediateFile)));
                SetProperty<IEntity>(ref this.parent, value, () => CalcCRC());
            }
        }

        Type IChildEntity.ParentType
        {
            get
            {
                return typeof(IEntity);
            }
        }

        public abstract ObservableList<Stream> Streams { get; }

        public abstract void ResolveInternalReferences();

        IRootEntity IDeepCopyable<IRootEntity>.DeepCopy()
        {
            return this.DeepCopy();
        }

        void IDeepCopyFrom<IRootEntity>.DeepCopyFrom(IRootEntity source)
        {
            this.DeepCopyFrom(source);
        }

        private protected abstract void DeepCopyFrom(IRootEntity source);

        private protected abstract IRootEntity DeepCopy();
    }
}
