﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.ComponentModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml;
using nw.g3d.nw4f_3dif;
using Opal.Security.Cryptography;
using Nintendo.ToolFoundation.Collections;
using Nintendo.ToolFoundation.Contracts;
using Nintendo.G3dTool.Entities.Internal;

namespace Nintendo.G3dTool.Entities
{
    public class OptionVar : ObservableEntity<option_varType>, IUiElementHolder, IDeepCopyable<OptionVar>, IDeepCopyFrom<OptionVar>, IDisposable
    {
        private readonly VertexSymbol @vertexSymbol = new VertexSymbol();
        private readonly GeometrySymbol @geometrySymbol = new GeometrySymbol();
        private readonly FragmentSymbol @fragmentSymbol = new FragmentSymbol();
        private readonly ComputeSymbol @computeSymbol = new ComputeSymbol();
        private UiLabel @uiLabel = null;
        private UiComment @uiComment = null;
        private UiGroup @uiGroup = null;
        private UiOrder @uiOrder = null;
        private UiItem @uiItem = null;
        private UiVisible @uiVisible = null;
        private string @id = string.Empty;
        private option_var_typeType @type;
        private readonly ShaderOptionChoice @choice = new ShaderOptionChoice();
        private string @default = string.Empty;
        private bool @branch;

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        public OptionVar()
        {
            this.@vertexSymbol.PropertyChanged += this.OnPropertyChanged;
            this.@geometrySymbol.PropertyChanged += this.OnPropertyChanged;
            this.@fragmentSymbol.PropertyChanged += this.OnPropertyChanged;
            this.@computeSymbol.PropertyChanged += this.OnPropertyChanged;
            this.@choice.PropertyChanged += this.OnPropertyChanged;
        }

        /// <summary>
        /// コピーコンストラクタです。
        /// </summary>
        /// <param name="source">設定するデータです。</param>
        public OptionVar(OptionVar source)
            : this()
        {
            this.DeepCopyFrom(source);
        }

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="source">設定するデータです。</param>
        public OptionVar(option_varType source)
        {
            if (source.@vertex_symbol != null)
            {
                this.@vertexSymbol = new VertexSymbol(source.@vertex_symbol);
            }
            else
            {
                this.@vertexSymbol = new VertexSymbol();
            }
            if (source.@geometry_symbol != null)
            {
                this.@geometrySymbol = new GeometrySymbol(source.@geometry_symbol);
            }
            else
            {
                this.@geometrySymbol = new GeometrySymbol();
            }
            if (source.@fragment_symbol != null)
            {
                this.@fragmentSymbol = new FragmentSymbol(source.@fragment_symbol);
            }
            else
            {
                this.@fragmentSymbol = new FragmentSymbol();
            }
            if (source.@compute_symbol != null)
            {
                this.@computeSymbol = new ComputeSymbol(source.@compute_symbol);
            }
            else
            {
                this.@computeSymbol = new ComputeSymbol();
            }
            if (source.@ui_label != null)
            {
                this.UiLabel = new UiLabel(source.@ui_label);
            }
            else
            {
                this.UiLabel = null;
            }
            if (source.@ui_comment != null)
            {
                this.UiComment = new UiComment(source.@ui_comment);
            }
            else
            {
                this.UiComment = null;
            }
            if (source.@ui_group != null)
            {
                this.UiGroup = new UiGroup(source.@ui_group);
            }
            else
            {
                this.UiGroup = null;
            }
            if (source.@ui_order != null)
            {
                this.UiOrder = new UiOrder(source.@ui_order);
            }
            else
            {
                this.UiOrder = null;
            }
            if (source.@ui_item != null)
            {
                this.UiItem = new UiItem(source.@ui_item);
            }
            else
            {
                this.UiItem = null;
            }
            if (source.@ui_visible != null)
            {
                this.UiVisible = new UiVisible(source.@ui_visible);
            }
            else
            {
                this.UiVisible = null;
            }
            this.@id = source.@id;
            this.@type = source.@type;
            this.@choice = new ShaderOptionChoice(source.choice);
            this.@default = source.@default;
            this.@branch = source.@branch;
            this.@vertexSymbol.PropertyChanged += this.OnPropertyChanged;
            this.@geometrySymbol.PropertyChanged += this.OnPropertyChanged;
            this.@fragmentSymbol.PropertyChanged += this.OnPropertyChanged;
            this.@computeSymbol.PropertyChanged += this.OnPropertyChanged;
            this.@choice.PropertyChanged += this.OnPropertyChanged;
        }

        public void Dispose()
        {
            if (this.@uiLabel != null)
            {
                this.@uiLabel.PropertyChanged -= this.OnPropertyChanged;
            }
            if (this.@uiComment != null)
            {
                this.@uiComment.PropertyChanged -= this.OnPropertyChanged;
            }
            if (this.@uiGroup != null)
            {
                this.@uiGroup.PropertyChanged -= this.OnPropertyChanged;
            }
            if (this.@uiOrder != null)
            {
                this.@uiOrder.PropertyChanged -= this.OnPropertyChanged;
            }
            if (this.@uiItem != null)
            {
                this.@uiItem.PropertyChanged -= this.OnPropertyChanged;
            }
            if (this.@uiVisible != null)
            {
                this.@uiVisible.PropertyChanged -= this.OnPropertyChanged;
            }
        }

        public VertexSymbol VertexSymbol
        {
            get
            {
                return this.@vertexSymbol;
            }
        }

        public GeometrySymbol GeometrySymbol
        {
            get
            {
                return this.@geometrySymbol;
            }
        }

        public FragmentSymbol FragmentSymbol
        {
            get
            {
                return this.@fragmentSymbol;
            }
        }

        public ComputeSymbol ComputeSymbol
        {
            get
            {
                return this.@computeSymbol;
            }
        }

        public UiLabel UiLabel
        {
            get
            {
                return this.@uiLabel;
            }

            set
            {
                if (this.@uiLabel == value)
                {
                    return;
                }

                Ensure.Argument.True(value != null ? typeof(UiLabel).IsAssignableFrom(value.GetType()) : true);
                if (this.@uiLabel != null)
                {
                    (this.@uiLabel as IChildEntity).Parent = null;
                }

                if (value != null)
                {
                    (value as IChildEntity).Parent = this;
                }

                if (this.@uiLabel != null)
                {
                    this.@uiLabel.PropertyChanged -= this.OnPropertyChanged;
                }

                if (value != null)
                {
                    value.PropertyChanged += this.OnPropertyChanged;
                }

                this.SetProperty(ref this.@uiLabel, value, () => this.CalcCRC());
            }
        }

        public UiComment UiComment
        {
            get
            {
                return this.@uiComment;
            }

            set
            {
                if (this.@uiComment == value)
                {
                    return;
                }

                Ensure.Argument.True(value != null ? typeof(UiComment).IsAssignableFrom(value.GetType()) : true);
                if (this.@uiComment != null)
                {
                    (this.@uiComment as IChildEntity).Parent = null;
                }

                if (value != null)
                {
                    (value as IChildEntity).Parent = this;
                }

                if (this.@uiComment != null)
                {
                    this.@uiComment.PropertyChanged -= this.OnPropertyChanged;
                }

                if (value != null)
                {
                    value.PropertyChanged += this.OnPropertyChanged;
                }

                this.SetProperty(ref this.@uiComment, value, () => this.CalcCRC());
            }
        }

        public UiGroup UiGroup
        {
            get
            {
                return this.@uiGroup;
            }

            set
            {
                if (this.@uiGroup == value)
                {
                    return;
                }

                Ensure.Argument.True(value != null ? typeof(UiGroup).IsAssignableFrom(value.GetType()) : true);
                if (this.@uiGroup != null)
                {
                    (this.@uiGroup as IChildEntity).Parent = null;
                }

                if (value != null)
                {
                    (value as IChildEntity).Parent = this;
                }

                if (this.@uiGroup != null)
                {
                    this.@uiGroup.PropertyChanged -= this.OnPropertyChanged;
                }

                if (value != null)
                {
                    value.PropertyChanged += this.OnPropertyChanged;
                }

                this.SetProperty(ref this.@uiGroup, value, () => this.CalcCRC());
            }
        }

        public UiOrder UiOrder
        {
            get
            {
                return this.@uiOrder;
            }

            set
            {
                if (this.@uiOrder == value)
                {
                    return;
                }

                Ensure.Argument.True(value != null ? typeof(UiOrder).IsAssignableFrom(value.GetType()) : true);
                if (this.@uiOrder != null)
                {
                    (this.@uiOrder as IChildEntity).Parent = null;
                }

                if (value != null)
                {
                    (value as IChildEntity).Parent = this;
                }

                if (this.@uiOrder != null)
                {
                    this.@uiOrder.PropertyChanged -= this.OnPropertyChanged;
                }

                if (value != null)
                {
                    value.PropertyChanged += this.OnPropertyChanged;
                }

                this.SetProperty(ref this.@uiOrder, value, () => this.CalcCRC());
            }
        }

        public UiItem UiItem
        {
            get
            {
                return this.@uiItem;
            }

            set
            {
                if (this.@uiItem == value)
                {
                    return;
                }

                Ensure.Argument.True(value != null ? typeof(UiItem).IsAssignableFrom(value.GetType()) : true);
                if (this.@uiItem != null)
                {
                    (this.@uiItem as IChildEntity).Parent = null;
                }

                if (value != null)
                {
                    (value as IChildEntity).Parent = this;
                }

                if (this.@uiItem != null)
                {
                    this.@uiItem.PropertyChanged -= this.OnPropertyChanged;
                }

                if (value != null)
                {
                    value.PropertyChanged += this.OnPropertyChanged;
                }

                this.SetProperty(ref this.@uiItem, value, () => this.CalcCRC());
            }
        }

        public UiVisible UiVisible
        {
            get
            {
                return this.@uiVisible;
            }

            set
            {
                if (this.@uiVisible == value)
                {
                    return;
                }

                Ensure.Argument.True(value != null ? typeof(UiVisible).IsAssignableFrom(value.GetType()) : true);
                if (this.@uiVisible != null)
                {
                    (this.@uiVisible as IChildEntity).Parent = null;
                }

                if (value != null)
                {
                    (value as IChildEntity).Parent = this;
                }

                if (this.@uiVisible != null)
                {
                    this.@uiVisible.PropertyChanged -= this.OnPropertyChanged;
                }

                if (value != null)
                {
                    value.PropertyChanged += this.OnPropertyChanged;
                }

                this.SetProperty(ref this.@uiVisible, value, () => this.CalcCRC());
            }
        }

        public string Id
        {
            get
            {
                return this.@id;
            }

            set
            {
                if (this.@id == value)
                {
                    return;
                }

                Ensure.Argument.NotNull(value);
                this.SetProperty(ref this.@id, value, () => this.CalcCRC());
            }
        }

        public option_var_typeType Type
        {
            get
            {
                return this.@type;
            }

            set
            {
                if (this.@type == value)
                {
                    return;
                }

                this.SetProperty(ref this.@type, value, () => this.CalcCRC());
            }
        }

        public ShaderOptionChoice Choice
        {
            get
            {
                return this.@choice;
            }
        }

        public string Default
        {
            get
            {
                return this.@default;
            }

            set
            {
                if (this.@default == value)
                {
                    return;
                }

                Ensure.Argument.NotNull(value);
                this.SetProperty(ref this.@default, value, () => this.CalcCRC());
            }
        }

        public bool Branch
        {
            get
            {
                return this.@branch;
            }

            set
            {
                if (this.@branch == value)
                {
                    return;
                }

                this.SetProperty(ref this.@branch, value, () => this.CalcCRC());
            }
        }

        /// <summary>
        /// 出力データを作成します。
        /// </summary>
        /// <returns>出力データのインスタンスを返します。</returns>
        public override option_varType CreateSerializableData()
        {
            Ensure.Operation.True(
                !string.IsNullOrEmpty(this.vertexSymbol.Name) ||
                !string.IsNullOrEmpty(this.fragmentSymbol.Name) ||
                !string.IsNullOrEmpty(this.geometrySymbol.Name) ||
                !string.IsNullOrEmpty(this.computeSymbol.Name));
            var writeData = new option_varType();
            writeData.@vertex_symbol = this.@vertexSymbol.CreateSerializableData() as vertex_symbolType;
            writeData.@geometry_symbol = this.@geometrySymbol.CreateSerializableData() as geometry_symbolType;
            writeData.@fragment_symbol = this.@fragmentSymbol.CreateSerializableData() as fragment_symbolType;
            writeData.@compute_symbol = this.@computeSymbol.CreateSerializableData() as compute_symbolType;
            if (this.@uiLabel != null)
            {
                writeData.@ui_label = this.UiLabel.CreateSerializableData() as ui_labelType;
            }
            if (this.@uiComment != null)
            {
                writeData.@ui_comment = this.UiComment.CreateSerializableData() as ui_commentType;
            }
            if (this.@uiGroup != null)
            {
                writeData.@ui_group = this.UiGroup.CreateSerializableData() as ui_groupType;
            }
            if (this.@uiOrder != null)
            {
                writeData.@ui_order = this.UiOrder.CreateSerializableData() as ui_orderType;
            }
            if (this.@uiItem != null)
            {
                writeData.@ui_item = this.UiItem.CreateSerializableData() as ui_itemType;
            }
            if (this.@uiVisible != null)
            {
                writeData.@ui_visible = this.UiVisible.CreateSerializableData() as ui_visibleType;
            }
            writeData.@id = this.Id;
            writeData.@type = this.Type;
            writeData.@choice = this.@choice.CreateSerializableData() as String;
            writeData.@default = this.Default;
            writeData.@branch = this.Branch;
            return writeData;
        }

        /// <summary>
        /// 現在のインスタンスをディープコピーで複製した新規インスタンスを返します。
        /// </summary>
        OptionVar IDeepCopyable<OptionVar>.DeepCopy()
        {
            return new OptionVar(this);
        }

        /// <summary>
        /// 入力ファイルからディープコピーします。
        /// </summary>
        /// <param name="source">コピー元となる入力ファイルです。</param>
        public void DeepCopyFrom(OptionVar source)
        {
            this.@vertexSymbol.DeepCopyFrom(source.@vertexSymbol);
            this.@geometrySymbol.DeepCopyFrom(source.@geometrySymbol);
            this.@fragmentSymbol.DeepCopyFrom(source.@fragmentSymbol);
            this.@computeSymbol.DeepCopyFrom(source.@computeSymbol);
            if (source.@uiLabel == null)
            {
                this.UiLabel = null;
            }
            else
            {
                this.UiLabel.DeepCopyFrom(source.@uiLabel);
            }
            if (source.@uiComment == null)
            {
                this.UiComment = null;
            }
            else
            {
                this.UiComment.DeepCopyFrom(source.@uiComment);
            }
            if (source.@uiGroup == null)
            {
                this.UiGroup = null;
            }
            else
            {
                this.UiGroup.DeepCopyFrom(source.@uiGroup);
            }
            if (source.@uiOrder == null)
            {
                this.UiOrder = null;
            }
            else
            {
                this.UiOrder.DeepCopyFrom(source.@uiOrder);
            }
            if (source.@uiItem == null)
            {
                this.UiItem = null;
            }
            else
            {
                this.UiItem.DeepCopyFrom(source.@uiItem);
            }
            if (source.@uiVisible == null)
            {
                this.UiVisible = null;
            }
            else
            {
                this.UiVisible.DeepCopyFrom(source.@uiVisible);
            }
            this.@id = source.@id;
            this.@type = source.@type;
            this.@choice.DeepCopyFrom(source.@choice);
            this.@default = source.@default;
            this.@branch = source.@branch;
        }

        /// <summary>
        /// エンティティの CRC を作成します。（内部処理用）
        /// </summary>
        /// <returns>CRC の値を返します。</returns>
        protected override uint CreateCRCInternal()
        {
            CRC32 crc = new CRC32();
            List<byte> buffers = new List<byte>();
            buffers.AddRange(BitConverter.GetBytes(crc.ComputeHashUInt32(this.VertexSymbol.HashValue)));
            buffers.AddRange(BitConverter.GetBytes(crc.ComputeHashUInt32(this.GeometrySymbol.HashValue)));
            buffers.AddRange(BitConverter.GetBytes(crc.ComputeHashUInt32(this.FragmentSymbol.HashValue)));
            buffers.AddRange(BitConverter.GetBytes(crc.ComputeHashUInt32(this.ComputeSymbol.HashValue)));
            if (this.UiLabel != null)
            {
                buffers.AddRange(BitConverter.GetBytes(crc.ComputeHashUInt32(this.UiLabel.HashValue)));
            }
            if (this.UiComment != null)
            {
                buffers.AddRange(BitConverter.GetBytes(crc.ComputeHashUInt32(this.UiComment.HashValue)));
            }
            if (this.UiGroup != null)
            {
                buffers.AddRange(BitConverter.GetBytes(crc.ComputeHashUInt32(this.UiGroup.HashValue)));
            }
            if (this.UiOrder != null)
            {
                buffers.AddRange(BitConverter.GetBytes(crc.ComputeHashUInt32(this.UiOrder.HashValue)));
            }
            if (this.UiItem != null)
            {
                buffers.AddRange(BitConverter.GetBytes(crc.ComputeHashUInt32(this.UiItem.HashValue)));
            }
            if (this.UiVisible != null)
            {
                buffers.AddRange(BitConverter.GetBytes(crc.ComputeHashUInt32(this.UiVisible.HashValue)));
            }
            buffers.AddRange(BitConverter.GetBytes(crc.ComputeHashUInt32(this.Id)));
            buffers.AddRange(BitConverter.GetBytes(crc.ComputeHashUInt32(this.Type)));
            buffers.AddRange(BitConverter.GetBytes(crc.ComputeHashUInt32(this.Choice.HashValue)));
            buffers.AddRange(BitConverter.GetBytes(crc.ComputeHashUInt32(this.Default)));
            buffers.AddRange(BitConverter.GetBytes(crc.ComputeHashUInt32(this.Branch)));
            return crc.ComputeHashUInt32(buffers.ToArray());
        }

        /// <summary>
        /// 自動計算フラグを設定します。(内部処理用）
        /// </summary>
        protected override void SetAutoCalcFlagInternal()
        {
            this.@vertexSymbol.AutoCalc = this.AutoCalc;
            this.@geometrySymbol.AutoCalc = this.AutoCalc;
            this.@fragmentSymbol.AutoCalc = this.AutoCalc;
            this.@computeSymbol.AutoCalc = this.AutoCalc;
            if (this.@uiLabel != null)
            {
                this.@uiLabel.AutoCalc = this.AutoCalc;
            }
            if (this.@uiComment != null)
            {
                this.@uiComment.AutoCalc = this.AutoCalc;
            }
            if (this.@uiGroup != null)
            {
                this.@uiGroup.AutoCalc = this.AutoCalc;
            }
            if (this.@uiOrder != null)
            {
                this.@uiOrder.AutoCalc = this.AutoCalc;
            }
            if (this.@uiItem != null)
            {
                this.@uiItem.AutoCalc = this.AutoCalc;
            }
            if (this.@uiVisible != null)
            {
                this.@uiVisible.AutoCalc = this.AutoCalc;
            }
            this.@choice.AutoCalc = this.AutoCalc;
        }

        /// <summary>
        /// エンティティの状態をリセットします。(内部処理用）
        /// </summary>
        protected override void ResetInternal()
        {
            this.@vertexSymbol.Reset();
            this.@geometrySymbol.Reset();
            this.@fragmentSymbol.Reset();
            this.@computeSymbol.Reset();
            if (this.@uiLabel != null)
            {
                this.@uiLabel.Reset();
            }
            if (this.@uiComment != null)
            {
                this.@uiComment.Reset();
            }
            if (this.@uiGroup != null)
            {
                this.@uiGroup.Reset();
            }
            if (this.@uiOrder != null)
            {
                this.@uiOrder.Reset();
            }
            if (this.@uiItem != null)
            {
                this.@uiItem.Reset();
            }
            if (this.@uiVisible != null)
            {
                this.@uiVisible.Reset();
            }
            this.@choice.Reset();
        }

        /// <summary>
        /// エンティティの状態を更新します。(内部処理用）
        /// </summary>
        protected override void RefreshInternal()
        {
            this.@vertexSymbol.Refresh();
            this.@geometrySymbol.Refresh();
            this.@fragmentSymbol.Refresh();
            this.@computeSymbol.Refresh();
            if (this.@uiLabel != null)
            {
                this.@uiLabel.Refresh();
            }
            if (this.@uiComment != null)
            {
                this.@uiComment.Refresh();
            }
            if (this.@uiGroup != null)
            {
                this.@uiGroup.Refresh();
            }
            if (this.@uiOrder != null)
            {
                this.@uiOrder.Refresh();
            }
            if (this.@uiItem != null)
            {
                this.@uiItem.Refresh();
            }
            if (this.@uiVisible != null)
            {
                this.@uiVisible.Refresh();
            }
            this.@choice.Refresh();
        }

        private void OnPropertyChanged(object sender, PropertyChangedEventArgs e)
        {
            if (e.PropertyName == "HashValue")
            {
                this.CalcCRC();
            }
        }
    }
}
