﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Nintendo.ToolFoundation.Contracts;
using nw.g3d.nw4f_3dif;

namespace Nintendo.G3dTool.Entities.Internal
{
    internal class Utility
    {
        internal static void CopyArray<T>(T[] source, T[] destination)
        {
            for (int elemIndex = 0; elemIndex < source.Length; ++elemIndex)
            {
                destination[elemIndex] = source[elemIndex];
            }
        }

        internal static IRootEntity FindRootEntity(object parentEntity)
        {
            if (typeof(IRootEntity).IsAssignableFrom(parentEntity.GetType()))
            {
                return parentEntity as IRootEntity;
            }

            var parentProp = parentEntity.GetType().GetProperty("Parent");
            Ensure.Operation.NotNull(parentProp);

            object nextParent = parentProp.GetValue(parentEntity);
            if (nextParent == null)
            {
                return null;
            }

            return FindRootEntity(nextParent) as IRootEntity;
        }

        internal static int GetComponentCount(vtx_attrib_typeType type)
        {
            switch (type)
            {
                case vtx_attrib_typeType.@float:
                case vtx_attrib_typeType.@int:
                case vtx_attrib_typeType.@uint:
                    return 1;
                case vtx_attrib_typeType.@float2:
                case vtx_attrib_typeType.@int2:
                case vtx_attrib_typeType.@uint2:
                    return 2;
                case vtx_attrib_typeType.@float3:
                case vtx_attrib_typeType.@int3:
                case vtx_attrib_typeType.@uint3:
                    return 3;
                case vtx_attrib_typeType.@float4:
                case vtx_attrib_typeType.@int4:
                case vtx_attrib_typeType.@uint4:
                    return 4;
                default:
                    throw new NotImplementedException();
            }
        }

    }
}
