﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml.Serialization;

namespace Nintendo.G3dTool.Entities.Internal
{
    internal static class StringUtility
    {
        internal static string ConvertSnakeCaseToCamelCase(string text)
        {
            string pascal = ConvertSnakeCaseToPascalCase(text);
            string result = pascal.Substring(0, 1).ToLower();
            if (pascal.Length > 1)
            {
                result += pascal.Substring(1, pascal.Length - 1);
            }
            return result;
        }

        internal static string ConvertSnakeCaseToPascalCase(string text)
        {
            StringBuilder result = new StringBuilder();
            foreach (string elem in text.Split('_'))
            {
                result.Append(elem.Substring(0, 1).ToUpper());
                if (elem.Length > 1)
                {
                    result.Append(elem.Substring(1, elem.Length - 1));
                }
            }

            return result.ToString();
        }

        internal static string[] SplitValueListText(string valueListText)
        {
            return valueListText.Split(new char[] { ' ', '\t', '\n', '\r' }, StringSplitOptions.RemoveEmptyEntries);
        }

        internal static T[] ConvertTextToValueArray<T>(string valueListText)
        {
            string[] elems = SplitValueListText(valueListText);
            List<T> result = new List<T>();

            foreach (string elem in elems)
            {
                T value = (T)TypeDescriptor.GetConverter(typeof(T)).ConvertFromString(elem);
                result.Add(value);
            }

            return result.ToArray();
        }

        internal static string ConvertValueArrayToText<T>(IEnumerable<T> values)
        {
            StringBuilder valueText = new StringBuilder();

            foreach (var value in values)
            {
                valueText.Append($"{value} ");
            }

            return valueText.ToString().TrimEnd();
        }

        internal static string ConvertValueToText<T>(this T value) where T : struct, IConvertible
        {
            if (typeof(T) == typeof(float))
            {
                return Convert.ToSingle(value).ToString("G9");
            }

            var enumType = typeof(T);
            if (!enumType.IsEnum)
            {
                return value.ToString();
            }

            var member = enumType.GetMember(value.ToString()).FirstOrDefault();
            if (member == null)
            {
                return value.ToString();
            }

            var attribute = member.GetCustomAttributes(false).OfType<XmlEnumAttribute>().FirstOrDefault();
            if (attribute == null)
            {
                return value.ToString();
            }

            return attribute.Name;
        }
    }
}
