﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Drawing;
using System.Globalization;
using System.IO;
using System.Reflection;
using System.Threading;
using System.Threading.Tasks;
using System.Windows.Forms;
using System.Linq;
using nw.g3d.nw4f_3dif;

namespace App
{
    // バッググラウンドタスクマネージャー
    static public class BackgroundTaskManager
    {
// System.Threading.Tasks の実装
#if false
        public static void Initialize()
        {
        }

        public static void Destroy()
        {
        }

        // 現在走っているタスク
        private static Task    runningTask_    = null;

        // タスクの追加
        public static void AddTask(Action task)
        {
            Action<Task> startTaskGroup = (t) =>
            {
                runningTask_ = Task.Factory.StartNew(
                    () =>
                    {
                        G3dParallel.IsParallel = false;
                        {
                            task();
                        }
                        G3dParallel.IsParallel = true;
                    }
                );
            };

            if (runningTask_ != null)
            {
                runningTask_.ContinueWith(startTaskGroup);
            }
            else
            {
                startTaskGroup(null);
            }
        }

// 普通のスレッドで実装
#else
        private static Thread            thread_    = null;
        private static Queue<Action>    queue_    = new Queue<Action>();

        public static void Initialize()
        {
            thread_ = new Thread(new ThreadStart(ThreadMain))
            {
                IsBackground = true,
                Priority = ThreadPriority.Lowest,
                CurrentUICulture = Thread.CurrentThread.CurrentUICulture
            };

            thread_.Start();
        }

        public static void Destroy()
        {
            // スレッドの停止を待つ
            if (thread_ != null)
            {
                thread_.Abort();
                thread_.Join();
                thread_ = null;
            }
        }

        private static void ThreadMain()
        {
            while (true)
            {
                Thread.Sleep(1000);

                Action[] tasks = null;
                {
                    if (queue_.Count > 0)
                    {
                        lock(typeof(BackgroundTaskManager))
                        {
                            tasks = queue_.ToArray();
                            queue_.Clear();
                        }
                    }
                }
                if (tasks != null)
                {
                    int tmp = G3dParallel.Job;
                    G3dParallel.Job = 1;
                    {
                        foreach(var task in tasks)
                        {
                            task();
                        }
                    }
                    G3dParallel.Job = tmp;
                }
            }
        }

        // タスクの追加
        public static void AddTask(Action task)
        {
            lock(typeof(BackgroundTaskManager))
            {
                queue_.Enqueue(task);
            }
        }
#endif
    }
}
