﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
//#define USE_CAFE_TEXTURE

using System.Collections.Generic;
using System.Drawing;
using System.IO;
using System.Reflection;

using nw.g3d.nw4f_3dif;
using nw.g3d.iftexutil;

namespace App.Data
{
    static public class TexUtilsProxy
    {
        private static readonly Converter converter_;

        static TexUtilsProxy()
        {
            converter_ = new Converter();
        }

        public static void Initialize()
        {
            var exeDirectoryPath = Path.GetDirectoryName(Assembly.GetEntryAssembly().Location);
            // ThumbnailExplorerExtensionでは、Cafeのタイリング画像には対応しない単体パッケージとすることに決まったため
            // 3dTextureConverterTexUtils.dllと3dIntermediateFileTextureUtilityCafe.dllが存在するパスは渡さないよう変更。
            // もしCafeのタイリング画像を確認したい場合はUSE_CAFE_TEXTUREを有効にする
            var basePaths = new[] {
#if USE_CAFE_TEXTURE
                exePath + @"\..\CommandLineTools\", // 単体パッケージ用
                exePath + @"\..\..\..\3dTools\", // NintendoSDK 用
                exePath + @"\..\..\..\..\..\..\..\Tools\Graphics\3dTools\", // デバッグ実行用
#else
                exeDirectoryPath
#endif
            };
            converter_.Initialize(basePaths);
        }

        public static void Destroy()
        {
            converter_.Destroy();
        }

        public static Bitmap[] ConvertTo1d2dBitmap(textureType texture, List<G3dStream> streams)
        {
            return converter_.ConvertTo1d2dBitmap(texture, streams);
        }

        public static Bitmap[][] ConvertTo3dBitmap(textureType texture, List<G3dStream> streams)
        {
            return converter_.ConvertTo3dBitmap(texture, streams);
        }

        public static Bitmap[][] ConvertToCubeBitmap(textureType texture, List<G3dStream> streams)
        {
            return converter_.ConvertToCubeBitmap(texture, streams);
        }

        public static Bitmap[][] ConvertTo1dArrayBitmap(textureType texture, List<G3dStream> streams)
        {
            return converter_.ConvertTo1dArrayBitmap(texture, streams);
        }

        public static Bitmap[][] ConvertTo2dArrayBitmap(textureType texture, List<G3dStream> streams)
        {
            return converter_.ConvertTo2dArrayBitmap(texture, streams);
        }

        public static Bitmap[][] ConvertToCubeArrayBitmap(textureType texture, List<G3dStream> streams)
        {
            return converter_.ConvertToCubeArrayBitmap(texture, streams);
        }
    }
}
