﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Diagnostics;

namespace NintendoWare.ExtensionManager
{
    //==========================================================================
    /// <summary>
    /// Registration Define
    /// </summary>
    //==========================================================================
    public class Define
    {
        static public Guid CLSID_ShellExtensionIconFTX           = new Guid("FE379908-2332-4270-9FE1-CD692D2FE704");
        static public Guid CLSID_ShellExtensionInfoTipFTX        = new Guid("52C3DCF1-92B6-48cd-B5DB-A761E9D1B5DE");
        static public Guid CLSID_ShellExtensionPreviewFTX        = new Guid("DD3FC52A-C1AA-48b2-B7F5-BD4D6AD18723");
        static public Guid CLSID_ShellExtensionPropertyStoreFTX  = new Guid("2B5B2FDA-6CBA-4b24-99A4-CD77C4C5FC0D");
        static public Guid CLSID_ShellExtensionColumnProviderFTX = new Guid("E1C4EAB3-C39B-4f0e-9B94-7C67EFF7DE47");
        static public Guid CLSID_ShellExtensionContextMenuFTX    = new Guid("1BE71FB9-98E4-44D8-8B4F-CB76036E295E");

        static public Guid CLSID_ShellExtensionContextMenuFXX    = new Guid("D339F591-6107-4F76-A182-0AE5EAC976A9");

        static public Guid CLSID_ShellExtensionIconTGA           = new Guid("C2DB6C23-B022-40bb-B416-3C58CA965D89");
        static public Guid CLSID_ShellExtensionInfoTipTGA        = new Guid("A3D3C644-DB60-475b-A54D-BEC9B33BC859");
        static public Guid CLSID_ShellExtensionPreviewTGA        = new Guid("2F3B6EF5-871C-402c-B1A2-DBB1108C0E45");
        static public Guid CLSID_ShellExtensionPropertyStoreTGA  = new Guid("C521C4D9-EB29-4115-AC10-A62DD909ABE7");
        static public Guid CLSID_ShellExtensionColumnProviderTGA = new Guid("5744EC00-3F0C-4d55-A809-A3DDF413530C");

        static public Guid CLSID_ShellExtensionIconPSD           = new Guid("09D5F39F-2845-4DDD-BC34-69024F38FDB1");
        static public Guid CLSID_ShellExtensionInfoTipPSD        = new Guid("C43E072C-4CAD-41AB-B7FA-A93F5B5E2230");
        static public Guid CLSID_ShellExtensionPreviewPSD        = new Guid("2E695B99-D9EE-4203-AADD-CB82C3CD454D");
        static public Guid CLSID_ShellExtensionPropertyStorePSD  = new Guid("0F531883-300C-4947-B882-E9A82E91E8E8");
        static public Guid CLSID_ShellExtensionColumnProviderPSD = new Guid("530D7208-C4C6-4739-83BB-2027DAC1922A");

        static public Guid CLSID_ShellExtensionIconAI = new Guid("C82ADACD-1C97-4C9D-B29E-C9F95A8FF754");

        static public Guid CLSID_ShellExtensionIconEPS = new Guid("440F0CFB-51B2-4715-822C-407401AD453C");

        static public Guid CLSID_ShellExtensionIconTHUMBS = new Guid("81B5C6B3-2640-43F9-B091-A45FC0AA1306");
        static public Guid CLSID_ShellExtensionPreviewTHUMBS = new Guid("078C837D-48E3-496B-B377-DE167063A71F");

        static public Dictionary<ShellExtensionService, Dictionary<string, Guid>> IDs = new Dictionary<ShellExtensionService, Dictionary<string, Guid>>
        {
            {
                ShellExtensionService.IconService, new Dictionary<string, Guid>()
                {
                    { "FTX", CLSID_ShellExtensionIconFTX },
                    { "TGA", CLSID_ShellExtensionIconTGA },
                    { "PSD", CLSID_ShellExtensionIconPSD },
                    { "AI", CLSID_ShellExtensionIconAI },
                    { "EPS", CLSID_ShellExtensionIconEPS },
                    { "THUMBS", CLSID_ShellExtensionIconTHUMBS },
                }
            },
            {
                ShellExtensionService.InfoTipService, new Dictionary<string, Guid>()
                {
                    { "FTX", CLSID_ShellExtensionInfoTipFTX },
                    { "TGA", CLSID_ShellExtensionInfoTipTGA },
                    { "PSD", CLSID_ShellExtensionInfoTipPSD },
                }
            },
            {
                ShellExtensionService.PreviewService, new Dictionary<string, Guid>()
                {
                    { "FTX", CLSID_ShellExtensionPreviewFTX },
                    { "TGA", CLSID_ShellExtensionPreviewTGA },
                    { "PSD", CLSID_ShellExtensionPreviewPSD },
                    { "THUMBS", CLSID_ShellExtensionPreviewTHUMBS },
                }
            },
        };
    }
}
