﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Diagnostics;
using System.ComponentModel;

namespace NintendoWare.ExtensionManager
{
    //==========================================================================
    /// <summary>
    /// Config manager
    /// </summary>
    //==========================================================================
    public class ConfigManager : SubManager
    {
        //----------------------------------------------------------------------
        /// <summary>
        /// Constructor
        /// </summary>
        //----------------------------------------------------------------------
        public ConfigManager()
        {
        }

        //----------------------------------------------------------------------
        /// <summary>
        /// Dispose
        /// </summary>
        //----------------------------------------------------------------------
        public override void Dispose()
        {
            base.Dispose();
        }

        #region Init / Deinit
        //----------------------------------------------------------------------
        /// <summary>
        /// Initialization. Override this to customize initialization.
        /// </summary>
        ///
        /// <returns>True if success</returns>
        //----------------------------------------------------------------------
        public override bool Init()
        {
            if (base.Init() == false)
                return false;

            InitSessionConfig();

            return true;
        }

        //----------------------------------------------------------------------
        /// <summary>
        /// Cleanup code. Overridable
        /// </summary>
        //----------------------------------------------------------------------
        public override void Deinit()
        {
            base.Deinit();
        }
        #endregion

        #region SessionConfig
        //----------------------------------------------------------------------
        /// <summary>
        /// SessionConfig
        /// </summary>
        //----------------------------------------------------------------------
        public SessionConfig SessionConfig
        {
            get { return m_sessionConfig; }
        }

        protected SessionConfig m_sessionConfig;

        //----------------------------------------------------------------------
        /// <summary>
        /// Init SessionConfig
        /// </summary>
        ///
        /// <returns>True on success</returns>
        //----------------------------------------------------------------------
        protected bool InitSessionConfig()
        {
            m_sessionConfig = new SessionConfig();
            return true;
        }
        #endregion

        #region Load & Save Config
        //----------------------------------------------------------------------
        /// <summary>
        /// Load Config
        /// </summary>
        ///
        /// <returns>True on success</returns>
        //----------------------------------------------------------------------
        public bool LoadConfig(String configDir)
        {
            if (m_sessionConfig != null)
            {
                m_sessionConfig.Load(configDir);
            }

            return true;
        }

        //----------------------------------------------------------------------
        /// <summary>
        /// Save Config
        /// </summary>
        ///
        /// <returns>True on success</returns>
        //----------------------------------------------------------------------
        public bool SaveConfig(String configDir)
        {
            if (System.IO.Directory.Exists(configDir) == false)
            {
                System.IO.Directory.CreateDirectory(configDir);
            }

            if (m_sessionConfig != null)
            {
                m_sessionConfig.Save(configDir);
            }

            return true;
        }
        #endregion

        #region Apply
        //----------------------------------------------------------------------
        /// <summary>
        /// Apply
        /// </summary>
        //----------------------------------------------------------------------
        public void ApplyConfig()
        {
            if (m_sessionConfig != null)
                m_sessionConfig.ApplyConfig();
        }
        #endregion
    }
}
