﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Text;
using System.Threading;
using System.Windows.Forms;
using nw.g3d.bifedit.Properties;

namespace nw.g3d.bifedit
{
    public class EditorProcess
    {
        public static bool Run(string fileToOpen)
        {
            var pathManager = PathManager.Instance;

            if (pathManager.EditorApplication == null)
                return false;

            return ThreadPool.QueueUserWorkItem(_ => ProcessFile(fileToOpen, pathManager));
        }

        private static void ProcessFile(string fileToOpen, PathManager pathManager)
        {
            if (pathManager.IsXSDFilePathValid==false)
            {
                CustomMessageBox.Show(string.Format("{0} ({1})\r\n", Resources.NW4F_INVALID_XSD_PATH, pathManager.XSDFilePath),
                                      Resources.NW4F_LOAD_FILE_FILE_ERROR,
                                      MessageBoxButtons.OK, MessageBoxIcon.Error);
                return;
            }

            var document = new Document
            {
                XSDFilePath = pathManager.XSDFilePath
            };

            bool bTextFile = false;
            if (document.LoadFromFile(fileToOpen,out bTextFile) == false)
            {
                //throw new Exception("Impossible to load input file");
                CustomMessageBox.Show(Properties.Resources.NW4F_LOAD_FILE_INVALID_BINARY_IF_FILE,
                    Properties.Resources.NW4F_LOAD_FILE_FILE_ERROR,
                    MessageBoxButtons.OK, MessageBoxIcon.Error);
                return;
            }

            String filePathToLoad = "";
            if (bTextFile == false) // Usual binary file
            {
                if (document.SaveToTempFile() == false)
                    throw new Exception("Impossible to save working copy");

                filePathToLoad = document.TempFilePath;
            }
            else
            {
                filePathToLoad = document.FilePath;
            }

            var procStartInfo = new ProcessStartInfo
            {
                FileName = pathManager.EditorApplication,
                Arguments = filePathToLoad,
                RedirectStandardOutput = false,
                UseShellExecute = false,
            };

            // Now we create a process, assign its ProcessStartInfo and start it
            var proc = new Process
            {
                StartInfo = procStartInfo,
                EnableRaisingEvents = true,
            };

            proc.Start();
            proc.WaitForExit();

            document.Cleanup();
        }
    }
}
