﻿using System;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using NintendoWare.FontInfoGetter;

namespace UnitTest
{
    [TestClass]
    public class UnitTest1
    {
        // スケーラブルフォントから情報を取得するテスト
        [TestMethod]
        public void TestAcquireScalableFontInfo()
        {
            // スケーラブルフォントの情報の取得
            const string path = @"..\..\..\..\..\..\..\..\..\..\..\Externals\Binaries\GoogleNotoFonts\NotoSansCJKjp-Regular.otf";
            ScalableFontInfo scalableFontInfo = FontInfoUtility.AcquireScalableFontInfo(path);

            // メトリクスの取得
            Metrics metrics = scalableFontInfo.metrics;
            Assert.AreEqual(metrics.unitsPerEm, 1000);
            Assert.AreEqual(metrics.headMacStyle, 0);
            Assert.AreEqual(metrics.os2WinAscent, 1160);
            Assert.AreEqual(metrics.os2WinDescent, 320);
            Assert.AreEqual(metrics.os2Ascent, 880);
            Assert.AreEqual(metrics.os2Descent, -120);
            Assert.AreEqual(metrics.os2FsSelection, 64);
            Assert.AreEqual(metrics.os2Leading, 0);
            Assert.AreEqual(metrics.hheaAscent, 1160);
            Assert.AreEqual(metrics.hheaDescent, -320);
            Assert.AreEqual(metrics.hheaLeading, 0);
            Assert.AreEqual(metrics.embeddingBits, 0);
            Assert.AreEqual(metrics.fontBoundingBox.xMin, -1002);
            Assert.AreEqual(metrics.fontBoundingBox.yMin, -1048);
            Assert.AreEqual(metrics.fontBoundingBox.xMax, 2928);
            Assert.AreEqual(metrics.fontBoundingBox.yMax, 1808);
            Assert.AreEqual(metrics.fontInTtcCount, 0U);
            Assert.AreEqual(metrics.indexInTtc, 0U);
            Assert.AreEqual(metrics.fontName, "Noto Sans CJK JP Regular");
            Assert.AreEqual(metrics.fontFamilyName, "Noto Sans CJK JP Regular");
            Assert.AreEqual(metrics.metricsResolution, 1000);
            Assert.AreEqual(metrics.glyphCount, 65535U);
            Assert.AreEqual(metrics.iconCount, 0U);

            // グリフの個数の取得
            Assert.AreEqual(scalableFontInfo.glyphExistence.Length, 42187);

            // カーニングの有無の取得
            Assert.AreEqual(scalableFontInfo.kerningExistence, false);
            Assert.AreEqual(scalableFontInfo.gposKerningExistence, true);
        }

        // bfttf をデコードするテスト
        [TestMethod]
        public void TestDecodeScalableFont()
        {
            // スケーラブルフォントの情報の取得
            const string path = @"..\..\..\..\..\..\..\..\..\..\..\Externals\nw4f_externals\Samples\Resources\font\nintendo_NTLG-DB_002.bfttf";
            ScalableFontInfo scalableFontInfo = FontInfoUtility.AcquireScalableFontInfo(path);

            // メトリクスの取得
            Metrics metrics = scalableFontInfo.metrics;
            Assert.AreEqual(metrics.fontName, "nintendo_NTLG-DB_002");
        }
    }
}
