﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Diagnostics;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace FcpxMaker.Dialog
{
    using DataModel;
    using static FcpxMaker.Type;

    /// <summary>
    /// フォント追加のダイアログです。
    /// </summary>
    public partial class AddFontDialog : Form
    {
        private DataType _resultDataType = DataType.None;

        /// <summary>
        /// ダイアログを表示します。
        /// </summary>
        public void Appear(DataType type)
        {
            _lstFontType.Items.AddRange(CreateComboBoxMenu(type).ToArray());
            _lstFontType.SelectedIndex = 0;
            this.StartPosition = FormStartPosition.CenterParent;
            this.ShowDialog();
        }

        /// <summary>
        /// ダイアログの結果を取得します。
        /// </summary>
        public DataType GetResult()
        {
            return _resultDataType;
        }

        /// <summary>
        /// リストボックスのメニューを生成します。
        /// </summary>
        private IEnumerable<DataModelBase> CreateComboBoxMenu(DataType type)
        {
            List<DataModelBase> ret = new List<DataModelBase>();

            switch (type)
            {
                case DataType.Root:
                case DataType.PairFont:
                    {
                        ret.Add(new PairFontDataModel());
                        ret.Add(new BitmapFontDataModel());
                        ret.Add(new ScalableFontDataModel());
                        ret.Add(new MultiScalableFontDataModel());
                    }
                    break;
                case DataType.ScalableFont:
                case DataType.MultiScalableFont:
                    {
                        ret.Add(new ScalableFontDescriptionDataModel());
                    }
                    break;
                case DataType.BitmapFont:
                case DataType.ScalableFontDescription:
                    {
                        ret.Add(new FontDataModel());
                    }
                    break;
                default:
                    Debug.Assert(false);
                    break;
            }

            return ret.ToArray();
        }

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        public AddFontDialog()
        {
            InitializeComponent();
        }

        /// <summary>
        /// OKが押された時のイベントハンドラです。
        /// </summary>
        private void Event_OkClick(object sender, EventArgs e)
        {
            _resultDataType = (_lstFontType.SelectedItem as DataModelBase).DataType;
        }

        /// <summary>
        /// Cancelが押された時のイベントハンドラです。
        /// </summary>
        private void Event_CancelClick(object sender, EventArgs e)
        {
            _resultDataType = DataType.None;
        }

        /// <summary>
        /// フォームが閉じた時のイベントハンドラです。
        /// </summary>
        private void Event_FormClosed(object sender, FormClosedEventArgs e)
        {
            EventParam args = new EventParam(EventType.DialogClose, null);
            EventManager.entry(sender, args);
        }

        /// <summary>
        /// キーが押された時のイベントハンドラです。
        /// </summary>
        private void Event_KeyDown(object sender, KeyEventArgs e)
        {
            if (e.KeyCode == Keys.Return)
            {
                Event_OkClick(sender, null);
                this.Close();
            }
        }
    }
}
