﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Diagnostics;
using System.Windows.Forms;

namespace LayoutEditorStarter
{
    class Program
    {
        /// <summary>
        /// OSバージョンに応じて適切な LayoutEditor を起動するアプリ。
        /// </summary>
        static void Main(string[] args)
        {
            Process proc = new Process();
            proc.StartInfo.FileName = string.Format("{0}/{1}/LayoutEditor.exe", Application.StartupPath, IsCurrentWindows64Bit_() ? "x64" : "x86");
            proc.StartInfo.Arguments = string.Join(" ", args);
            proc.StartInfo.CreateNoWindow = true;
            proc.StartInfo.UseShellExecute = false;
            proc.Start();
        }

        /// <summary>
        /// Windows が 64bit か ?
        /// </summary>
        private static bool IsCurrentWindows64Bit_()
        {
            // AnyCPU で実行されるアプリは IntPtr のサイズでOSのビット数を判定できる。
            return IntPtr.Size == 8;
        }
    }
}
