﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

//
// $Id: StringResMgr.cs,v 1.4 2007/03/23 07:09:41 kitani_toshikazu Exp $
// このコードは、3D エディタからコピーされたコードです。
//

using System;
using System.Diagnostics;
using System.Reflection;
using System.Resources;

namespace LayoutEditor
{
    /// <summary>
    /// 文字列リソースマネージャクラス。
    /// </summary>
    public sealed class StringResMgr
    {
        // リソースマネージャ
        private static ResourceManager _resMgr = null;

        /// <summary>
        /// 初期化処理。
        /// </summary>
        public static void Initialize()
        {
        }

        /// <summary>
        /// 文字列取得。
        /// </summary>
        public static string Get(string id)
        {
            string result = _resMgr.GetString(id);
            Debug.Assert(result != null, string.Format("文字列リソース '{0}' が見つかりません。", id));
            return result;
        }

        /// <summary>
        /// 書式指定して文字列取得。
        /// </summary>
        public static string Get(string id, params object[] args)
        {
            string format = _resMgr.GetString(id);
            Debug.Assert(format != null, string.Format("文字列リソース '{0}' が見つかりません。", id));
            return string.Format(format, args);
        }

        /// <summary>
        /// コンストラクタ。
        /// </summary>
        static StringResMgr()
        {
            // リソースマネージャ作成
            _resMgr = new ResourceManager( "LayoutEditor.res.Strings", Assembly.GetExecutingAssembly() );
        }
    }
}
