﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using LayoutEditor.Forms.ToolWindows.PropertyEditWindow;

namespace LayoutEditor.Plugin
{
    /// <summary>
    /// ページプラグインのベースクラスです。
    /// フォームデザイナでインスタンス化させるため抽象クラスにしません。
    /// </summary>
    public class PagePluginBase : PropertyPage
    {
        /// <summary>
        /// コンストラクタです。
        /// </summary>
        public PagePluginBase()
        {
        }

        //// 派生クラスで実装する項目です。
        //// staticメンバはoverrideできないのでコメントアウトしています。
#if false
        /// <summary>
        /// インスタンスを作成します。
        /// </summary>
        /// <param name="arg">作成パラメータ</param>
        /// <returns>インスタンスを返します。</returns>
        public static PropertyPage CreateInstance (object arg)
        {
            var page = new PagePluginSample1();
            page.OwnerPane = arg as IPane;

            return page;
        }

        /// <summary>
        /// ノード名を取得します。
        /// </summary>
        public static string NodeName
        {
            get
            {
                return "PluginPage";
            }
        }

        /// <summary>
        /// インスタンスを作成するデリゲートを取得します。
        /// DLLからstaticメソッドのデリゲートを取得するための対応です。
        /// </summary>
        public static CreatePropertyPageFunction CreateInstanceDelegate
        {
            get
            {
                return CreateInstance;
            }
        }
#endif
    }
}
