﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Drawing;
using System.Diagnostics;
using System.Windows.Forms;

namespace LayoutEditor.Forms.ToolWindows.common
{
    /// <summary>
    /// ツリースクロール処理
    /// </summary>
    class TreeViewScroller : ControlScroller
    {
        /// <summary>
        /// 対象ツリー
        /// </summary>
        readonly TreeView _targetTreeView;

        /// スクロールハンドラ。
        /// </summary>
        static void OnScrollHandler_( Control target, PointF vDiff )
        {
            if( vDiff.Y != 0.0f )
            {
                // スクロール方向値
                int treeScrollingDir = ( vDiff.Y > 0 ) ? 1 : 0;
                // スクロールメッセージを送信します。
                LECore.Win32.User32.SendMessage( target.Handle, LECore.Win32.WM.WM_VSCROLL, (IntPtr)treeScrollingDir, IntPtr.Zero );
            }
        }

        /// <summary>
        /// スクロール開始判定。(オーバーライド)
        /// </summary>
        protected override bool CheckNeedToStartScroll_( Point posInCliant )
        {
            TreeNode    treeNode       = _targetTreeView.GetNodeAt( posInCliant );

            if( treeNode != null && !treeNode.Bounds.Contains( posInCliant ) )
            {
                return base.CheckNeedToStartScroll_( posInCliant );
            }
            return false;
        }

        /// <summary>
        /// コンストラクタ
        /// </summary>
        public TreeViewScroller( TreeView tv )
            : base( tv, OnScrollHandler_, tv.ItemHeight * 2 )
        {
            _targetTreeView = tv;
        }
    }
}
