﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Diagnostics;

namespace LayoutEditor.Forms.ToolWindows.TimeControlWindow
{
    using LECore.Util;
    using LECore.Structures.Core;


    /// <summary>
    /// TimeControlWindow の概要の説明です。
    /// </summary>
    public class TimeControlWindow : LEToolWindow
    {
        private LayoutEditor.Forms.ToolWindows.TimiControlWindow.TimeControlPanel _pnlTimeControl;
        #region デザイナ生成コード
        #region デザイナ変数

        private System.ComponentModel.IContainer components = null;

        #endregion デザイナ変数

        #region Windows フォーム デザイナで生成されたコード
        /// <summary>
        /// デザイナ サポートに必要なメソッドです。このメソッドの内容を
        /// コード エディタで変更しないでください。
        /// </summary>
        private void InitializeComponent()
        {
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager( typeof( TimeControlWindow ) );
            this._pnlTimeControl = new LayoutEditor.Forms.ToolWindows.TimiControlWindow.TimeControlPanel();
            this.SuspendLayout();
            //
            // _pnlTimeControl
            //
            resources.ApplyResources( this._pnlTimeControl, "_pnlTimeControl" );
            this._pnlTimeControl.Name = "_pnlTimeControl";
            //
            // TimeControlWindow
            //
            resources.ApplyResources( this, "$this" );
            this.Controls.Add( this._pnlTimeControl );
            this.Name = "TimeControlWindow";
            this.ResumeLayout( false );

        }
        #endregion
        #endregion

        #region プロパティ
        /// <summary>
        /// グローバル時間クラス（クラス中でよく使用するので）
        /// </summary>
        GlobalTime _GrbTime
        {
            get{ return GlobalTime.Inst;}
        }
        #endregion プロパティ

        /// <summary>
        /// コンストラクタ
        /// </summary>
        public TimeControlWindow()
        {
           //
            // Windows フォーム デザイナ サポートに必要です。
            //
            InitializeComponent();
           _pnlTimeControl.UpdateProperty();
        }

        /// <summary>
        /// 使用されているリソースに後処理を実行します。
        /// </summary>
        protected override void Dispose( bool disposing )
        {
            if( disposing )
            {
                if(components != null)
                {
                    components.Dispose();
                }
            }
            base.Dispose( disposing );
        }

        /// <summary>
        /// 再描画します。
        /// </summary>
        public new void Invalidate()
        {
           _pnlTimeControl.UpdateProperty();
        }

    }
}
