﻿using LECore.Structures;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Diagnostics;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace LayoutEditor.src.Forms.ToolWindows.StateSettingWindow
{
    public partial class AddStateDlg : Form
    {
        Action _OnOkAction { get; set; }

        //----------------------------------------------------------

        public AddStateDlg()
        {
            InitializeComponent();
        }

        public string NewStateName { get { return _tbxName.Text; } }

        public string OriginStateName { get; private set; }

        public string SourceStateName { get { return _cmbSourceName.Text; } }

        public bool IsCreateTransition { get { return _chkCreateTransition.Checked; } }

        //----------------------------------------------------------

        public void Setup(IStateMachine stateMachine, string sourceStateName, Action onOkAction)
        {
            _OnOkAction = onOkAction;

            this.OriginStateName = sourceStateName;

            var layer = stateMachine.GetSelectedIStateLayer();
            if (layer == null)
            {
                Debug.Assert(false);
                return;
            }

            {
                _tbxName.Text = "NewState";
            }

            {
                _cmbSourceName.Items.Clear();

                int selectedIndex = -1;
                foreach (var state in layer.States)
                {
                    if (state.Name == sourceStateName)
                    {
                        selectedIndex = _cmbSourceName.Items.Count;
                    }

                    _cmbSourceName.Items.Add(state.Name);
                }

                _cmbSourceName.SelectedIndex = selectedIndex;

            }
        }

        void UpdateButtons_()
        {
            bool isValid = string.IsNullOrEmpty(_tbxName.Text);
            _btnOK.Enabled = isValid;
        }

        //----------------------------------------------------------

        private void AddPropertyDlg_Deactivate(object sender, EventArgs e)
        {
            this.Hide();
        }

        //----------------------------------------------------------

        public void ShowInEditMode()
        {
            Show();
        }

        //----------------------------------------------------------

        private void _btnOK_Click(object sender, EventArgs e)
        {
            if(_OnOkAction != null)
            {
                _OnOkAction();
            }

            this.Hide();
        }
    }
}
