﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Drawing;
using System.Diagnostics;
using System.Linq;
using System.Windows.Forms;

namespace LayoutEditor.Forms.ToolWindows.PropertyEditWindow
{
    using LayoutEditor.Controls;
    using LayoutEditor.Forms.ToolWindows.PropertyEditWindow.Adapters;

    using LECore.Manipulator;
    using LECore.Structures;

    /// <summary>
    /// UserDataPage の概要の説明です。
    /// </summary>
    public class UserDataPage : PropertyPage
    {
        #region デザイナメンバ

        #endregion デザイナメンバ

        #region デザイナ生成コード
        private void InitializeComponent()
        {
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(UserDataPage));
            this._pnlUserData = new LayoutEditor.Forms.ToolWindows.UserDataPanel();
            this.SuspendLayout();
            //
            // _pnlUserData
            //
            resources.ApplyResources(this._pnlUserData, "_pnlUserData");
            this._pnlUserData.Name = "_pnlUserData";
            //
            // UserDataPage
            //
            this.BackColor = System.Drawing.SystemColors.Control;
            this.Controls.Add(this._pnlUserData);
            this.MinimumSize = new System.Drawing.Size(384, 110);
            this.Name = "UserDataPage";
            this.Sizable = true;
            resources.ApplyResources(this, "$this");
            this.ResumeLayout(false);

        }
        #endregion デザイナ生成コード

        UserDataHolderManipulator _targetMnp = new UserDataHolderManipulator();
        UserDataPanel _pnlUserData;

        /// <summary>
        /// ページの表示内容と関係しているペインです。
        /// peneAdapterからマテリアル操作クラスを取得する際のキーとして利用します。
        /// </summary>
        IPane _OwnerPane
        {
            get;
            set;
        }

        /// <summary>
        /// 操作対象ペインを操作するクラスを取得します。
        /// </summary>
        IPane _TargetPane
        {
            get
            {
                PaneManipulator paneMnp = null;
                if (_OwnerPane != null)
                {
                    paneMnp = Target.Active.PartsSubPaneManipulators.FirstOrDefault((mnp) => object.ReferenceEquals(mnp.IPane, _OwnerPane)) as PaneManipulator;
                }
                else
                {
                    paneMnp = Target.Active.PaneManipulator;
                }

                return paneMnp.IPane;
            }
        }

        /// <summary>
        /// コンストラクタ
        /// </summary>
        public UserDataPage()
        {
            InitializeComponent();
        }

        /// <summary>
        ///
        /// </summary>
        protected override void InitializeProperty()
        {
        }

        /// <summary>
        /// GUIを更新します。
        /// </summary>
        protected override void UpdateProperty()
        {
            _pnlUserData.Initialize(
                _TargetPane.IUserDataHolder,
                _TargetPane.ExtUserDataAnimEnabled,
                true,
                _TargetPane.OwnerSubScene != null && _TargetPane.OwnerSubScene.IPartsLayout != null,
                Owner.Owner.ViewManager.AppSetting.ProjectSettings.ExUserDataPresets,
                (preset) => preset.IsTragetsPane(GetTargetPaneKind_()));

            _pnlUserData.UpdateProperty();
        }

        /// <summary>
        /// インスタンス作成。
        /// </summary>
        public static PropertyPage CreateInstance( object arg )
        {
            var page = new UserDataPage();
            page._OwnerPane = arg as IPane;

            return page;
        }

        /// <summary>
        /// 対象ペインの種類を取得します。
        /// </summary>
        PaneKind GetTargetPaneKind_()
        {
            return _TargetPane != null ? _TargetPane.PaneKind : PaneKind.Null;;
        }
    }
}

