﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Drawing;
using System.Diagnostics;
using System.Windows.Forms;
using System.IO;
using System.Linq;

namespace LayoutEditor.Forms.ToolWindows.PropertyEditWindow
{
    using LayoutEditor.Controls;
    using LayoutEditor.Forms.ToolWindows.PropertyEditWindow.Adapters;
    using LayoutEditor.Utility;

    using LECore.Manipulator;
    using LECore.Structures;
    using LECore;
    using LECore.Structures.Core;
    using src.Controls;
    using System.Collections.Generic;

    /// <summary>
    /// PropWndPaneBasicPage の概要の説明です。
    /// </summary>
    public class TextBoxPanePage : PropertyPage
    {
        #region デザイナ変数

        private LayoutEditor.Controls.IntTextBox _ctlNumTexCoord;
        private System.Windows.Forms.GroupBox _grpColor;
        private System.Windows.Forms.GroupBox _grpPosition;
        private System.Windows.Forms.Panel _pnlPositionH;
        private LayoutEditor.Controls.UIRadioButton _radPosHCenter;
        private LayoutEditor.Controls.UIRadioButton _radPosHLeft;
        private LayoutEditor.Controls.UIRadioButton _radPosHRight;
        private System.Windows.Forms.Label _lblPositionH;
        private System.Windows.Forms.Panel _pnlPositionV;
        private LayoutEditor.Controls.UIRadioButton _radPosVCenter;
        private LayoutEditor.Controls.UIRadioButton _radPosVTop;
        private LayoutEditor.Controls.UIRadioButton _radPosVBottom;
        private System.Windows.Forms.Label _lblPositionV;
        private System.Windows.Forms.Label _lblFontSize;
        private System.Windows.Forms.GroupBox _grpFontInfo;
        private System.Windows.Forms.GroupBox _grpContents;
        private LayoutEditor.Controls.StringTextBox _tbxContents;
        private LayoutEditor.Controls.ColorEditPanel _ctlVtxColTop;
        private LayoutEditor.Controls.ColorEditPanel _ctlVtxColBottom;
        private LayoutEditor.Controls.IntTextBox _tbxAllocByte;
        private System.Windows.Forms.Label _lblAllocByte;
        private System.Windows.Forms.Label _lblFontInfoT;
        private LayoutEditor.Controls.UIComboBox _ctlFontName;
        private LayoutEditor.Controls.Fvec2EditUpDownPanel _ctlFontSizeScale;
        private System.Windows.Forms.Label label1;
        private System.Windows.Forms.GroupBox _grpFontSize;
        private System.Windows.Forms.Label _lblFontSizeInit;
        private LayoutEditor.Controls.IntTextBox _tbxFontSizeInitX;
        private LayoutEditor.Controls.IntTextBox _tbxFontSizeInitY;
        private LayoutEditor.Controls.Fvec2EditUpDownPanel _ctlFontSizePixel;
        private LayoutEditor.Controls.UICheckBox _chkAllocByte;
        private System.Windows.Forms.Button _btnFontLoad;
        private Button _btnAdjustPaneSize;
        private Panel _pnlLine;
        private UIRadioButton _radAlignNotSpecified;
        private UIRadioButton _radAlignCenter;
        private UIRadioButton _radAlignLeft;
        private UIRadioButton _radAlignRight;
        private Label _lblLineAlignment;
        private StringTextBox _tbxTextID;
        private Label _lblTextID;
        private Label _line;
        private Button _btnPaneNameAsTextID;
        private LayoutEditor.Controls.DockContentToolTip _ttpMain;
        private System.ComponentModel.IContainer components;
        private GroupBox _rgpShadow;
        private UICheckBox _chkShadowEnabled;
        private Fvec2EditUpDownPanel _nudShadowScale;
        private Fvec2EditUpDownPanel _nudShadowOffset;
        private Label _lblShadowScale;
        private Label _lblShadowOffset;
        private Label _lblShadowItalic;
        private Label _lblShadowColorBottom;
        private Label _lblShadowColorTop;
        private Panel _pnlShadowEnabled;
        private Label _lblBlankSize;
        private Fvec2EditUpDownPanel _ctlBlankSize;
        private ColorEditPanel _colShadowColorTop;
        private ColorEditPanel _colShadowColorBottom;
        private Label _line3;
        private Label _line2;
        private Label _lblItalic;
        private Label _lblItalicAngle;
        private FloatEditSlider _fesShadowItalic;
        private FloatEditSlider _fesItalic;
        private FlowLayoutPanel _flyMain;
        private ColorEditPanel _colShadowWhiteColor;
        private ColorEditPanel _colShadowBlackColor;
        private Label _lblKerningState;
        private Label _lblKerning;
        private Label _lblBorderState;
        private Label _lblBorder;
        private ErrorProvider _erpMain;
        private UIRadioButton _radBorderDisabled;
        private UIRadioButton _radBorderEnabled;
        private UIRadioButton _radDoubleBorderEnabled;
        private Panel _pnlBorder;
        private Label _lblBorderNotice;
        private Controls.TextColorPanel _pnlTextColor;
        private Controls.TextColorPanel _pnlShadowTextColor;
        private GroupBox _grpPerCharTransform;
        private Label _lblPerCharLoop;
        private UIRadioButton _radPerCharLoopLoop;
        private UIRadioButton _radPerCharLoopOneTime;
        private Panel _pnlPerCharLoop;
        private Panel _pnlPerCharOriginV;
        private Label _lblPerCharOriginV;
        private UIRadioButton _radPerCharOriginVCenter;
        private UIRadioButton _radPerCharOriginVBottom;
        private UICheckBox _chkPerCharTransformEnabled;
        private Panel _pnlPerCharTransform;
        private FloatTextBox _tbxItalicRate;
        private FloatTextBox _tbxShadowItalicRate;
        private Label _lblShadowItalicAngle;
        private Label _lblCenterCeilingEnabled;
        private UICheckBox _chkCenterCeilingEnabled;
        private Label _lblLineWidthOffsetInfo0;
        private UICheckBox _chkLineWidthOffsetEnabled;
        private UINumericUpDown _ctlLineWidthOffsetLeft0;
        private UINumericUpDown _ctlLineWidthOffsetRight0;
        private GroupBox _grpLineWidthOffset;
        private FloatTextBox _tbxLineWidthOffsetSizeX;
        private Label _lblLineWidthOffsetSizeX;
        private FloatTextBox _tbxPerCharOriginVOffset;
        private Label _lblPerCharOriginVOffset;
        private Button _btnEasySettingOfPerCharTransform;
        private UICheckBox _chkPerCharTransformSplitByCharWidth;
        private UICheckBox _chkPerCharTransformAutoShadowAlpha;
        private Label _lblDrawFromRightToLeft;
        private UICheckBox _chkDrawFromRightToLeft;
        private src.Controls.AnimationMarkFloatTextBox _tbxPerCharTransOffset;
        private src.Controls.BindAnimationLabel _lblPerCharTransOffset;
        private src.Controls.AnimationMarkFloatTextBox _tbxPerCharTransWidth;
        private src.Controls.BindAnimationLabel _lblPerCharTransWidth;
        private src.Controls.BindAnimationLabel _lblVtxColTop;
        private BindAnimationLabel _lblVtxColBottom;
        private BindAnimationLabel _lblWhiteColor;
        private BindAnimationLabel _lblBlackColor;
        private UICheckBox _chkPerCharTransformOriginToCenter;
        private Button _btnPerCharTransformEasyCircle;
        private BindAnimationLabel _lblPerCharTransform;
        private GroupBox _grpPerCharTransformFixSpace;
        private Panel _pnlPerCharTransformFixSpaceOrigin;
        private UIRadioButton _radPerCharTransformFixSpaceOriginCenter;
        private UIRadioButton _radPerCharTransformFixSpaceOriginLeft;
        private UIRadioButton _radPerCharTransformFixSpaceOriginRight;
        private Label _lblPerCharTransformFixSpaceOrigin;
        private FloatTextBox _tbxPerCharTransformFixSpaceWidth;
        private Label _lblPerCharTransformFixSpaceWidth;
        private UICheckBox _chkPerCharTransformFixSpaceEnabled;
        private System.Windows.Forms.GroupBox _grpEtc;

        #endregion デザイナ変数

        #region デザイナコード
        private void InitializeComponent()
        {
            this.components = new System.ComponentModel.Container();
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(TextBoxPanePage));
            this._ctlNumTexCoord = new LayoutEditor.Controls.IntTextBox();
            this._ttpMain = new LayoutEditor.Controls.DockContentToolTip(this.components);
            this._lblBorderNotice = new System.Windows.Forms.Label();
            this._lblBorder = new System.Windows.Forms.Label();
            this._btnPaneNameAsTextID = new System.Windows.Forms.Button();
            this._fesItalic = new LayoutEditor.Controls.FloatEditSlider();
            this._colShadowWhiteColor = new LayoutEditor.Controls.ColorEditPanel();
            this._colShadowBlackColor = new LayoutEditor.Controls.ColorEditPanel();
            this._fesShadowItalic = new LayoutEditor.Controls.FloatEditSlider();
            this._colShadowColorTop = new LayoutEditor.Controls.ColorEditPanel();
            this._colShadowColorBottom = new LayoutEditor.Controls.ColorEditPanel();
            this._nudShadowOffset = new LayoutEditor.Controls.Fvec2EditUpDownPanel();
            this._nudShadowScale = new LayoutEditor.Controls.Fvec2EditUpDownPanel();
            this._lblBorderState = new System.Windows.Forms.Label();
            this._lblKerning = new System.Windows.Forms.Label();
            this._lblKerningState = new System.Windows.Forms.Label();
            this._chkPerCharTransformSplitByCharWidth = new LayoutEditor.Controls.UICheckBox();
            this._chkPerCharTransformOriginToCenter = new LayoutEditor.Controls.UICheckBox();
            this._flyMain = new System.Windows.Forms.FlowLayoutPanel();
            this._grpFontInfo = new System.Windows.Forms.GroupBox();
            this._pnlBorder = new System.Windows.Forms.Panel();
            this._radBorderDisabled = new LayoutEditor.Controls.UIRadioButton();
            this._radDoubleBorderEnabled = new LayoutEditor.Controls.UIRadioButton();
            this._radBorderEnabled = new LayoutEditor.Controls.UIRadioButton();
            this._btnFontLoad = new System.Windows.Forms.Button();
            this._ctlFontName = new LayoutEditor.Controls.UIComboBox();
            this._lblFontInfoT = new System.Windows.Forms.Label();
            this._grpContents = new System.Windows.Forms.GroupBox();
            this._line = new System.Windows.Forms.Label();
            this._lblTextID = new System.Windows.Forms.Label();
            this._tbxTextID = new LayoutEditor.Controls.StringTextBox();
            this._btnAdjustPaneSize = new System.Windows.Forms.Button();
            this._tbxContents = new LayoutEditor.Controls.StringTextBox();
            this._grpFontSize = new System.Windows.Forms.GroupBox();
            this._tbxItalicRate = new LayoutEditor.Controls.FloatTextBox();
            this._lblItalic = new System.Windows.Forms.Label();
            this._lblItalicAngle = new System.Windows.Forms.Label();
            this._line3 = new System.Windows.Forms.Label();
            this._line2 = new System.Windows.Forms.Label();
            this._lblBlankSize = new System.Windows.Forms.Label();
            this._ctlBlankSize = new LayoutEditor.Controls.Fvec2EditUpDownPanel();
            this._tbxFontSizeInitY = new LayoutEditor.Controls.IntTextBox();
            this._tbxFontSizeInitX = new LayoutEditor.Controls.IntTextBox();
            this._lblFontSizeInit = new System.Windows.Forms.Label();
            this.label1 = new System.Windows.Forms.Label();
            this._lblFontSize = new System.Windows.Forms.Label();
            this._ctlFontSizePixel = new LayoutEditor.Controls.Fvec2EditUpDownPanel();
            this._ctlFontSizeScale = new LayoutEditor.Controls.Fvec2EditUpDownPanel();
            this._grpPosition = new System.Windows.Forms.GroupBox();
            this._lblDrawFromRightToLeft = new System.Windows.Forms.Label();
            this._chkDrawFromRightToLeft = new LayoutEditor.Controls.UICheckBox();
            this._lblCenterCeilingEnabled = new System.Windows.Forms.Label();
            this._chkCenterCeilingEnabled = new LayoutEditor.Controls.UICheckBox();
            this._pnlLine = new System.Windows.Forms.Panel();
            this._radAlignNotSpecified = new LayoutEditor.Controls.UIRadioButton();
            this._radAlignCenter = new LayoutEditor.Controls.UIRadioButton();
            this._radAlignLeft = new LayoutEditor.Controls.UIRadioButton();
            this._radAlignRight = new LayoutEditor.Controls.UIRadioButton();
            this._lblLineAlignment = new System.Windows.Forms.Label();
            this._pnlPositionH = new System.Windows.Forms.Panel();
            this._radPosHCenter = new LayoutEditor.Controls.UIRadioButton();
            this._radPosHLeft = new LayoutEditor.Controls.UIRadioButton();
            this._radPosHRight = new LayoutEditor.Controls.UIRadioButton();
            this._lblPositionH = new System.Windows.Forms.Label();
            this._pnlPositionV = new System.Windows.Forms.Panel();
            this._radPosVCenter = new LayoutEditor.Controls.UIRadioButton();
            this._radPosVTop = new LayoutEditor.Controls.UIRadioButton();
            this._radPosVBottom = new LayoutEditor.Controls.UIRadioButton();
            this._lblPositionV = new System.Windows.Forms.Label();
            this._grpLineWidthOffset = new System.Windows.Forms.GroupBox();
            this._tbxLineWidthOffsetSizeX = new LayoutEditor.Controls.FloatTextBox();
            this._lblLineWidthOffsetSizeX = new System.Windows.Forms.Label();
            this._ctlLineWidthOffsetRight0 = new LayoutEditor.Controls.UINumericUpDown();
            this._lblLineWidthOffsetInfo0 = new System.Windows.Forms.Label();
            this._chkLineWidthOffsetEnabled = new LayoutEditor.Controls.UICheckBox();
            this._ctlLineWidthOffsetLeft0 = new LayoutEditor.Controls.UINumericUpDown();
            this._grpColor = new System.Windows.Forms.GroupBox();
            this._lblVtxColBottom = new LayoutEditor.src.Controls.BindAnimationLabel();
            this._lblVtxColTop = new LayoutEditor.src.Controls.BindAnimationLabel();
            this._pnlTextColor = new LayoutEditor.Controls.TextColorPanel();
            this._ctlVtxColTop = new LayoutEditor.Controls.ColorEditPanel();
            this._ctlVtxColBottom = new LayoutEditor.Controls.ColorEditPanel();
            this._grpEtc = new System.Windows.Forms.GroupBox();
            this._chkAllocByte = new LayoutEditor.Controls.UICheckBox();
            this._tbxAllocByte = new LayoutEditor.Controls.IntTextBox();
            this._lblAllocByte = new System.Windows.Forms.Label();
            this._rgpShadow = new System.Windows.Forms.GroupBox();
            this._pnlShadowEnabled = new System.Windows.Forms.Panel();
            this._lblWhiteColor = new LayoutEditor.src.Controls.BindAnimationLabel();
            this._lblBlackColor = new LayoutEditor.src.Controls.BindAnimationLabel();
            this._tbxShadowItalicRate = new LayoutEditor.Controls.FloatTextBox();
            this._lblShadowItalicAngle = new System.Windows.Forms.Label();
            this._pnlShadowTextColor = new LayoutEditor.Controls.TextColorPanel();
            this._lblShadowOffset = new System.Windows.Forms.Label();
            this._lblShadowColorBottom = new System.Windows.Forms.Label();
            this._lblShadowColorTop = new System.Windows.Forms.Label();
            this._lblShadowScale = new System.Windows.Forms.Label();
            this._lblShadowItalic = new System.Windows.Forms.Label();
            this._chkShadowEnabled = new LayoutEditor.Controls.UICheckBox();
            this._grpPerCharTransform = new System.Windows.Forms.GroupBox();
            this._lblPerCharTransform = new LayoutEditor.src.Controls.BindAnimationLabel();
            this._pnlPerCharTransform = new System.Windows.Forms.Panel();
            this._grpPerCharTransformFixSpace = new System.Windows.Forms.GroupBox();
            this._pnlPerCharTransformFixSpaceOrigin = new System.Windows.Forms.Panel();
            this._radPerCharTransformFixSpaceOriginCenter = new LayoutEditor.Controls.UIRadioButton();
            this._radPerCharTransformFixSpaceOriginLeft = new LayoutEditor.Controls.UIRadioButton();
            this._radPerCharTransformFixSpaceOriginRight = new LayoutEditor.Controls.UIRadioButton();
            this._lblPerCharTransformFixSpaceOrigin = new System.Windows.Forms.Label();
            this._tbxPerCharTransformFixSpaceWidth = new LayoutEditor.Controls.FloatTextBox();
            this._lblPerCharTransformFixSpaceWidth = new System.Windows.Forms.Label();
            this._chkPerCharTransformFixSpaceEnabled = new LayoutEditor.Controls.UICheckBox();
            this._btnPerCharTransformEasyCircle = new System.Windows.Forms.Button();
            this._lblPerCharTransWidth = new LayoutEditor.src.Controls.BindAnimationLabel();
            this._tbxPerCharTransWidth = new LayoutEditor.src.Controls.AnimationMarkFloatTextBox();
            this._lblPerCharTransOffset = new LayoutEditor.src.Controls.BindAnimationLabel();
            this._tbxPerCharTransOffset = new LayoutEditor.src.Controls.AnimationMarkFloatTextBox();
            this._chkPerCharTransformAutoShadowAlpha = new LayoutEditor.Controls.UICheckBox();
            this._btnEasySettingOfPerCharTransform = new System.Windows.Forms.Button();
            this._pnlPerCharLoop = new System.Windows.Forms.Panel();
            this._radPerCharLoopLoop = new LayoutEditor.Controls.UIRadioButton();
            this._lblPerCharLoop = new System.Windows.Forms.Label();
            this._radPerCharLoopOneTime = new LayoutEditor.Controls.UIRadioButton();
            this._pnlPerCharOriginV = new System.Windows.Forms.Panel();
            this._tbxPerCharOriginVOffset = new LayoutEditor.Controls.FloatTextBox();
            this._lblPerCharOriginVOffset = new System.Windows.Forms.Label();
            this._lblPerCharOriginV = new System.Windows.Forms.Label();
            this._radPerCharOriginVCenter = new LayoutEditor.Controls.UIRadioButton();
            this._radPerCharOriginVBottom = new LayoutEditor.Controls.UIRadioButton();
            this._chkPerCharTransformEnabled = new LayoutEditor.Controls.UICheckBox();
            this._erpMain = new System.Windows.Forms.ErrorProvider(this.components);
            this._flyMain.SuspendLayout();
            this._grpFontInfo.SuspendLayout();
            this._pnlBorder.SuspendLayout();
            this._grpContents.SuspendLayout();
            this._grpFontSize.SuspendLayout();
            this._grpPosition.SuspendLayout();
            this._pnlLine.SuspendLayout();
            this._pnlPositionH.SuspendLayout();
            this._pnlPositionV.SuspendLayout();
            this._grpLineWidthOffset.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this._ctlLineWidthOffsetRight0)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this._ctlLineWidthOffsetLeft0)).BeginInit();
            this._grpColor.SuspendLayout();
            this._grpEtc.SuspendLayout();
            this._rgpShadow.SuspendLayout();
            this._pnlShadowEnabled.SuspendLayout();
            this._grpPerCharTransform.SuspendLayout();
            this._pnlPerCharTransform.SuspendLayout();
            this._grpPerCharTransformFixSpace.SuspendLayout();
            this._pnlPerCharTransformFixSpaceOrigin.SuspendLayout();
            this._pnlPerCharLoop.SuspendLayout();
            this._pnlPerCharOriginV.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this._erpMain)).BeginInit();
            this.SuspendLayout();
            //
            // _ctlNumTexCoord
            //
            this._ctlNumTexCoord.AccessibleRole = System.Windows.Forms.AccessibleRole.None;
            resources.ApplyResources(this._ctlNumTexCoord, "_ctlNumTexCoord");
            this._ctlNumTexCoord.MaxValue = 8;
            this._ctlNumTexCoord.MinValue = 1;
            this._ctlNumTexCoord.Name = "_ctlNumTexCoord";
            this._ctlNumTexCoord.Value = 1;
            //
            // _lblBorderNotice
            //
            this._lblBorderNotice.BackColor = System.Drawing.SystemColors.Control;
            resources.ApplyResources(this._lblBorderNotice, "_lblBorderNotice");
            this._lblBorderNotice.Name = "_lblBorderNotice";
            this._ttpMain.SetToolTip(this._lblBorderNotice, resources.GetString("_lblBorderNotice.ToolTip"));
            //
            // _lblBorder
            //
            resources.ApplyResources(this._lblBorder, "_lblBorder");
            this._lblBorder.Name = "_lblBorder";
            this._ttpMain.SetToolTip(this._lblBorder, resources.GetString("_lblBorder.ToolTip"));
            //
            // _btnPaneNameAsTextID
            //
            resources.ApplyResources(this._btnPaneNameAsTextID, "_btnPaneNameAsTextID");
            this._btnPaneNameAsTextID.Name = "_btnPaneNameAsTextID";
            this._ttpMain.SetToolTip(this._btnPaneNameAsTextID, resources.GetString("_btnPaneNameAsTextID.ToolTip"));
            this._btnPaneNameAsTextID.UseVisualStyleBackColor = true;
            this._btnPaneNameAsTextID.Click += new System.EventHandler(this.Event_btnPaneNameAsTextID_Click);
            //
            // _fesItalic
            //
            resources.ApplyResources(this._fesItalic, "_fesItalic");
            this._fesItalic.Format = "f2";
            this._fesItalic.MaxValue = 60F;
            this._fesItalic.MinValue = -60F;
            this._fesItalic.Name = "_fesItalic";
            this._fesItalic.RangeLabelFormat = "f2";
            this._fesItalic.TextBoxBackColor = System.Drawing.SystemColors.Window;
            this._fesItalic.TextBoxSize = LayoutEditor.Controls.EditSliderTextBoxSize.Size56;
            this._fesItalic.TextBoxTextAlign = System.Windows.Forms.HorizontalAlignment.Right;
            this._ttpMain.SetToolTip(this._fesItalic, resources.GetString("_fesItalic.ToolTip"));
            this._fesItalic.TrackBarLargeChange = 0F;
            this._fesItalic.TrackBarPrecision = 100;
            this._fesItalic.TrackBarSmallChange = 0F;
            this._fesItalic.UseAnimationMark = false;
            this._fesItalic.ValueEdit += new LayoutEditor.Controls.ValueEditEventHandler(this.Event_FesItalic_ValueEdit);
            //
            // _colShadowWhiteColor
            //
            this._colShadowWhiteColor.AllowDrop = true;
            resources.ApplyResources(this._colShadowWhiteColor, "_colShadowWhiteColor");
            this._colShadowWhiteColor.Name = "_colShadowWhiteColor";
            this._colShadowWhiteColor.Tag = "";
            this._ttpMain.SetToolTip(this._colShadowWhiteColor, resources.GetString("_colShadowWhiteColor.ToolTip"));
            this._colShadowWhiteColor.UseAnimationMark = true;
            //
            // _colShadowBlackColor
            //
            this._colShadowBlackColor.AllowDrop = true;
            resources.ApplyResources(this._colShadowBlackColor, "_colShadowBlackColor");
            this._colShadowBlackColor.IsAlphaEnabled = false;
            this._colShadowBlackColor.Name = "_colShadowBlackColor";
            this._colShadowBlackColor.Tag = "";
            this._ttpMain.SetToolTip(this._colShadowBlackColor, resources.GetString("_colShadowBlackColor.ToolTip"));
            this._colShadowBlackColor.UseAnimationMark = true;
            //
            // _fesShadowItalic
            //
            resources.ApplyResources(this._fesShadowItalic, "_fesShadowItalic");
            this._fesShadowItalic.Format = "f2";
            this._fesShadowItalic.MaxValue = 60F;
            this._fesShadowItalic.MinValue = -60F;
            this._fesShadowItalic.Name = "_fesShadowItalic";
            this._fesShadowItalic.RangeLabelFormat = "f2";
            this._fesShadowItalic.TextBoxBackColor = System.Drawing.SystemColors.Window;
            this._fesShadowItalic.TextBoxSize = LayoutEditor.Controls.EditSliderTextBoxSize.Size56;
            this._fesShadowItalic.TextBoxTextAlign = System.Windows.Forms.HorizontalAlignment.Right;
            this._ttpMain.SetToolTip(this._fesShadowItalic, resources.GetString("_fesShadowItalic.ToolTip"));
            this._fesShadowItalic.TrackBarLargeChange = 0F;
            this._fesShadowItalic.TrackBarPrecision = 100;
            this._fesShadowItalic.TrackBarSmallChange = 0F;
            this._fesShadowItalic.UseAnimationMark = false;
            this._fesShadowItalic.ValueEdit += new LayoutEditor.Controls.ValueEditEventHandler(this.Event_FesShadowItalic_ValueEdit);
            //
            // _colShadowColorTop
            //
            this._colShadowColorTop.AllowDrop = true;
            this._colShadowColorTop.ColorButtonVisible = false;
            resources.ApplyResources(this._colShadowColorTop, "_colShadowColorTop");
            this._colShadowColorTop.Name = "_colShadowColorTop";
            this._colShadowColorTop.Tag = "";
            this._ttpMain.SetToolTip(this._colShadowColorTop, resources.GetString("_colShadowColorTop.ToolTip"));
            this._colShadowColorTop.UseAnimationMark = false;
            //
            // _colShadowColorBottom
            //
            this._colShadowColorBottom.AllowDrop = true;
            this._colShadowColorBottom.ColorButtonVisible = false;
            resources.ApplyResources(this._colShadowColorBottom, "_colShadowColorBottom");
            this._colShadowColorBottom.Name = "_colShadowColorBottom";
            this._colShadowColorBottom.Tag = "";
            this._ttpMain.SetToolTip(this._colShadowColorBottom, resources.GetString("_colShadowColorBottom.ToolTip"));
            this._colShadowColorBottom.UseAnimationMark = false;
            //
            // _nudShadowOffset
            //
            this._nudShadowOffset.DecimalPlaces = 2;
            this._nudShadowOffset.Increment = 1F;
            this._nudShadowOffset.LabelX = "X :";
            this._nudShadowOffset.LabelY = "Y :";
            this._nudShadowOffset.Link = false;
            resources.ApplyResources(this._nudShadowOffset, "_nudShadowOffset");
            this._nudShadowOffset.Name = "_nudShadowOffset";
            this._nudShadowOffset.RoundByStepValue = false;
            this._nudShadowOffset.TextBoxWidth = 62;
            this._ttpMain.SetToolTip(this._nudShadowOffset, resources.GetString("_nudShadowOffset.ToolTip"));
            this._nudShadowOffset.UseAnimationMark = false;
            this._nudShadowOffset.Vertical = false;
            this._nudShadowOffset.XEnabled = true;
            this._nudShadowOffset.YEnabled = true;
            this._nudShadowOffset.OnFVec2Edit += new LayoutEditor.Controls.FVec2EditEventHandler(this.Event_nudShadowOffset_OnFVec2Edit);
            //
            // _nudShadowScale
            //
            this._nudShadowScale.DecimalPlaces = 2;
            this._nudShadowScale.Increment = 0.1F;
            this._nudShadowScale.LabelX = "X :";
            this._nudShadowScale.LabelY = "Y :";
            this._nudShadowScale.Link = true;
            resources.ApplyResources(this._nudShadowScale, "_nudShadowScale");
            this._nudShadowScale.Name = "_nudShadowScale";
            this._nudShadowScale.RoundByStepValue = false;
            this._nudShadowScale.TextBoxWidth = 62;
            this._ttpMain.SetToolTip(this._nudShadowScale, resources.GetString("_nudShadowScale.ToolTip"));
            this._nudShadowScale.UseAnimationMark = false;
            this._nudShadowScale.Vertical = false;
            this._nudShadowScale.XEnabled = true;
            this._nudShadowScale.YEnabled = true;
            this._nudShadowScale.OnFVec2Edit += new LayoutEditor.Controls.FVec2EditEventHandler(this.Event_nudShadowScale_OnFVec2Edit);
            //
            // _lblBorderState
            //
            this._lblBorderState.BackColor = System.Drawing.SystemColors.GradientInactiveCaption;
            resources.ApplyResources(this._lblBorderState, "_lblBorderState");
            this._lblBorderState.Name = "_lblBorderState";
            this._ttpMain.SetToolTip(this._lblBorderState, resources.GetString("_lblBorderState.ToolTip"));
            //
            // _lblKerning
            //
            resources.ApplyResources(this._lblKerning, "_lblKerning");
            this._lblKerning.Name = "_lblKerning";
            this._ttpMain.SetToolTip(this._lblKerning, resources.GetString("_lblKerning.ToolTip"));
            //
            // _lblKerningState
            //
            this._lblKerningState.BackColor = System.Drawing.SystemColors.GradientInactiveCaption;
            resources.ApplyResources(this._lblKerningState, "_lblKerningState");
            this._lblKerningState.Name = "_lblKerningState";
            this._ttpMain.SetToolTip(this._lblKerningState, resources.GetString("_lblKerningState.ToolTip"));
            //
            // _chkPerCharTransformSplitByCharWidth
            //
            resources.ApplyResources(this._chkPerCharTransformSplitByCharWidth, "_chkPerCharTransformSplitByCharWidth");
            this._chkPerCharTransformSplitByCharWidth.Name = "_chkPerCharTransformSplitByCharWidth";
            this._ttpMain.SetToolTip(this._chkPerCharTransformSplitByCharWidth, resources.GetString("_chkPerCharTransformSplitByCharWidth.ToolTip"));
            this._chkPerCharTransformSplitByCharWidth.CheckedChanged += new System.EventHandler(this.Event_chkPerCharTransformSplitByCharWidth_CheckedChanged);
            //
            // _chkPerCharTransformOriginToCenter
            //
            resources.ApplyResources(this._chkPerCharTransformOriginToCenter, "_chkPerCharTransformOriginToCenter");
            this._chkPerCharTransformOriginToCenter.Name = "_chkPerCharTransformOriginToCenter";
            this._ttpMain.SetToolTip(this._chkPerCharTransformOriginToCenter, resources.GetString("_chkPerCharTransformOriginToCenter.ToolTip"));
            this._chkPerCharTransformOriginToCenter.CheckedChanged += new System.EventHandler(this.Event_chkPerCharTransformOriginToCenter_CheckedChanged);
            //
            // _flyMain
            //
            this._flyMain.Controls.Add(this._grpFontInfo);
            this._flyMain.Controls.Add(this._grpContents);
            this._flyMain.Controls.Add(this._grpFontSize);
            this._flyMain.Controls.Add(this._grpPosition);
            this._flyMain.Controls.Add(this._grpLineWidthOffset);
            this._flyMain.Controls.Add(this._grpColor);
            this._flyMain.Controls.Add(this._grpEtc);
            this._flyMain.Controls.Add(this._rgpShadow);
            this._flyMain.Controls.Add(this._grpPerCharTransform);
            resources.ApplyResources(this._flyMain, "_flyMain");
            this._flyMain.Name = "_flyMain";
            //
            // _grpFontInfo
            //
            resources.ApplyResources(this._grpFontInfo, "_grpFontInfo");
            this._grpFontInfo.Controls.Add(this._pnlBorder);
            this._grpFontInfo.Controls.Add(this._lblBorderState);
            this._grpFontInfo.Controls.Add(this._lblBorder);
            this._grpFontInfo.Controls.Add(this._lblKerningState);
            this._grpFontInfo.Controls.Add(this._lblKerning);
            this._grpFontInfo.Controls.Add(this._btnFontLoad);
            this._grpFontInfo.Controls.Add(this._ctlFontName);
            this._grpFontInfo.Controls.Add(this._lblFontInfoT);
            this._grpFontInfo.Name = "_grpFontInfo";
            this._grpFontInfo.TabStop = false;
            //
            // _pnlBorder
            //
            this._pnlBorder.Controls.Add(this._lblBorderNotice);
            this._pnlBorder.Controls.Add(this._radBorderDisabled);
            this._pnlBorder.Controls.Add(this._radDoubleBorderEnabled);
            this._pnlBorder.Controls.Add(this._radBorderEnabled);
            resources.ApplyResources(this._pnlBorder, "_pnlBorder");
            this._pnlBorder.Name = "_pnlBorder";
            //
            // _radBorderDisabled
            //
            resources.ApplyResources(this._radBorderDisabled, "_radBorderDisabled");
            this._radBorderDisabled.Name = "_radBorderDisabled";
            this._radBorderDisabled.CheckedChanged += new System.EventHandler(this.Event_RadBorderEnabled_CheckedChanged);
            //
            // _radDoubleBorderEnabled
            //
            resources.ApplyResources(this._radDoubleBorderEnabled, "_radDoubleBorderEnabled");
            this._radDoubleBorderEnabled.Name = "_radDoubleBorderEnabled";
            this._radDoubleBorderEnabled.CheckedChanged += new System.EventHandler(this.Event_RadBorderEnabled_CheckedChanged);
            //
            // _radBorderEnabled
            //
            resources.ApplyResources(this._radBorderEnabled, "_radBorderEnabled");
            this._radBorderEnabled.Name = "_radBorderEnabled";
            this._radBorderEnabled.CheckedChanged += new System.EventHandler(this.Event_RadBorderEnabled_CheckedChanged);
            //
            // _btnFontLoad
            //
            resources.ApplyResources(this._btnFontLoad, "_btnFontLoad");
            this._btnFontLoad.Name = "_btnFontLoad";
            this._btnFontLoad.Click += new System.EventHandler(this.Event_BtnFontLoad_Click);
            //
            // _ctlFontName
            //
            resources.ApplyResources(this._ctlFontName, "_ctlFontName");
            this._erpMain.SetError(this._ctlFontName, resources.GetString("_ctlFontName.Error"));
            this._ctlFontName.Name = "_ctlFontName";
            this._ctlFontName.SelectedItemData = null;
            this._ctlFontName.SelectedIndexChanged += new System.EventHandler(this.Event_CtlFontName_SelectedIndexChanged);
            //
            // _lblFontInfoT
            //
            resources.ApplyResources(this._lblFontInfoT, "_lblFontInfoT");
            this._lblFontInfoT.Name = "_lblFontInfoT";
            //
            // _grpContents
            //
            resources.ApplyResources(this._grpContents, "_grpContents");
            this._grpContents.Controls.Add(this._btnPaneNameAsTextID);
            this._grpContents.Controls.Add(this._line);
            this._grpContents.Controls.Add(this._lblTextID);
            this._grpContents.Controls.Add(this._tbxTextID);
            this._grpContents.Controls.Add(this._btnAdjustPaneSize);
            this._grpContents.Controls.Add(this._tbxContents);
            this._grpContents.Name = "_grpContents";
            this._grpContents.TabStop = false;
            //
            // _line
            //
            resources.ApplyResources(this._line, "_line");
            this._line.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
            this._line.Name = "_line";
            //
            // _lblTextID
            //
            resources.ApplyResources(this._lblTextID, "_lblTextID");
            this._lblTextID.Name = "_lblTextID";
            //
            // _tbxTextID
            //
            resources.ApplyResources(this._tbxTextID, "_tbxTextID");
            this._tbxTextID.Name = "_tbxTextID";
            this._tbxTextID.ValueChanged += new System.EventHandler(this.Event_TbxTextID_Validating);
            //
            // _btnAdjustPaneSize
            //
            resources.ApplyResources(this._btnAdjustPaneSize, "_btnAdjustPaneSize");
            this._btnAdjustPaneSize.Name = "_btnAdjustPaneSize";
            this._btnAdjustPaneSize.UseVisualStyleBackColor = true;
            this._btnAdjustPaneSize.Click += new System.EventHandler(this.Event_BtnAdjustPaneSize_Click);
            //
            // _tbxContents
            //
            resources.ApplyResources(this._tbxContents, "_tbxContents");
            this._tbxContents.Name = "_tbxContents";
            this._tbxContents.TextChanged += new System.EventHandler(this.Event_TbxContents_TextChanged);
            this._tbxContents.Enter += new System.EventHandler(this.Event_TbxContents_Enter);
            this._tbxContents.KeyDown += new System.Windows.Forms.KeyEventHandler(this.Event_tbxContents_KeyDown);
            this._tbxContents.Leave += new System.EventHandler(this.Event_TbxContents_Leave);
            //
            // _grpFontSize
            //
            resources.ApplyResources(this._grpFontSize, "_grpFontSize");
            this._grpFontSize.Controls.Add(this._tbxItalicRate);
            this._grpFontSize.Controls.Add(this._fesItalic);
            this._grpFontSize.Controls.Add(this._lblItalic);
            this._grpFontSize.Controls.Add(this._lblItalicAngle);
            this._grpFontSize.Controls.Add(this._line3);
            this._grpFontSize.Controls.Add(this._line2);
            this._grpFontSize.Controls.Add(this._lblBlankSize);
            this._grpFontSize.Controls.Add(this._ctlBlankSize);
            this._grpFontSize.Controls.Add(this._tbxFontSizeInitY);
            this._grpFontSize.Controls.Add(this._tbxFontSizeInitX);
            this._grpFontSize.Controls.Add(this._lblFontSizeInit);
            this._grpFontSize.Controls.Add(this.label1);
            this._grpFontSize.Controls.Add(this._lblFontSize);
            this._grpFontSize.Controls.Add(this._ctlFontSizePixel);
            this._grpFontSize.Controls.Add(this._ctlFontSizeScale);
            this._grpFontSize.Name = "_grpFontSize";
            this._grpFontSize.TabStop = false;
            //
            // _tbxItalicRate
            //
            this._tbxItalicRate.AccessibleRole = System.Windows.Forms.AccessibleRole.None;
            this._tbxItalicRate.Format = "f2";
            resources.ApplyResources(this._tbxItalicRate, "_tbxItalicRate");
            this._tbxItalicRate.MaxValue = 100000F;
            this._tbxItalicRate.MinValue = -100000F;
            this._tbxItalicRate.Name = "_tbxItalicRate";
            this._tbxItalicRate.ReadOnly = true;
            //
            // _lblItalic
            //
            resources.ApplyResources(this._lblItalic, "_lblItalic");
            this._lblItalic.Name = "_lblItalic";
            //
            // _lblItalicAngle
            //
            resources.ApplyResources(this._lblItalicAngle, "_lblItalicAngle");
            this._lblItalicAngle.Name = "_lblItalicAngle";
            //
            // _line3
            //
            resources.ApplyResources(this._line3, "_line3");
            this._line3.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
            this._line3.Name = "_line3";
            //
            // _line2
            //
            resources.ApplyResources(this._line2, "_line2");
            this._line2.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
            this._line2.Name = "_line2";
            //
            // _lblBlankSize
            //
            resources.ApplyResources(this._lblBlankSize, "_lblBlankSize");
            this._lblBlankSize.Name = "_lblBlankSize";
            //
            // _ctlBlankSize
            //
            this._ctlBlankSize.DecimalPlaces = 2;
            this._ctlBlankSize.Increment = 1F;
            this._ctlBlankSize.LabelX = "X :";
            this._ctlBlankSize.LabelY = "Y :";
            this._ctlBlankSize.Link = false;
            resources.ApplyResources(this._ctlBlankSize, "_ctlBlankSize");
            this._ctlBlankSize.Name = "_ctlBlankSize";
            this._ctlBlankSize.RoundByStepValue = false;
            this._ctlBlankSize.TextBoxWidth = 62;
            this._ctlBlankSize.UseAnimationMark = false;
            this._ctlBlankSize.Vertical = false;
            this._ctlBlankSize.XEnabled = true;
            this._ctlBlankSize.YEnabled = true;
            //
            // _tbxFontSizeInitY
            //
            this._tbxFontSizeInitY.AccessibleRole = System.Windows.Forms.AccessibleRole.None;
            this._tbxFontSizeInitY.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
            resources.ApplyResources(this._tbxFontSizeInitY, "_tbxFontSizeInitY");
            this._tbxFontSizeInitY.MaxValue = 100000;
            this._tbxFontSizeInitY.MinValue = 0;
            this._tbxFontSizeInitY.Name = "_tbxFontSizeInitY";
            this._tbxFontSizeInitY.ReadOnly = true;
            //
            // _tbxFontSizeInitX
            //
            this._tbxFontSizeInitX.AccessibleRole = System.Windows.Forms.AccessibleRole.None;
            this._tbxFontSizeInitX.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
            resources.ApplyResources(this._tbxFontSizeInitX, "_tbxFontSizeInitX");
            this._tbxFontSizeInitX.MaxValue = 100000;
            this._tbxFontSizeInitX.MinValue = 0;
            this._tbxFontSizeInitX.Name = "_tbxFontSizeInitX";
            this._tbxFontSizeInitX.ReadOnly = true;
            //
            // _lblFontSizeInit
            //
            resources.ApplyResources(this._lblFontSizeInit, "_lblFontSizeInit");
            this._lblFontSizeInit.Name = "_lblFontSizeInit";
            //
            // label1
            //
            resources.ApplyResources(this.label1, "label1");
            this.label1.Name = "label1";
            //
            // _lblFontSize
            //
            resources.ApplyResources(this._lblFontSize, "_lblFontSize");
            this._lblFontSize.Name = "_lblFontSize";
            //
            // _ctlFontSizePixel
            //
            this._ctlFontSizePixel.DecimalPlaces = 2;
            this._ctlFontSizePixel.Increment = 1F;
            this._ctlFontSizePixel.LabelX = "X :";
            this._ctlFontSizePixel.LabelY = "Y :";
            this._ctlFontSizePixel.Link = false;
            resources.ApplyResources(this._ctlFontSizePixel, "_ctlFontSizePixel");
            this._ctlFontSizePixel.Name = "_ctlFontSizePixel";
            this._ctlFontSizePixel.RoundByStepValue = false;
            this._ctlFontSizePixel.TextBoxWidth = 62;
            this._ctlFontSizePixel.UseAnimationMark = false;
            this._ctlFontSizePixel.Vertical = false;
            this._ctlFontSizePixel.XEnabled = true;
            this._ctlFontSizePixel.YEnabled = true;
            //
            // _ctlFontSizeScale
            //
            this._ctlFontSizeScale.DecimalPlaces = 2;
            this._ctlFontSizeScale.Increment = 0.1F;
            this._ctlFontSizeScale.LabelX = "X :";
            this._ctlFontSizeScale.LabelY = "Y :";
            this._ctlFontSizeScale.Link = true;
            resources.ApplyResources(this._ctlFontSizeScale, "_ctlFontSizeScale");
            this._ctlFontSizeScale.Name = "_ctlFontSizeScale";
            this._ctlFontSizeScale.RoundByStepValue = false;
            this._ctlFontSizeScale.TextBoxWidth = 62;
            this._ctlFontSizeScale.UseAnimationMark = false;
            this._ctlFontSizeScale.Vertical = false;
            this._ctlFontSizeScale.XEnabled = true;
            this._ctlFontSizeScale.YEnabled = true;
            //
            // _grpPosition
            //
            resources.ApplyResources(this._grpPosition, "_grpPosition");
            this._grpPosition.Controls.Add(this._lblDrawFromRightToLeft);
            this._grpPosition.Controls.Add(this._chkDrawFromRightToLeft);
            this._grpPosition.Controls.Add(this._lblCenterCeilingEnabled);
            this._grpPosition.Controls.Add(this._chkCenterCeilingEnabled);
            this._grpPosition.Controls.Add(this._pnlLine);
            this._grpPosition.Controls.Add(this._pnlPositionH);
            this._grpPosition.Controls.Add(this._pnlPositionV);
            this._grpPosition.Name = "_grpPosition";
            this._grpPosition.TabStop = false;
            //
            // _lblDrawFromRightToLeft
            //
            resources.ApplyResources(this._lblDrawFromRightToLeft, "_lblDrawFromRightToLeft");
            this._lblDrawFromRightToLeft.Name = "_lblDrawFromRightToLeft";
            //
            // _chkDrawFromRightToLeft
            //
            resources.ApplyResources(this._chkDrawFromRightToLeft, "_chkDrawFromRightToLeft");
            this._chkDrawFromRightToLeft.Name = "_chkDrawFromRightToLeft";
            this._chkDrawFromRightToLeft.CheckedChanged += new System.EventHandler(this._chkDrawFromRightToLeft_CheckedChanged);
            //
            // _lblCenterCeilingEnabled
            //
            resources.ApplyResources(this._lblCenterCeilingEnabled, "_lblCenterCeilingEnabled");
            this._lblCenterCeilingEnabled.Name = "_lblCenterCeilingEnabled";
            //
            // _chkCenterCeilingEnabled
            //
            resources.ApplyResources(this._chkCenterCeilingEnabled, "_chkCenterCeilingEnabled");
            this._chkCenterCeilingEnabled.Name = "_chkCenterCeilingEnabled";
            this._chkCenterCeilingEnabled.CheckedChanged += new System.EventHandler(this._chkCenterCeilingEnabled_CheckedChanged);
            //
            // _pnlLine
            //
            this._pnlLine.Controls.Add(this._radAlignNotSpecified);
            this._pnlLine.Controls.Add(this._radAlignCenter);
            this._pnlLine.Controls.Add(this._radAlignLeft);
            this._pnlLine.Controls.Add(this._radAlignRight);
            this._pnlLine.Controls.Add(this._lblLineAlignment);
            resources.ApplyResources(this._pnlLine, "_pnlLine");
            this._pnlLine.Name = "_pnlLine";
            //
            // _radAlignNotSpecified
            //
            resources.ApplyResources(this._radAlignNotSpecified, "_radAlignNotSpecified");
            this._radAlignNotSpecified.Name = "_radAlignNotSpecified";
            //
            // _radAlignCenter
            //
            resources.ApplyResources(this._radAlignCenter, "_radAlignCenter");
            this._radAlignCenter.Name = "_radAlignCenter";
            //
            // _radAlignLeft
            //
            resources.ApplyResources(this._radAlignLeft, "_radAlignLeft");
            this._radAlignLeft.Name = "_radAlignLeft";
            //
            // _radAlignRight
            //
            resources.ApplyResources(this._radAlignRight, "_radAlignRight");
            this._radAlignRight.Name = "_radAlignRight";
            //
            // _lblLineAlignment
            //
            resources.ApplyResources(this._lblLineAlignment, "_lblLineAlignment");
            this._lblLineAlignment.Name = "_lblLineAlignment";
            //
            // _pnlPositionH
            //
            this._pnlPositionH.Controls.Add(this._radPosHCenter);
            this._pnlPositionH.Controls.Add(this._radPosHLeft);
            this._pnlPositionH.Controls.Add(this._radPosHRight);
            this._pnlPositionH.Controls.Add(this._lblPositionH);
            resources.ApplyResources(this._pnlPositionH, "_pnlPositionH");
            this._pnlPositionH.Name = "_pnlPositionH";
            //
            // _radPosHCenter
            //
            resources.ApplyResources(this._radPosHCenter, "_radPosHCenter");
            this._radPosHCenter.Name = "_radPosHCenter";
            //
            // _radPosHLeft
            //
            resources.ApplyResources(this._radPosHLeft, "_radPosHLeft");
            this._radPosHLeft.Name = "_radPosHLeft";
            //
            // _radPosHRight
            //
            resources.ApplyResources(this._radPosHRight, "_radPosHRight");
            this._radPosHRight.Name = "_radPosHRight";
            //
            // _lblPositionH
            //
            resources.ApplyResources(this._lblPositionH, "_lblPositionH");
            this._lblPositionH.Name = "_lblPositionH";
            //
            // _pnlPositionV
            //
            this._pnlPositionV.Controls.Add(this._radPosVCenter);
            this._pnlPositionV.Controls.Add(this._radPosVTop);
            this._pnlPositionV.Controls.Add(this._radPosVBottom);
            this._pnlPositionV.Controls.Add(this._lblPositionV);
            resources.ApplyResources(this._pnlPositionV, "_pnlPositionV");
            this._pnlPositionV.Name = "_pnlPositionV";
            //
            // _radPosVCenter
            //
            resources.ApplyResources(this._radPosVCenter, "_radPosVCenter");
            this._radPosVCenter.Name = "_radPosVCenter";
            //
            // _radPosVTop
            //
            resources.ApplyResources(this._radPosVTop, "_radPosVTop");
            this._radPosVTop.Name = "_radPosVTop";
            //
            // _radPosVBottom
            //
            resources.ApplyResources(this._radPosVBottom, "_radPosVBottom");
            this._radPosVBottom.Name = "_radPosVBottom";
            //
            // _lblPositionV
            //
            resources.ApplyResources(this._lblPositionV, "_lblPositionV");
            this._lblPositionV.Name = "_lblPositionV";
            //
            // _grpLineWidthOffset
            //
            resources.ApplyResources(this._grpLineWidthOffset, "_grpLineWidthOffset");
            this._grpLineWidthOffset.Controls.Add(this._tbxLineWidthOffsetSizeX);
            this._grpLineWidthOffset.Controls.Add(this._lblLineWidthOffsetSizeX);
            this._grpLineWidthOffset.Controls.Add(this._ctlLineWidthOffsetRight0);
            this._grpLineWidthOffset.Controls.Add(this._lblLineWidthOffsetInfo0);
            this._grpLineWidthOffset.Controls.Add(this._chkLineWidthOffsetEnabled);
            this._grpLineWidthOffset.Controls.Add(this._ctlLineWidthOffsetLeft0);
            this._grpLineWidthOffset.Name = "_grpLineWidthOffset";
            this._grpLineWidthOffset.TabStop = false;
            //
            // _tbxLineWidthOffsetSizeX
            //
            this._tbxLineWidthOffsetSizeX.AccessibleRole = System.Windows.Forms.AccessibleRole.None;
            this._tbxLineWidthOffsetSizeX.Format = "f2";
            resources.ApplyResources(this._tbxLineWidthOffsetSizeX, "_tbxLineWidthOffsetSizeX");
            this._tbxLineWidthOffsetSizeX.MaxValue = 100000F;
            this._tbxLineWidthOffsetSizeX.MinValue = -100000F;
            this._tbxLineWidthOffsetSizeX.Name = "_tbxLineWidthOffsetSizeX";
            this._tbxLineWidthOffsetSizeX.ReadOnly = true;
            //
            // _lblLineWidthOffsetSizeX
            //
            resources.ApplyResources(this._lblLineWidthOffsetSizeX, "_lblLineWidthOffsetSizeX");
            this._lblLineWidthOffsetSizeX.Name = "_lblLineWidthOffsetSizeX";
            //
            // _ctlLineWidthOffsetRight0
            //
            this._ctlLineWidthOffsetRight0.DecimalPlaces = 2;
            resources.ApplyResources(this._ctlLineWidthOffsetRight0, "_ctlLineWidthOffsetRight0");
            this._ctlLineWidthOffsetRight0.Maximum = new decimal(new int[] {
            0,
            0,
            0,
            0});
            this._ctlLineWidthOffsetRight0.Minimum = new decimal(new int[] {
            1000,
            0,
            0,
            -2147483648});
            this._ctlLineWidthOffsetRight0.Name = "_ctlLineWidthOffsetRight0";
            this._ctlLineWidthOffsetRight0.ValueChanged += new System.EventHandler(this.Event_ctlLineWidthOffsetRight0_ValueChanged);
            //
            // _lblLineWidthOffsetInfo0
            //
            this._lblLineWidthOffsetInfo0.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
            resources.ApplyResources(this._lblLineWidthOffsetInfo0, "_lblLineWidthOffsetInfo0");
            this._lblLineWidthOffsetInfo0.Name = "_lblLineWidthOffsetInfo0";
            //
            // _chkLineWidthOffsetEnabled
            //
            resources.ApplyResources(this._chkLineWidthOffsetEnabled, "_chkLineWidthOffsetEnabled");
            this._chkLineWidthOffsetEnabled.Name = "_chkLineWidthOffsetEnabled";
            this._chkLineWidthOffsetEnabled.UseVisualStyleBackColor = true;
            this._chkLineWidthOffsetEnabled.CheckedChanged += new System.EventHandler(this.Event_chkLineWidthOffsetEnabled_CheckedChanged);
            //
            // _ctlLineWidthOffsetLeft0
            //
            this._ctlLineWidthOffsetLeft0.DecimalPlaces = 2;
            resources.ApplyResources(this._ctlLineWidthOffsetLeft0, "_ctlLineWidthOffsetLeft0");
            this._ctlLineWidthOffsetLeft0.Maximum = new decimal(new int[] {
            0,
            0,
            0,
            0});
            this._ctlLineWidthOffsetLeft0.Minimum = new decimal(new int[] {
            1000,
            0,
            0,
            -2147483648});
            this._ctlLineWidthOffsetLeft0.Name = "_ctlLineWidthOffsetLeft0";
            this._ctlLineWidthOffsetLeft0.ValueChanged += new System.EventHandler(this.Event_ctlLineWidthOffsetLeft0_ValueChanged);
            //
            // _grpColor
            //
            resources.ApplyResources(this._grpColor, "_grpColor");
            this._grpColor.Controls.Add(this._lblVtxColBottom);
            this._grpColor.Controls.Add(this._lblVtxColTop);
            this._grpColor.Controls.Add(this._pnlTextColor);
            this._grpColor.Controls.Add(this._ctlVtxColTop);
            this._grpColor.Controls.Add(this._ctlVtxColBottom);
            this._grpColor.Name = "_grpColor";
            this._grpColor.TabStop = false;
            //
            // _lblVtxColBottom
            //
            resources.ApplyResources(this._lblVtxColBottom, "_lblVtxColBottom");
            this._lblVtxColBottom.Name = "_lblVtxColBottom";
            this._lblVtxColBottom.UseAnimationMark = false;
            this._lblVtxColBottom.UseContextMenu = false;
            //
            // _lblVtxColTop
            //
            resources.ApplyResources(this._lblVtxColTop, "_lblVtxColTop");
            this._lblVtxColTop.Name = "_lblVtxColTop";
            this._lblVtxColTop.UseAnimationMark = false;
            this._lblVtxColTop.UseContextMenu = false;
            //
            // _pnlTextColor
            //
            resources.ApplyResources(this._pnlTextColor, "_pnlTextColor");
            this._pnlTextColor.Name = "_pnlTextColor";
            this._pnlTextColor.ColorChange += new LayoutEditor.Controls.TextColorPanel.OnColorChange(this.Event_pnlTextColor_ColorChange);
            //
            // _ctlVtxColTop
            //
            this._ctlVtxColTop.AllowDrop = true;
            this._ctlVtxColTop.ColorButtonVisible = false;
            resources.ApplyResources(this._ctlVtxColTop, "_ctlVtxColTop");
            this._ctlVtxColTop.Name = "_ctlVtxColTop";
            this._ctlVtxColTop.Tag = "";
            this._ctlVtxColTop.UseAnimationMark = true;
            //
            // _ctlVtxColBottom
            //
            this._ctlVtxColBottom.AllowDrop = true;
            this._ctlVtxColBottom.ColorButtonVisible = false;
            resources.ApplyResources(this._ctlVtxColBottom, "_ctlVtxColBottom");
            this._ctlVtxColBottom.Name = "_ctlVtxColBottom";
            this._ctlVtxColBottom.Tag = "";
            this._ctlVtxColBottom.UseAnimationMark = true;
            //
            // _grpEtc
            //
            resources.ApplyResources(this._grpEtc, "_grpEtc");
            this._grpEtc.Controls.Add(this._chkAllocByte);
            this._grpEtc.Controls.Add(this._tbxAllocByte);
            this._grpEtc.Controls.Add(this._lblAllocByte);
            this._grpEtc.Name = "_grpEtc";
            this._grpEtc.TabStop = false;
            //
            // _chkAllocByte
            //
            resources.ApplyResources(this._chkAllocByte, "_chkAllocByte");
            this._chkAllocByte.Name = "_chkAllocByte";
            this._chkAllocByte.CheckedChanged += new System.EventHandler(this.Event_ChkAllocByte_CheckedChanged);
            //
            // _tbxAllocByte
            //
            this._tbxAllocByte.AccessibleRole = System.Windows.Forms.AccessibleRole.None;
            resources.ApplyResources(this._tbxAllocByte, "_tbxAllocByte");
            this._tbxAllocByte.MaxValue = 100000;
            this._tbxAllocByte.MinValue = 0;
            this._tbxAllocByte.Name = "_tbxAllocByte";
            this._tbxAllocByte.ValueChanged += new System.EventHandler(this.Event_TbxAllocByte_ValueChanged);
            //
            // _lblAllocByte
            //
            resources.ApplyResources(this._lblAllocByte, "_lblAllocByte");
            this._lblAllocByte.Name = "_lblAllocByte";
            //
            // _rgpShadow
            //
            resources.ApplyResources(this._rgpShadow, "_rgpShadow");
            this._rgpShadow.Controls.Add(this._pnlShadowEnabled);
            this._rgpShadow.Controls.Add(this._chkShadowEnabled);
            this._rgpShadow.Name = "_rgpShadow";
            this._rgpShadow.TabStop = false;
            //
            // _pnlShadowEnabled
            //
            this._pnlShadowEnabled.Controls.Add(this._lblWhiteColor);
            this._pnlShadowEnabled.Controls.Add(this._lblBlackColor);
            this._pnlShadowEnabled.Controls.Add(this._tbxShadowItalicRate);
            this._pnlShadowEnabled.Controls.Add(this._lblShadowItalicAngle);
            this._pnlShadowEnabled.Controls.Add(this._pnlShadowTextColor);
            this._pnlShadowEnabled.Controls.Add(this._colShadowWhiteColor);
            this._pnlShadowEnabled.Controls.Add(this._colShadowBlackColor);
            this._pnlShadowEnabled.Controls.Add(this._fesShadowItalic);
            this._pnlShadowEnabled.Controls.Add(this._colShadowColorTop);
            this._pnlShadowEnabled.Controls.Add(this._colShadowColorBottom);
            this._pnlShadowEnabled.Controls.Add(this._lblShadowOffset);
            this._pnlShadowEnabled.Controls.Add(this._lblShadowColorBottom);
            this._pnlShadowEnabled.Controls.Add(this._lblShadowColorTop);
            this._pnlShadowEnabled.Controls.Add(this._nudShadowOffset);
            this._pnlShadowEnabled.Controls.Add(this._nudShadowScale);
            this._pnlShadowEnabled.Controls.Add(this._lblShadowScale);
            this._pnlShadowEnabled.Controls.Add(this._lblShadowItalic);
            resources.ApplyResources(this._pnlShadowEnabled, "_pnlShadowEnabled");
            this._pnlShadowEnabled.Name = "_pnlShadowEnabled";
            //
            // _lblWhiteColor
            //
            resources.ApplyResources(this._lblWhiteColor, "_lblWhiteColor");
            this._lblWhiteColor.Name = "_lblWhiteColor";
            this._lblWhiteColor.UseAnimationMark = false;
            this._lblWhiteColor.UseContextMenu = false;
            //
            // _lblBlackColor
            //
            resources.ApplyResources(this._lblBlackColor, "_lblBlackColor");
            this._lblBlackColor.Name = "_lblBlackColor";
            this._lblBlackColor.UseAnimationMark = false;
            this._lblBlackColor.UseContextMenu = false;
            //
            // _tbxShadowItalicRate
            //
            this._tbxShadowItalicRate.AccessibleRole = System.Windows.Forms.AccessibleRole.None;
            this._tbxShadowItalicRate.Format = "f2";
            resources.ApplyResources(this._tbxShadowItalicRate, "_tbxShadowItalicRate");
            this._tbxShadowItalicRate.MaxValue = 100000F;
            this._tbxShadowItalicRate.MinValue = -100000F;
            this._tbxShadowItalicRate.Name = "_tbxShadowItalicRate";
            this._tbxShadowItalicRate.ReadOnly = true;
            //
            // _lblShadowItalicAngle
            //
            resources.ApplyResources(this._lblShadowItalicAngle, "_lblShadowItalicAngle");
            this._lblShadowItalicAngle.Name = "_lblShadowItalicAngle";
            //
            // _pnlShadowTextColor
            //
            resources.ApplyResources(this._pnlShadowTextColor, "_pnlShadowTextColor");
            this._pnlShadowTextColor.Name = "_pnlShadowTextColor";
            this._pnlShadowTextColor.ColorChange += new LayoutEditor.Controls.TextColorPanel.OnColorChange(this.Event_pnlShadowTextColor_ColorChange);
            //
            // _lblShadowOffset
            //
            resources.ApplyResources(this._lblShadowOffset, "_lblShadowOffset");
            this._lblShadowOffset.Name = "_lblShadowOffset";
            //
            // _lblShadowColorBottom
            //
            resources.ApplyResources(this._lblShadowColorBottom, "_lblShadowColorBottom");
            this._lblShadowColorBottom.Name = "_lblShadowColorBottom";
            //
            // _lblShadowColorTop
            //
            resources.ApplyResources(this._lblShadowColorTop, "_lblShadowColorTop");
            this._lblShadowColorTop.Name = "_lblShadowColorTop";
            //
            // _lblShadowScale
            //
            resources.ApplyResources(this._lblShadowScale, "_lblShadowScale");
            this._lblShadowScale.Name = "_lblShadowScale";
            //
            // _lblShadowItalic
            //
            resources.ApplyResources(this._lblShadowItalic, "_lblShadowItalic");
            this._lblShadowItalic.Name = "_lblShadowItalic";
            //
            // _chkShadowEnabled
            //
            resources.ApplyResources(this._chkShadowEnabled, "_chkShadowEnabled");
            this._chkShadowEnabled.Name = "_chkShadowEnabled";
            this._chkShadowEnabled.CheckedChanged += new System.EventHandler(this.Event_chkShadowEnabled_CheckedChanged);
            //
            // _grpPerCharTransform
            //
            resources.ApplyResources(this._grpPerCharTransform, "_grpPerCharTransform");
            this._grpPerCharTransform.Controls.Add(this._lblPerCharTransform);
            this._grpPerCharTransform.Controls.Add(this._pnlPerCharTransform);
            this._grpPerCharTransform.Controls.Add(this._chkPerCharTransformEnabled);
            this._grpPerCharTransform.Name = "_grpPerCharTransform";
            this._grpPerCharTransform.TabStop = false;
            //
            // _lblPerCharTransform
            //
            resources.ApplyResources(this._lblPerCharTransform, "_lblPerCharTransform");
            this._lblPerCharTransform.Name = "_lblPerCharTransform";
            this._lblPerCharTransform.UseAnimationMark = false;
            this._lblPerCharTransform.UseContextMenu = false;
            //
            // _pnlPerCharTransform
            //
            this._pnlPerCharTransform.Controls.Add(this._grpPerCharTransformFixSpace);
            this._pnlPerCharTransform.Controls.Add(this._btnPerCharTransformEasyCircle);
            this._pnlPerCharTransform.Controls.Add(this._chkPerCharTransformOriginToCenter);
            this._pnlPerCharTransform.Controls.Add(this._lblPerCharTransWidth);
            this._pnlPerCharTransform.Controls.Add(this._tbxPerCharTransWidth);
            this._pnlPerCharTransform.Controls.Add(this._lblPerCharTransOffset);
            this._pnlPerCharTransform.Controls.Add(this._tbxPerCharTransOffset);
            this._pnlPerCharTransform.Controls.Add(this._chkPerCharTransformAutoShadowAlpha);
            this._pnlPerCharTransform.Controls.Add(this._chkPerCharTransformSplitByCharWidth);
            this._pnlPerCharTransform.Controls.Add(this._btnEasySettingOfPerCharTransform);
            this._pnlPerCharTransform.Controls.Add(this._pnlPerCharLoop);
            this._pnlPerCharTransform.Controls.Add(this._pnlPerCharOriginV);
            resources.ApplyResources(this._pnlPerCharTransform, "_pnlPerCharTransform");
            this._pnlPerCharTransform.Name = "_pnlPerCharTransform";
            //
            // _grpPerCharTransformFixSpace
            //
            this._grpPerCharTransformFixSpace.Controls.Add(this._pnlPerCharTransformFixSpaceOrigin);
            this._grpPerCharTransformFixSpace.Controls.Add(this._tbxPerCharTransformFixSpaceWidth);
            this._grpPerCharTransformFixSpace.Controls.Add(this._lblPerCharTransformFixSpaceWidth);
            this._grpPerCharTransformFixSpace.Controls.Add(this._chkPerCharTransformFixSpaceEnabled);
            resources.ApplyResources(this._grpPerCharTransformFixSpace, "_grpPerCharTransformFixSpace");
            this._grpPerCharTransformFixSpace.Name = "_grpPerCharTransformFixSpace";
            this._grpPerCharTransformFixSpace.TabStop = false;
            //
            // _pnlPerCharTransformFixSpaceOrigin
            //
            this._pnlPerCharTransformFixSpaceOrigin.Controls.Add(this._radPerCharTransformFixSpaceOriginCenter);
            this._pnlPerCharTransformFixSpaceOrigin.Controls.Add(this._radPerCharTransformFixSpaceOriginLeft);
            this._pnlPerCharTransformFixSpaceOrigin.Controls.Add(this._radPerCharTransformFixSpaceOriginRight);
            this._pnlPerCharTransformFixSpaceOrigin.Controls.Add(this._lblPerCharTransformFixSpaceOrigin);
            resources.ApplyResources(this._pnlPerCharTransformFixSpaceOrigin, "_pnlPerCharTransformFixSpaceOrigin");
            this._pnlPerCharTransformFixSpaceOrigin.Name = "_pnlPerCharTransformFixSpaceOrigin";
            //
            // _radPerCharTransformFixSpaceOriginCenter
            //
            resources.ApplyResources(this._radPerCharTransformFixSpaceOriginCenter, "_radPerCharTransformFixSpaceOriginCenter");
            this._radPerCharTransformFixSpaceOriginCenter.Name = "_radPerCharTransformFixSpaceOriginCenter";
            //
            // _radPerCharTransformFixSpaceOriginLeft
            //
            resources.ApplyResources(this._radPerCharTransformFixSpaceOriginLeft, "_radPerCharTransformFixSpaceOriginLeft");
            this._radPerCharTransformFixSpaceOriginLeft.Name = "_radPerCharTransformFixSpaceOriginLeft";
            //
            // _radPerCharTransformFixSpaceOriginRight
            //
            resources.ApplyResources(this._radPerCharTransformFixSpaceOriginRight, "_radPerCharTransformFixSpaceOriginRight");
            this._radPerCharTransformFixSpaceOriginRight.Name = "_radPerCharTransformFixSpaceOriginRight";
            //
            // _lblPerCharTransformFixSpaceOrigin
            //
            resources.ApplyResources(this._lblPerCharTransformFixSpaceOrigin, "_lblPerCharTransformFixSpaceOrigin");
            this._lblPerCharTransformFixSpaceOrigin.Name = "_lblPerCharTransformFixSpaceOrigin";
            //
            // _tbxPerCharTransformFixSpaceWidth
            //
            this._tbxPerCharTransformFixSpaceWidth.AccessibleRole = System.Windows.Forms.AccessibleRole.None;
            this._tbxPerCharTransformFixSpaceWidth.Format = "f2";
            resources.ApplyResources(this._tbxPerCharTransformFixSpaceWidth, "_tbxPerCharTransformFixSpaceWidth");
            this._tbxPerCharTransformFixSpaceWidth.MaxValue = 100000F;
            this._tbxPerCharTransformFixSpaceWidth.MinValue = -100000F;
            this._tbxPerCharTransformFixSpaceWidth.Name = "_tbxPerCharTransformFixSpaceWidth";
            this._tbxPerCharTransformFixSpaceWidth.ValueChanged += new System.EventHandler(this.Event_tbxPerCharTransformFixSpaceWidth_ValueChanged);
            //
            // _lblPerCharTransformFixSpaceWidth
            //
            resources.ApplyResources(this._lblPerCharTransformFixSpaceWidth, "_lblPerCharTransformFixSpaceWidth");
            this._lblPerCharTransformFixSpaceWidth.Name = "_lblPerCharTransformFixSpaceWidth";
            //
            // _chkPerCharTransformFixSpaceEnabled
            //
            resources.ApplyResources(this._chkPerCharTransformFixSpaceEnabled, "_chkPerCharTransformFixSpaceEnabled");
            this._chkPerCharTransformFixSpaceEnabled.Name = "_chkPerCharTransformFixSpaceEnabled";
            this._chkPerCharTransformFixSpaceEnabled.UseVisualStyleBackColor = true;
            this._chkPerCharTransformFixSpaceEnabled.CheckedChanged += new System.EventHandler(this.Event_chkPerCharTransformFixSpaceEnabled_CheckedChanged);
            //
            // _btnPerCharTransformEasyCircle
            //
            resources.ApplyResources(this._btnPerCharTransformEasyCircle, "_btnPerCharTransformEasyCircle");
            this._btnPerCharTransformEasyCircle.Name = "_btnPerCharTransformEasyCircle";
            this._btnPerCharTransformEasyCircle.UseVisualStyleBackColor = true;
            this._btnPerCharTransformEasyCircle.Click += new System.EventHandler(this.Event_BtnPerCharTransformEasyCircle_Click);
            //
            // _lblPerCharTransWidth
            //
            resources.ApplyResources(this._lblPerCharTransWidth, "_lblPerCharTransWidth");
            this._lblPerCharTransWidth.Name = "_lblPerCharTransWidth";
            this._lblPerCharTransWidth.UseAnimationMark = false;
            this._lblPerCharTransWidth.UseContextMenu = false;
            //
            // _tbxPerCharTransWidth
            //
            this._tbxPerCharTransWidth.AnimationMarkSize = new System.Drawing.Size(5, 19);
            resources.ApplyResources(this._tbxPerCharTransWidth, "_tbxPerCharTransWidth");
            this._tbxPerCharTransWidth.Name = "_tbxPerCharTransWidth";
            this._tbxPerCharTransWidth.TextBoxAccessibleRole = System.Windows.Forms.AccessibleRole.None;
            this._tbxPerCharTransWidth.TextBoxAlign = System.Windows.Forms.HorizontalAlignment.Left;
            this._tbxPerCharTransWidth.TextBoxBackColor = System.Drawing.SystemColors.Window;
            this._tbxPerCharTransWidth.TextBoxFormat = "f2";
            this._tbxPerCharTransWidth.TextBoxMaxValue = 100000F;
            this._tbxPerCharTransWidth.TextBoxMinValue = -100000F;
            this._tbxPerCharTransWidth.TextBoxSize = new System.Drawing.Size(48, 19);
            this._tbxPerCharTransWidth.TextBoxValue = 0F;
            this._tbxPerCharTransWidth.UseAnimationMark = true;
            this._tbxPerCharTransWidth.TextBoxValueChanged += new System.EventHandler(this.Event_tbxPerCharTransWidth_ValueChanged);
            //
            // _lblPerCharTransOffset
            //
            resources.ApplyResources(this._lblPerCharTransOffset, "_lblPerCharTransOffset");
            this._lblPerCharTransOffset.Name = "_lblPerCharTransOffset";
            this._lblPerCharTransOffset.UseAnimationMark = false;
            this._lblPerCharTransOffset.UseContextMenu = false;
            //
            // _tbxPerCharTransOffset
            //
            this._tbxPerCharTransOffset.AnimationMarkSize = new System.Drawing.Size(5, 19);
            resources.ApplyResources(this._tbxPerCharTransOffset, "_tbxPerCharTransOffset");
            this._tbxPerCharTransOffset.Name = "_tbxPerCharTransOffset";
            this._tbxPerCharTransOffset.TextBoxAccessibleRole = System.Windows.Forms.AccessibleRole.None;
            this._tbxPerCharTransOffset.TextBoxAlign = System.Windows.Forms.HorizontalAlignment.Left;
            this._tbxPerCharTransOffset.TextBoxBackColor = System.Drawing.SystemColors.Window;
            this._tbxPerCharTransOffset.TextBoxFormat = "F2";
            this._tbxPerCharTransOffset.TextBoxMaxValue = 100000F;
            this._tbxPerCharTransOffset.TextBoxMinValue = -100000F;
            this._tbxPerCharTransOffset.TextBoxSize = new System.Drawing.Size(48, 19);
            this._tbxPerCharTransOffset.TextBoxValue = 0F;
            this._tbxPerCharTransOffset.UseAnimationMark = true;
            this._tbxPerCharTransOffset.TextBoxValueChanged += new System.EventHandler(this.Event_tbxPerCharTransOffset_ValueChanged);
            //
            // _chkPerCharTransformAutoShadowAlpha
            //
            resources.ApplyResources(this._chkPerCharTransformAutoShadowAlpha, "_chkPerCharTransformAutoShadowAlpha");
            this._chkPerCharTransformAutoShadowAlpha.Name = "_chkPerCharTransformAutoShadowAlpha";
            this._chkPerCharTransformAutoShadowAlpha.CheckedChanged += new System.EventHandler(this.Event_chkPerCharTransformAutoShadowAlpha_CheckedChanged);
            //
            // _btnEasySettingOfPerCharTransform
            //
            resources.ApplyResources(this._btnEasySettingOfPerCharTransform, "_btnEasySettingOfPerCharTransform");
            this._btnEasySettingOfPerCharTransform.Name = "_btnEasySettingOfPerCharTransform";
            this._btnEasySettingOfPerCharTransform.UseVisualStyleBackColor = true;
            this._btnEasySettingOfPerCharTransform.Click += new System.EventHandler(this.Event_BtnEasySettingOfPerCharTransform_Click);
            //
            // _pnlPerCharLoop
            //
            this._pnlPerCharLoop.BackColor = System.Drawing.SystemColors.Control;
            this._pnlPerCharLoop.Controls.Add(this._radPerCharLoopLoop);
            this._pnlPerCharLoop.Controls.Add(this._lblPerCharLoop);
            this._pnlPerCharLoop.Controls.Add(this._radPerCharLoopOneTime);
            resources.ApplyResources(this._pnlPerCharLoop, "_pnlPerCharLoop");
            this._pnlPerCharLoop.Name = "_pnlPerCharLoop";
            //
            // _radPerCharLoopLoop
            //
            resources.ApplyResources(this._radPerCharLoopLoop, "_radPerCharLoopLoop");
            this._radPerCharLoopLoop.Name = "_radPerCharLoopLoop";
            //
            // _lblPerCharLoop
            //
            resources.ApplyResources(this._lblPerCharLoop, "_lblPerCharLoop");
            this._lblPerCharLoop.Name = "_lblPerCharLoop";
            //
            // _radPerCharLoopOneTime
            //
            resources.ApplyResources(this._radPerCharLoopOneTime, "_radPerCharLoopOneTime");
            this._radPerCharLoopOneTime.Name = "_radPerCharLoopOneTime";
            //
            // _pnlPerCharOriginV
            //
            this._pnlPerCharOriginV.BackColor = System.Drawing.SystemColors.Control;
            this._pnlPerCharOriginV.Controls.Add(this._tbxPerCharOriginVOffset);
            this._pnlPerCharOriginV.Controls.Add(this._lblPerCharOriginVOffset);
            this._pnlPerCharOriginV.Controls.Add(this._lblPerCharOriginV);
            this._pnlPerCharOriginV.Controls.Add(this._radPerCharOriginVCenter);
            this._pnlPerCharOriginV.Controls.Add(this._radPerCharOriginVBottom);
            resources.ApplyResources(this._pnlPerCharOriginV, "_pnlPerCharOriginV");
            this._pnlPerCharOriginV.Name = "_pnlPerCharOriginV";
            //
            // _tbxPerCharOriginVOffset
            //
            this._tbxPerCharOriginVOffset.AccessibleRole = System.Windows.Forms.AccessibleRole.None;
            this._tbxPerCharOriginVOffset.Format = "f2";
            resources.ApplyResources(this._tbxPerCharOriginVOffset, "_tbxPerCharOriginVOffset");
            this._tbxPerCharOriginVOffset.MaxValue = 100000F;
            this._tbxPerCharOriginVOffset.MinValue = -100000F;
            this._tbxPerCharOriginVOffset.Name = "_tbxPerCharOriginVOffset";
            this._tbxPerCharOriginVOffset.ValueChanged += new System.EventHandler(this.Event_tbxPerCharOriginVOffset_ValueChanged);
            //
            // _lblPerCharOriginVOffset
            //
            resources.ApplyResources(this._lblPerCharOriginVOffset, "_lblPerCharOriginVOffset");
            this._lblPerCharOriginVOffset.Name = "_lblPerCharOriginVOffset";
            //
            // _lblPerCharOriginV
            //
            resources.ApplyResources(this._lblPerCharOriginV, "_lblPerCharOriginV");
            this._lblPerCharOriginV.Name = "_lblPerCharOriginV";
            //
            // _radPerCharOriginVCenter
            //
            resources.ApplyResources(this._radPerCharOriginVCenter, "_radPerCharOriginVCenter");
            this._radPerCharOriginVCenter.Name = "_radPerCharOriginVCenter";
            //
            // _radPerCharOriginVBottom
            //
            resources.ApplyResources(this._radPerCharOriginVBottom, "_radPerCharOriginVBottom");
            this._radPerCharOriginVBottom.Name = "_radPerCharOriginVBottom";
            //
            // _chkPerCharTransformEnabled
            //
            resources.ApplyResources(this._chkPerCharTransformEnabled, "_chkPerCharTransformEnabled");
            this._chkPerCharTransformEnabled.Name = "_chkPerCharTransformEnabled";
            this._chkPerCharTransformEnabled.CheckedChanged += new System.EventHandler(this.Event_chkPerCharTransformEnabled_CheckedChanged);
            //
            // _erpMain
            //
            this._erpMain.ContainerControl = this;
            //
            // TextBoxPanePage
            //
            this.Controls.Add(this._flyMain);
            this.Name = "TextBoxPanePage";
            this.Sizable = true;
            resources.ApplyResources(this, "$this");
            this._flyMain.ResumeLayout(false);
            this._grpFontInfo.ResumeLayout(false);
            this._grpFontInfo.PerformLayout();
            this._pnlBorder.ResumeLayout(false);
            this._grpContents.ResumeLayout(false);
            this._grpContents.PerformLayout();
            this._grpFontSize.ResumeLayout(false);
            this._grpFontSize.PerformLayout();
            this._grpPosition.ResumeLayout(false);
            this._pnlLine.ResumeLayout(false);
            this._pnlPositionH.ResumeLayout(false);
            this._pnlPositionV.ResumeLayout(false);
            this._grpLineWidthOffset.ResumeLayout(false);
            this._grpLineWidthOffset.PerformLayout();
            ((System.ComponentModel.ISupportInitialize)(this._ctlLineWidthOffsetRight0)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this._ctlLineWidthOffsetLeft0)).EndInit();
            this._grpColor.ResumeLayout(false);
            this._grpColor.PerformLayout();
            this._grpEtc.ResumeLayout(false);
            this._grpEtc.PerformLayout();
            this._rgpShadow.ResumeLayout(false);
            this._pnlShadowEnabled.ResumeLayout(false);
            this._pnlShadowEnabled.PerformLayout();
            this._grpPerCharTransform.ResumeLayout(false);
            this._grpPerCharTransform.PerformLayout();
            this._pnlPerCharTransform.ResumeLayout(false);
            this._pnlPerCharTransform.PerformLayout();
            this._grpPerCharTransformFixSpace.ResumeLayout(false);
            this._grpPerCharTransformFixSpace.PerformLayout();
            this._pnlPerCharTransformFixSpaceOrigin.ResumeLayout(false);
            this._pnlPerCharLoop.ResumeLayout(false);
            this._pnlPerCharOriginV.ResumeLayout(false);
            this._pnlPerCharOriginV.PerformLayout();
            ((System.ComponentModel.ISupportInitialize)(this._erpMain)).EndInit();
            this.ResumeLayout(false);

        }
        #endregion デザイナコード

        #region プロパティ
        /// <summary>
        /// 捜査対象ペインアダプタ
        /// </summary>
        PaneGUIAdapter _TargetPane
        {
            get
            {
                PaneGUIAdapter  paneAdapter = Target.Active;
                return paneAdapter;
            }
        }

        /// <summary>
        /// 操作対象ペインを操作するクラスを取得します。
        /// </summary>
        protected TextBoxManipulator _TargetTextBoxMpn
        {
            get { return _TargetPane.FindTargetTextBoxManipulator(_TargetIndex); }
        }

        /// <summary>
        /// 複数が対象にある場合に、何番目を対象とするかを指定します。
        /// </summary>
        protected int _TargetIndex
        {
            get;
            set;
        }

        protected FlowLayoutPanel BasePanel { get { return _flyMain; } }
        protected GroupBox ContentGroup { get { return _grpContents; } }
        protected GroupBox FontInfoGroup {get { return _grpFontInfo; }}
        protected GroupBox FontSizeGroup { get { return _grpFontSize; } }
        protected GroupBox ShadowGroup { get { return _rgpShadow; } }
        protected GroupBox EtcGroup { get { return _grpEtc; } }
        protected GroupBox ColorGroup { get { return _grpColor; } }
        protected GroupBox PositionGroup { get { return _grpPosition; } }
        protected Button AdjustPaneSizeButton { get { return _btnAdjustPaneSize; } }

        #endregion プロパティ

        #region フィールド

        /// <summary>
        /// フォーカス失効時にIMEを保存したかどうか
        /// </summary>
        bool _ContentTextBoxImeEnabled = false;

        #endregion フィールド

        #region PropertyPage からのオーバーライド
        /// <summary>
        /// プロパティ初期化。
        /// </summary>
        protected override void InitializeProperty()
        {
            // 何もしません
            _ctlVtxColTop.ColorEdit += new ColorEditEventHandler(Event_CtlVtxCol_ColorEdit);
            _ctlVtxColBottom.ColorEdit += new ColorEditEventHandler(Event_CtlVtxCol_ColorEdit);
            _ctlFontSizePixel.OnFVec2Edit += new FVec2EditEventHandler(Event_CtlFontSizePixel_OnFVec2Edit);
            _ctlFontSizeScale.OnFVec2Edit += new FVec2EditEventHandler(Event_CtlFontSizeScale_OnFVec2Edit);
            _ctlBlankSize.OnFVec2Edit += new FVec2EditEventHandler(Event_CtlBlankSize_OnFVec2Edit);

            // 水平位置
            _radPosHLeft.Tag    = HorizontalLocation.Left;
            _radPosHCenter.Tag  = HorizontalLocation.Center;
            _radPosHRight.Tag   = HorizontalLocation.Right;
            _radPosHLeft.RadioChecked += new EventHandler(Event_RadPosH_RadioChecked);
            _radPosHCenter.RadioChecked += new EventHandler(Event_RadPosH_RadioChecked);
            _radPosHRight.RadioChecked += new EventHandler(Event_RadPosH_RadioChecked);

            // 垂直位置
            _radPosVTop.Tag      = VerticalLocation.Top;
            _radPosVCenter.Tag   = VerticalLocation.Center;
            _radPosVBottom.Tag   = VerticalLocation.Bottom;
            _radPosVTop.RadioChecked += new EventHandler(Event_RadPosV_RadioChecked);
            _radPosVCenter.RadioChecked += new EventHandler(Event_RadPosV_RadioChecked);
            _radPosVBottom.RadioChecked += new EventHandler(Event_RadPosV_RadioChecked);

            // 行そろえ
            _radAlignNotSpecified.Tag = LineAlignment.NotSpecified;
            _radAlignLeft.Tag = LineAlignment.Left;
            _radAlignCenter.Tag = LineAlignment.Center;
            _radAlignRight.Tag = LineAlignment.Right;

            _radAlignNotSpecified.RadioChecked += Event_RadAlignNotSpecified_RadioChecked;
            _radAlignLeft.RadioChecked         += Event_RadAlignNotSpecified_RadioChecked;
            _radAlignCenter.RadioChecked       += Event_RadAlignNotSpecified_RadioChecked;
            _radAlignRight.RadioChecked        += Event_RadAlignNotSpecified_RadioChecked;

            _colShadowColorTop.ColorEdit += Event_colShadowColorTop_ColorEdit;
            _colShadowColorBottom.ColorEdit += Event_colShadowColorBottom_ColorEdit;

            _colShadowBlackColor.ColorEdit += Event_colShadowBlackColor_ColorEdit;
            _colShadowWhiteColor.ColorEdit += Event_colShadowWhiteColor_ColorEdit;

            _radPerCharLoopOneTime.Tag = PerCharTransformLoopType.OneTime;
            _radPerCharLoopLoop.Tag = PerCharTransformLoopType.Loop;
            _radPerCharLoopOneTime.RadioChecked += Event_radPerCharLoopOneTime_RadioChecked;
            _radPerCharLoopLoop.RadioChecked += Event_radPerCharLoopOneTime_RadioChecked;

            _radPerCharOriginVCenter.Tag = VerticalLocation.Center;
            _radPerCharOriginVBottom.Tag = VerticalLocation.Bottom;
            _radPerCharOriginVCenter.RadioChecked += Event_radPerCharOriginVTop_RadioChecked;
            _radPerCharOriginVBottom.RadioChecked += Event_radPerCharOriginVTop_RadioChecked;

            _radPerCharTransformFixSpaceOriginLeft.Tag = HorizontalLocation.Left;
            _radPerCharTransformFixSpaceOriginCenter.Tag = HorizontalLocation.Center;
            _radPerCharTransformFixSpaceOriginRight.Tag = HorizontalLocation.Right;
            _radPerCharTransformFixSpaceOriginLeft.RadioChecked += Event_radPerCharTransformFixSpaceOrigin_RadioChecked;
            _radPerCharTransformFixSpaceOriginCenter.RadioChecked += Event_radPerCharTransformFixSpaceOrigin_RadioChecked;
            _radPerCharTransformFixSpaceOriginRight.RadioChecked += Event_radPerCharTransformFixSpaceOrigin_RadioChecked;

            // ViewManagerへのメッセージハンドラを設定します
            _ctlVtxColTop.SetViewManagerMessageHandler(this.Owner.SendMessageToViewManagerAction);
            _ctlVtxColBottom.SetViewManagerMessageHandler(this.Owner.SendMessageToViewManagerAction);
            _colShadowBlackColor.SetViewManagerMessageHandler(this.Owner.SendMessageToViewManagerAction);
            _colShadowWhiteColor.SetViewManagerMessageHandler(this.Owner.SendMessageToViewManagerAction);
            _tbxPerCharTransOffset.SetViewManagerMessageHandler(this.Owner.SendMessageToViewManagerAction);
            _tbxPerCharTransWidth.SetViewManagerMessageHandler(this.Owner.SendMessageToViewManagerAction);
        }

        /// <summary>
        ///
        /// </summary>
        protected override void UpdateProperty()
        {
            // ターゲットを参照してUIを更新する
            SetDataToGUIControl_();
        }

        /// <summary>
        /// 連動ボタンを更新します
        /// </summary>
        private void UpdateLinkButton(ITextBox textbox)
        {
            if (textbox == null) return;

            _nudShadowScale.UpdateLinkButton(textbox.ShadowScale.X == textbox.ShadowScale.Y);
            _ctlFontSizeScale.UpdateLinkButton(textbox.FontScale.X == textbox.FontScale.Y);
        }

        /// <summary>
        /// インスタンス作成。
        /// </summary>
        public static PropertyPage CreateInstance(object arg)
        {
            var newInstance = new TextBoxPanePage();
            newInstance._TargetIndex = (arg == null) ? 0 : (int)arg;

            return newInstance;
        }

        public override void OnSceneModifyHandler(object sender, SceneModifyEventArgs e)
        {
            if (e.Target == SceneModifyEventArgs.Kind.PlatformChanged)
            {
                using (new GUIUpdating(this))
                {
                    UpdateProperty();
                }
            }
            else
            {
                base.OnSceneModifyHandler(sender, e);
            }
        }
        #endregion PropertyPage からのオーバーライド

        #region その他の変数

        /// <summary>
        /// 行ごとの幅とオフセットの左コントロール
        /// </summary>
        UINumericUpDown[] _ctlLineWidthOffsetLeft;

        /// <summary>
        /// 行ごとの幅とオフセットの情報
        /// </summary>
        Label[] _lblLineWidthOffsetInfo;

        /// <summary>
        /// 行ごとの幅とオフセットの右コントロール
        /// </summary>
        UINumericUpDown[] _ctlLineWidthOffsetRight;

        /// <summary>
        /// 行ごとの幅とオフセットのツールチップ
        /// </summary>
        LayoutEditor.Controls.DockContentToolTip _ttpLineWidthOffset;

        /// <summary>
        /// _grpLineWidthOffset のデフォルトの高さ
        /// </summary>
        int _grpLineWidthOffsetDefaultHeight = 0;

        /// <summary>
        /// Form のデフォルトの高さ
        /// </summary>
        protected int _FormDefaultHeight = 0;

        /// <summary>
        /// Form のデフォルトの高さ
        /// </summary>
        EasySettingOfPerCharTransformDlg _EasySettingOfPerCharTransformDlg = null;

        /// <summary>
        /// 前回選択されたオブジェクトGUIグループ
        /// </summary>
        PaneGuiAdapterGroup _oldTarget = null;

        #endregion

        /// <summary>
        /// コンストラクタ
        /// </summary>
        public TextBoxPanePage()
        {
            InitializeComponent();

            // 互換性を維持するためには、”指定しない”を設定します。
            //_cabLineAlignment.ToolTipText = StringResMgr.Get( "PROP_COMPATIVILITY_TOOLTIP_LINEALIGN" );

            _ctlLineWidthOffsetLeft = new UINumericUpDown[ITextBoxHelper.LineOffsetWidthCountMax];
            _lblLineWidthOffsetInfo = new Label[ITextBoxHelper.LineOffsetWidthCountMax];
            _ctlLineWidthOffsetRight = new UINumericUpDown[ITextBoxHelper.LineOffsetWidthCountMax];
            _ctlLineWidthOffsetLeft[0] = _ctlLineWidthOffsetLeft0;
            _lblLineWidthOffsetInfo[0] = _lblLineWidthOffsetInfo0;
            _ctlLineWidthOffsetRight[0] = _ctlLineWidthOffsetRight0;
            for (int i = 1; i < ITextBoxHelper.LineOffsetWidthCountMax; i++)
            {
                _ctlLineWidthOffsetLeft[i] = new UINumericUpDown();
                _lblLineWidthOffsetInfo[i] = new Label();
                _ctlLineWidthOffsetRight[i] = new UINumericUpDown();
                _ctlLineWidthOffsetLeft[i].Left = _ctlLineWidthOffsetLeft[i - 1].Left;
                _ctlLineWidthOffsetLeft[i].Top = _ctlLineWidthOffsetLeft[i - 1].Top + 30;
                _ctlLineWidthOffsetLeft[i].Size = _ctlLineWidthOffsetLeft[i - 1].Size;
                _ctlLineWidthOffsetLeft[i].DecimalPlaces = _ctlLineWidthOffsetLeft[i - 1].DecimalPlaces;
                _ctlLineWidthOffsetLeft[i].ValueChanged += Event_ctlLineWidthOffsetLeft0_ValueChanged;
                _ctlLineWidthOffsetLeft[i].Minimum = _ctlLineWidthOffsetLeft[i - 1].Minimum;
                _ctlLineWidthOffsetLeft[i].Maximum = _ctlLineWidthOffsetLeft[i - 1].Maximum;

                _ctlLineWidthOffsetLeft[i].Visible = false;
                _lblLineWidthOffsetInfo[i].Left = _lblLineWidthOffsetInfo[i - 1].Left;
                _lblLineWidthOffsetInfo[i].Top = _lblLineWidthOffsetInfo[i - 1].Top + 30;
                _lblLineWidthOffsetInfo[i].Size = _lblLineWidthOffsetInfo[i - 1].Size;
                _lblLineWidthOffsetInfo[i].BorderStyle = _lblLineWidthOffsetInfo[i - 1].BorderStyle;
                _lblLineWidthOffsetInfo[i].TextAlign = _lblLineWidthOffsetInfo[i - 1].TextAlign;
                _lblLineWidthOffsetInfo[i].Visible = false;
                _ctlLineWidthOffsetRight[i].Left = _ctlLineWidthOffsetRight[i - 1].Left;
                _ctlLineWidthOffsetRight[i].Top = _ctlLineWidthOffsetRight[i - 1].Top + 30;
                _ctlLineWidthOffsetRight[i].Size = _ctlLineWidthOffsetRight[i - 1].Size;
                _ctlLineWidthOffsetRight[i].DecimalPlaces = _ctlLineWidthOffsetRight[i - 1].DecimalPlaces;
                _ctlLineWidthOffsetRight[i].ValueChanged += Event_ctlLineWidthOffsetRight0_ValueChanged;
                _ctlLineWidthOffsetRight[i].Minimum = _ctlLineWidthOffsetRight[i - 1].Minimum;
                _ctlLineWidthOffsetRight[i].Maximum = _ctlLineWidthOffsetRight[i - 1].Maximum;
                _ctlLineWidthOffsetRight[i].Visible = false;
                _grpLineWidthOffset.Controls.Add(_ctlLineWidthOffsetLeft[i]);
                _grpLineWidthOffset.Controls.Add(_lblLineWidthOffsetInfo[i]);
                _grpLineWidthOffset.Controls.Add(_ctlLineWidthOffsetRight[i]);
            }

            _ttpLineWidthOffset = new LayoutEditor.Controls.DockContentToolTip();
            ToolTipInitializer.Initialize(_ttpLineWidthOffset);
            for (int i = 0; i < ITextBoxHelper.LineOffsetWidthCountMax; i++)
            {
                _ttpLineWidthOffset.SetToolTip(_ctlLineWidthOffsetLeft[i], StringResMgr.Get("TOOL_TIP_LINE_WIDTH_OFFSET_LEFT"));
                _ttpLineWidthOffset.SetToolTip(_lblLineWidthOffsetInfo[i], StringResMgr.Get("TOOL_TIP_LINE_WIDTH_OFFSET_INFO"));
                _ttpLineWidthOffset.SetToolTip(_ctlLineWidthOffsetRight[i], StringResMgr.Get("TOOL_TIP_LINE_WIDTH_OFFSET_RIGHT"));
            }
            _ttpLineWidthOffset.SetToolTip(_chkLineWidthOffsetEnabled, StringResMgr.Get("TOOL_TIP_LINE_WIDTH_OFFSET_GRP_POSITION"));

            _grpLineWidthOffsetDefaultHeight = _grpLineWidthOffset.Height;

            _FormDefaultHeight = this.Height;

            _EasySettingOfPerCharTransformDlg = new PropertyEditWindow.EasySettingOfPerCharTransformDlg(this);

            // コンテキストメニューを追加する
            AnimationMarkContextMenuBuilder.BuildMultiControlMenu(_lblVtxColTop, _ctlVtxColTop.AnimationMarkArray);
            AnimationMarkContextMenuBuilder.BuildMultiControlMenu(_lblVtxColBottom, _ctlVtxColBottom.AnimationMarkArray);
            AnimationMarkContextMenuBuilder.BuildMultiControlMenu(_lblBlackColor, _colShadowBlackColor.AnimationMarkArray);
            AnimationMarkContextMenuBuilder.BuildMultiControlMenu(_lblWhiteColor, _colShadowWhiteColor.AnimationMarkArray);

            // アニメーションマークを関連付ける
            _lblPerCharTransOffset.BindAnimationMark(_tbxPerCharTransOffset.AnimationMarkInst);
            _lblPerCharTransWidth.BindAnimationMark(_tbxPerCharTransWidth.AnimationMarkInst);
        }

        #region データをGUIに設定する処理

        void SetDataToGUIControl_()
        {
            if (this._TargetTextBoxMpn == null)
            {
                return;
            }

            ITextBox srcTextBox = _TargetTextBoxMpn.ITextBox;

            // アニメーションマークとコンテキストメニューの有効無効
            bool bUse = CanUseAnimationMark(srcTextBox?.OwnerPane?.OwnerSubScene);
            IEnumerable<IAnimationMarkUsable> animCtrlList = GetAnimationMarkUsableControl();
            foreach (IAnimationMarkUsable ctrl in animCtrlList)
            {
                ctrl.UseAnimationMark = bUse;
            }

            // 上下端カラー
            _ctlVtxColTop.Color = new FloatColor(srcTextBox.TopColor);
            _ctlVtxColBottom.Color = new FloatColor(srcTextBox.BottomColor);
            _pnlTextColor.Set(
                new FloatColor(srcTextBox.TopColor),
                new FloatColor(srcTextBox.BottomColor));

            // ラインタイム用確保メモリ
            _tbxAllocByte.SetValue(Convert.ToInt32(srcTextBox.AllocStringLength));
            _tbxAllocByte.Enabled = srcTextBox.SpecifiedStringLength;
            _chkAllocByte.SetChecked(srcTextBox.SpecifiedStringLength);


            // 文字サイズ
            _ctlFontSizePixel.FVec2Value = srcTextBox.FontSize;
            // 初期値
            if (srcTextBox.ILEFont != null)
            {
                _tbxFontSizeInitX.SetValue(srcTextBox.ILEFont.Width);
                _tbxFontSizeInitY.SetValue(srcTextBox.ILEFont.Height);
            }
            else
            {
                _tbxFontSizeInitX.Value = 0;
                _tbxFontSizeInitY.Value = 0;
            }

            // 文字サイズ(スケール)
            _ctlFontSizeScale.FVec2Value = srcTextBox.FontScale;


            // 文字間隔サイズ
            _ctlBlankSize.FVec2Value = new FVec2(srcTextBox.CharSpace, srcTextBox.LineSpace);

            // 斜体
            _fesItalic.SetValue(ItalicRatioToAngle(srcTextBox.ItalicFactor, srcTextBox.FontSize));
            _tbxItalicRate.Text = srcTextBox.ItalicFactor.ToString("0.00");

            // 内容文字列
            _tbxContents.SetValue(srcTextBox.ContentsText);
            _tbxTextID.SetValue(srcTextBox.TextID);

            // 水平方向位置
            HorizontalLocation horizontalLocation = _TargetTextBoxMpn.ITextBox.BasePosTypeH;
            _radPosHLeft.SetCheckedByTag(horizontalLocation);
            _radPosHCenter.SetCheckedByTag(horizontalLocation);
            _radPosHRight.SetCheckedByTag(horizontalLocation);
            _radPosHLeft.Enabled = !srcTextBox.PerCharacterTransformOriginToCenter;
            _radPosHCenter.Enabled = !srcTextBox.PerCharacterTransformOriginToCenter;
            _radPosHRight.Enabled = !srcTextBox.PerCharacterTransformOriginToCenter;

            // 水平方向位置
            VerticalLocation verticalLocation = _TargetTextBoxMpn.ITextBox.BasePosTypeV;
            _radPosVTop.SetCheckedByTag(verticalLocation);
            _radPosVCenter.SetCheckedByTag(verticalLocation);
            _radPosVBottom.SetCheckedByTag(verticalLocation);

            // 行そろえ位置
            LineAlignment LineAlignment = _TargetTextBoxMpn.ITextBox.LineAlignment;
            _radAlignNotSpecified.SetCheckedByTag(LineAlignment);
            _radAlignLeft.SetCheckedByTag(LineAlignment);
            _radAlignCenter.SetCheckedByTag(LineAlignment);
            _radAlignRight.SetCheckedByTag(LineAlignment);

            _chkCenterCeilingEnabled.SetChecked(_TargetTextBoxMpn.ITextBox.CenterCeilingEnabled);
            _chkDrawFromRightToLeft.SetChecked(_TargetTextBoxMpn.ITextBox.DrawFromRightToLeft);

            // コンボボックスを構築して、現在のフォントを選択する。
            ILEFont currentFont = _TargetTextBoxMpn.ITextBox.ILEFont;

            _ctlFontName.Items.Clear();
            GuiFont[] fontSet = FontManager.GuiFontSet;
            foreach (GuiFont font in fontSet)
            {
                _ctlFontName.AddItem(font.FontName, font, false);

                // 現在のパラメータに対応するものを選択します。
                if (currentFont != null && currentFont.FontName == font.FontName)
                {
                    _ctlFontName.SetSelectedIndex(_ctlFontName.Items.Count - 1);
                }
            }

            // 現在のフォントが設定されているなら関連する初期化
            if (currentFont != null)
            {
                _ctlFontName.SelectByCondition(
                    (item) => ((item as UIListControlItem).Data as GuiFont).FontName == currentFont.FontName);

                // フォントのエラー表示
                this._erpMain.SetError(this._ctlFontName, srcTextBox.WarningMsg);

                // 注意: フォントの初期化に失敗していると currentFont.NWFont が null になる

                // カーニング
                _lblKerningState.Text = currentFont.NWFont?.HasKerning() ?? false ? "YES" : "NO";

                // フチ
                bool isAvailableBorder = currentFont.NWFont?.IsAvailableBorder() ?? false;
                _lblBorderState.Text = isAvailableBorder ? "YES" : "NO";

                //_pnlBorder.Enabled = isAvailableBorder;
                _radBorderDisabled.Enabled = isAvailableBorder;
                _radDoubleBorderEnabled.Enabled = isAvailableBorder;
                _lblBorderNotice.Visible = isAvailableBorder;

                if (_TargetTextBoxMpn.ITextBox.InvisibleBorderEnabled)
                {
                    _radBorderDisabled.SetChecked(true);
                }
                else if (_TargetTextBoxMpn.ITextBox.DoubleDrawnBorderEnabled)
                {
                    _radDoubleBorderEnabled.SetChecked(true);
                }
                else
                {
                    _radBorderEnabled.SetChecked(true);
                }
            }
            else
            {
                this._erpMain.SetError(this._ctlFontName, string.Empty);
            }

            // 影
            _chkShadowEnabled.SetChecked(srcTextBox.ShadowEnabled);
            _pnlShadowEnabled.Enabled = srcTextBox.ShadowEnabled;

            _nudShadowOffset.FVec2Value = srcTextBox.ShadowOffset;
            _nudShadowScale.FVec2Value = srcTextBox.ShadowScale;
            _fesShadowItalic.SetValue(ItalicRatioToAngle(srcTextBox.ShadowItalicFactor, srcTextBox.FontSize));
            _tbxShadowItalicRate.Text = srcTextBox.ShadowItalicFactor.ToString("0.00");
            _colShadowColorTop.Color = new FloatColor(srcTextBox.ShadowTopColor);
            _colShadowColorBottom.Color = new FloatColor(srcTextBox.ShadowBottomColor);
            _pnlShadowTextColor.Set(new FloatColor(srcTextBox.ShadowTopColor), new FloatColor(srcTextBox.ShadowBottomColor));

            _colShadowBlackColor.Color = new FloatColor(srcTextBox.ShadowBlackColor);
            _colShadowWhiteColor.Color = new FloatColor(srcTextBox.ShadowWhiteColor);

            // 複数編集時の背景カラー
            var backColor = GetMultiEditColor();
            var panelBackColor = GetMultiEditPanelColor();
            _ctlFontName.BackColor = backColor;
            _tbxContents.BackColor = backColor;
            _tbxTextID.BackColor = backColor;
            _ctlFontSizePixel.TextBoxBackColor = backColor;
            _ctlFontSizeScale.TextBoxBackColor = backColor;
            _ctlBlankSize.TextBoxBackColor = backColor;
            _fesItalic.BackColor = panelBackColor;
            _pnlPositionH.BackColor = panelBackColor;
            _pnlPositionV.BackColor = panelBackColor;
            _pnlLine.BackColor = panelBackColor;
            _ctlVtxColTop.TextBoxBackColor = backColor;
            _ctlVtxColBottom.TextBoxBackColor = backColor;
            _chkAllocByte.BackColor = panelBackColor;
            _tbxAllocByte.BackColor = backColor;
            _chkShadowEnabled.BackColor = panelBackColor;
            _nudShadowOffset.TextBoxBackColor = backColor;
            _nudShadowScale.TextBoxBackColor = backColor;
            _fesShadowItalic.BackColor = panelBackColor;
            _colShadowColorTop.TextBoxBackColor = backColor;
            _colShadowColorBottom.TextBoxBackColor = backColor;
            _colShadowBlackColor.TextBoxBackColor = backColor;
            _colShadowWhiteColor.TextBoxBackColor = backColor;
            _tbxPerCharTransOffset.TextBoxBackColor = backColor;
            _tbxPerCharTransWidth.TextBoxBackColor = backColor;
            _pnlPerCharLoop.BackColor = panelBackColor;
            _pnlPerCharOriginV.BackColor = panelBackColor;
            _tbxPerCharOriginVOffset.BackColor = backColor;
            _chkPerCharTransformSplitByCharWidth.BackColor = backColor;
            _chkPerCharTransformAutoShadowAlpha.BackColor = backColor;


            // 文字変換
            _chkPerCharTransformEnabled.SetChecked(srcTextBox.IsPerCharTransformEnabled);
            _chkPerCharTransformSplitByCharWidth.SetChecked(srcTextBox.PerCharacterTransformSplitByCharWidth);
            _chkPerCharTransformAutoShadowAlpha.SetChecked(srcTextBox.PerCharacterTransformAutoShadowAlpha);
            _chkPerCharTransformOriginToCenter.SetChecked(srcTextBox.PerCharacterTransformOriginToCenter);
            _pnlPerCharTransform.Enabled = srcTextBox.IsPerCharTransformEnabled;
            _tbxPerCharTransOffset.TextBox.SetValue(srcTextBox.PerCharacterTransformTimeOffset);
            _tbxPerCharTransWidth.TextBox.SetValue(srcTextBox.PerCharacterTransformTimeWidth);

            _grpPerCharTransformFixSpace.Enabled = srcTextBox.PerCharacterTransformOriginToCenter;
            _chkPerCharTransformFixSpaceEnabled.SetChecked(srcTextBox.IsPerCharTransformFixSpaceEnabled);
            _tbxPerCharTransformFixSpaceWidth.Enabled = srcTextBox.IsPerCharTransformFixSpaceEnabled;
            _tbxPerCharTransformFixSpaceWidth.SetValue(srcTextBox.PerCharTransformFixSpaceWidth);
            _radPerCharTransformFixSpaceOriginLeft.Enabled = srcTextBox.IsPerCharTransformFixSpaceEnabled;
            _radPerCharTransformFixSpaceOriginLeft.SetCheckedByTag(_TargetTextBoxMpn.ITextBox.PerCharTransformFixSpaceOrigin);
            _radPerCharTransformFixSpaceOriginCenter.Enabled = srcTextBox.IsPerCharTransformFixSpaceEnabled;
            _radPerCharTransformFixSpaceOriginCenter.SetCheckedByTag(_TargetTextBoxMpn.ITextBox.PerCharTransformFixSpaceOrigin);
            _radPerCharTransformFixSpaceOriginRight.Enabled = srcTextBox.IsPerCharTransformFixSpaceEnabled;
            _radPerCharTransformFixSpaceOriginRight.SetCheckedByTag(_TargetTextBoxMpn.ITextBox.PerCharTransformFixSpaceOrigin);
            _pnlPerCharOriginV.Enabled = !srcTextBox.PerCharacterTransformOriginToCenter;

            _EasySettingOfPerCharTransformDlg.SetDataToGUIControl(srcTextBox);

            _radPerCharLoopOneTime.SetCheckedByTag(_TargetTextBoxMpn.ITextBox.PerCharacterTransformLoopType);
            _radPerCharLoopLoop.SetCheckedByTag(_TargetTextBoxMpn.ITextBox.PerCharacterTransformLoopType);

            _radPerCharOriginVCenter.SetCheckedByTag(_TargetTextBoxMpn.ITextBox.PerCharacterTransformOriginV);
            _radPerCharOriginVBottom.SetCheckedByTag(_TargetTextBoxMpn.ITextBox.PerCharacterTransformOriginV);
            _tbxPerCharOriginVOffset.SetValue(_TargetTextBoxMpn.ITextBox.PerCharacterTransformOriginVOffset);

            // 行ごとの幅とオフセット
            _chkLineWidthOffsetEnabled.SetChecked(srcTextBox.LineWidthOffsetEnabled);
            for (int i = 0; i < ITextBoxHelper.LineOffsetWidthCountMax; i++)
            {
                _ctlLineWidthOffsetLeft[i].Visible = srcTextBox.LineWidthOffsetEnabled;
                _lblLineWidthOffsetInfo[i].Visible = srcTextBox.LineWidthOffsetEnabled;
                _ctlLineWidthOffsetRight[i].Visible = srcTextBox.LineWidthOffsetEnabled;
            }
            _lblLineWidthOffsetSizeX.Visible = srcTextBox.LineWidthOffsetEnabled;
            _tbxLineWidthOffsetSizeX.Visible = srcTextBox.LineWidthOffsetEnabled;

            // 行ごとの幅とオフセットが有効化されたら _grpPosition を無効化する
            _grpPosition.Enabled = !srcTextBox.LineWidthOffsetEnabled;

            // 行ごとの幅とオフセットが有効化されたら _grpLineWidthOffset などを展開する
            {
                int height = srcTextBox.LineWidthOffsetEnabled ? 30 * ITextBoxHelper.LineOffsetWidthCountMax : 0;

                _grpLineWidthOffset.Height = _grpLineWidthOffsetDefaultHeight + height;

                int newParentHeight = _FormDefaultHeight + height;

                _flyMain.Height = newParentHeight;
                this.Height = newParentHeight;
            }
            _grpLineWidthOffset.Enabled = !srcTextBox.PerCharacterTransformOriginToCenter;

            if (srcTextBox.LineWidthOffsetEnabled)
            {
                for (int i = 0; i < ITextBoxHelper.LineOffsetWidthCountMax; i++)
                {
                    float left;
                    float right;
                    ITextBoxHelper.ChangeWidthOffsetToLeftRight(out left, out right, srcTextBox.LineOffset[i], srcTextBox.LineWidth[i]);
                    _ctlLineWidthOffsetLeft[i].SetValue((decimal)left);
                    _ctlLineWidthOffsetRight[i].SetValue((decimal)right);

                    float width = this._TargetPane.Target.Size.X + srcTextBox.LineWidth[i];
                    _lblLineWidthOffsetInfo[i].Text = width.ToString("0.00");
                }

                _tbxLineWidthOffsetSizeX.Text = this._TargetPane.Target.Size.X.ToString("0.00");
            }

            // アニメーションマークで利用するアトリビュートを関連付け
            _ctlVtxColTop.SetTargetAttribute(PaneGuiAdapterGroupHelper.GetTopColorIAnmAttr(Target));
            _ctlVtxColBottom.SetTargetAttribute(PaneGuiAdapterGroupHelper.GetBottomColorIAnmAttr(Target));
            _colShadowBlackColor.SetTargetAttribute(PaneGuiAdapterGroupHelper.GetShadowBlackColorIAnmAttr(Target));
            _colShadowWhiteColor.SetTargetAttribute(PaneGuiAdapterGroupHelper.GetShadowWhiteColorIAnmAttr(Target));
            _tbxPerCharTransOffset.SetTargetAttribute(PaneGuiAdapterGroupHelper.GetPerCharTransformTimeOffsetIAnmAttr(Target));
            _tbxPerCharTransWidth.SetTargetAttribute(PaneGuiAdapterGroupHelper.GetPerCharTransformTimeWidthIAnmAttr(Target));

            // アニメーションマークの更新
            foreach (IAnimationMarkUsable ctrl in animCtrlList)
            {
                ctrl.UpdateAnimationMark();
            }

            // 連動ボタンの更新
            if (_oldTarget != Target)
            {
                _oldTarget = Target;
                UpdateLinkButton(srcTextBox);
            }
        }

        /// <summary>
        /// アニメーションマークが利用可能なコントロールの一覧を取得する。
        /// </summary>
        protected override IEnumerable<IAnimationMarkUsable> GetAnimationMarkUsableControl()
        {
            List<IAnimationMarkUsable> list = new List<IAnimationMarkUsable>();

            list.Add(_lblVtxColTop);
            list.Add(_lblVtxColBottom);
            list.Add(_lblBlackColor);
            list.Add(_lblWhiteColor);
            list.Add(_lblPerCharTransOffset);
            list.Add(_lblPerCharTransWidth);
            list.Add(_ctlVtxColTop);
            list.Add(_ctlVtxColBottom);
            list.Add(_colShadowBlackColor);
            list.Add(_colShadowWhiteColor);
            list.Add(_tbxPerCharTransOffset);
            list.Add(_tbxPerCharTransWidth);

            return list;
        }

        #endregion データをGUIに設定する処理

        #region GUIの変更をデータに反映するハンドラ群
        /// <summary>
        /// 複数同時編集
        /// </summary>
        private void MultiEdit_(Action<TextBoxManipulator> modifyAction)
        {
            if (IsGUIUpdating)
            {
                // 各コントロール等で弾いているはず
                Debug.Assert(false);
                return;
            }

            if (_TargetTextBoxMpn == null)
            {
                return;
            }

            if (this.Owner.Target.IsMulti)
            {
                ISubScene subScene = LECore.LayoutEditorCore.Scene.CurrentISubScene;
                subScene.BeginMassiveModify();
                {
                    TextBoxManipulator textBoxMnp = new TextBoxManipulator();
                    foreach (IBaseGuiAdapter paneAdapter in this.Owner.Target.Objects)
                    {
                        if (paneAdapter.Target == null) { continue; }
                        if (paneAdapter.Target.ITextBox == null) { continue; }

                        textBoxMnp.BindTarget(paneAdapter.Target.ITextBox);
                        modifyAction(textBoxMnp);
                    }
                }
                subScene.EndMassiveModify();
            }
            else
            {
                // 変更実行途中での UI の更新を抑える
                ISubScene subScene = LECore.LayoutEditorCore.Scene.CurrentISubScene;
                subScene.BeginMassiveModify();
                modifyAction(_TargetTextBoxMpn);
                subScene.EndMassiveModify();
            }

            _TargetTextBoxMpn.RaiseChangeEvent();
        }

        /// <summary>
        // フォントの特殊フチ形式の情報を更新する関数
        /// </summary>
        private void UpdateBorderEnabled(TextBoxManipulator textBoxMnp)
        {
            ILEFont currentFont = _TargetTextBoxMpn.ITextBox.ILEFont;
            bool isAvailableBorder = currentFont.NWFont?.IsAvailableBorder() ?? false;
            textBoxMnp.InvisibleBorderEnabled = isAvailableBorder && _radBorderDisabled.Checked;
            textBoxMnp.DoubleDrawnBorderEnabled = isAvailableBorder && _radDoubleBorderEnabled.Checked;
        }

        /// <summary>
        /// 文字サイズ更新ハンドラ
        /// </summary>
        private void Event_CtlFontSizePixel_OnFVec2Edit(object sender, FVec2EditEventArgs args)
        {
            var updateX = Math.Abs(_TargetTextBoxMpn.ITextBox.FontSize.X - args.Value.X) >= 0.0001f;
            var updateY = Math.Abs(_TargetTextBoxMpn.ITextBox.FontSize.Y - args.Value.Y) >= 0.0001f;
            MultiEdit_((textBoxMnp) =>
            {
                var newX = updateX ? args.Value.X : textBoxMnp.ITextBox.FontSize.X;
                var newY = updateY ? args.Value.Y : textBoxMnp.ITextBox.FontSize.Y;
                textBoxMnp.FontSize = new FVec2(newX, newY);
            });
        }

        /// <summary>
        /// 文字サイズ更新ハンドラ(スケール指定)
        /// </summary>
        private void Event_CtlFontSizeScale_OnFVec2Edit(object sender, FVec2EditEventArgs args)
        {
            // スケールとして有効であれば...
            if( _TargetTextBoxMpn.ITextBox.ILEFont != null &&
                Math.Abs( args.Value.X ) >= float.Epsilon &&
                Math.Abs( args.Value.Y ) >= float.Epsilon )
            {
                var updateX = Math.Abs(_TargetTextBoxMpn.ITextBox.FontScale.X - args.Value.X) >= 0.0001f;
                var updateY = Math.Abs(_TargetTextBoxMpn.ITextBox.FontScale.Y - args.Value.Y) >= 0.0001f;

                MultiEdit_((textBoxMnp) =>
                {
                    var newX = textBoxMnp.ITextBox.ILEFont.Width * args.Value.X;
                    var newY = textBoxMnp.ITextBox.ILEFont.Height * args.Value.Y;

                    // UIでサイズ値として設定できる精度以下の値を切り捨てます。
                    // そうしないと、UIで完全に同じ値を指定出来なくなってしまいます。
                    newX = updateX ? (float)Math.Round(newX, 2) : textBoxMnp.ITextBox.FontSize.X;
                    newY = updateY ? (float)Math.Round(newY, 2) : textBoxMnp.ITextBox.FontSize.Y;
                    textBoxMnp.FontSize = new FVec2(newX, newY);
                });
            }
            else
            {
                // GUIの表示を元に戻します。
                _ctlFontSizeScale.FVec2Value = _TargetTextBoxMpn.ITextBox.FontScale;
            }
        }

        /// <summary>
        /// 文字間隔更新ハンドラ
        /// </summary>
        private void Event_CtlBlankSize_OnFVec2Edit(object sender, FVec2EditEventArgs args)
        {
            MultiEdit_((textBoxMnp) => textBoxMnp.FontBlank = args.Value);
        }

        /// <summary>
        /// 内容文字列更新ハンドラ
        /// </summary>
        private void Event_TbxContents_TextChanged(object sender, System.EventArgs e)
        {
            var textBox = sender as System.Windows.Forms.TextBox;
            if (textBox != null)
            {
                // SetValue 時に TextChanged はコントロール側で抑制されないのでここでチェック
                if (!IsGUIUpdating)
                {
                    MultiEdit_((textBoxMnp) => textBoxMnp.ContentsText = textBox.Text);
                }
            }
        }

        /// <summary>
        /// テキストID変更
        /// </summary>
        private void Event_TbxTextID_Validating(object sender, EventArgs e)
        {
            MultiEdit_((textBoxMnp) => textBoxMnp.TextID = _tbxTextID.Text);
        }

        /// <summary>
        /// テキストIDにペイン名
        /// </summary>
        private void Event_btnPaneNameAsTextID_Click(object sender, EventArgs e)
        {
            MultiEdit_((textBoxMnp) =>
            {
                var paneName = textBoxMnp.ITextBox.OwnerPane.PaneName;
                string defaultID = AppSetting.ProjectSettings.DefaultTextBoxPaneTextID;
                string newTextID;
                if (string.IsNullOrEmpty(defaultID))
                {
                    newTextID = paneName;
                }
                else
                {
                    // ペイン名を代入する
                    var paneNameVariable = "$(Pane)";
                    newTextID = defaultID.Replace(
                        paneNameVariable,
                        paneName);
                }

                if (!string.IsNullOrEmpty(textBoxMnp.ITextBox.TextID) &&
                    textBoxMnp.ITextBox.TextID != newTextID)
                {
                    string text = StringResMgr.Get("PROP_TEXTBOX_REPLACE_TEXTID", textBoxMnp.ITextBox.TextID, newTextID);
                    if (MessageBox.Show(text, StringResMgr.Get("PROP_PANE_CATEGORY_TEXTBOX"),
                        MessageBoxButtons.OKCancel, MessageBoxIcon.Question) != DialogResult.OK)
                    {
                        return;
                    }
                }

                textBoxMnp.TextID = newTextID;
            });
        }

        /// <summary>
        /// ペインサイズ調整ボタンハンドラ
        /// </summary>
        private void Event_BtnAdjustPaneSize_Click( object sender, EventArgs e )
        {
            MultiEdit_((textBoxMnp) => textBoxMnp.AdjustPaneSize());
        }

        /// <summary>
        /// 水平位置ラジオボタンハンドラ
        /// </summary>
        private void Event_RadPosH_RadioChecked(object sender, EventArgs e)
        {
            var    rb = sender as UIRadioButton;
            var hLoc = (HorizontalLocation)rb.Tag;
            MultiEdit_((textBoxMnp) => textBoxMnp.BasePosTypeH = hLoc);
        }

        /// <summary>
        /// 垂直位置ラジオボタンハンドラ
        /// </summary>
        private void Event_RadPosV_RadioChecked(object sender, EventArgs e)
        {
            var    rb = sender as UIRadioButton;
            var vLoc = (VerticalLocation)rb.Tag;
            MultiEdit_((textBoxMnp) => textBoxMnp.BasePosTypeV = vLoc);
        }

        /// <summary>
        /// 行そろえ ラジオボタン更新
        /// </summary>
        void Event_RadAlignNotSpecified_RadioChecked( object sender, EventArgs e )
        {
            RadioButton rb = sender as RadioButton;
            var alignment = (LineAlignment)rb.Tag;
            MultiEdit_((textBoxMnp) => textBoxMnp.LineAlignment = alignment);
        }

        /// <summary>
        /// 中央揃えのにじみ防止機能を有効にする
        /// </summary>
        private void _chkCenterCeilingEnabled_CheckedChanged(object sender, EventArgs e)
        {
            MultiEdit_((textBoxMnp) => textBoxMnp.CenterCeilingEnabled = _chkCenterCeilingEnabled.Checked);
        }

        /// <summary>
        /// 右側の文字から描画する機能を有効にする
        /// </summary>
        private void _chkDrawFromRightToLeft_CheckedChanged(object sender, EventArgs e)
        {
            MultiEdit_((textBoxMnp) => textBoxMnp.DrawFromRightToLeft = _chkDrawFromRightToLeft.Checked);
        }

        /// <summary>
        /// フォント名変更ハンドラ
        /// </summary>
        private void Event_CtlFontName_SelectedIndexChanged(object sender, System.EventArgs e)
        {
            var cbx = sender as UIComboBox;
            var font = cbx.SelectedItemData as GuiFont;
            Debug.Assert(font != null);

            MultiEdit_((textBoxMnp) =>
            {
                textBoxMnp.SetLEFontByFileName(font.FontName, font.FontPath);
                UpdateBorderEnabled(textBoxMnp);
            });
        }

        /// <summary>
        /// フォント読み込みハンドラ
        /// </summary>
        private void Event_BtnFontLoad_Click(object sender, System.EventArgs e)
        {
            OpenFileDialog dialog = new OpenFileDialog();

            // ユーザが拡張子を指定しない場合、拡張子を追加する。
            dialog.AddExtension = true;
            dialog.Filter = LEFontHelper.OPEN_FONT_FILE_FILTER_STR;
            if( _TargetTextBoxMpn.ITextBox.ILEFont != null && !string.IsNullOrEmpty(_TargetTextBoxMpn.ITextBox.ILEFont.FontPath))
            {
                var dirName = Path.GetDirectoryName(_TargetTextBoxMpn.ITextBox.ILEFont.FontPath);
                if (Directory.Exists(dirName))
                {
                    dialog.InitialDirectory = SaveLoadUIHelper.GetAbsolutePathForExistDirectory(dirName);
                }

                dialog.FileName = Path.GetFileName( _TargetTextBoxMpn.ITextBox.ILEFont.FontPath );
            }

            if ( dialog.ShowDialog() == DialogResult.OK )
            {
                try
                {
                    ILEFont font;
                    if( _TargetTextBoxMpn.SameNameButDifferentPaths( dialog.FileName, out font) != false )
                    {
                        if (font.FontSettings != null && !font.IsComplexFont())
                        {
                            try
                            {
                                var fileName = Path.GetFileName(dialog.FileName);
                                MessageBox.Show(string.Format(StringResMgr.Get("CREATE_TEXTBOX_DLG_USEDNAME"), font.FontName, fileName), AppConstants.AppName);
                            }
                            catch
                            {
                            }
                        }
                        else if( MsgBox.YesNo
                            ( StringResMgr.Get("PROP_TEXTBOX_REPLACE_FONT_INQUIRE")) != false )
                        {
                            // フォントパスの差し替えだけなので MultiEdit_ は使用しない。
                            _TargetTextBoxMpn.ReplaceFontFilePath(dialog.FileName);
                        }

                        if ((LEFontHelper.IsBitmapFontFile(font.FontPath) || LEFontHelper.IsComplexFont(font))&& !LEFontHelper.IsAcceptableBntxPlatform(font, LECore.LayoutEditorCore.PlatformDetail.PlatformPreference))
                        {
                            // プロパティウインドウ - エラー
                            string title = LayoutEditor.StringResMgr.Get("PROP_ERROR_DLG_TITLE");
                            LECore.LayoutEditorCore.MsgReporter.ReportError(title, LECoreStringResMgr.Get("LECORE_UNACCEPTABLE_PLATFORM",
                                Path.GetFullPath(font.FontPath), font.BntxPlatform, LECore.LayoutEditorCore.PlatformDetail.UIPlatformName));
                        }
                        return;
                    }

                    // 設定します。内部で読み込みます。
                    MultiEdit_((textBoxMnp) =>
                    {
                        textBoxMnp.SetLEFontByFileName(dialog.FileName);
                        UpdateBorderEnabled(textBoxMnp);
                    });
                }
                catch( Exception exception )
                {
                    // PROP_ERROR_DLG_TITLE  プロパティウインドウ - エラー
                    // PROP_ERROR_FAIL_LOADFONT  フォントの読み込みに失敗しました
                    string title   = StringResMgr.Get( "PROP_ERROR_DLG_TITLE" );
                    string msg     = StringResMgr.Get( "PROP_ERROR_FAIL_LOADFONT" ) +"\n"+ exception.Message;

                    LECore.LayoutEditorCore.MsgReporter.ReportError( title, msg );

                }
            }
        }

        /// <summary>
        /// 上下端カラー変更ハンドラ
        /// </summary>
        private void Event_CtlVtxCol_ColorEdit(object sender, ColorEditEventArgs e)
        {
            if (sender == _ctlVtxColTop)
            {
                MultiEdit_((textBoxMnp) => textBoxMnp.TopColor = e.Color.ToRGBAColor());
            }
            else if (sender == _ctlVtxColBottom)
            {
                MultiEdit_((textBoxMnp) => textBoxMnp.BottomColor = e.Color.ToRGBAColor());
            }

            _pnlTextColor.Set(
                new FloatColor(_TargetTextBoxMpn.ITextBox.TopColor),
                new FloatColor(_TargetTextBoxMpn.ITextBox.BottomColor));
        }

        /// <summary>
        /// 文字列長指定チェックボックスハンドラ
        /// </summary>
        private void Event_ChkAllocByte_CheckedChanged(object sender, System.EventArgs e)
        {
            MultiEdit_((textBoxMnp) => textBoxMnp.SpecifiedStringLength = _chkAllocByte.Checked);
        }

        /// <summary>
        /// ラインタイム用確保メモリ変更ハンドラ
        /// </summary>
        private void Event_TbxAllocByte_ValueChanged(object sender, System.EventArgs e)
        {
            var intTextBox = sender as IntTextBox;
            if (intTextBox == null) return;
            MultiEdit_((textBoxMnp) => textBoxMnp.AllocByte = Convert.ToUInt32(intTextBox.Value));
        }

        //----------------------------------------------------------
        // 影、斜体関連
        //----------------------------------------------------------

        /// <summary>
        /// 角度から割合への変換
        /// </summary>
        private static float ItalicAngleToRatio(float angle, FVec2 fontSize)
        {
            return (float)(Math.Tan(angle / 180.0 * Math.PI) / fontSize.X * fontSize.Y);
        }

        /// <summary>
        /// 割合から角度への変換
        /// </summary>
        private static float ItalicRatioToAngle(float ratio, FVec2 fontSize)
        {
            return (float)(Math.Atan(ratio * fontSize.X / fontSize.Y) / Math.PI * 180.0);
        }

        private void Event_FesItalic_ValueEdit(object sender, ValueEditEventArgs e)
        {
            if (e.EditFixed)
            {
                MultiEdit_((textBoxMnp) =>
                {
                    var ratio = ItalicAngleToRatio(_fesItalic.Value, textBoxMnp.ITextBox.FontSize);
                    textBoxMnp.ItalicFactor = ratio;
                });
            }
        }

        private void Event_FesShadowItalic_ValueEdit(object sender, ValueEditEventArgs e)
        {
            if (e.EditFixed)
            {
                MultiEdit_((textBoxMnp) =>
                {
                    var ratio = ItalicAngleToRatio(_fesShadowItalic.Value, textBoxMnp.ITextBox.FontSize);
                    textBoxMnp.ShadowItalicFactor = ratio;
                });
            }
        }

        private void Event_nudShadowOffset_OnFVec2Edit(object sender, FVec2EditEventArgs args)
        {
            MultiEdit_((textBoxMnp) => textBoxMnp.ShadowOffset = args.Value);
        }

        private void Event_nudShadowScale_OnFVec2Edit(object sender, FVec2EditEventArgs args)
        {
            MultiEdit_((textBoxMnp) => textBoxMnp.ShadowScale = args.Value);
        }

        private void Event_chkShadowEnabled_CheckedChanged(object sender, EventArgs e)
        {
            MultiEdit_((textBoxMnp) => textBoxMnp.ShadowEnabled = _chkShadowEnabled.Checked);
        }

        void Event_colShadowColorTop_ColorEdit(object sender, ColorEditEventArgs e)
        {
            MultiEdit_((textBoxMnp) => textBoxMnp.ShadowTopColor = e.Color.ToRGBAColor());
            _pnlShadowTextColor.Set(
                new FloatColor(_TargetTextBoxMpn.ITextBox.ShadowTopColor),
                new FloatColor(_TargetTextBoxMpn.ITextBox.ShadowBottomColor));
        }

        void Event_colShadowColorBottom_ColorEdit(object sender, ColorEditEventArgs e)
        {
            MultiEdit_((textBoxMnp) => textBoxMnp.ShadowBottomColor = e.Color.ToRGBAColor());
            _pnlShadowTextColor.Set(
                new FloatColor(_TargetTextBoxMpn.ITextBox.ShadowTopColor),
                new FloatColor(_TargetTextBoxMpn.ITextBox.ShadowBottomColor));
        }

        void Event_colShadowBlackColor_ColorEdit(object sender, ColorEditEventArgs e)
        {
            MultiEdit_((textBoxMnp) => textBoxMnp.ShadowBlackColor = e.Color.ToRGBAColor());
        }

        void Event_colShadowWhiteColor_ColorEdit(object sender, ColorEditEventArgs e)
        {
            MultiEdit_((textBoxMnp) => textBoxMnp.ShadowWhiteColor = e.Color.ToRGBAColor());
        }

        private void Event_RadBorderEnabled_CheckedChanged(object sender, EventArgs e)
        {
            var currentISubScene = LECore.LayoutEditorCore.Scene.CurrentISubScene;
            currentISubScene.BeginMassiveModify();
            MultiEdit_((textBoxMnp) =>
            {
                if (textBoxMnp.ITextBox.OwnerPane == null || textBoxMnp.ITextBox.OwnerPane.OwnerSubScene == null)
                {
                    return;
                }
                UpdateBorderEnabled(textBoxMnp);
            });
            currentISubScene.EndMassiveModify();
        }

        /// <summary>
        /// 上下端カラー
        /// </summary>
        private void Event_pnlTextColor_ColorChange(FloatColor colT, FloatColor colB)
        {
            var currentISubScene = LECore.LayoutEditorCore.Scene.CurrentISubScene;
            currentISubScene.BeginMassiveModify();
            MultiEdit_((textBoxMnp) =>
            {
                textBoxMnp.TopColor = new RGBAColor(colT.ToRGBAColor());
                textBoxMnp.BottomColor = new RGBAColor(colB.ToRGBAColor());
            });
            currentISubScene.EndMassiveModify();
        }

        /// <summary>
        /// カゲ上下端カラー
        /// </summary>
        private void Event_pnlShadowTextColor_ColorChange(FloatColor colT, FloatColor colB)
        {
            var currentISubScene = LECore.LayoutEditorCore.Scene.CurrentISubScene;
            currentISubScene.BeginMassiveModify();
            MultiEdit_((textBoxMnp) =>
            {
                textBoxMnp.ShadowTopColor = new RGBAColor(colT.ToRGBAColor());
                textBoxMnp.ShadowBottomColor = new RGBAColor(colB.ToRGBAColor());
            });
            currentISubScene.EndMassiveModify();
        }

        /// <summary>
        ///
        /// </summary>
        private void Event_tbxPerCharTransOffset_ValueChanged(object sender, EventArgs e)
        {
            MultiEdit_((textBoxMnp) => textBoxMnp.PerCharacterTransformTimeOffset = _tbxPerCharTransOffset.TextBox.Value);
        }

        /// <summary>
        ///
        /// </summary>
        private void Event_tbxPerCharTransWidth_ValueChanged(object sender, EventArgs e)
        {
            MultiEdit_((textBoxMnp) => textBoxMnp.PerCharacterTransformTimeWidth = _tbxPerCharTransWidth.TextBox.Value);
        }

        /// <summary>
        ///
        /// </summary>
        private void Event_radPerCharLoopOneTime_RadioChecked(object sender, EventArgs e)
        {
            var radioButton = (sender as RadioButton);
            if (radioButton == null) return;
            var loopType = (PerCharTransformLoopType)radioButton.Tag;
            MultiEdit_((textBoxMnp) => textBoxMnp.PerCharacterTransformLoopType = loopType);
        }

        /// <summary>
        ///
        /// </summary>
        private void Event_radPerCharOriginVTop_RadioChecked(object sender, EventArgs e)
        {
            var radioButton = (sender as RadioButton);
            if (radioButton == null) return;
            var v = (VerticalLocation)radioButton.Tag;
            _TargetTextBoxMpn.PerCharacterTransformOriginV = v;
            MultiEdit_((textBoxMnp) => textBoxMnp.PerCharacterTransformOriginV = v);
        }

        /// <summary>
        ///
        /// </summary>
        private void Event_tbxPerCharOriginVOffset_ValueChanged(object sender, EventArgs e)
        {
            MultiEdit_((textBoxMnp) => textBoxMnp.PerCharacterTransformOriginVOffset = _tbxPerCharOriginVOffset.Value);
        }

        /// <summary>
        ///
        /// </summary>
        private void Event_chkPerCharTransformEnabled_CheckedChanged(object sender, EventArgs e)
        {
            MultiEdit_((textBoxMnp) => textBoxMnp.IsPerCharTransformEnabled = _chkPerCharTransformEnabled.Checked);
        }

        private void Event_chkPerCharTransformSplitByCharWidth_CheckedChanged(object sender, EventArgs e)
        {
            MultiEdit_((textBoxMnp) => textBoxMnp.PerCharacterTransformSplitByCharWidth = _chkPerCharTransformSplitByCharWidth.Checked);
        }

        private void Event_chkPerCharTransformAutoShadowAlpha_CheckedChanged(object sender, EventArgs e)
        {
            MultiEdit_((textBoxMnp) => textBoxMnp.PerCharacterTransformAutoShadowAlpha = _chkPerCharTransformAutoShadowAlpha.Checked);
        }

        private void Event_chkPerCharTransformOriginToCenter_CheckedChanged(object sender, EventArgs e)
        {
            MultiEdit_((textBoxMnp) => textBoxMnp.PerCharacterTransformOriginToCenter = _chkPerCharTransformOriginToCenter.Checked);
        }

        private void Event_chkLineWidthOffsetEnabled_CheckedChanged(object sender, EventArgs e)
        {
            MultiEdit_((textBoxMnp) => textBoxMnp.LineWidthOffsetEnabled = _chkLineWidthOffsetEnabled.Checked);
        }

        private void Event_chkPerCharTransformFixSpaceEnabled_CheckedChanged(object sender, EventArgs e)
        {
            MultiEdit_((textBoxMnp) => textBoxMnp.IsPerCharTransformFixSpaceEnabled = _chkPerCharTransformFixSpaceEnabled.Checked);
        }

        private void Event_tbxPerCharTransformFixSpaceWidth_ValueChanged(object sender, EventArgs e)
        {
            MultiEdit_((textBoxMnp) => textBoxMnp.PerCharTransformFixSpaceWidth = _tbxPerCharTransformFixSpaceWidth.Value);
        }

        private void Event_radPerCharTransformFixSpaceOrigin_RadioChecked(object sender, EventArgs e)
        {
            var radioButton = (sender as RadioButton);
            if (radioButton == null) return;
            var v = (HorizontalLocation)radioButton.Tag;
            _TargetTextBoxMpn.PerCharTransformFixSpaceOrigin = v;
            MultiEdit_((textBoxMnp) => textBoxMnp.PerCharTransformFixSpaceOrigin = v);
        }

        /// <summary>
        /// 文字毎の変換の簡単設定のパラメータの相互関係を調整してカーブを設定する関数
        /// </summary>
        public void SetEasySettingParameters(EasySettingOfPerCharTransform[] param)
        {
            if (_TargetPane.Target.ITextBox == null)
            {
                return;
            }

            // パラメータの値域を調整する
            for (int i = 0; i < param.Length; i++)
            {
                // 1 つ前のカーブと区間が重複しないようにする。
                if (i >= 1 && param[i].easySettingBeginFrame < param[i - 1].easySettingEndFrame + 1.0f)
                {
                    param[i].easySettingBeginFrame = param[i - 1].easySettingEndFrame + 1.0f;
                }
                // 終了フレームを自動計算する。
                if (param[i].easySettingCalcEndFrame)
                {
                    float animationFrame = param[i].easySettingStartFrameOfLastChar - param[i].easySettingBeginFrame;
                    param[i].easySettingEndFrame = animationFrame + param[i].easySettingStopFrameOfFirstChar;
                }
                // 終了フレームは開始フレームよりも 1 フレーム以上後でなければならない。
                if (param[i].easySettingEndFrame < param[i].easySettingBeginFrame + 1.0f)
                {
                    param[i].easySettingEndFrame = param[i].easySettingBeginFrame + 1.0f;
                }
                // 最初の文字が動き終わるフレームは、開始フレームよりも 1 フレーム以上後でなければならない。
                if (param[i].easySettingStopFrameOfFirstChar < param[i].easySettingBeginFrame + 1.0f)
                {
                    param[i].easySettingStopFrameOfFirstChar = param[i].easySettingBeginFrame + 1.0f;
                }
                // 最初の文字が動き終わるフレームは、終了フレームを超えてはならない。
                if (param[i].easySettingStopFrameOfFirstChar > param[i].easySettingEndFrame)
                {
                    param[i].easySettingStopFrameOfFirstChar = param[i].easySettingEndFrame;
                }
                // 最後の文字が動き始めるフレームは、開始フレームよりも 1 フレーム以上後でなければならない。
                if (param[i].easySettingStartFrameOfLastChar < param[i].easySettingBeginFrame + 1.0f)
                {
                    param[i].easySettingStartFrameOfLastChar = param[i].easySettingBeginFrame + 1.0f;
                }
                // 最後の文字が動き始めるフレームは、終了フレームを超えてはならない。
                if (param[i].easySettingStartFrameOfLastChar > param[i].easySettingEndFrame)
                {
                    param[i].easySettingStartFrameOfLastChar = param[i].easySettingEndFrame;
                }
            }
            // コントロールのプロパティに反映させる
            MultiEdit_((textBoxMnp) =>
            {
                textBoxMnp.EasySettingOfPerCharTransform = param;
            });

            // カーブを設定する
            InitializeEasySettingCurve(param);
        }

        /// <summary>
        /// 文字毎の変換の簡単設定のカーブを初期化する関数
        /// </summary>
        private void InitializeEasySettingCurve(EasySettingOfPerCharTransform[] param)
        {
            IAnmAttribute offsetAttr = _TargetPane.Target.ITextBox.PerCharTransformTimeOffsetIAnmAttr;
            IAnmAttribute widthAttr = _TargetPane.Target.ITextBox.PerCharTransformTimeWidthIAnmAttr;

            // TargetAnmAttributeSet の設定
            LayoutEditor.Forms.ToolWindows.CurveEditWindow.TargetAnmAttributeSet targetAttrSet = new CurveEditWindow.TargetAnmAttributeSet();
            IAnmAttribute[] perCharTransformAttrSet = { offsetAttr, widthAttr };
            targetAttrSet.SetTargetAttribute(perCharTransformAttrSet, delegate { return true; });
            targetAttrSet.BeginKeySelectChange();

            // 既存のキーをすべて削除する
            targetAttrSet.SelectKey(targetAttrSet._TargetKeyFrameSet);
            targetAttrSet.DeleteSlectedKey();

            // 各パラメータのカーブを追加する
            foreach(var item in param)
            {
                AddEasySettingCurve(offsetAttr, widthAttr, item);
            }

            // カーブを線形にする
            AnmKeyFrameManipulator anmKeyFrameMnp = new AnmKeyFrameManipulator();
            foreach (IAnmKeyFrame keyFrame in targetAttrSet._TargetKeyFrameSet)
            {
                anmKeyFrameMnp.BindTarget(keyFrame);
                anmKeyFrameMnp.InterporationType = InterporationType.Liner;
                anmKeyFrameMnp.UpdateSlope();
            }

            targetAttrSet.EndKeySelectChange();
        }

        /// <summary>
        /// 文字毎の変換の簡単設定のカーブを追加する関数
        /// </summary>
        private void AddEasySettingCurve(IAnmAttribute offsetAttr, IAnmAttribute widthAttr, EasySettingOfPerCharTransform param)
        {
            bool moveFromLeft = param.easySettingMoveFromLeft;
            float beginFrame = param.easySettingBeginFrame;
            float endFrame = param.easySettingEndFrame;
            float startFrameOfLastChar = param.easySettingStartFrameOfLastChar;

            // 各パラメータを時間幅とオフセットに直す
            float widthValue;
            float offsetBegin;
            float offsetEnd;
            if (moveFromLeft)
            {
                // x = 0, y = -widthValue
                // x = startFrameOfLastChar, y = 0
                // x = stopFrameOfFirstChar - beginFrame, y = stopFrameOfFirstChar - beginFrame - widthValue
                // から直線の方程式を作って解くと以下が得られる。
                widthValue = -(startFrameOfLastChar - beginFrame);
                offsetBegin = 0.0f + beginFrame;
                offsetEnd = -widthValue / (startFrameOfLastChar - beginFrame) * (endFrame - beginFrame) + beginFrame;
            }
            else
            {
                // x = 0, y = 0
                // x = startFrameOfLastChar, y = widthValue
                // x = stopFrameOfFirstChar - beginFrame, y = stopFrameOfFirstChar - beginFrame
                // から直線の方程式を作って解くと以下が得られる。
                widthValue = startFrameOfLastChar - beginFrame;
                offsetBegin = -widthValue + beginFrame;
                offsetEnd = widthValue / (startFrameOfLastChar - beginFrame) * (endFrame - beginFrame) - widthValue + beginFrame;
            }

            // 時間幅とオフセットのキーを設定する
            int beginFrameRounded = (int)Math.Floor(param.easySettingBeginFrame);
            int endFrameRounded = (int)Math.Ceiling(param.easySettingEndFrame);
            SetEasySettingCurve(widthAttr, beginFrameRounded, widthValue, endFrameRounded, widthValue);
            SetEasySettingCurve(offsetAttr, beginFrameRounded, offsetBegin, endFrameRounded, offsetEnd);
        }

        /// <summary>
        /// 文字毎の変換の簡単設定のカーブを設定する関数
        /// </summary>
        private void SetEasySettingCurve(IAnmAttribute anmAttr, int key1, float value1, int key2, float value2)
        {
            AnmCurveManipulator anmCurveMnp = new AnmCurveManipulator();
            anmCurveMnp.BindTarget(anmAttr.ICurrentAnimationCurve);
            anmCurveMnp.PreInfinity = AnmCurveInfinityType.Constant;
            anmCurveMnp.PostInfinity = AnmCurveInfinityType.Constant;
            anmCurveMnp.MakeKeyFrame(key1, value1);
            anmCurveMnp.MakeKeyFrame(key2, value2);
        }

        private void Event_ctlLineWidthOffsetLeft0_ValueChanged(object sender, EventArgs e)
        {
            int index = 0;
            for (int i = 0; i < ITextBoxHelper.LineOffsetWidthCountMax; i++)
            {
                if (_ctlLineWidthOffsetLeft[i] == sender)
                {
                    index = i;
                    break;
                }
            }
            float offset;
            float width;
            ITextBoxHelper.ChangeLeftRightToWidthOffset(out offset, out width, (float)_ctlLineWidthOffsetLeft[index].Value, (float)_ctlLineWidthOffsetRight[index].Value);

            var currentISubScene = LECore.LayoutEditorCore.Scene.CurrentISubScene;
            currentISubScene.BeginMassiveModify();
            MultiEdit_((textBoxMnp) =>
            {
                textBoxMnp.SetLineOffset(index, offset);
                textBoxMnp.SetLineWidth(index, width);
            });
            currentISubScene.EndMassiveModify();
        }

        private void Event_ctlLineWidthOffsetRight0_ValueChanged(object sender, EventArgs e)
        {
            int index = 0;
            for (int i = 0; i < ITextBoxHelper.LineOffsetWidthCountMax; i++)
            {
                if (_ctlLineWidthOffsetRight[i] == sender)
                {
                    index = i;
                    break;
                }
            }
            float offset;
            float width;
            ITextBoxHelper.ChangeLeftRightToWidthOffset(out offset, out width, (float)_ctlLineWidthOffsetLeft[index].Value, (float)_ctlLineWidthOffsetRight[index].Value);

            var currentISubScene = LECore.LayoutEditorCore.Scene.CurrentISubScene;
            currentISubScene.BeginMassiveModify();
            MultiEdit_((textBoxMnp) =>
            {
                textBoxMnp.SetLineOffset(index, offset);
                textBoxMnp.SetLineWidth(index, width);
            });
            currentISubScene.EndMassiveModify();
        }

        private void Event_BtnEasySettingOfPerCharTransform_Click(object sender, EventArgs e)
        {
            if (!_EasySettingOfPerCharTransformDlg.Visible)
            {
                _EasySettingOfPerCharTransformDlg.Show();
            }
            else
            {
                _EasySettingOfPerCharTransformDlg.Activate();
            }
        }

        /// <summary>
        /// テキストを円形に配置する機能
        /// </summary>
        private void Event_BtnPerCharTransformEasyCircle_Click(object sender, EventArgs e)
        {
            var _easyCircleDlg = new src.Forms.ToolWindows.PropertyEditWindow.Pane.PerCharTransformEasyCircleDlg(
                _TargetTextBoxMpn.ITextBox.PerCharTransformEasyCircleBeginAngle,
                _TargetTextBoxMpn.ITextBox.PerCharTransformEasyCircleEndAngle,
                _TargetTextBoxMpn.ITextBox.PerCharTransformEasyCircleRadiusX,
                _TargetTextBoxMpn.ITextBox.PerCharTransformEasyCircleRadiusY,
                _TargetTextBoxMpn.ITextBox.PerCharTransformEasyCircleDivisionNumber,
                _TargetTextBoxMpn.ITextBox.PerCharTransformEasyCircleCharAngle);
            if (_easyCircleDlg.ShowDialog(this) == DialogResult.OK)
            {
                float beginAngle = _easyCircleDlg.BeginAngle;
                float endAngle = _easyCircleDlg.EndAngle;
                float radiusX = _easyCircleDlg.RadiusX;
                float radiusY = _easyCircleDlg.RadiusY;
                int divisionNumber = Math.Max(_easyCircleDlg.DivisionNumber, 2);
                float charAngle = _easyCircleDlg.CharAngle;

                // テキストボックスのプロパティの設定
                var currentISubScene = LECore.LayoutEditorCore.Scene.CurrentISubScene;
                currentISubScene.BeginMassiveModify();
                MultiEdit_((textBoxMnp) =>
                {
                    textBoxMnp.PerCharacterTransformTimeOffset = 0.0f;
                    textBoxMnp.PerCharacterTransformTimeWidth = (float)(divisionNumber - 1);
                    textBoxMnp.PerCharacterTransformOriginToCenter = true;
                    textBoxMnp.PerCharacterTransformSplitByCharWidth = true;

                    textBoxMnp.PerCharTransformEasyCircleBeginAngle = beginAngle;
                    textBoxMnp.PerCharTransformEasyCircleEndAngle = endAngle;
                    textBoxMnp.PerCharTransformEasyCircleRadiusX = radiusX;
                    textBoxMnp.PerCharTransformEasyCircleRadiusY = radiusY;
                    textBoxMnp.PerCharTransformEasyCircleDivisionNumber = divisionNumber;
                    textBoxMnp.PerCharTransformEasyCircleCharAngle = charAngle;
                });
                currentISubScene.EndMassiveModify();

                IAnmAttribute offsetAttr = _TargetTextBoxMpn.ITextBox.PerCharTransformTimeOffsetIAnmAttr;
                IAnmAttribute widthAttr = _TargetTextBoxMpn.ITextBox.PerCharTransformTimeWidthIAnmAttr;
                IAnmAttribute translate = _TargetTextBoxMpn.ITextBox.PerCharTransformTIAnmAttr;
                IAnmAttribute rotate = _TargetTextBoxMpn.ITextBox.PerCharTransformRIAnmAttr;

                // TargetAnmAttributeSet の設定
                LayoutEditor.Forms.ToolWindows.CurveEditWindow.TargetAnmAttributeSet targetAttrSet = new CurveEditWindow.TargetAnmAttributeSet();
                IAnmAttribute[] perCharTransformAttrSet = { offsetAttr, widthAttr, translate, rotate };
                targetAttrSet.SetTargetAttribute(perCharTransformAttrSet, delegate { return true; });
                targetAttrSet.BeginKeySelectChange();

                // 既存のキーをすべて削除する
                targetAttrSet.SelectKey(targetAttrSet._TargetKeyFrameSet);
                targetAttrSet.DeleteSlectedKey();

                // カーブを設定する
                SetEasyCircleCurve(translate, rotate, beginAngle, endAngle, radiusX, radiusY, divisionNumber, charAngle);

                // カーブをスプライン補間にする
                AnmKeyFrameManipulator anmKeyFrameMnp = new AnmKeyFrameManipulator();
                foreach (IAnmKeyFrame keyFrame in targetAttrSet._TargetKeyFrameSet)
                {
                    anmKeyFrameMnp.BindTarget(keyFrame);
                    anmKeyFrameMnp.InterporationType = InterporationType.Spline;
                    anmKeyFrameMnp.UpdateSlope();
                }

                targetAttrSet.EndKeySelectChange();
            }
        }

        /// <summary>
        /// テキストを円形に配置する機能のカーブを設定する関数
        /// </summary>
        private void SetEasyCircleCurve(IAnmAttribute anmAttrTranslate, IAnmAttribute anmAttrRotate, float beginAngle, float endAngle, float radiusX, float radiusY, float divisionNumber, float charAngle)
        {
            AnmCurveManipulator anmCurveMnpX = new AnmCurveManipulator();
            anmCurveMnpX.BindTarget(anmAttrTranslate.FindSubAttributeByIdx(0).ICurrentAnimationCurve);
            anmCurveMnpX.PreInfinity = AnmCurveInfinityType.Constant;
            anmCurveMnpX.PostInfinity = AnmCurveInfinityType.Constant;
            AnmCurveManipulator anmCurveMnpY = new AnmCurveManipulator();
            anmCurveMnpY.BindTarget(anmAttrTranslate.FindSubAttributeByIdx(1).ICurrentAnimationCurve);
            anmCurveMnpY.PreInfinity = AnmCurveInfinityType.Constant;
            anmCurveMnpY.PostInfinity = AnmCurveInfinityType.Constant;
            AnmCurveManipulator anmCurveMnpR = new AnmCurveManipulator();
            anmCurveMnpR.BindTarget(anmAttrRotate.FindSubAttributeByIdx(2).ICurrentAnimationCurve);
            anmCurveMnpR.PreInfinity = AnmCurveInfinityType.Constant;
            anmCurveMnpR.PostInfinity = AnmCurveInfinityType.Constant;

            // カーブを設定
            float oldValueR = 0.0f;
            for (int i = 0; i < divisionNumber; i++)
            {
                float angle = (beginAngle + (float)i * (endAngle - beginAngle) / (float)(divisionNumber - 1));
                float valueX = radiusX * (float)Math.Cos(angle / 180.0f * (float)Math.PI);
                anmCurveMnpX.MakeKeyFrame(i, valueX);
                float valueY = radiusY * (float)Math.Sin(angle / 180.0f * (float)Math.PI);
                anmCurveMnpY.MakeKeyFrame(i, valueY);
                // 楕円でも角度が自然になるように angle ではなく座標から角度を求める
                float valueR = (float)Math.Atan2(valueY, valueX) / (float)Math.PI * 180.0f + charAngle;
                // 角度の差が 180 度を超えないようにして連続になるようにする
                if (i != 0)
                {
                    if (valueR < oldValueR - 180.0f)
                    {
                        valueR += 360.0f;
                    }
                    else if (valueR > oldValueR + 180.0f)
                    {
                        valueR -= 360.0f;
                    }
                }
                oldValueR = valueR;
                anmCurveMnpR.MakeKeyFrame(i, valueR);
            }
        }

        /// <summary>
        /// 非表示になったときに呼び出されるメソッド。
        /// </summary>
        public override void OnHide()
        {
            if (_EasySettingOfPerCharTransformDlg.Visible)
            {
                _EasySettingOfPerCharTransformDlg.Hide();
            }
        }

        #endregion GUIの変更をデータに反映するハンドラ群

        #region コンテンツテキストボックスのIME状態を保存する処理
        /// <summary>
        /// コンテンツ：Enter
        /// </summary>
        private void Event_TbxContents_Enter( object sender, EventArgs e )
        {
            // IME状態の復元
            if( _ContentTextBoxImeEnabled )
            {
                IntPtr hImc = LECore.Win32.Imm32.ImmGetContext( _tbxContents.Handle );
                if( hImc != IntPtr.Zero )
                {
                    LECore.Win32.Imm32.ImmSetOpenStatus( hImc, true );
                    LECore.Win32.Imm32.ImmReleaseContext( _tbxContents.Handle, hImc );
                }
            }
        }

        /// <summary>
        /// コンテンツ：Leave
        /// </summary>
        private void Event_TbxContents_Leave( object sender, EventArgs e )
        {
            // IME状態の復元の準備
            IntPtr hImc = LECore.Win32.Imm32.ImmGetContext( _tbxContents.Handle );
            if( hImc != IntPtr.Zero )
            {
                _ContentTextBoxImeEnabled = LECore.Win32.Imm32.ImmGetOpenStatus( hImc );
                LECore.Win32.Imm32.ImmReleaseContext( _tbxContents.Handle, hImc );
            }
        }
        #endregion コンテンツテキストボックスのIME状態を保存する処理

        /// <summary>
        /// 複数行テキストで Ctrl + A で全選択
        /// </summary>
        void Event_tbxContents_KeyDown(object sender, KeyEventArgs e)
        {
            TextBox textBox = sender as TextBox;
            if (null != textBox)
            {
                if (e.Control && e.KeyCode == Keys.A)
                {
                    textBox.SelectAll();
                    e.SuppressKeyPress = true;
                }
            }
        }
    }
}

