﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Drawing;
using System.Diagnostics;
using System.Windows.Forms;
using System.Linq;

namespace LayoutEditor.Forms.ToolWindows.PropertyEditWindow
{
    using LayoutEditor.Forms.ToolWindows.PropertyEditWindow.Adapters;
    using LayoutEditor.Controls;
    using LECore.Manipulator;
    using LECore.Structures;
    using Pane;
    using LECore.Structures.Core;
    using Utility;
    using src.Controls;
    using System.Collections.Generic;

    /// <summary>
    /// PropWndPaneBasicPage の概要の説明です。
    /// </summary>
    public class PicturePanePage : PropertyPage
    {
        #region デザイナ生成コード

        private LayoutEditor.Controls.VertexColorEditPanel _pnlVtxColor;
        private LayoutEditor.Controls.DockContentToolTip _ttpMain;
        private System.ComponentModel.IContainer components;
        private src.Forms.ToolWindows.common.TextureCoordEdit _ctlTexCoord;
        private GroupBox _grpTexCoord;
        private ComboBox _cmbShapeType;
        private GroupBox _grpRoundRectParams;
        private NumericUpDown _numRoundRadius;
        private Label _lblRadius;
        private GroupBox _grpCircleParams;
        private Label _lblCircleSliceCount;
        private NumericUpDown _numCircleSliceCount;
        private Label _lblShapeType;
        private Label _lblRoundSliceCount;
        private NumericUpDown _numRoundSliceCount;
        private src.Controls.BindAnimationLabel _lblVertexColor;
        private System.Windows.Forms.GroupBox _grpVtxCol;


        private void InitializeComponent()
        {
            this.components = new System.ComponentModel.Container();
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(PicturePanePage));
            this._grpVtxCol = new System.Windows.Forms.GroupBox();
            this._lblVertexColor = new LayoutEditor.src.Controls.BindAnimationLabel();
            this._pnlVtxColor = new LayoutEditor.Controls.VertexColorEditPanel();
            this._ctlTexCoord = new LayoutEditor.src.Forms.ToolWindows.common.TextureCoordEdit();
            this._ttpMain = new LayoutEditor.Controls.DockContentToolTip(this.components);
            this._grpTexCoord = new System.Windows.Forms.GroupBox();
            this._cmbShapeType = new System.Windows.Forms.ComboBox();
            this._grpRoundRectParams = new System.Windows.Forms.GroupBox();
            this._lblRoundSliceCount = new System.Windows.Forms.Label();
            this._numRoundSliceCount = new System.Windows.Forms.NumericUpDown();
            this._lblRadius = new System.Windows.Forms.Label();
            this._numRoundRadius = new System.Windows.Forms.NumericUpDown();
            this._grpCircleParams = new System.Windows.Forms.GroupBox();
            this._lblCircleSliceCount = new System.Windows.Forms.Label();
            this._numCircleSliceCount = new System.Windows.Forms.NumericUpDown();
            this._lblShapeType = new System.Windows.Forms.Label();
            this._grpVtxCol.SuspendLayout();
            this._grpTexCoord.SuspendLayout();
            this._grpRoundRectParams.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this._numRoundSliceCount)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this._numRoundRadius)).BeginInit();
            this._grpCircleParams.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this._numCircleSliceCount)).BeginInit();
            this.SuspendLayout();
            //
            // _grpVtxCol
            //
            this._grpVtxCol.Controls.Add(this._lblVertexColor);
            this._grpVtxCol.Controls.Add(this._pnlVtxColor);
            resources.ApplyResources(this._grpVtxCol, "_grpVtxCol");
            this._grpVtxCol.Name = "_grpVtxCol";
            this._grpVtxCol.TabStop = false;
            //
            // _lblVertexColor
            //
            resources.ApplyResources(this._lblVertexColor, "_lblVertexColor");
            this._lblVertexColor.Name = "_lblVertexColor";
            this._lblVertexColor.UseAnimationMark = false;
            this._lblVertexColor.UseContextMenu = false;
            //
            // _pnlVtxColor
            //
            resources.ApplyResources(this._pnlVtxColor, "_pnlVtxColor");
            this._pnlVtxColor.Name = "_pnlVtxColor";
            this._pnlVtxColor.UseAnimationMark = true;
            this._pnlVtxColor.ColorChange += new LayoutEditor.Controls.VertexColorEditPanel.OnColorChange(this.Event_PnlVtxColor_ColorChange);
            //
            // _ctlTexCoord
            //
            resources.ApplyResources(this._ctlTexCoord, "_ctlTexCoord");
            this._ctlTexCoord.Name = "_ctlTexCoord";
            //
            // _grpTexCoord
            //
            this._grpTexCoord.Controls.Add(this._ctlTexCoord);
            resources.ApplyResources(this._grpTexCoord, "_grpTexCoord");
            this._grpTexCoord.Name = "_grpTexCoord";
            this._grpTexCoord.TabStop = false;
            //
            // _cmbShapeType
            //
            this._cmbShapeType.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this._cmbShapeType.FormattingEnabled = true;
            this._cmbShapeType.Items.AddRange(new object[] {
            resources.GetString("_cmbShapeType.Items"),
            resources.GetString("_cmbShapeType.Items1"),
            resources.GetString("_cmbShapeType.Items2")});
            resources.ApplyResources(this._cmbShapeType, "_cmbShapeType");
            this._cmbShapeType.Name = "_cmbShapeType";
            this._cmbShapeType.SelectedIndexChanged += new System.EventHandler(this.Event_CmbShapeType_SelectedIndexChanged);
            //
            // _grpRoundRectParams
            //
            this._grpRoundRectParams.Controls.Add(this._lblRoundSliceCount);
            this._grpRoundRectParams.Controls.Add(this._numRoundSliceCount);
            this._grpRoundRectParams.Controls.Add(this._lblRadius);
            this._grpRoundRectParams.Controls.Add(this._numRoundRadius);
            resources.ApplyResources(this._grpRoundRectParams, "_grpRoundRectParams");
            this._grpRoundRectParams.Name = "_grpRoundRectParams";
            this._grpRoundRectParams.TabStop = false;
            //
            // _lblRoundSliceCount
            //
            resources.ApplyResources(this._lblRoundSliceCount, "_lblRoundSliceCount");
            this._lblRoundSliceCount.Name = "_lblRoundSliceCount";
            //
            // _numRoundSliceCount
            //
            resources.ApplyResources(this._numRoundSliceCount, "_numRoundSliceCount");
            this._numRoundSliceCount.Maximum = new decimal(new int[] {
            1000,
            0,
            0,
            0});
            this._numRoundSliceCount.Minimum = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this._numRoundSliceCount.Name = "_numRoundSliceCount";
            this._numRoundSliceCount.Value = new decimal(new int[] {
            4,
            0,
            0,
            0});
            this._numRoundSliceCount.ValueChanged += new System.EventHandler(this.Event_numRoundSliceCount_ValueChanged);
            //
            // _lblRadius
            //
            resources.ApplyResources(this._lblRadius, "_lblRadius");
            this._lblRadius.Name = "_lblRadius";
            //
            // _numRoundRadius
            //
            resources.ApplyResources(this._numRoundRadius, "_numRoundRadius");
            this._numRoundRadius.Maximum = new decimal(new int[] {
            2048,
            0,
            0,
            0});
            this._numRoundRadius.Minimum = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this._numRoundRadius.Name = "_numRoundRadius";
            this._numRoundRadius.Value = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this._numRoundRadius.ValueChanged += new System.EventHandler(this.Event_numRoundRadius_ValueChanged);
            //
            // _grpCircleParams
            //
            this._grpCircleParams.Controls.Add(this._lblCircleSliceCount);
            this._grpCircleParams.Controls.Add(this._numCircleSliceCount);
            resources.ApplyResources(this._grpCircleParams, "_grpCircleParams");
            this._grpCircleParams.Name = "_grpCircleParams";
            this._grpCircleParams.TabStop = false;
            //
            // _lblCircleSliceCount
            //
            resources.ApplyResources(this._lblCircleSliceCount, "_lblCircleSliceCount");
            this._lblCircleSliceCount.Name = "_lblCircleSliceCount";
            //
            // _numCircleSliceCount
            //
            resources.ApplyResources(this._numCircleSliceCount, "_numCircleSliceCount");
            this._numCircleSliceCount.Maximum = new decimal(new int[] {
            2000,
            0,
            0,
            0});
            this._numCircleSliceCount.Minimum = new decimal(new int[] {
            3,
            0,
            0,
            0});
            this._numCircleSliceCount.Name = "_numCircleSliceCount";
            this._numCircleSliceCount.Value = new decimal(new int[] {
            16,
            0,
            0,
            0});
            this._numCircleSliceCount.ValueChanged += new System.EventHandler(this.Event_numCircleSlice_ValueChanged);
            //
            // _lblShapeType
            //
            resources.ApplyResources(this._lblShapeType, "_lblShapeType");
            this._lblShapeType.Name = "_lblShapeType";
            //
            // PicturePanePage
            //
            this.Controls.Add(this._lblShapeType);
            this.Controls.Add(this._grpCircleParams);
            this.Controls.Add(this._grpRoundRectParams);
            this.Controls.Add(this._cmbShapeType);
            this.Controls.Add(this._grpTexCoord);
            this.Controls.Add(this._grpVtxCol);
            this.Name = "PicturePanePage";
            resources.ApplyResources(this, "$this");
            this._grpVtxCol.ResumeLayout(false);
            this._grpVtxCol.PerformLayout();
            this._grpTexCoord.ResumeLayout(false);
            this._grpRoundRectParams.ResumeLayout(false);
            this._grpRoundRectParams.PerformLayout();
            ((System.ComponentModel.ISupportInitialize)(this._numRoundSliceCount)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this._numRoundRadius)).EndInit();
            this._grpCircleParams.ResumeLayout(false);
            this._grpCircleParams.PerformLayout();
            ((System.ComponentModel.ISupportInitialize)(this._numCircleSliceCount)).EndInit();
            this.ResumeLayout(false);
            this.PerformLayout();

        }

        #endregion デザイナ生成コード

        /// <summary>
        /// 操作対象ペインを取得します。
        /// </summary>
        PaneGUIAdapter _TargetPane
        {
            get
            {
                PaneGUIAdapter  paneAdapter = Target.Active;
                return paneAdapter;
            }
        }

        /// <summary>
        /// 操作対象ペインを取得します。
        /// </summary>
        IEnumerable<PaneGUIAdapter> _TargetPanes
        {
            get
            {
                return Target.Objects.Select(pane => pane as PaneGUIAdapter);
            }
        }

        /// <summary>
        /// 操作対象ペインを操作するクラスを取得します。
        /// </summary>
        PictureManipulator _TargetPictureMpn
        {
            get
            {
                return _TargetPane.FindTargetPictureManipulator(_TargetIndex);
            }
        }

        /// <summary>
        /// 操作対象ペインを操作するクラスを取得します。
        /// </summary>
        IEnumerable<PictureManipulator> _TargetPictureMnps
        {
            get
            {
                return _TargetPanes.Select(pane => pane.FindTargetPictureManipulator(_TargetIndex))
                    .Where(mnp => mnp != null);
            }
        }

        /// <summary>
        /// 操作対象マテリアルを取得します。
        /// </summary>
        MaterialGUIAdapter _TargetMaterialMnp
        {
            get
            {
                return _TargetPane.MaterialAdapters.FirstOrDefault(
                        (mat) => _TargetPane.Target.HasMaterial(mat.IMaterial));
            }
        }

        /// <summary>
        /// 複数が対象にある場合に、何番目を対象とするかを指定します。
        /// </summary>
        protected int _TargetIndex
        {
            get;
            set;
        }

        /// <summary>
        /// プロパティ初期化。
        /// </summary>
        protected override void InitializeProperty()
        {
            this._ctlTexCoord.Initialize(() => NotifyPropertyChanged());

            // ViewManagerへのメッセージハンドラを設定します
            _pnlVtxColor.SetViewManagerMessageHandler(this.Owner.SendMessageToViewManagerAction);
        }

        /// <summary>
        ///
        /// </summary>
        protected override void UpdateProperty()
        {
            if( _TargetPictureMpn == null ||
                _TargetPictureMpn.IPicture == null)
            {
                return;
            }

            _ctlTexCoord.SetTarget(_TargetPictureMpn, _TargetPictureMnps, GetMultiEditColor());
            _ctlTexCoord.UpdateProperty();

            _cmbShapeType.SelectedIndex = (int)_TargetPictureMpn.IPicture.ShapeType;
            UpdatePropertyShapeType_(_TargetPictureMpn.IPicture.ShapeType);

            switch (_TargetPictureMpn.IPicture.ShapeType)
            {
                case LECore.Structures.SerializableObject.Lyt.ShapeType.GfxPrimitiveCircle:
                    _numCircleSliceCount.Value = (int)_TargetPictureMpn.IPicture.CircleSlice;
                    break;
                case LECore.Structures.SerializableObject.Lyt.ShapeType.GfxPrimitiveRoundRect:
                    _numRoundSliceCount.Value = (int)_TargetPictureMpn.IPicture.RoundSlice;
                    _numRoundRadius.Value = (int)_TargetPictureMpn.IPicture.RoundRadius;
                    break;
                default:
                    break;
            }

            // 頂点カラーをGUIコントロールに設定します。
            _UpdataVtxColorProperty_();
        }

        private void UpdatePropertyShapeType_(LECore.Structures.SerializableObject.Lyt.ShapeType shapeType)
        {
            var grpVtxColVisible = false;
            var grpTexCoordVisible = false;
            var grpRoundRectParamsVisible = false;
            var grpCircleParamsVisible = false;

            switch (shapeType)
            {
                case LECore.Structures.SerializableObject.Lyt.ShapeType.NormalQuad:
                    grpVtxColVisible = true;
                    _grpVtxCol.Location = new Point(5, 32);
                    grpTexCoordVisible = true;
                    _grpTexCoord.Location = new Point(5, 153);
                    break;
                case LECore.Structures.SerializableObject.Lyt.ShapeType.GfxPrimitiveRoundRect:
                    grpRoundRectParamsVisible = true;
                    _grpRoundRectParams.Location = new Point(5, 32);
                    break;
                case LECore.Structures.SerializableObject.Lyt.ShapeType.GfxPrimitiveCircle:
                    grpCircleParamsVisible = true;
                    _grpCircleParams.Location = new Point(5, 32);
                    break;
                default:
                    break;
            }

            _grpVtxCol.Visible = grpVtxColVisible;
            _grpTexCoord.Visible = grpTexCoordVisible;
            _grpRoundRectParams.Visible = grpRoundRectParamsVisible;
            _grpCircleParams.Visible = grpCircleParamsVisible;
        }

        #region データをGUIコントロールに設定する処理

        /// <summary>
        /// コントロールにカラー値を設定します。
        /// </summary>
        void SetColorPropertyControl_( ColorEditPanel dstColCtrl, RGBAColor srcCol )
        {
            dstColCtrl.Color = new FloatColor(Color.FromArgb( srcCol.A, srcCol.R, srcCol.G, srcCol.B ));
        }

        /// <summary>
        /// GUI頂点カラー情報を更新します。
        /// </summary>
        void _UpdataVtxColorProperty_()
        {
            // アニメーションマークとコンテキストメニューの有効無効
            bool bUse = CanUseAnimationMark(_TargetPictureMpn.IPicture?.OwnerPane?.OwnerSubScene);
            IEnumerable<IAnimationMarkUsable> animCtrlList = GetAnimationMarkUsableControl();
            foreach (IAnimationMarkUsable ctrl in animCtrlList)
            {
                ctrl.UseAnimationMark = bUse;
            }

            IPicture srcPicture = _TargetPictureMpn.IPicture;
            _pnlVtxColor.Set( srcPicture.VtxCol_LT.AsColor,
                              srcPicture.VtxCol_RT.AsColor,
                              srcPicture.VtxCol_LB.AsColor,
                              srcPicture.VtxCol_RB.AsColor );

            // アニメーションマークで利用するアトリビュートを関連付け
            _pnlVtxColor.SetTargetAttribute(srcPicture);

            // アニメーションマークの更新
            foreach (IAnimationMarkUsable ctrl in animCtrlList)
            {
                ctrl.UpdateAnimationMark();
            }
        }

        #endregion データをGUIコントロールに設定する処理

        public PicturePanePage()
        {
            InitializeComponent();

            // コンテキストメニューを追加する
            AnimationMarkContextMenuBuilder.BuildMultiControlMenu(_lblVertexColor, _pnlVtxColor.AnimationMarkArray);
        }

        /// <summary>
        /// インスタンス作成。
        /// </summary>
        public static PropertyPage CreateInstance(object arg)
        {
            var newInstance = new PicturePanePage();
            newInstance._TargetIndex = (arg == null) ? 0 : (int)arg;

            return newInstance;
        }

        #region イベントハンドラ

        /// <summary>
        /// カラーコントロール変更ハンドラ
        /// GUIコントロールの変更をデータに反映します。
        /// </summary>
        private void Event_PnlVtxColor_ColorChange( Color LT, Color RT, Color LB, Color RB )
        {
            if (IsGUIUpdating) { return; }

            var currentISubScene = LECore.LayoutEditorCore.Scene.CurrentISubScene;
            currentISubScene.BeginMassiveModify();
            _TargetPictureMpn.VtxColor_LT = new RGBAColor( LT );
            _TargetPictureMpn.VtxColor_RT = new RGBAColor( RT );
            _TargetPictureMpn.VtxColor_LB = new RGBAColor( LB );
            _TargetPictureMpn.VtxColor_RB = new RGBAColor( RB );
            currentISubScene.EndMassiveModify();
        }

        /// <summary>
        /// シェイプタイプコンボボックス切り替え
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void Event_CmbShapeType_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (IsGUIUpdating) { return; }

            var cbx = sender as ComboBox;

            if (cbx.SelectedIndex < 0)
            {
                return;
            }

            var shapeType = (LECore.Structures.SerializableObject.Lyt.ShapeType)cbx.SelectedIndex;

            UpdatePropertyShapeType_(shapeType);

            var currentISubScene = LECore.LayoutEditorCore.Scene.CurrentISubScene;
            currentISubScene.BeginMassiveModify();
            _TargetPictureMpn.ShapeType = shapeType;
            currentISubScene.EndMassiveModify();
        }

        private void Event_numCircleSlice_ValueChanged(object sender, EventArgs e)
        {
            if (IsGUIUpdating) { return; }

            var ctrl = sender as NumericUpDown;
            var currentISubScene = LECore.LayoutEditorCore.Scene.CurrentISubScene;
            currentISubScene.BeginMassiveModify();
            _TargetPictureMpn.CircleSlice = (uint)ctrl.Value;
            currentISubScene.EndMassiveModify();
        }

        private void Event_numRoundRadius_ValueChanged(object sender, EventArgs e)
        {
            if (IsGUIUpdating) { return; }

            var ctrl = sender as NumericUpDown;
            var currentISubScene = LECore.LayoutEditorCore.Scene.CurrentISubScene;
            currentISubScene.BeginMassiveModify();
            _TargetPictureMpn.RoundRadius = (uint)ctrl.Value;
            currentISubScene.EndMassiveModify();
        }

        private void Event_numRoundSliceCount_ValueChanged(object sender, EventArgs e)
        {
            if (IsGUIUpdating) { return; }

            var ctrl = sender as NumericUpDown;
            var currentISubScene = LECore.LayoutEditorCore.Scene.CurrentISubScene;
            currentISubScene.BeginMassiveModify();
            _TargetPictureMpn.RoundSlice = (uint)ctrl.Value;
            currentISubScene.EndMassiveModify();
        }

        #endregion イベントハンドラ

        /// <summary>
        /// アニメーションマークが利用可能なコントロールの一覧を取得する。
        /// </summary>
        protected override IEnumerable<IAnimationMarkUsable> GetAnimationMarkUsableControl()
        {
            List<IAnimationMarkUsable> list = new List<IAnimationMarkUsable>();

            list.Add(_lblVertexColor);
            list.Add(_pnlVtxColor);

            return list;
        }
    }
}
