﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

using LECore.Structures;
using LayoutEditor.Controls;

namespace LayoutEditor.Forms.ToolWindows.PropertyEditWindow
{
    public partial class EasySettingOfPerCharTransformDlg : Form
    {
        const int EasySettingMax = 8;

        TextBoxPanePage m_TextBoxPanePage = null;

        struct EasySettingControls
        {
            public GroupBox grpEasySettingOfPerCharTransform;
            public UICheckBox chkEasySettingMoveFromLeft;
            public UICheckBox chkEasySettingCalcEndFrame;
            public Label lblEasySettingBeginFrame;
            public Label lblEasySettingStopFrameOfFirstChar;
            public Label lblEasySettingEndFrame;
            public FloatTextBox tbxEasySettingBeginFrame;
            public FloatTextBox tbxEasySettingStopFrameOfFirstChar;
            public FloatTextBox tbxEasySettingEndFrame;
            public Label lblEasySettingStartFrameOfLastChar;
            public FloatTextBox tbxEasySettingStartFrameOfLastChar;
        };

        EasySettingControls[] m_EasySettingControls = null;

        public EasySettingOfPerCharTransformDlg(TextBoxPanePage textBoxPanePage)
        {
            InitializeComponent();

            m_TextBoxPanePage = textBoxPanePage;

            // 簡単設定の項目数の分のコントロールの配列を作成する
            m_EasySettingControls = new EasySettingControls[EasySettingMax];
            for (int i = 0; i < EasySettingMax; i++)
            {
                m_EasySettingControls[i].grpEasySettingOfPerCharTransform = new GroupBox();
                m_EasySettingControls[i].grpEasySettingOfPerCharTransform.Top = _grpEasySettingOfPerCharTransform.Top +
                    (_grpEasySettingOfPerCharTransform.Height + _grpEasySettingOfPerCharTransform.Margin.Top + _grpEasySettingOfPerCharTransform.Margin.Bottom) * i;
                m_EasySettingControls[i].grpEasySettingOfPerCharTransform.Left = _grpEasySettingOfPerCharTransform.Left;
                m_EasySettingControls[i].grpEasySettingOfPerCharTransform.Size = _grpEasySettingOfPerCharTransform.Size;
                m_EasySettingControls[i].grpEasySettingOfPerCharTransform.Text = _grpEasySettingOfPerCharTransform.Text + "(" + (i + 1) + ")";
                this.Controls.Add(m_EasySettingControls[i].grpEasySettingOfPerCharTransform);

                m_EasySettingControls[i].chkEasySettingMoveFromLeft = new UICheckBox();
                m_EasySettingControls[i].chkEasySettingMoveFromLeft.Location = _chkEasySettingMoveFromLeft.Location;
                m_EasySettingControls[i].chkEasySettingMoveFromLeft.Size = _chkEasySettingMoveFromLeft.Size;
                m_EasySettingControls[i].chkEasySettingMoveFromLeft.Text = _chkEasySettingMoveFromLeft.Text;
                m_EasySettingControls[i].chkEasySettingMoveFromLeft.Checked = _chkEasySettingMoveFromLeft.Checked;
                m_EasySettingControls[i].chkEasySettingMoveFromLeft.CheckedChanged += new EventHandler(Event_ChkEasySettingMoveFromLeft_CheckedChanged);
                m_EasySettingControls[i].grpEasySettingOfPerCharTransform.Controls.Add(m_EasySettingControls[i].chkEasySettingMoveFromLeft);

                m_EasySettingControls[i].chkEasySettingCalcEndFrame = new UICheckBox();
                m_EasySettingControls[i].chkEasySettingCalcEndFrame.Location = _chkEasySettingCalcEndFrame.Location;
                m_EasySettingControls[i].chkEasySettingCalcEndFrame.Size = _chkEasySettingCalcEndFrame.Size;
                m_EasySettingControls[i].chkEasySettingCalcEndFrame.Text = _chkEasySettingCalcEndFrame.Text;
                m_EasySettingControls[i].chkEasySettingCalcEndFrame.Checked = _chkEasySettingCalcEndFrame.Checked;
                m_EasySettingControls[i].chkEasySettingCalcEndFrame.CheckedChanged += new EventHandler(Event_ChkEasySettingCalcEndFrame_CheckedChanged);
                m_EasySettingControls[i].grpEasySettingOfPerCharTransform.Controls.Add(m_EasySettingControls[i].chkEasySettingCalcEndFrame);

                m_EasySettingControls[i].lblEasySettingBeginFrame = new Label();
                m_EasySettingControls[i].lblEasySettingBeginFrame.Location = _lblEasySettingBeginFrame.Location;
                m_EasySettingControls[i].lblEasySettingBeginFrame.Size = _lblEasySettingBeginFrame.Size;
                m_EasySettingControls[i].lblEasySettingBeginFrame.Text = _lblEasySettingBeginFrame.Text;
                m_EasySettingControls[i].lblEasySettingBeginFrame.TextAlign = _lblEasySettingBeginFrame.TextAlign;
                m_EasySettingControls[i].grpEasySettingOfPerCharTransform.Controls.Add(m_EasySettingControls[i].lblEasySettingBeginFrame);

                m_EasySettingControls[i].lblEasySettingStopFrameOfFirstChar = new Label();
                m_EasySettingControls[i].lblEasySettingStopFrameOfFirstChar.Location = _lblEasySettingStopFrameOfFirstChar.Location;
                m_EasySettingControls[i].lblEasySettingStopFrameOfFirstChar.Size = _lblEasySettingStopFrameOfFirstChar.Size;
                m_EasySettingControls[i].lblEasySettingStopFrameOfFirstChar.Text = _lblEasySettingStopFrameOfFirstChar.Text;
                m_EasySettingControls[i].lblEasySettingStopFrameOfFirstChar.TextAlign = _lblEasySettingStopFrameOfFirstChar.TextAlign;
                m_EasySettingControls[i].grpEasySettingOfPerCharTransform.Controls.Add(m_EasySettingControls[i].lblEasySettingStopFrameOfFirstChar);

                m_EasySettingControls[i].lblEasySettingEndFrame = new Label();
                m_EasySettingControls[i].lblEasySettingEndFrame.Location = _lblEasySettingEndFrame.Location;
                m_EasySettingControls[i].lblEasySettingEndFrame.Size = _lblEasySettingEndFrame.Size;
                m_EasySettingControls[i].lblEasySettingEndFrame.Text = _lblEasySettingEndFrame.Text;
                m_EasySettingControls[i].lblEasySettingEndFrame.TextAlign = _lblEasySettingEndFrame.TextAlign;
                m_EasySettingControls[i].grpEasySettingOfPerCharTransform.Controls.Add(m_EasySettingControls[i].lblEasySettingEndFrame);

                m_EasySettingControls[i].tbxEasySettingBeginFrame = new FloatTextBox();
                m_EasySettingControls[i].tbxEasySettingBeginFrame.Location = _tbxEasySettingBeginFrame.Location;
                m_EasySettingControls[i].tbxEasySettingBeginFrame.Size = _tbxEasySettingBeginFrame.Size;
                m_EasySettingControls[i].tbxEasySettingBeginFrame.Value = _tbxEasySettingBeginFrame.Value;
                m_EasySettingControls[i].tbxEasySettingBeginFrame.Text = _tbxEasySettingBeginFrame.Text;
                m_EasySettingControls[i].tbxEasySettingBeginFrame.Format = _tbxEasySettingBeginFrame.Format;
                m_EasySettingControls[i].tbxEasySettingBeginFrame.ValueChanged += new EventHandler(Event_TbxEasySettingBeginFrame_ValueChanged);
                m_EasySettingControls[i].grpEasySettingOfPerCharTransform.Controls.Add(m_EasySettingControls[i].tbxEasySettingBeginFrame);

                m_EasySettingControls[i].tbxEasySettingEndFrame = new FloatTextBox();
                m_EasySettingControls[i].tbxEasySettingEndFrame.Location = _tbxEasySettingEndFrame.Location;
                m_EasySettingControls[i].tbxEasySettingEndFrame.Size = _tbxEasySettingEndFrame.Size;
                m_EasySettingControls[i].tbxEasySettingEndFrame.Value = _tbxEasySettingEndFrame.Value;
                m_EasySettingControls[i].tbxEasySettingEndFrame.Text = _tbxEasySettingEndFrame.Text;
                m_EasySettingControls[i].tbxEasySettingEndFrame.Format = _tbxEasySettingEndFrame.Format;
                m_EasySettingControls[i].tbxEasySettingEndFrame.ValueChanged += new EventHandler(Event_TbxEasySettingEndFrame_ValueChanged);
                m_EasySettingControls[i].grpEasySettingOfPerCharTransform.Controls.Add(m_EasySettingControls[i].tbxEasySettingEndFrame);

                m_EasySettingControls[i].tbxEasySettingStopFrameOfFirstChar = new FloatTextBox();
                m_EasySettingControls[i].tbxEasySettingStopFrameOfFirstChar.Location = _tbxEasySettingStopFrameOfFirstChar.Location;
                m_EasySettingControls[i].tbxEasySettingStopFrameOfFirstChar.Size = _tbxEasySettingStopFrameOfFirstChar.Size;
                m_EasySettingControls[i].tbxEasySettingStopFrameOfFirstChar.Value = _tbxEasySettingStopFrameOfFirstChar.Value;
                m_EasySettingControls[i].tbxEasySettingStopFrameOfFirstChar.Text = _tbxEasySettingStopFrameOfFirstChar.Text;
                m_EasySettingControls[i].tbxEasySettingStopFrameOfFirstChar.Format = _tbxEasySettingStopFrameOfFirstChar.Format;
                m_EasySettingControls[i].tbxEasySettingStopFrameOfFirstChar.ValueChanged += new EventHandler(Event_TbxEasySettingStopFrameOfFirstChar_ValueChanged);
                m_EasySettingControls[i].grpEasySettingOfPerCharTransform.Controls.Add(m_EasySettingControls[i].tbxEasySettingStopFrameOfFirstChar);

                m_EasySettingControls[i].lblEasySettingStartFrameOfLastChar = new Label();
                m_EasySettingControls[i].lblEasySettingStartFrameOfLastChar.Location = _lblEasySettingStartFrameOfLastChar.Location;
                m_EasySettingControls[i].lblEasySettingStartFrameOfLastChar.Size = _lblEasySettingStartFrameOfLastChar.Size;
                m_EasySettingControls[i].lblEasySettingStartFrameOfLastChar.Text = _lblEasySettingStartFrameOfLastChar.Text;
                m_EasySettingControls[i].lblEasySettingStartFrameOfLastChar.TextAlign = _lblEasySettingStartFrameOfLastChar.TextAlign;
                m_EasySettingControls[i].grpEasySettingOfPerCharTransform.Controls.Add(m_EasySettingControls[i].lblEasySettingStartFrameOfLastChar);

                m_EasySettingControls[i].tbxEasySettingStartFrameOfLastChar = new FloatTextBox();
                m_EasySettingControls[i].tbxEasySettingStartFrameOfLastChar.Location = _tbxEasySettingStartFrameOfLastChar.Location;
                m_EasySettingControls[i].tbxEasySettingStartFrameOfLastChar.Size = _tbxEasySettingStartFrameOfLastChar.Size;
                m_EasySettingControls[i].tbxEasySettingStartFrameOfLastChar.Value = _tbxEasySettingStartFrameOfLastChar.Value;
                m_EasySettingControls[i].tbxEasySettingStartFrameOfLastChar.Text = _tbxEasySettingStartFrameOfLastChar.Text;
                m_EasySettingControls[i].tbxEasySettingStartFrameOfLastChar.Format = _tbxEasySettingStartFrameOfLastChar.Format;
                m_EasySettingControls[i].tbxEasySettingStartFrameOfLastChar.ValueChanged += new EventHandler(Event_TbxEasySettingStartFrameOfLastChar_ValueChanged);
                m_EasySettingControls[i].grpEasySettingOfPerCharTransform.Controls.Add(m_EasySettingControls[i].tbxEasySettingStartFrameOfLastChar);
            }
            this.Controls.Remove(_grpEasySettingOfPerCharTransform);
        }

        private void Event_EasySettingOfPerCharTransformDlg_Closing(object sender, FormClosingEventArgs e)
        {
            // 閉じるとインスタンスが解放されてしまうため非表示にする
            e.Cancel = true;
            this.Hide();
        }

        public void SetDataToGUIControl(ITextBox srcTextBox)
        {
            _btnEasySettingAdd.Enabled = srcTextBox.IsPerCharTransformEnabled;
            _btnEasySettingDelete.Enabled = srcTextBox.IsPerCharTransformEnabled;
            _lblEasySettingPaneName.Text = srcTextBox.OwnerPane.PaneName;

            int length = srcTextBox.EasySettingOfPerCharTransform == null ? 0 : srcTextBox.EasySettingOfPerCharTransform.Length;
            for (int i = 0; i < EasySettingMax; i++)
            {
                if (i < length)
                {
                    m_EasySettingControls[i].grpEasySettingOfPerCharTransform.Visible = true;
                    m_EasySettingControls[i].grpEasySettingOfPerCharTransform.Enabled = srcTextBox.IsPerCharTransformEnabled;
                    m_EasySettingControls[i].chkEasySettingMoveFromLeft.SetChecked(srcTextBox.EasySettingOfPerCharTransform[i].easySettingMoveFromLeft);
                    m_EasySettingControls[i].chkEasySettingCalcEndFrame.SetChecked(srcTextBox.EasySettingOfPerCharTransform[i].easySettingCalcEndFrame);
                    m_EasySettingControls[i].tbxEasySettingBeginFrame.SetValue(srcTextBox.EasySettingOfPerCharTransform[i].easySettingBeginFrame);
                    m_EasySettingControls[i].tbxEasySettingEndFrame.SetValue(srcTextBox.EasySettingOfPerCharTransform[i].easySettingEndFrame);
                    m_EasySettingControls[i].tbxEasySettingStopFrameOfFirstChar.SetValue(srcTextBox.EasySettingOfPerCharTransform[i].easySettingStopFrameOfFirstChar);
                    m_EasySettingControls[i].tbxEasySettingStartFrameOfLastChar.SetValue(srcTextBox.EasySettingOfPerCharTransform[i].easySettingStartFrameOfLastChar);
                    m_EasySettingControls[i].tbxEasySettingEndFrame.Enabled = !srcTextBox.EasySettingOfPerCharTransform[i].easySettingCalcEndFrame;
                    m_EasySettingControls[i].tbxEasySettingStopFrameOfFirstChar.Enabled = srcTextBox.EasySettingOfPerCharTransform[i].easySettingCalcEndFrame;
                }
                else
                {
                    m_EasySettingControls[i].grpEasySettingOfPerCharTransform.Visible = false;
                }
            }
        }

        // 簡単設定で有効になっている項目数を得る関数
        private int CalculateEasySettingCount()
        {
            // 表示されている簡単設定の項目数を数える
            for (int i = 0; i < EasySettingMax; i++)
            {
                if (!m_EasySettingControls[i].grpEasySettingOfPerCharTransform.Visible)
                {
                    return i;
                }
            }
            return EasySettingMax;
        }

        private EasySettingOfPerCharTransform[] CreateEasySettingParameters()
        {
            int length = CalculateEasySettingCount();
            EasySettingOfPerCharTransform[] param = new EasySettingOfPerCharTransform[length];
            for (int i = 0; i < length; i++)
            {
                param[i].easySettingMoveFromLeft = m_EasySettingControls[i].chkEasySettingMoveFromLeft.Checked;
                param[i].easySettingCalcEndFrame = m_EasySettingControls[i].chkEasySettingCalcEndFrame.Checked;
                param[i].easySettingBeginFrame = m_EasySettingControls[i].tbxEasySettingBeginFrame.Value;
                param[i].easySettingEndFrame = m_EasySettingControls[i].tbxEasySettingEndFrame.Value;
                param[i].easySettingStopFrameOfFirstChar = m_EasySettingControls[i].tbxEasySettingStopFrameOfFirstChar.Value;
                param[i].easySettingStartFrameOfLastChar = m_EasySettingControls[i].tbxEasySettingStartFrameOfLastChar.Value;
            }
            return param;
        }

        private void Event_BtnEasySettingAdd_Click(object sender, EventArgs e)
        {
            if (m_TextBoxPanePage.Target.Active == null)
            {
                return;
            }
            int count = CalculateEasySettingCount();
            if (count < EasySettingMax)
            {
                m_EasySettingControls[count].grpEasySettingOfPerCharTransform.Visible = true;

                EasySettingOfPerCharTransform[] param = CreateEasySettingParameters();
                m_TextBoxPanePage.SetEasySettingParameters(param);
            }
        }

        private void Event_BtnEasySettingDelete_Click(object sender, EventArgs e)
        {
            if (m_TextBoxPanePage.Target.Active == null)
            {
                return;
            }
            int count = CalculateEasySettingCount();
            if (count > 0)
            {
                m_EasySettingControls[count - 1].grpEasySettingOfPerCharTransform.Visible = false;

                EasySettingOfPerCharTransform[] param = CreateEasySettingParameters();
                m_TextBoxPanePage.SetEasySettingParameters(param);
            }
        }

        private void Event_ChkEasySettingMoveFromLeft_CheckedChanged(object sender, EventArgs e)
        {
            if (m_TextBoxPanePage.Target.Active == null)
            {
                return;
            }
            EasySettingOfPerCharTransform[] param = CreateEasySettingParameters();
            m_TextBoxPanePage.SetEasySettingParameters(param);
        }

        private void Event_ChkEasySettingCalcEndFrame_CheckedChanged(object sender, EventArgs e)
        {
            if (m_TextBoxPanePage.Target.Active == null)
            {
                return;
            }
            EasySettingOfPerCharTransform[] param = CreateEasySettingParameters();
            m_TextBoxPanePage.SetEasySettingParameters(param);
        }

        private void Event_TbxEasySettingBeginFrame_ValueChanged(object sender, EventArgs e)
        {
            if (m_TextBoxPanePage.Target.Active == null)
            {
                return;
            }
            EasySettingOfPerCharTransform[] param = CreateEasySettingParameters();
            m_TextBoxPanePage.SetEasySettingParameters(param);
        }

        private void Event_TbxEasySettingEndFrame_ValueChanged(object sender, EventArgs e)
        {
            if (m_TextBoxPanePage.Target.Active == null)
            {
                return;
            }
            EasySettingOfPerCharTransform[] param = CreateEasySettingParameters();
            m_TextBoxPanePage.SetEasySettingParameters(param);
        }

        private void Event_TbxEasySettingStopFrameOfFirstChar_ValueChanged(object sender, EventArgs e)
        {
            if (m_TextBoxPanePage.Target.Active == null)
            {
                return;
            }
            EasySettingOfPerCharTransform[] param = CreateEasySettingParameters();
            m_TextBoxPanePage.SetEasySettingParameters(param);
        }

        private void Event_TbxEasySettingStartFrameOfLastChar_ValueChanged(object sender, EventArgs e)
        {
            if (m_TextBoxPanePage.Target.Active == null)
            {
                return;
            }
            EasySettingOfPerCharTransform[] param = CreateEasySettingParameters();
            m_TextBoxPanePage.SetEasySettingParameters(param);

        }
    }
}
