﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Drawing;
using System.Diagnostics;
using System.Windows.Forms;
using System.IO;
using System.Linq;

namespace LayoutEditor.Forms.ToolWindows.PropertyEditWindow
{
    using LayoutEditor.Controls;
    using LayoutEditor.Forms.ToolWindows.PropertyEditWindow.Adapters;
    using LayoutEditor.Utility;

    using LECore.Manipulator;
    using LECore.Structures;
    using LECore;
    using LECore.Structures.Core;

    /// <summary>
    /// CapturePanePage の概要の説明です。
    /// </summary>
    public class CapturePanePage : PropertyPage
    {
        #region デザイナメンバ



        #endregion デザイナメンバ

        /// <summary>
        /// コンストラクタ
        /// </summary>
        public CapturePanePage()
        {
            InitializeComponent();
        }

        /// <summary>
        /// 捜査対象ペインアダプタ
        /// </summary>
        PaneGUIAdapter _TargetPane
        {
            get
            {
                PaneGUIAdapter paneAdapter = Target.Active;
                return paneAdapter;
            }
        }

        /// <summary>
        /// 操作対象ペインを操作するクラスを取得します。
        /// </summary>
        protected CaptureManipulator _TargetCaptureMpn
        {
            get
            {
                return _TargetPane.FindTargetCaptureManipulator(_TargetIndex);
            }
        }

        /// <summary>
        /// 複数が対象にある場合に、何番目を対象とするかを指定します。
        /// </summary>
        protected int _TargetIndex
        {
            get;
            set;
        }

        /// <summary>
        /// プロパティ初期化。
        /// </summary>
        protected override void InitializeProperty()
        {
            // GUIに関するユーザ独自の初期化処理を記述します。
        }

        /// <summary>
        /// GUIを更新します。
        /// </summary>
        protected override void UpdateProperty()
        {
            // ターゲットを参照してUIを更新する
            SetDataToGUIControl_();
        }


        #region デザイナ生成コード
        private void InitializeComponent()
        {
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(CapturePanePage));
            this._chkFrameBufferCaptureEnable = new LayoutEditor.Controls.UICheckBox();
            this._chkCaptureOnlyFirstFrame = new LayoutEditor.Controls.UICheckBox();
            this.groupBox1 = new System.Windows.Forms.GroupBox();
            this._lblTextureScalePercent = new System.Windows.Forms.Label();
            this._nudTextureScale = new LayoutEditor.Controls.UINumericUpDown();
            this._lbTextureScale = new System.Windows.Forms.Label();
            this.groupBox2 = new System.Windows.Forms.GroupBox();
            this._colClearColor = new LayoutEditor.Controls.ColorEditPanel();
            this._lblSizeAnimationNotification = new System.Windows.Forms.Label();
            this.groupBox1.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this._nudTextureScale)).BeginInit();
            this.groupBox2.SuspendLayout();
            this.SuspendLayout();
            //
            // _chkFrameBufferCaptureEnable
            //
            resources.ApplyResources(this._chkFrameBufferCaptureEnable, "_chkFrameBufferCaptureEnable");
            this._chkFrameBufferCaptureEnable.Checked = true;
            this._chkFrameBufferCaptureEnable.CheckState = System.Windows.Forms.CheckState.Checked;
            this._chkFrameBufferCaptureEnable.Name = "_chkFrameBufferCaptureEnable";
            this._chkFrameBufferCaptureEnable.UseVisualStyleBackColor = true;
            this._chkFrameBufferCaptureEnable.CheckStateChanged += new System.EventHandler(this.Event_chkFrameBufferCaptureEnable_CheckStateChanged);
            //
            // _chkCaptureOnlyFirstFrame
            //
            resources.ApplyResources(this._chkCaptureOnlyFirstFrame, "_chkCaptureOnlyFirstFrame");
            this._chkCaptureOnlyFirstFrame.Name = "_chkCaptureOnlyFirstFrame";
            this._chkCaptureOnlyFirstFrame.UseVisualStyleBackColor = true;
            this._chkCaptureOnlyFirstFrame.CheckedChanged += new System.EventHandler(this.Event_chkCaptureOnlyFirstFrame_CheckedChanged);
            //
            // groupBox1
            //
            this.groupBox1.Controls.Add(this._lblTextureScalePercent);
            this.groupBox1.Controls.Add(this._nudTextureScale);
            this.groupBox1.Controls.Add(this._lbTextureScale);
            this.groupBox1.Controls.Add(this.groupBox2);
            this.groupBox1.Controls.Add(this._chkFrameBufferCaptureEnable);
            this.groupBox1.Controls.Add(this._chkCaptureOnlyFirstFrame);
            resources.ApplyResources(this.groupBox1, "groupBox1");
            this.groupBox1.Name = "groupBox1";
            this.groupBox1.TabStop = false;
            //
            // _lblTextureScalePercent
            //
            resources.ApplyResources(this._lblTextureScalePercent, "_lblTextureScalePercent");
            this._lblTextureScalePercent.Name = "_lblTextureScalePercent";
            //
            // _nudTextureScale
            //
            resources.ApplyResources(this._nudTextureScale, "_nudTextureScale");
            this._nudTextureScale.Minimum = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this._nudTextureScale.Name = "_nudTextureScale";
            this._nudTextureScale.Value = new decimal(new int[] {
            100,
            0,
            0,
            0});
            this._nudTextureScale.ValueChanged += new System.EventHandler(this.Event_nudTextureScale_ValueCahnged);
            //
            // _lbTextureScale
            //
            resources.ApplyResources(this._lbTextureScale, "_lbTextureScale");
            this._lbTextureScale.Name = "_lbTextureScale";
            //
            // groupBox2
            //
            this.groupBox2.Controls.Add(this._colClearColor);
            resources.ApplyResources(this.groupBox2, "groupBox2");
            this.groupBox2.Name = "groupBox2";
            this.groupBox2.TabStop = false;
            //
            // _colClearColor
            //
            this._colClearColor.AllowDrop = true;
            resources.ApplyResources(this._colClearColor, "_colClearColor");
            this._colClearColor.Name = "_colClearColor";
            this._colClearColor.Tag = "";
            this._colClearColor.UseAnimationMark = false;
            this._colClearColor.ColorEdit += new LayoutEditor.Controls.ColorEditEventHandler(this.Event_colClearColor_ColorEdit);
            //
            // _lblSizeAnimationNotification
            //
            resources.ApplyResources(this._lblSizeAnimationNotification, "_lblSizeAnimationNotification");
            this._lblSizeAnimationNotification.Name = "_lblSizeAnimationNotification";
            //
            // CapturePanePage
            //
            this.Controls.Add(this._lblSizeAnimationNotification);
            this.Controls.Add(this.groupBox1);
            this.Name = "CapturePanePage";
            resources.ApplyResources(this, "$this");
            this.groupBox1.ResumeLayout(false);
            this.groupBox1.PerformLayout();
            ((System.ComponentModel.ISupportInitialize)(this._nudTextureScale)).EndInit();
            this.groupBox2.ResumeLayout(false);
            this.ResumeLayout(false);

        }
        #endregion デザイナ生成コード

        /// <summary>
        /// インスタンス作成。
        /// </summary>
        public static PropertyPage CreateInstance(object arg)
        {
            var newInstance = new CapturePanePage();
            newInstance._TargetIndex = (arg == null) ? 0 : (int)arg;

            return newInstance;
        }

        private UICheckBox _chkFrameBufferCaptureEnable;
        private UICheckBox _chkCaptureOnlyFirstFrame;
        private GroupBox groupBox1;
        private GroupBox groupBox2;
        private ColorEditPanel _colClearColor;
        private UINumericUpDown _nudTextureScale;
        private Label _lbTextureScale;
        private Label _lblTextureScalePercent;
        private Label _lblSizeAnimationNotification;

        #region データをGUIに設定する処理

        void SetDataToGUIControl_()
        {
            if (this._TargetCaptureMpn == null)
            {
                return;
            }

            ICapture srcCapture = _TargetCaptureMpn.ICapture;

            // 参照元のテクスチャがすでになくなっていないかチェックする。
            if (srcCapture.OwnTexture != null)
            {
                _chkFrameBufferCaptureEnable.SetChecked(srcCapture.FrameBufferCaptureEnabled);
                _chkCaptureOnlyFirstFrame.SetChecked(srcCapture.CaptureOnlyFirstFrame);
                _colClearColor.Color = new FloatColor(srcCapture.ClearColor);
                _nudTextureScale.SetValue((decimal)(srcCapture.TextureScale * 100.0f));
            }
        }
        #endregion データをGUIに設定する処理

        #region GUIの変更をデータに反映するハンドラ群
        /// <summary>
        /// 複数同時編集
        /// </summary>
        private void MultiEdit_(Action<CaptureManipulator> modifyAction)
        {
            if (IsGUIUpdating)
            {
                // 各コントロール等で弾いているはず
                Debug.Assert(false);
                return;
            }

            if (_TargetCaptureMpn == null)
            {
                return;
            }

            if (this.Owner.Target.IsMulti)
            {
                ISubScene subScene = LECore.LayoutEditorCore.Scene.CurrentISubScene;
                subScene.BeginMassiveModify();
                {
                    CaptureManipulator captureMnp = new CaptureManipulator();
                    foreach (IBaseGuiAdapter paneAdapter in this.Owner.Target.Objects)
                    {
                        if (paneAdapter.Target == null) { continue; }
                        if (paneAdapter.Target.ITextBox == null) { continue; }

                        captureMnp.BindTarget(paneAdapter.Target.ICapture);
                        modifyAction(captureMnp);
                    }
                }
                subScene.EndMassiveModify();
            }
            else
            {
                // 変更実行途中での UI の更新を抑える
                ISubScene subScene = LECore.LayoutEditorCore.Scene.CurrentISubScene;
                subScene.BeginMassiveModify();
                modifyAction(_TargetCaptureMpn);
                subScene.EndMassiveModify();
            }
        }
        #endregion GUIの変更をデータに反映するハンドラ群

        private void Event_colClearColor_ColorEdit(object sender, ColorEditEventArgs args)
        {
            MultiEdit_((captureMnp) => captureMnp.ClearColor = args.Color);
        }

        private void Event_chkFrameBufferCaptureEnable_CheckStateChanged(object sender, EventArgs e)
        {
            MultiEdit_((captureMnp) => captureMnp.FrameBufferCaptureEnabled = _chkFrameBufferCaptureEnable.Checked);
        }

        private void Event_chkCaptureOnlyFirstFrame_CheckedChanged(object sender, EventArgs e)
        {
            MultiEdit_((captureMnp) => captureMnp.CaptureOnlyFirstFrame = _chkCaptureOnlyFirstFrame.Checked);
        }

        private void Event_nudTextureScale_ValueCahnged(object sender, EventArgs e)
        {
            MultiEdit_((captureMnp) => captureMnp.TextureScale = (float)_nudTextureScale.Value / 100.0f);
        }


    }
}

