﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Windows.Forms;



namespace LayoutEditor.Forms.ToolWindows.PropertyEditWindow.PEControls
{
    using LayoutEditor.Forms.ToolWindows.PropertyEditWindow.Adapters ;
    using LECore.Structures.Nsrif.Attributes;
    using LECore.Structures;

    using App = LayoutEditor;
    /// <summary>
    /// ＰＥ論理演算パネルクラス。
    /// </summary>
    public sealed class PELogicBlendPanel : UserControl
    {
        #region デザイナ変数

        private System.Windows.Forms.Label lblLogicOp;
        private App.Controls.UIComboBox cmbLogicOp;
        private System.ComponentModel.Container components = null;
        #endregion

        #region デザイナコード
        /// <summary>
        /// デザイナ サポートに必要なメソッドです。このメソッドの内容を
        /// コード エディタで変更しないでください。
        /// </summary>
        private void InitializeComponent()
        {
            System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(PELogicBlendPanel));
            this.cmbLogicOp = new App.Controls.UIComboBox();
            this.lblLogicOp = new System.Windows.Forms.Label();
            this.SuspendLayout();
            //
            // cmbLogicOp
            //
            this.cmbLogicOp.AccessibleDescription = resources.GetString("cmbLogicOp.AccessibleDescription");
            this.cmbLogicOp.AccessibleName = resources.GetString("cmbLogicOp.AccessibleName");
            this.cmbLogicOp.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("cmbLogicOp.Anchor")));
            this.cmbLogicOp.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("cmbLogicOp.BackgroundImage")));
            this.cmbLogicOp.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("cmbLogicOp.Dock")));
            this.cmbLogicOp.Enabled = ((bool)(resources.GetObject("cmbLogicOp.Enabled")));
            this.cmbLogicOp.Font = ((System.Drawing.Font)(resources.GetObject("cmbLogicOp.Font")));
            this.cmbLogicOp.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("cmbLogicOp.ImeMode")));
            this.cmbLogicOp.IntegralHeight = ((bool)(resources.GetObject("cmbLogicOp.IntegralHeight")));
            this.cmbLogicOp.ItemHeight = ((int)(resources.GetObject("cmbLogicOp.ItemHeight")));
            this.cmbLogicOp.Location = ((System.Drawing.Point)(resources.GetObject("cmbLogicOp.Location")));
            this.cmbLogicOp.MaxDropDownItems = ((int)(resources.GetObject("cmbLogicOp.MaxDropDownItems")));
            this.cmbLogicOp.MaxLength = ((int)(resources.GetObject("cmbLogicOp.MaxLength")));
            this.cmbLogicOp.Name = "cmbLogicOp";
            this.cmbLogicOp.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("cmbLogicOp.RightToLeft")));
            this.cmbLogicOp.SelectedItemData = null;
            this.cmbLogicOp.Size = ((System.Drawing.Size)(resources.GetObject("cmbLogicOp.Size")));
            this.cmbLogicOp.TabIndex = ((int)(resources.GetObject("cmbLogicOp.TabIndex")));
            this.cmbLogicOp.Text = resources.GetString("cmbLogicOp.Text");
            this.cmbLogicOp.Visible = ((bool)(resources.GetObject("cmbLogicOp.Visible")));
            //
            // lblLogicOp
            //
            this.lblLogicOp.AccessibleDescription = resources.GetString("lblLogicOp.AccessibleDescription");
            this.lblLogicOp.AccessibleName = resources.GetString("lblLogicOp.AccessibleName");
            this.lblLogicOp.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("lblLogicOp.Anchor")));
            this.lblLogicOp.AutoSize = ((bool)(resources.GetObject("lblLogicOp.AutoSize")));
            this.lblLogicOp.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("lblLogicOp.Dock")));
            this.lblLogicOp.Enabled = ((bool)(resources.GetObject("lblLogicOp.Enabled")));
            this.lblLogicOp.Font = ((System.Drawing.Font)(resources.GetObject("lblLogicOp.Font")));
            this.lblLogicOp.Image = ((System.Drawing.Image)(resources.GetObject("lblLogicOp.Image")));
            this.lblLogicOp.ImageAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("lblLogicOp.ImageAlign")));
            this.lblLogicOp.ImageIndex = ((int)(resources.GetObject("lblLogicOp.ImageIndex")));
            this.lblLogicOp.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("lblLogicOp.ImeMode")));
            this.lblLogicOp.Location = ((System.Drawing.Point)(resources.GetObject("lblLogicOp.Location")));
            this.lblLogicOp.Name = "lblLogicOp";
            this.lblLogicOp.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("lblLogicOp.RightToLeft")));
            this.lblLogicOp.Size = ((System.Drawing.Size)(resources.GetObject("lblLogicOp.Size")));
            this.lblLogicOp.TabIndex = ((int)(resources.GetObject("lblLogicOp.TabIndex")));
            this.lblLogicOp.Text = resources.GetString("lblLogicOp.Text");
            this.lblLogicOp.TextAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("lblLogicOp.TextAlign")));
            this.lblLogicOp.Visible = ((bool)(resources.GetObject("lblLogicOp.Visible")));
            //
            // PELogicBlendPanel
            //
            this.AccessibleDescription = resources.GetString("$this.AccessibleDescription");
            this.AccessibleName = resources.GetString("$this.AccessibleName");
            this.AutoScroll = ((bool)(resources.GetObject("$this.AutoScroll")));
            this.AutoScrollMargin = ((System.Drawing.Size)(resources.GetObject("$this.AutoScrollMargin")));
            this.AutoScrollMinSize = ((System.Drawing.Size)(resources.GetObject("$this.AutoScrollMinSize")));
            this.BackColor = System.Drawing.Color.Honeydew;
            this.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("$this.BackgroundImage")));
            this.Controls.Add(this.lblLogicOp);
            this.Controls.Add(this.cmbLogicOp);
            this.Enabled = ((bool)(resources.GetObject("$this.Enabled")));
            this.Font = ((System.Drawing.Font)(resources.GetObject("$this.Font")));
            this.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("$this.ImeMode")));
            this.Location = ((System.Drawing.Point)(resources.GetObject("$this.Location")));
            this.Name = "PELogicBlendPanel";
            this.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("$this.RightToLeft")));
            this.Size = ((System.Drawing.Size)(resources.GetObject("$this.Size")));
            this.ResumeLayout(false);

        }
        #endregion

        // 参照データ
        private PEBlend _refData = null;

        /// <summary>データ変更イベント。</summary>
        public event EventHandler DataChanged = null;

        /// <summary>
        /// コンストラクタ。
        /// </summary>
        public PELogicBlendPanel()
        {
            InitializeComponent();
        }

        /// <summary>
        /// 参照データ。
        /// </summary>
        public PEBlend RefData
        {
            set { _refData = value; }
        }

        /// <summary>
        /// プロパティ初期化。
        /// </summary>
        public void InitializeProperty()
        {
            cmbLogicOp.AddItem("PROP_MAT_PE_LO_CLEAR",   AttrLogicOp.Clear, true);
            cmbLogicOp.AddItem("PROP_MAT_PE_LO_SET",     AttrLogicOp.Set, true);
            cmbLogicOp.AddItem("PROP_MAT_PE_LO_COPY",    AttrLogicOp.Copy, true);
            cmbLogicOp.AddItem("PROP_MAT_PE_LO_INVCOPY", AttrLogicOp.InvCopy, true);
            cmbLogicOp.AddItem("PROP_MAT_PE_LO_NOOP",    AttrLogicOp.Noop, true);
            cmbLogicOp.AddItem("PROP_MAT_PE_LO_INV",     AttrLogicOp.Inv, true);
            cmbLogicOp.AddItem("PROP_MAT_PE_LO_AND",     AttrLogicOp.And, true);
            cmbLogicOp.AddItem("PROP_MAT_PE_LO_NAND",    AttrLogicOp.Nand, true);
            cmbLogicOp.AddItem("PROP_MAT_PE_LO_OR",      AttrLogicOp.Or, true);
            cmbLogicOp.AddItem("PROP_MAT_PE_LO_NOR",     AttrLogicOp.Nor, true);
            cmbLogicOp.AddItem("PROP_MAT_PE_LO_XOR",     AttrLogicOp.Xor, true);
            cmbLogicOp.AddItem("PROP_MAT_PE_LO_EQUIV",   AttrLogicOp.Equiv, true);
            cmbLogicOp.AddItem("PROP_MAT_PE_LO_REVAND",  AttrLogicOp.RevAnd, true);
            cmbLogicOp.AddItem("PROP_MAT_PE_LO_INVAND",  AttrLogicOp.InvAnd, true);
            cmbLogicOp.AddItem("PROP_MAT_PE_LO_REVOR",   AttrLogicOp.RevOr, true);
            cmbLogicOp.AddItem("PROP_MAT_PE_LO_INVOR",   AttrLogicOp.InvOr, true);
            cmbLogicOp.SelectedIndexChanged += new EventHandler(Event_CmbLogicOp_SelectedIndexChanged);
        }

        /// <summary>
        /// プロパティ更新。
        /// </summary>
        public void UpdateProperty()
        {
            cmbLogicOp.SetSelectedItemData(_refData.LogicOp);
        }

        /// <summary>
        /// オーバーライド。
        /// </summary>
        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                if (components != null)
                {
                    components.Dispose();
                }
            }
            base.Dispose(disposing);
        }

        /// <summary>
        /// データ変更ハンドラ。
        /// </summary>
        private void OnDataChanged(EventArgs e)
        {
            if (this.DataChanged != null)
            {
                this.DataChanged(this, e);
            }
        }

        #region イベントハンドラ
        // logicOp
        private void Event_CmbLogicOp_SelectedIndexChanged(object sender, EventArgs e)
        {
            _refData.LogicOp = (AttrLogicOp)cmbLogicOp.SelectedItemData;
            OnDataChanged(EventArgs.Empty);
        }
        #endregion
    }
}
