﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Windows.Forms;

namespace  LayoutEditor.Forms.ToolWindows.PropertyEditWindow.PEControls
{
    using LayoutEditor.Forms.ToolWindows.PropertyEditWindow.Adapters ;
    using LECore.Structures.Nsrif.Attributes;
    using LECore.Structures;
    using App = LayoutEditor;

    /// <summary>
    /// ＰＥブレンド計算パネルクラス。
    /// </summary>
    public sealed class PECalcBlendPanel : UserControl
    {
        #region デザイナ変数

        private System.Windows.Forms.Label lblText1;
        private System.Windows.Forms.Label lblText6;
        private System.Windows.Forms.Label lblText2;
        private System.Windows.Forms.Label lblText5;
        private System.Windows.Forms.Label lblText4;
        private System.Windows.Forms.Label lblText3;
        private System.Windows.Forms.Label lblText0;
        private App.Controls.UIComboBox cmbSrcFactor;
        private App.Controls.UIComboBox cmbDstFactor;
        private System.ComponentModel.Container components = null;
        #endregion

        #region デザイナコード
        /// <summary>
        /// デザイナ サポートに必要なメソッドです。このメソッドの内容を
        /// コード エディタで変更しないでください。
        /// </summary>
        private void InitializeComponent()
        {
            System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(PECalcBlendPanel));
            this.lblText1 = new System.Windows.Forms.Label();
            this.lblText6 = new System.Windows.Forms.Label();
            this.lblText2 = new System.Windows.Forms.Label();
            this.cmbDstFactor = new App.Controls.UIComboBox();
            this.lblText5 = new System.Windows.Forms.Label();
            this.lblText4 = new System.Windows.Forms.Label();
            this.lblText3 = new System.Windows.Forms.Label();
            this.cmbSrcFactor = new App.Controls.UIComboBox();
            this.lblText0 = new System.Windows.Forms.Label();
            this.SuspendLayout();
            //
            // lblText1
            //
            this.lblText1.AccessibleDescription = resources.GetString("lblText1.AccessibleDescription");
            this.lblText1.AccessibleName = resources.GetString("lblText1.AccessibleName");
            this.lblText1.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("lblText1.Anchor")));
            this.lblText1.AutoSize = ((bool)(resources.GetObject("lblText1.AutoSize")));
            this.lblText1.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("lblText1.Dock")));
            this.lblText1.Enabled = ((bool)(resources.GetObject("lblText1.Enabled")));
            this.lblText1.Font = ((System.Drawing.Font)(resources.GetObject("lblText1.Font")));
            this.lblText1.Image = ((System.Drawing.Image)(resources.GetObject("lblText1.Image")));
            this.lblText1.ImageAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("lblText1.ImageAlign")));
            this.lblText1.ImageIndex = ((int)(resources.GetObject("lblText1.ImageIndex")));
            this.lblText1.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("lblText1.ImeMode")));
            this.lblText1.Location = ((System.Drawing.Point)(resources.GetObject("lblText1.Location")));
            this.lblText1.Name = "lblText1";
            this.lblText1.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("lblText1.RightToLeft")));
            this.lblText1.Size = ((System.Drawing.Size)(resources.GetObject("lblText1.Size")));
            this.lblText1.TabIndex = ((int)(resources.GetObject("lblText1.TabIndex")));
            this.lblText1.Text = resources.GetString("lblText1.Text");
            this.lblText1.TextAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("lblText1.TextAlign")));
            this.lblText1.Visible = ((bool)(resources.GetObject("lblText1.Visible")));
            //
            // lblText6
            //
            this.lblText6.AccessibleDescription = resources.GetString("lblText6.AccessibleDescription");
            this.lblText6.AccessibleName = resources.GetString("lblText6.AccessibleName");
            this.lblText6.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("lblText6.Anchor")));
            this.lblText6.AutoSize = ((bool)(resources.GetObject("lblText6.AutoSize")));
            this.lblText6.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("lblText6.Dock")));
            this.lblText6.Enabled = ((bool)(resources.GetObject("lblText6.Enabled")));
            this.lblText6.Font = ((System.Drawing.Font)(resources.GetObject("lblText6.Font")));
            this.lblText6.Image = ((System.Drawing.Image)(resources.GetObject("lblText6.Image")));
            this.lblText6.ImageAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("lblText6.ImageAlign")));
            this.lblText6.ImageIndex = ((int)(resources.GetObject("lblText6.ImageIndex")));
            this.lblText6.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("lblText6.ImeMode")));
            this.lblText6.Location = ((System.Drawing.Point)(resources.GetObject("lblText6.Location")));
            this.lblText6.Name = "lblText6";
            this.lblText6.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("lblText6.RightToLeft")));
            this.lblText6.Size = ((System.Drawing.Size)(resources.GetObject("lblText6.Size")));
            this.lblText6.TabIndex = ((int)(resources.GetObject("lblText6.TabIndex")));
            this.lblText6.Text = resources.GetString("lblText6.Text");
            this.lblText6.TextAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("lblText6.TextAlign")));
            this.lblText6.Visible = ((bool)(resources.GetObject("lblText6.Visible")));
            //
            // lblText2
            //
            this.lblText2.AccessibleDescription = resources.GetString("lblText2.AccessibleDescription");
            this.lblText2.AccessibleName = resources.GetString("lblText2.AccessibleName");
            this.lblText2.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("lblText2.Anchor")));
            this.lblText2.AutoSize = ((bool)(resources.GetObject("lblText2.AutoSize")));
            this.lblText2.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("lblText2.Dock")));
            this.lblText2.Enabled = ((bool)(resources.GetObject("lblText2.Enabled")));
            this.lblText2.Font = ((System.Drawing.Font)(resources.GetObject("lblText2.Font")));
            this.lblText2.Image = ((System.Drawing.Image)(resources.GetObject("lblText2.Image")));
            this.lblText2.ImageAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("lblText2.ImageAlign")));
            this.lblText2.ImageIndex = ((int)(resources.GetObject("lblText2.ImageIndex")));
            this.lblText2.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("lblText2.ImeMode")));
            this.lblText2.Location = ((System.Drawing.Point)(resources.GetObject("lblText2.Location")));
            this.lblText2.Name = "lblText2";
            this.lblText2.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("lblText2.RightToLeft")));
            this.lblText2.Size = ((System.Drawing.Size)(resources.GetObject("lblText2.Size")));
            this.lblText2.TabIndex = ((int)(resources.GetObject("lblText2.TabIndex")));
            this.lblText2.Text = resources.GetString("lblText2.Text");
            this.lblText2.TextAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("lblText2.TextAlign")));
            this.lblText2.Visible = ((bool)(resources.GetObject("lblText2.Visible")));
            //
            // cmbDstFactor
            //
            this.cmbDstFactor.AccessibleDescription = resources.GetString("cmbDstFactor.AccessibleDescription");
            this.cmbDstFactor.AccessibleName = resources.GetString("cmbDstFactor.AccessibleName");
            this.cmbDstFactor.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("cmbDstFactor.Anchor")));
            this.cmbDstFactor.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("cmbDstFactor.BackgroundImage")));
            this.cmbDstFactor.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("cmbDstFactor.Dock")));
            this.cmbDstFactor.Enabled = ((bool)(resources.GetObject("cmbDstFactor.Enabled")));
            this.cmbDstFactor.Font = ((System.Drawing.Font)(resources.GetObject("cmbDstFactor.Font")));
            this.cmbDstFactor.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("cmbDstFactor.ImeMode")));
            this.cmbDstFactor.IntegralHeight = ((bool)(resources.GetObject("cmbDstFactor.IntegralHeight")));
            this.cmbDstFactor.ItemHeight = ((int)(resources.GetObject("cmbDstFactor.ItemHeight")));
            this.cmbDstFactor.Location = ((System.Drawing.Point)(resources.GetObject("cmbDstFactor.Location")));
            this.cmbDstFactor.MaxDropDownItems = ((int)(resources.GetObject("cmbDstFactor.MaxDropDownItems")));
            this.cmbDstFactor.MaxLength = ((int)(resources.GetObject("cmbDstFactor.MaxLength")));
            this.cmbDstFactor.Name = "cmbDstFactor";
            this.cmbDstFactor.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("cmbDstFactor.RightToLeft")));
            this.cmbDstFactor.SelectedItemData = null;
            this.cmbDstFactor.Size = ((System.Drawing.Size)(resources.GetObject("cmbDstFactor.Size")));
            this.cmbDstFactor.TabIndex = ((int)(resources.GetObject("cmbDstFactor.TabIndex")));
            this.cmbDstFactor.Text = resources.GetString("cmbDstFactor.Text");
            this.cmbDstFactor.Visible = ((bool)(resources.GetObject("cmbDstFactor.Visible")));
            //
            // lblText5
            //
            this.lblText5.AccessibleDescription = resources.GetString("lblText5.AccessibleDescription");
            this.lblText5.AccessibleName = resources.GetString("lblText5.AccessibleName");
            this.lblText5.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("lblText5.Anchor")));
            this.lblText5.AutoSize = ((bool)(resources.GetObject("lblText5.AutoSize")));
            this.lblText5.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("lblText5.Dock")));
            this.lblText5.Enabled = ((bool)(resources.GetObject("lblText5.Enabled")));
            this.lblText5.Font = ((System.Drawing.Font)(resources.GetObject("lblText5.Font")));
            this.lblText5.Image = ((System.Drawing.Image)(resources.GetObject("lblText5.Image")));
            this.lblText5.ImageAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("lblText5.ImageAlign")));
            this.lblText5.ImageIndex = ((int)(resources.GetObject("lblText5.ImageIndex")));
            this.lblText5.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("lblText5.ImeMode")));
            this.lblText5.Location = ((System.Drawing.Point)(resources.GetObject("lblText5.Location")));
            this.lblText5.Name = "lblText5";
            this.lblText5.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("lblText5.RightToLeft")));
            this.lblText5.Size = ((System.Drawing.Size)(resources.GetObject("lblText5.Size")));
            this.lblText5.TabIndex = ((int)(resources.GetObject("lblText5.TabIndex")));
            this.lblText5.Text = resources.GetString("lblText5.Text");
            this.lblText5.TextAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("lblText5.TextAlign")));
            this.lblText5.Visible = ((bool)(resources.GetObject("lblText5.Visible")));
            //
            // lblText4
            //
            this.lblText4.AccessibleDescription = resources.GetString("lblText4.AccessibleDescription");
            this.lblText4.AccessibleName = resources.GetString("lblText4.AccessibleName");
            this.lblText4.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("lblText4.Anchor")));
            this.lblText4.AutoSize = ((bool)(resources.GetObject("lblText4.AutoSize")));
            this.lblText4.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("lblText4.Dock")));
            this.lblText4.Enabled = ((bool)(resources.GetObject("lblText4.Enabled")));
            this.lblText4.Font = ((System.Drawing.Font)(resources.GetObject("lblText4.Font")));
            this.lblText4.Image = ((System.Drawing.Image)(resources.GetObject("lblText4.Image")));
            this.lblText4.ImageAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("lblText4.ImageAlign")));
            this.lblText4.ImageIndex = ((int)(resources.GetObject("lblText4.ImageIndex")));
            this.lblText4.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("lblText4.ImeMode")));
            this.lblText4.Location = ((System.Drawing.Point)(resources.GetObject("lblText4.Location")));
            this.lblText4.Name = "lblText4";
            this.lblText4.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("lblText4.RightToLeft")));
            this.lblText4.Size = ((System.Drawing.Size)(resources.GetObject("lblText4.Size")));
            this.lblText4.TabIndex = ((int)(resources.GetObject("lblText4.TabIndex")));
            this.lblText4.Text = resources.GetString("lblText4.Text");
            this.lblText4.TextAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("lblText4.TextAlign")));
            this.lblText4.Visible = ((bool)(resources.GetObject("lblText4.Visible")));
            //
            // lblText3
            //
            this.lblText3.AccessibleDescription = resources.GetString("lblText3.AccessibleDescription");
            this.lblText3.AccessibleName = resources.GetString("lblText3.AccessibleName");
            this.lblText3.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("lblText3.Anchor")));
            this.lblText3.AutoSize = ((bool)(resources.GetObject("lblText3.AutoSize")));
            this.lblText3.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("lblText3.Dock")));
            this.lblText3.Enabled = ((bool)(resources.GetObject("lblText3.Enabled")));
            this.lblText3.Font = ((System.Drawing.Font)(resources.GetObject("lblText3.Font")));
            this.lblText3.Image = ((System.Drawing.Image)(resources.GetObject("lblText3.Image")));
            this.lblText3.ImageAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("lblText3.ImageAlign")));
            this.lblText3.ImageIndex = ((int)(resources.GetObject("lblText3.ImageIndex")));
            this.lblText3.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("lblText3.ImeMode")));
            this.lblText3.Location = ((System.Drawing.Point)(resources.GetObject("lblText3.Location")));
            this.lblText3.Name = "lblText3";
            this.lblText3.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("lblText3.RightToLeft")));
            this.lblText3.Size = ((System.Drawing.Size)(resources.GetObject("lblText3.Size")));
            this.lblText3.TabIndex = ((int)(resources.GetObject("lblText3.TabIndex")));
            this.lblText3.Text = resources.GetString("lblText3.Text");
            this.lblText3.TextAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("lblText3.TextAlign")));
            this.lblText3.Visible = ((bool)(resources.GetObject("lblText3.Visible")));
            //
            // cmbSrcFactor
            //
            this.cmbSrcFactor.AccessibleDescription = resources.GetString("cmbSrcFactor.AccessibleDescription");
            this.cmbSrcFactor.AccessibleName = resources.GetString("cmbSrcFactor.AccessibleName");
            this.cmbSrcFactor.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("cmbSrcFactor.Anchor")));
            this.cmbSrcFactor.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("cmbSrcFactor.BackgroundImage")));
            this.cmbSrcFactor.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("cmbSrcFactor.Dock")));
            this.cmbSrcFactor.Enabled = ((bool)(resources.GetObject("cmbSrcFactor.Enabled")));
            this.cmbSrcFactor.Font = ((System.Drawing.Font)(resources.GetObject("cmbSrcFactor.Font")));
            this.cmbSrcFactor.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("cmbSrcFactor.ImeMode")));
            this.cmbSrcFactor.IntegralHeight = ((bool)(resources.GetObject("cmbSrcFactor.IntegralHeight")));
            this.cmbSrcFactor.ItemHeight = ((int)(resources.GetObject("cmbSrcFactor.ItemHeight")));
            this.cmbSrcFactor.Location = ((System.Drawing.Point)(resources.GetObject("cmbSrcFactor.Location")));
            this.cmbSrcFactor.MaxDropDownItems = ((int)(resources.GetObject("cmbSrcFactor.MaxDropDownItems")));
            this.cmbSrcFactor.MaxLength = ((int)(resources.GetObject("cmbSrcFactor.MaxLength")));
            this.cmbSrcFactor.Name = "cmbSrcFactor";
            this.cmbSrcFactor.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("cmbSrcFactor.RightToLeft")));
            this.cmbSrcFactor.SelectedItemData = null;
            this.cmbSrcFactor.Size = ((System.Drawing.Size)(resources.GetObject("cmbSrcFactor.Size")));
            this.cmbSrcFactor.TabIndex = ((int)(resources.GetObject("cmbSrcFactor.TabIndex")));
            this.cmbSrcFactor.Text = resources.GetString("cmbSrcFactor.Text");
            this.cmbSrcFactor.Visible = ((bool)(resources.GetObject("cmbSrcFactor.Visible")));
            //
            // lblText0
            //
            this.lblText0.AccessibleDescription = resources.GetString("lblText0.AccessibleDescription");
            this.lblText0.AccessibleName = resources.GetString("lblText0.AccessibleName");
            this.lblText0.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("lblText0.Anchor")));
            this.lblText0.AutoSize = ((bool)(resources.GetObject("lblText0.AutoSize")));
            this.lblText0.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("lblText0.Dock")));
            this.lblText0.Enabled = ((bool)(resources.GetObject("lblText0.Enabled")));
            this.lblText0.Font = ((System.Drawing.Font)(resources.GetObject("lblText0.Font")));
            this.lblText0.Image = ((System.Drawing.Image)(resources.GetObject("lblText0.Image")));
            this.lblText0.ImageAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("lblText0.ImageAlign")));
            this.lblText0.ImageIndex = ((int)(resources.GetObject("lblText0.ImageIndex")));
            this.lblText0.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("lblText0.ImeMode")));
            this.lblText0.Location = ((System.Drawing.Point)(resources.GetObject("lblText0.Location")));
            this.lblText0.Name = "lblText0";
            this.lblText0.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("lblText0.RightToLeft")));
            this.lblText0.Size = ((System.Drawing.Size)(resources.GetObject("lblText0.Size")));
            this.lblText0.TabIndex = ((int)(resources.GetObject("lblText0.TabIndex")));
            this.lblText0.Text = resources.GetString("lblText0.Text");
            this.lblText0.TextAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("lblText0.TextAlign")));
            this.lblText0.Visible = ((bool)(resources.GetObject("lblText0.Visible")));
            //
            // PECalcBlendPanel
            //
            this.AccessibleDescription = resources.GetString("$this.AccessibleDescription");
            this.AccessibleName = resources.GetString("$this.AccessibleName");
            this.AutoScroll = ((bool)(resources.GetObject("$this.AutoScroll")));
            this.AutoScrollMargin = ((System.Drawing.Size)(resources.GetObject("$this.AutoScrollMargin")));
            this.AutoScrollMinSize = ((System.Drawing.Size)(resources.GetObject("$this.AutoScrollMinSize")));
            this.BackColor = System.Drawing.Color.AntiqueWhite;
            this.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("$this.BackgroundImage")));
            this.Controls.Add(this.lblText0);
            this.Controls.Add(this.lblText1);
            this.Controls.Add(this.lblText2);
            this.Controls.Add(this.cmbSrcFactor);
            this.Controls.Add(this.lblText3);
            this.Controls.Add(this.lblText4);
            this.Controls.Add(this.lblText5);
            this.Controls.Add(this.cmbDstFactor);
            this.Controls.Add(this.lblText6);
            this.Enabled = ((bool)(resources.GetObject("$this.Enabled")));
            this.Font = ((System.Drawing.Font)(resources.GetObject("$this.Font")));
            this.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("$this.ImeMode")));
            this.Location = ((System.Drawing.Point)(resources.GetObject("$this.Location")));
            this.Name = "PECalcBlendPanel";
            this.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("$this.RightToLeft")));
            this.Size = ((System.Drawing.Size)(resources.GetObject("$this.Size")));
            this.ResumeLayout(false);

        }
        #endregion

        // 参照データ
        private PEBlend _refData = null;

        /// <summary>データ変更イベント。</summary>
        public event EventHandler DataChanged = null;

        /// <summary>
        /// コンストラクタ。
        /// </summary>
        public PECalcBlendPanel()
        {
            InitializeComponent();
        }

        /// <summary>
        /// 参照データ。
        /// </summary>
        public PEBlend RefData
        {
            set { _refData = value; }
        }

        /// <summary>
        /// プロパティ初期化。
        /// </summary>
        public void InitializeProperty()
        {
            // srcFactor
            cmbSrcFactor.AddItem("PROP_MAT_PE_BF_ZERO",        AttrBlendFactor.V0, true);
            cmbSrcFactor.AddItem("PROP_MAT_PE_BF_ONE",         AttrBlendFactor.V1_0, true);
            cmbSrcFactor.AddItem("PROP_MAT_PE_BF_DSTCOLOR",    AttrBlendFactor.DstClr, true);
            cmbSrcFactor.AddItem("PROP_MAT_PE_BF_INVDSTCOLOR", AttrBlendFactor.InvDstClr, true);
            cmbSrcFactor.AddItem("PROP_MAT_PE_BF_SRCALPHA",    AttrBlendFactor.SrcAlpha, true);
            cmbSrcFactor.AddItem("PROP_MAT_PE_BF_INVSRCALPHA", AttrBlendFactor.InvSrcAlpha, true);
            cmbSrcFactor.AddItem("PROP_MAT_PE_BF_DSTALPHA",    AttrBlendFactor.DstAlpha, true);
            cmbSrcFactor.AddItem("PROP_MAT_PE_BF_INVDSTALPHA", AttrBlendFactor.InvDstAlpha, true);
            cmbSrcFactor.SelectedIndexChanged += new EventHandler(Event_CmbSrcFactor_SelectedIndexChanged);

            // dstFactor
            cmbDstFactor.AddItem("PROP_MAT_PE_BF_ZERO",        AttrBlendFactor.V0, true);
            cmbDstFactor.AddItem("PROP_MAT_PE_BF_ONE",         AttrBlendFactor.V1_0, true);
            cmbDstFactor.AddItem("PROP_MAT_PE_BF_SRCCOLOR",    AttrBlendFactor.DstClr, true);
            cmbDstFactor.AddItem("PROP_MAT_PE_BF_INVSRCCOLOR", AttrBlendFactor.InvDstClr, true);
            cmbDstFactor.AddItem("PROP_MAT_PE_BF_SRCALPHA",    AttrBlendFactor.SrcAlpha, true);
            cmbDstFactor.AddItem("PROP_MAT_PE_BF_INVSRCALPHA", AttrBlendFactor.InvSrcAlpha, true);
            cmbDstFactor.AddItem("PROP_MAT_PE_BF_DSTALPHA",    AttrBlendFactor.DstAlpha, true);
            cmbDstFactor.AddItem("PROP_MAT_PE_BF_INVDSTALPHA", AttrBlendFactor.InvDstAlpha, true);
            cmbDstFactor.SelectedIndexChanged += new EventHandler(Event_CmbDstFactor_SelectedIndexChanged);
        }

        /// <summary>
        /// プロパティ更新。
        /// </summary>
        public void UpdateProperty()
        {
            cmbSrcFactor.SetSelectedItemData(_refData.SrcFactor);
            cmbDstFactor.SetSelectedItemData(_refData.DstFactor);
        }

        /// <summary>
        /// オーバーライド。
        /// </summary>
        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                if (components != null)
                {
                    components.Dispose();
                }
            }
            base.Dispose(disposing);
        }

        /// <summary>
        /// データ変更ハンドラ。
        /// </summary>
        private void OnDataChanged(EventArgs e)
        {
            if (this.DataChanged != null)
            {
                this.DataChanged(this, e);
            }
        }

        #region イベントハンドラ
        // srcFactor
        private void Event_CmbSrcFactor_SelectedIndexChanged(object sender, EventArgs e)
        {
            _refData.SrcFactor = (AttrBlendFactor)cmbSrcFactor.SelectedItemData;
            OnDataChanged(EventArgs.Empty);
        }

        // dstFactor
        private void Event_CmbDstFactor_SelectedIndexChanged(object sender, EventArgs e)
        {
            _refData.DstFactor = (AttrBlendFactor)cmbDstFactor.SelectedItemData;
            OnDataChanged(EventArgs.Empty);
        }
        #endregion
    }
}
