﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Windows.Forms;
using System.Windows.Forms.Design;

using LECore.Util;

namespace LayoutEditor.Forms.ToolWindows.PropertyEditWindow
{
    /// <summary>
    /// マテリアルＴＥＶ自動マーククラス。
    /// </summary>
    [ToolboxBitmap(typeof(Control))]
    [Designer(typeof(MaterialTevAutoMark.CustomDesigner))]
    public sealed class MaterialTevAutoMark : Control
    {
        private static readonly Size _defaultSize = new Size(24, 14);

        /// <summary>
        /// コンストラクタ。
        /// </summary>
        public MaterialTevAutoMark()
        {
            this.SetStyle(ControlStyles.Opaque, true);
            this.SetStyle(ControlStyles.DoubleBuffer, true);
            this.SetStyle(ControlStyles.Selectable, false);

            this.Size    = _defaultSize;
            this.TabStop = false;
        }

        /// <summary>
        /// オーバーライド。
        /// </summary>
        protected override Size DefaultSize
        {
            get { return _defaultSize; }
        }

        /// <summary>
        /// オーバーライド。
        /// </summary>
        protected override void OnPaint(PaintEventArgs e)
        {
            Color baseColor = Color.LightPink;
            Color darkColor = ControlPaint.Dark(baseColor);

            // 背景
            e.Graphics.Clear(baseColor);

            // 枠
            using (Pen pen = new Pen(darkColor))
            {
                GraphicsUtil.DrawRectangle(e.Graphics, pen, this.ClientRectangle);
            }

            // テキスト
            using (StringFormat sf = new StringFormat())
            using (Brush brush = new SolidBrush(darkColor))
            {
                sf.Alignment     = StringAlignment.Center;
                sf.LineAlignment = StringAlignment.Center;

                e.Graphics.DrawString("TEV", this.Font, brush, this.ClientRectangle, sf);
            }
        }

        #region CustomDesigner
        /// <summary>
        /// カスタムデザイナクラス。
        /// </summary>
        internal class CustomDesigner : ControlDesigner
        {
            /// <summary>
            /// オーバーライド。
            /// </summary>
            protected override void PostFilterProperties(IDictionary properties)
            {
                properties.Remove("AllowDrop");
                properties.Remove("BackColor");
                properties.Remove("BackgroundImage");
                properties.Remove("CausesValidation");
                properties.Remove("Font");
                properties.Remove("ForeColor");
                properties.Remove("ImeMode");
                properties.Remove("RightToLeft");
                properties.Remove("Size");
                properties.Remove("TabIndex");
                properties.Remove("TabStop");
                properties.Remove("Text");

                base.PostFilterProperties(properties);
            }
        }
        #endregion
    }
}
