﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Windows.Forms;

namespace LayoutEditor.Forms.ToolWindows.PropertyEditWindow.FragmentOperationControls
{
    using LECore.Structures;
    using LECore.Structures.Nsrif.Attributes;

    public partial class FragmentOperationLogicBlendPanel : UserControl
    {
        // 参照データ
        private PEBlend _refData = null;

        /// <summary>データ変更イベント。</summary>
        public event EventHandler DataChanged = null;

        /// <summary>
        /// コンストラクタ。
        /// </summary>
        public FragmentOperationLogicBlendPanel()
        {
            InitializeComponent();
        }

        /// <summary>
        /// 参照データ。
        /// </summary>
        public PEBlend RefData
        {
            set { _refData = value; }
        }

        /// <summary>
        /// プロパティ初期化。
        /// </summary>
        public void InitializeProperty()
        {
            cmbLogicOp.Items.Clear();
            cmbLogicOp.AddItem("PROP_MAT_PE_LO_CLEAR",   AttrLogicOp.Clear, true);
            cmbLogicOp.AddItem("PROP_MAT_PE_LO_SET",     AttrLogicOp.Set, true);
            cmbLogicOp.AddItem("PROP_MAT_PE_LO_COPY",    AttrLogicOp.Copy, true);
            cmbLogicOp.AddItem("PROP_MAT_PE_LO_INVCOPY", AttrLogicOp.InvCopy, true);
            cmbLogicOp.AddItem("PROP_MAT_PE_LO_NOOP",    AttrLogicOp.Noop, true);
            cmbLogicOp.AddItem("PROP_MAT_PE_LO_INV",     AttrLogicOp.Inv, true);
            cmbLogicOp.AddItem("PROP_MAT_PE_LO_AND",     AttrLogicOp.And, true);
            cmbLogicOp.AddItem("PROP_MAT_PE_LO_NAND",    AttrLogicOp.Nand, true);
            cmbLogicOp.AddItem("PROP_MAT_PE_LO_OR",      AttrLogicOp.Or, true);
            cmbLogicOp.AddItem("PROP_MAT_PE_LO_NOR",     AttrLogicOp.Nor, true);
            cmbLogicOp.AddItem("PROP_MAT_PE_LO_XOR",     AttrLogicOp.Xor, true);
            cmbLogicOp.AddItem("PROP_MAT_PE_LO_EQUIV",   AttrLogicOp.Equiv, true);
            cmbLogicOp.AddItem("PROP_MAT_PE_LO_REVAND",  AttrLogicOp.RevAnd, true);
            cmbLogicOp.AddItem("PROP_MAT_PE_LO_INVAND",  AttrLogicOp.InvAnd, true);
            cmbLogicOp.AddItem("PROP_MAT_PE_LO_REVOR",   AttrLogicOp.RevOr, true);
            cmbLogicOp.AddItem("PROP_MAT_PE_LO_INVOR",   AttrLogicOp.InvOr, true);
            cmbLogicOp.SelectedIndexChanged += Event_CmbLogicOp_SelectedIndexChanged;
        }

        /// <summary>
        /// プロパティ更新。
        /// </summary>
        public void UpdateProperty()
        {
            cmbLogicOp.SetSelectedItemData(_refData.LogicOp);
        }

        /// <summary>
        /// データ変更ハンドラ。
        /// </summary>
        private void OnDataChanged(EventArgs e)
        {
            if (this.DataChanged != null)
            {
                this.DataChanged(this, e);
            }
        }

        #region イベントハンドラ
        // logicOp
        private void Event_CmbLogicOp_SelectedIndexChanged(object sender, EventArgs e)
        {
            _refData.LogicOp = (AttrLogicOp)cmbLogicOp.SelectedItemData;
            OnDataChanged(EventArgs.Empty);
        }
        #endregion
    }
}
