﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.Linq;
using System.Windows.Forms;
using System.IO;

namespace LayoutEditor.Forms.ToolWindows.PanePasteControlWindow
{
    using LECore.Structures;
    using LECore.Structures.Core;
    using LECore.Manipulator;
    using LECore.Save_Load;
    using SerializableAnmFmt = LECore.Structures.SerializableObject.Lan;
    using LayoutEditor.Utility;
    using LECore;


    /// <summary>
    /// PanePasteControlWindow の概要の説明です。
    /// </summary>
    public class PanePasteControlWindow :
        LEToolWindow
    {
        #region デザイナ生成コード

        private System.Windows.Forms.GroupBox _grpBase;
        private System.Windows.Forms.Button _btnPasetToSelectSet;
        private System.Windows.Forms.CheckBox _chkGroup;
        private System.Windows.Forms.CheckBox _chkHierarchy;
        private System.Windows.Forms.CheckBox _chkUserData;
        private System.Windows.Forms.CheckBox _chkUserComment;
        private System.Windows.Forms.CheckBox _chkRot;
        private System.Windows.Forms.CheckBox _chkSize;
        private System.Windows.Forms.CheckBox _chkPosition;
        private System.Windows.Forms.GroupBox _grpPicture;
        private System.Windows.Forms.CheckBox _chkPictTexCoord;
        private System.Windows.Forms.GroupBox _grpTextBox;
        private System.Windows.Forms.CheckBox _chkTextBoxStrBasePos;
        private System.Windows.Forms.CheckBox _chkTextBoxFontSize;
        private System.Windows.Forms.CheckBox _chkTextBoxContents;
        private System.Windows.Forms.CheckBox _chkTextBoxFont;
        private System.Windows.Forms.GroupBox _grpWindow;
        private System.Windows.Forms.CheckBox _chkWndFrame;
        private System.Windows.Forms.CheckBox _chkWndContentsArea;
        private System.Windows.Forms.GroupBox _grpMaterial;
        private System.Windows.Forms.CheckBox _chkMatDetails;
        private System.Windows.Forms.CheckBox _chkMatColorBlend;
        private System.Windows.Forms.CheckBox _chkMatTextures;
        private System.Windows.Forms.CheckBox _chkAnmRlmc;
        private System.Windows.Forms.CheckBox _chkAnmRlts;
        private System.Windows.Forms.CheckBox _chkAnmRltp;
        private System.Windows.Forms.CheckBox _chkAnmRlvc;
        private System.Windows.Forms.CheckBox _chkAnmRlvi;
        private System.Windows.Forms.CheckBox _chkAnmRlpa;
        private System.Windows.Forms.GroupBox _grpVec;
        private System.Windows.Forms.CheckBox _chkVecZ;
        private System.Windows.Forms.CheckBox _chkVecY;
        private System.Windows.Forms.CheckBox _chkVecX;
        private System.Windows.Forms.GroupBox _grpColor;
        private System.Windows.Forms.CheckBox _chkColB;
        private System.Windows.Forms.CheckBox _chkColG;
        private System.Windows.Forms.CheckBox _chkColR;
        private System.Windows.Forms.CheckBox _chkColA;
        private System.Windows.Forms.GroupBox _grpAnimation;
        private System.Windows.Forms.CheckBox _chkOverwriteDstAnim;
        private CheckBox _chkPaneBasicFlags;
        private CheckBox _chkTransparency;
        private CheckBox _chkTextBoxFontBlank;
        private CheckBox _chkScale;
        private CheckBox _chkUserDataEx;
        private Label _lblSource;
        private PictureBox _picSource;
        private Label _lblSourceTag;
        private CheckBox _chkBaseAll;
        private CheckBox _chkVecAll;
        private CheckBox _chkColAll;
        private CheckBox _chkAnimAll;
        private CheckBox _chkAll;
        private GroupBox _grpParts;
        private CheckBox _chkPartsAll;
        private CheckBox _chkTextBoxExt;
        private CheckBox _chkTextBoxShadow;
        private CheckBox _chkVtxAll;
        private CheckBox _chkPictVtxColor;
        private CheckBox _chkTextBoxFontColor;
        private GroupBox _grpVtxColor;
        private Label _lblVtxColNotice;
        private LayoutEditor.Controls.DockContentToolTip _ttpMain;
        private IContainer components;
        private CheckBox _chkAnmRlAlphaTest;
        private CheckBox _chkAnmRlIndirectTexture;
        private CheckBox _chkAnmEvalTimeOffset;
        private CheckBox _chkTextBoxPerCharTransform;
        private CheckBox _chkAnmRlud;
        private CheckBox _chkAnmWindow;
        private CheckBox _chkPictShapeType;
        private CheckBox _chkMask;
        private CheckBox _chkAnmRlma;
        private CheckBox _chkDropShadow;
        private CheckBox _chkAnmRlds;
        private CheckBox _chkPictProceduralShape;
        private CheckBox _chkAnmRlps;
        private System.Windows.Forms.Panel _pnlAll;

        private void InitializeComponent()
        {
            this.components = new System.ComponentModel.Container();
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(PanePasteControlWindow));
            this._grpBase = new System.Windows.Forms.GroupBox();
            this._chkDropShadow = new System.Windows.Forms.CheckBox();
            this._chkMask = new System.Windows.Forms.CheckBox();
            this._chkBaseAll = new System.Windows.Forms.CheckBox();
            this._chkUserDataEx = new System.Windows.Forms.CheckBox();
            this._chkScale = new System.Windows.Forms.CheckBox();
            this._chkPaneBasicFlags = new System.Windows.Forms.CheckBox();
            this._chkTransparency = new System.Windows.Forms.CheckBox();
            this._chkGroup = new System.Windows.Forms.CheckBox();
            this._chkHierarchy = new System.Windows.Forms.CheckBox();
            this._chkUserData = new System.Windows.Forms.CheckBox();
            this._chkUserComment = new System.Windows.Forms.CheckBox();
            this._chkRot = new System.Windows.Forms.CheckBox();
            this._chkSize = new System.Windows.Forms.CheckBox();
            this._chkPosition = new System.Windows.Forms.CheckBox();
            this._grpPicture = new System.Windows.Forms.GroupBox();
            this._chkPictProceduralShape = new System.Windows.Forms.CheckBox();
            this._chkPictShapeType = new System.Windows.Forms.CheckBox();
            this._chkPictTexCoord = new System.Windows.Forms.CheckBox();
            this._chkPictVtxColor = new System.Windows.Forms.CheckBox();
            this._grpTextBox = new System.Windows.Forms.GroupBox();
            this._chkTextBoxPerCharTransform = new System.Windows.Forms.CheckBox();
            this._chkTextBoxExt = new System.Windows.Forms.CheckBox();
            this._chkTextBoxShadow = new System.Windows.Forms.CheckBox();
            this._chkTextBoxFontBlank = new System.Windows.Forms.CheckBox();
            this._chkTextBoxFontColor = new System.Windows.Forms.CheckBox();
            this._chkTextBoxStrBasePos = new System.Windows.Forms.CheckBox();
            this._chkTextBoxFontSize = new System.Windows.Forms.CheckBox();
            this._chkTextBoxContents = new System.Windows.Forms.CheckBox();
            this._chkTextBoxFont = new System.Windows.Forms.CheckBox();
            this._grpWindow = new System.Windows.Forms.GroupBox();
            this._chkWndFrame = new System.Windows.Forms.CheckBox();
            this._chkWndContentsArea = new System.Windows.Forms.CheckBox();
            this._grpMaterial = new System.Windows.Forms.GroupBox();
            this._chkMatDetails = new System.Windows.Forms.CheckBox();
            this._chkMatColorBlend = new System.Windows.Forms.CheckBox();
            this._chkMatTextures = new System.Windows.Forms.CheckBox();
            this._chkVtxAll = new System.Windows.Forms.CheckBox();
            this._grpAnimation = new System.Windows.Forms.GroupBox();
            this._chkAnmRlps = new System.Windows.Forms.CheckBox();
            this._chkAnmRlds = new System.Windows.Forms.CheckBox();
            this._chkAnmRlma = new System.Windows.Forms.CheckBox();
            this._chkAnmWindow = new System.Windows.Forms.CheckBox();
            this._chkAnmRlud = new System.Windows.Forms.CheckBox();
            this._chkAnmEvalTimeOffset = new System.Windows.Forms.CheckBox();
            this._chkAnimAll = new System.Windows.Forms.CheckBox();
            this._chkAnmRlAlphaTest = new System.Windows.Forms.CheckBox();
            this._chkAnmRlmc = new System.Windows.Forms.CheckBox();
            this._chkAnmRlIndirectTexture = new System.Windows.Forms.CheckBox();
            this._chkAnmRlts = new System.Windows.Forms.CheckBox();
            this._chkAnmRltp = new System.Windows.Forms.CheckBox();
            this._chkAnmRlvc = new System.Windows.Forms.CheckBox();
            this._chkAnmRlvi = new System.Windows.Forms.CheckBox();
            this._chkAnmRlpa = new System.Windows.Forms.CheckBox();
            this._grpVec = new System.Windows.Forms.GroupBox();
            this._chkVecAll = new System.Windows.Forms.CheckBox();
            this._chkVecZ = new System.Windows.Forms.CheckBox();
            this._chkVecY = new System.Windows.Forms.CheckBox();
            this._chkVecX = new System.Windows.Forms.CheckBox();
            this._grpColor = new System.Windows.Forms.GroupBox();
            this._chkColAll = new System.Windows.Forms.CheckBox();
            this._chkColA = new System.Windows.Forms.CheckBox();
            this._chkColB = new System.Windows.Forms.CheckBox();
            this._chkColG = new System.Windows.Forms.CheckBox();
            this._chkColR = new System.Windows.Forms.CheckBox();
            this._btnPasetToSelectSet = new System.Windows.Forms.Button();
            this._pnlAll = new System.Windows.Forms.Panel();
            this._grpVtxColor = new System.Windows.Forms.GroupBox();
            this._lblVtxColNotice = new System.Windows.Forms.Label();
            this._grpParts = new System.Windows.Forms.GroupBox();
            this._chkPartsAll = new System.Windows.Forms.CheckBox();
            this._chkAll = new System.Windows.Forms.CheckBox();
            this._lblSourceTag = new System.Windows.Forms.Label();
            this._picSource = new System.Windows.Forms.PictureBox();
            this._lblSource = new System.Windows.Forms.Label();
            this._chkOverwriteDstAnim = new System.Windows.Forms.CheckBox();
            this._ttpMain = new LayoutEditor.Controls.DockContentToolTip(this.components);
            this._grpBase.SuspendLayout();
            this._grpPicture.SuspendLayout();
            this._grpTextBox.SuspendLayout();
            this._grpWindow.SuspendLayout();
            this._grpMaterial.SuspendLayout();
            this._grpAnimation.SuspendLayout();
            this._grpVec.SuspendLayout();
            this._grpColor.SuspendLayout();
            this._pnlAll.SuspendLayout();
            this._grpVtxColor.SuspendLayout();
            this._grpParts.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this._picSource)).BeginInit();
            this.SuspendLayout();
            //
            // _grpBase
            //
            this._grpBase.Controls.Add(this._chkDropShadow);
            this._grpBase.Controls.Add(this._chkMask);
            this._grpBase.Controls.Add(this._chkBaseAll);
            this._grpBase.Controls.Add(this._chkUserDataEx);
            this._grpBase.Controls.Add(this._chkScale);
            this._grpBase.Controls.Add(this._chkPaneBasicFlags);
            this._grpBase.Controls.Add(this._chkTransparency);
            this._grpBase.Controls.Add(this._chkGroup);
            this._grpBase.Controls.Add(this._chkHierarchy);
            this._grpBase.Controls.Add(this._chkUserData);
            this._grpBase.Controls.Add(this._chkUserComment);
            this._grpBase.Controls.Add(this._chkRot);
            this._grpBase.Controls.Add(this._chkSize);
            this._grpBase.Controls.Add(this._chkPosition);
            resources.ApplyResources(this._grpBase, "_grpBase");
            this._grpBase.Name = "_grpBase";
            this._grpBase.TabStop = false;
            //
            // _chkDropShadow
            //
            resources.ApplyResources(this._chkDropShadow, "_chkDropShadow");
            this._chkDropShadow.Name = "_chkDropShadow";
            this._chkDropShadow.CheckedChanged += new System.EventHandler(this.Event_ParamaterCheckBox_CheckedChanged);
            this._chkDropShadow.EnabledChanged += new System.EventHandler(this.Event_ParamaterCheckBox_EnabledChanged);
            //
            // _chkMask
            //
            resources.ApplyResources(this._chkMask, "_chkMask");
            this._chkMask.Name = "_chkMask";
            this._chkMask.CheckedChanged += new System.EventHandler(this.Event_ParamaterCheckBox_CheckedChanged);
            this._chkMask.EnabledChanged += new System.EventHandler(this.Event_ParamaterCheckBox_EnabledChanged);
            //
            // _chkBaseAll
            //
            resources.ApplyResources(this._chkBaseAll, "_chkBaseAll");
            this._chkBaseAll.Name = "_chkBaseAll";
            this._chkBaseAll.CheckedChanged += new System.EventHandler(this.Event_chkBaseAll_CheckedChanged);
            //
            // _chkUserDataEx
            //
            resources.ApplyResources(this._chkUserDataEx, "_chkUserDataEx");
            this._chkUserDataEx.Name = "_chkUserDataEx";
            this._chkUserDataEx.CheckedChanged += new System.EventHandler(this.Event_ParamaterCheckBox_CheckedChanged);
            this._chkUserDataEx.EnabledChanged += new System.EventHandler(this.Event_ParamaterCheckBox_EnabledChanged);
            //
            // _chkScale
            //
            resources.ApplyResources(this._chkScale, "_chkScale");
            this._chkScale.Name = "_chkScale";
            this._chkScale.CheckedChanged += new System.EventHandler(this.Event_ParamaterCheckBox_CheckedChanged);
            this._chkScale.EnabledChanged += new System.EventHandler(this.Event_ParamaterCheckBox_EnabledChanged);
            //
            // _chkPaneBasicFlags
            //
            resources.ApplyResources(this._chkPaneBasicFlags, "_chkPaneBasicFlags");
            this._chkPaneBasicFlags.Name = "_chkPaneBasicFlags";
            this._chkPaneBasicFlags.CheckedChanged += new System.EventHandler(this.Event_ParamaterCheckBox_CheckedChanged);
            this._chkPaneBasicFlags.EnabledChanged += new System.EventHandler(this.Event_ParamaterCheckBox_EnabledChanged);
            //
            // _chkTransparency
            //
            resources.ApplyResources(this._chkTransparency, "_chkTransparency");
            this._chkTransparency.Name = "_chkTransparency";
            this._chkTransparency.CheckedChanged += new System.EventHandler(this.Event_ParamaterCheckBox_CheckedChanged);
            this._chkTransparency.EnabledChanged += new System.EventHandler(this.Event_ParamaterCheckBox_EnabledChanged);
            //
            // _chkGroup
            //
            resources.ApplyResources(this._chkGroup, "_chkGroup");
            this._chkGroup.Name = "_chkGroup";
            this._chkGroup.CheckedChanged += new System.EventHandler(this.Event_ParamaterCheckBox_CheckedChanged);
            this._chkGroup.EnabledChanged += new System.EventHandler(this.Event_ParamaterCheckBox_EnabledChanged);
            //
            // _chkHierarchy
            //
            resources.ApplyResources(this._chkHierarchy, "_chkHierarchy");
            this._chkHierarchy.Name = "_chkHierarchy";
            this._chkHierarchy.CheckedChanged += new System.EventHandler(this.Event_ParamaterCheckBox_CheckedChanged);
            this._chkHierarchy.EnabledChanged += new System.EventHandler(this.Event_ParamaterCheckBox_EnabledChanged);
            //
            // _chkUserData
            //
            resources.ApplyResources(this._chkUserData, "_chkUserData");
            this._chkUserData.Name = "_chkUserData";
            this._chkUserData.CheckedChanged += new System.EventHandler(this.Event_ParamaterCheckBox_CheckedChanged);
            this._chkUserData.EnabledChanged += new System.EventHandler(this.Event_ParamaterCheckBox_EnabledChanged);
            //
            // _chkUserComment
            //
            resources.ApplyResources(this._chkUserComment, "_chkUserComment");
            this._chkUserComment.Name = "_chkUserComment";
            this._chkUserComment.CheckedChanged += new System.EventHandler(this.Event_ParamaterCheckBox_CheckedChanged);
            this._chkUserComment.EnabledChanged += new System.EventHandler(this.Event_ParamaterCheckBox_EnabledChanged);
            //
            // _chkRot
            //
            resources.ApplyResources(this._chkRot, "_chkRot");
            this._chkRot.Name = "_chkRot";
            this._chkRot.CheckedChanged += new System.EventHandler(this.Event_ParamaterCheckBox_CheckedChanged);
            this._chkRot.EnabledChanged += new System.EventHandler(this.Event_ParamaterCheckBox_EnabledChanged);
            //
            // _chkSize
            //
            resources.ApplyResources(this._chkSize, "_chkSize");
            this._chkSize.Name = "_chkSize";
            this._chkSize.CheckedChanged += new System.EventHandler(this.Event_ParamaterCheckBox_CheckedChanged);
            this._chkSize.EnabledChanged += new System.EventHandler(this.Event_ParamaterCheckBox_EnabledChanged);
            //
            // _chkPosition
            //
            resources.ApplyResources(this._chkPosition, "_chkPosition");
            this._chkPosition.Name = "_chkPosition";
            this._chkPosition.CheckedChanged += new System.EventHandler(this.Event_ParamaterCheckBox_CheckedChanged);
            this._chkPosition.EnabledChanged += new System.EventHandler(this.Event_ParamaterCheckBox_EnabledChanged);
            //
            // _grpPicture
            //
            this._grpPicture.Controls.Add(this._chkPictProceduralShape);
            this._grpPicture.Controls.Add(this._chkPictShapeType);
            this._grpPicture.Controls.Add(this._chkPictTexCoord);
            this._grpPicture.Controls.Add(this._chkPictVtxColor);
            resources.ApplyResources(this._grpPicture, "_grpPicture");
            this._grpPicture.Name = "_grpPicture";
            this._grpPicture.TabStop = false;
            //
            // _chkPictProceduralShape
            //
            resources.ApplyResources(this._chkPictProceduralShape, "_chkPictProceduralShape");
            this._chkPictProceduralShape.Name = "_chkPictProceduralShape";
            this._chkPictProceduralShape.CheckedChanged += new System.EventHandler(this.Event_ParamaterCheckBox_CheckedChanged);
            this._chkPictProceduralShape.EnabledChanged += new System.EventHandler(this.Event_ParamaterCheckBox_EnabledChanged);
            //
            // _chkPictShapeType
            //
            resources.ApplyResources(this._chkPictShapeType, "_chkPictShapeType");
            this._chkPictShapeType.Name = "_chkPictShapeType";
            this._chkPictShapeType.CheckedChanged += new System.EventHandler(this.Event_ParamaterCheckBox_CheckedChanged);
            this._chkPictShapeType.EnabledChanged += new System.EventHandler(this.Event_ParamaterCheckBox_EnabledChanged);
            //
            // _chkPictTexCoord
            //
            resources.ApplyResources(this._chkPictTexCoord, "_chkPictTexCoord");
            this._chkPictTexCoord.Name = "_chkPictTexCoord";
            this._chkPictTexCoord.CheckedChanged += new System.EventHandler(this.Event_ParamaterCheckBox_CheckedChanged);
            this._chkPictTexCoord.EnabledChanged += new System.EventHandler(this.Event_ParamaterCheckBox_EnabledChanged);
            //
            // _chkPictVtxColor
            //
            resources.ApplyResources(this._chkPictVtxColor, "_chkPictVtxColor");
            this._chkPictVtxColor.Name = "_chkPictVtxColor";
            this._chkPictVtxColor.CheckedChanged += new System.EventHandler(this.Event_ParamaterCheckBox_CheckedChanged);
            this._chkPictVtxColor.EnabledChanged += new System.EventHandler(this.Event_ParamaterCheckBox_EnabledChanged);
            //
            // _grpTextBox
            //
            this._grpTextBox.Controls.Add(this._chkTextBoxPerCharTransform);
            this._grpTextBox.Controls.Add(this._chkTextBoxExt);
            this._grpTextBox.Controls.Add(this._chkTextBoxShadow);
            this._grpTextBox.Controls.Add(this._chkTextBoxFontBlank);
            this._grpTextBox.Controls.Add(this._chkTextBoxFontColor);
            this._grpTextBox.Controls.Add(this._chkTextBoxStrBasePos);
            this._grpTextBox.Controls.Add(this._chkTextBoxFontSize);
            this._grpTextBox.Controls.Add(this._chkTextBoxContents);
            this._grpTextBox.Controls.Add(this._chkTextBoxFont);
            resources.ApplyResources(this._grpTextBox, "_grpTextBox");
            this._grpTextBox.Name = "_grpTextBox";
            this._grpTextBox.TabStop = false;
            //
            // _chkTextBoxPerCharTransform
            //
            resources.ApplyResources(this._chkTextBoxPerCharTransform, "_chkTextBoxPerCharTransform");
            this._chkTextBoxPerCharTransform.Name = "_chkTextBoxPerCharTransform";
            this._chkTextBoxPerCharTransform.CheckedChanged += new System.EventHandler(this.Event_ParamaterCheckBox_CheckedChanged);
            this._chkTextBoxPerCharTransform.EnabledChanged += new System.EventHandler(this.Event_ParamaterCheckBox_EnabledChanged);
            //
            // _chkTextBoxExt
            //
            resources.ApplyResources(this._chkTextBoxExt, "_chkTextBoxExt");
            this._chkTextBoxExt.Name = "_chkTextBoxExt";
            this._chkTextBoxExt.CheckedChanged += new System.EventHandler(this.Event_ParamaterCheckBox_CheckedChanged);
            this._chkTextBoxExt.EnabledChanged += new System.EventHandler(this.Event_ParamaterCheckBox_EnabledChanged);
            //
            // _chkTextBoxShadow
            //
            resources.ApplyResources(this._chkTextBoxShadow, "_chkTextBoxShadow");
            this._chkTextBoxShadow.Name = "_chkTextBoxShadow";
            this._chkTextBoxShadow.CheckedChanged += new System.EventHandler(this.Event_ParamaterCheckBox_CheckedChanged);
            this._chkTextBoxShadow.EnabledChanged += new System.EventHandler(this.Event_ParamaterCheckBox_EnabledChanged);
            //
            // _chkTextBoxFontBlank
            //
            resources.ApplyResources(this._chkTextBoxFontBlank, "_chkTextBoxFontBlank");
            this._chkTextBoxFontBlank.Name = "_chkTextBoxFontBlank";
            this._chkTextBoxFontBlank.CheckedChanged += new System.EventHandler(this.Event_ParamaterCheckBox_CheckedChanged);
            this._chkTextBoxFontBlank.EnabledChanged += new System.EventHandler(this.Event_ParamaterCheckBox_EnabledChanged);
            //
            // _chkTextBoxFontColor
            //
            resources.ApplyResources(this._chkTextBoxFontColor, "_chkTextBoxFontColor");
            this._chkTextBoxFontColor.Name = "_chkTextBoxFontColor";
            this._chkTextBoxFontColor.CheckedChanged += new System.EventHandler(this.Event_ParamaterCheckBox_CheckedChanged);
            this._chkTextBoxFontColor.EnabledChanged += new System.EventHandler(this.Event_ParamaterCheckBox_EnabledChanged);
            //
            // _chkTextBoxStrBasePos
            //
            resources.ApplyResources(this._chkTextBoxStrBasePos, "_chkTextBoxStrBasePos");
            this._chkTextBoxStrBasePos.Name = "_chkTextBoxStrBasePos";
            this._chkTextBoxStrBasePos.CheckedChanged += new System.EventHandler(this.Event_ParamaterCheckBox_CheckedChanged);
            this._chkTextBoxStrBasePos.EnabledChanged += new System.EventHandler(this.Event_ParamaterCheckBox_EnabledChanged);
            //
            // _chkTextBoxFontSize
            //
            resources.ApplyResources(this._chkTextBoxFontSize, "_chkTextBoxFontSize");
            this._chkTextBoxFontSize.Name = "_chkTextBoxFontSize";
            this._chkTextBoxFontSize.CheckedChanged += new System.EventHandler(this.Event_ParamaterCheckBox_CheckedChanged);
            this._chkTextBoxFontSize.EnabledChanged += new System.EventHandler(this.Event_ParamaterCheckBox_EnabledChanged);
            //
            // _chkTextBoxContents
            //
            resources.ApplyResources(this._chkTextBoxContents, "_chkTextBoxContents");
            this._chkTextBoxContents.Name = "_chkTextBoxContents";
            this._chkTextBoxContents.CheckedChanged += new System.EventHandler(this.Event_ParamaterCheckBox_CheckedChanged);
            this._chkTextBoxContents.EnabledChanged += new System.EventHandler(this.Event_ParamaterCheckBox_EnabledChanged);
            //
            // _chkTextBoxFont
            //
            resources.ApplyResources(this._chkTextBoxFont, "_chkTextBoxFont");
            this._chkTextBoxFont.Name = "_chkTextBoxFont";
            this._chkTextBoxFont.CheckedChanged += new System.EventHandler(this.Event_ParamaterCheckBox_CheckedChanged);
            this._chkTextBoxFont.EnabledChanged += new System.EventHandler(this.Event_ParamaterCheckBox_EnabledChanged);
            //
            // _grpWindow
            //
            this._grpWindow.Controls.Add(this._chkWndFrame);
            this._grpWindow.Controls.Add(this._chkWndContentsArea);
            resources.ApplyResources(this._grpWindow, "_grpWindow");
            this._grpWindow.Name = "_grpWindow";
            this._grpWindow.TabStop = false;
            //
            // _chkWndFrame
            //
            resources.ApplyResources(this._chkWndFrame, "_chkWndFrame");
            this._chkWndFrame.Name = "_chkWndFrame";
            this._chkWndFrame.CheckedChanged += new System.EventHandler(this.Event_ParamaterCheckBox_CheckedChanged);
            this._chkWndFrame.EnabledChanged += new System.EventHandler(this.Event_ParamaterCheckBox_EnabledChanged);
            //
            // _chkWndContentsArea
            //
            resources.ApplyResources(this._chkWndContentsArea, "_chkWndContentsArea");
            this._chkWndContentsArea.Name = "_chkWndContentsArea";
            this._chkWndContentsArea.CheckedChanged += new System.EventHandler(this.Event_ParamaterCheckBox_CheckedChanged);
            this._chkWndContentsArea.EnabledChanged += new System.EventHandler(this.Event_ParamaterCheckBox_EnabledChanged);
            //
            // _grpMaterial
            //
            this._grpMaterial.Controls.Add(this._chkMatDetails);
            this._grpMaterial.Controls.Add(this._chkMatColorBlend);
            this._grpMaterial.Controls.Add(this._chkMatTextures);
            resources.ApplyResources(this._grpMaterial, "_grpMaterial");
            this._grpMaterial.Name = "_grpMaterial";
            this._grpMaterial.TabStop = false;
            //
            // _chkMatDetails
            //
            resources.ApplyResources(this._chkMatDetails, "_chkMatDetails");
            this._chkMatDetails.Name = "_chkMatDetails";
            this._chkMatDetails.CheckedChanged += new System.EventHandler(this.Event_ParamaterCheckBox_CheckedChanged);
            this._chkMatDetails.EnabledChanged += new System.EventHandler(this.Event_ParamaterCheckBox_EnabledChanged);
            //
            // _chkMatColorBlend
            //
            resources.ApplyResources(this._chkMatColorBlend, "_chkMatColorBlend");
            this._chkMatColorBlend.Name = "_chkMatColorBlend";
            this._chkMatColorBlend.CheckedChanged += new System.EventHandler(this.Event_ParamaterCheckBox_CheckedChanged);
            this._chkMatColorBlend.EnabledChanged += new System.EventHandler(this.Event_ParamaterCheckBox_EnabledChanged);
            //
            // _chkMatTextures
            //
            resources.ApplyResources(this._chkMatTextures, "_chkMatTextures");
            this._chkMatTextures.Name = "_chkMatTextures";
            this._chkMatTextures.CheckedChanged += new System.EventHandler(this.Event_ParamaterCheckBox_CheckedChanged);
            this._chkMatTextures.EnabledChanged += new System.EventHandler(this.Event_ParamaterCheckBox_EnabledChanged);
            //
            // _chkVtxAll
            //
            resources.ApplyResources(this._chkVtxAll, "_chkVtxAll");
            this._chkVtxAll.Name = "_chkVtxAll";
            this._chkVtxAll.CheckedChanged += new System.EventHandler(this.Event_ParamaterCheckBox_CheckedChanged);
            this._chkVtxAll.EnabledChanged += new System.EventHandler(this.Event_ParamaterCheckBox_EnabledChanged);
            //
            // _grpAnimation
            //
            this._grpAnimation.Controls.Add(this._chkAnmRlps);
            this._grpAnimation.Controls.Add(this._chkAnmRlds);
            this._grpAnimation.Controls.Add(this._chkAnmRlma);
            this._grpAnimation.Controls.Add(this._chkAnmWindow);
            this._grpAnimation.Controls.Add(this._chkAnmRlud);
            this._grpAnimation.Controls.Add(this._chkAnmEvalTimeOffset);
            this._grpAnimation.Controls.Add(this._chkAnimAll);
            this._grpAnimation.Controls.Add(this._chkAnmRlAlphaTest);
            this._grpAnimation.Controls.Add(this._chkAnmRlmc);
            this._grpAnimation.Controls.Add(this._chkAnmRlIndirectTexture);
            this._grpAnimation.Controls.Add(this._chkAnmRlts);
            this._grpAnimation.Controls.Add(this._chkAnmRltp);
            this._grpAnimation.Controls.Add(this._chkAnmRlvc);
            this._grpAnimation.Controls.Add(this._chkAnmRlvi);
            this._grpAnimation.Controls.Add(this._chkAnmRlpa);
            resources.ApplyResources(this._grpAnimation, "_grpAnimation");
            this._grpAnimation.Name = "_grpAnimation";
            this._grpAnimation.TabStop = false;
            //
            // _chkAnmRlps
            //
            resources.ApplyResources(this._chkAnmRlps, "_chkAnmRlps");
            this._chkAnmRlps.Name = "_chkAnmRlps";
            this._chkAnmRlps.CheckedChanged += new System.EventHandler(this.Event_ParamaterCheckBox_CheckedChanged);
            this._chkAnmRlps.EnabledChanged += new System.EventHandler(this.Event_ParamaterCheckBox_EnabledChanged);
            //
            // _chkAnmRlds
            //
            resources.ApplyResources(this._chkAnmRlds, "_chkAnmRlds");
            this._chkAnmRlds.Name = "_chkAnmRlds";
            this._chkAnmRlds.CheckedChanged += new System.EventHandler(this.Event_ParamaterCheckBox_CheckedChanged);
            this._chkAnmRlds.EnabledChanged += new System.EventHandler(this.Event_ParamaterCheckBox_EnabledChanged);
            //
            // _chkAnmRlma
            //
            resources.ApplyResources(this._chkAnmRlma, "_chkAnmRlma");
            this._chkAnmRlma.Name = "_chkAnmRlma";
            this._chkAnmRlma.CheckedChanged += new System.EventHandler(this.Event_ParamaterCheckBox_CheckedChanged);
            this._chkAnmRlma.EnabledChanged += new System.EventHandler(this.Event_ParamaterCheckBox_EnabledChanged);
            //
            // _chkAnmWindow
            //
            resources.ApplyResources(this._chkAnmWindow, "_chkAnmWindow");
            this._chkAnmWindow.Name = "_chkAnmWindow";
            this._chkAnmWindow.CheckedChanged += new System.EventHandler(this.Event_ParamaterCheckBox_CheckedChanged);
            this._chkAnmWindow.EnabledChanged += new System.EventHandler(this.Event_ParamaterCheckBox_EnabledChanged);
            //
            // _chkAnmRlud
            //
            resources.ApplyResources(this._chkAnmRlud, "_chkAnmRlud");
            this._chkAnmRlud.Name = "_chkAnmRlud";
            this._chkAnmRlud.CheckedChanged += new System.EventHandler(this.Event_ParamaterCheckBox_CheckedChanged);
            this._chkAnmRlud.EnabledChanged += new System.EventHandler(this.Event_ParamaterCheckBox_EnabledChanged);
            //
            // _chkAnmEvalTimeOffset
            //
            resources.ApplyResources(this._chkAnmEvalTimeOffset, "_chkAnmEvalTimeOffset");
            this._chkAnmEvalTimeOffset.Name = "_chkAnmEvalTimeOffset";
            this._chkAnmEvalTimeOffset.CheckedChanged += new System.EventHandler(this.Event_ParamaterCheckBox_CheckedChanged);
            this._chkAnmEvalTimeOffset.EnabledChanged += new System.EventHandler(this.Event_ParamaterCheckBox_EnabledChanged);
            //
            // _chkAnimAll
            //
            resources.ApplyResources(this._chkAnimAll, "_chkAnimAll");
            this._chkAnimAll.Name = "_chkAnimAll";
            this._chkAnimAll.CheckedChanged += new System.EventHandler(this.Event_chkBaseAll_CheckedChanged);
            //
            // _chkAnmRlAlphaTest
            //
            resources.ApplyResources(this._chkAnmRlAlphaTest, "_chkAnmRlAlphaTest");
            this._chkAnmRlAlphaTest.Name = "_chkAnmRlAlphaTest";
            this._chkAnmRlAlphaTest.CheckedChanged += new System.EventHandler(this.Event_ParamaterCheckBox_CheckedChanged);
            this._chkAnmRlAlphaTest.EnabledChanged += new System.EventHandler(this.Event_ParamaterCheckBox_EnabledChanged);
            //
            // _chkAnmRlmc
            //
            resources.ApplyResources(this._chkAnmRlmc, "_chkAnmRlmc");
            this._chkAnmRlmc.Name = "_chkAnmRlmc";
            this._chkAnmRlmc.CheckedChanged += new System.EventHandler(this.Event_ParamaterCheckBox_CheckedChanged);
            this._chkAnmRlmc.EnabledChanged += new System.EventHandler(this.Event_ParamaterCheckBox_EnabledChanged);
            //
            // _chkAnmRlIndirectTexture
            //
            resources.ApplyResources(this._chkAnmRlIndirectTexture, "_chkAnmRlIndirectTexture");
            this._chkAnmRlIndirectTexture.Name = "_chkAnmRlIndirectTexture";
            this._chkAnmRlIndirectTexture.CheckedChanged += new System.EventHandler(this.Event_ParamaterCheckBox_CheckedChanged);
            this._chkAnmRlIndirectTexture.EnabledChanged += new System.EventHandler(this.Event_ParamaterCheckBox_EnabledChanged);
            //
            // _chkAnmRlts
            //
            resources.ApplyResources(this._chkAnmRlts, "_chkAnmRlts");
            this._chkAnmRlts.Name = "_chkAnmRlts";
            this._chkAnmRlts.CheckedChanged += new System.EventHandler(this.Event_ParamaterCheckBox_CheckedChanged);
            this._chkAnmRlts.EnabledChanged += new System.EventHandler(this.Event_ParamaterCheckBox_EnabledChanged);
            //
            // _chkAnmRltp
            //
            resources.ApplyResources(this._chkAnmRltp, "_chkAnmRltp");
            this._chkAnmRltp.Name = "_chkAnmRltp";
            this._chkAnmRltp.CheckedChanged += new System.EventHandler(this.Event_ParamaterCheckBox_CheckedChanged);
            this._chkAnmRltp.EnabledChanged += new System.EventHandler(this.Event_ParamaterCheckBox_EnabledChanged);
            //
            // _chkAnmRlvc
            //
            resources.ApplyResources(this._chkAnmRlvc, "_chkAnmRlvc");
            this._chkAnmRlvc.Name = "_chkAnmRlvc";
            this._chkAnmRlvc.CheckedChanged += new System.EventHandler(this.Event_ParamaterCheckBox_CheckedChanged);
            this._chkAnmRlvc.EnabledChanged += new System.EventHandler(this.Event_ParamaterCheckBox_EnabledChanged);
            //
            // _chkAnmRlvi
            //
            resources.ApplyResources(this._chkAnmRlvi, "_chkAnmRlvi");
            this._chkAnmRlvi.Name = "_chkAnmRlvi";
            this._chkAnmRlvi.CheckedChanged += new System.EventHandler(this.Event_ParamaterCheckBox_CheckedChanged);
            this._chkAnmRlvi.EnabledChanged += new System.EventHandler(this.Event_ParamaterCheckBox_EnabledChanged);
            //
            // _chkAnmRlpa
            //
            resources.ApplyResources(this._chkAnmRlpa, "_chkAnmRlpa");
            this._chkAnmRlpa.Name = "_chkAnmRlpa";
            this._chkAnmRlpa.CheckedChanged += new System.EventHandler(this.Event_ParamaterCheckBox_CheckedChanged);
            this._chkAnmRlpa.EnabledChanged += new System.EventHandler(this.Event_ParamaterCheckBox_EnabledChanged);
            //
            // _grpVec
            //
            this._grpVec.Controls.Add(this._chkVecAll);
            this._grpVec.Controls.Add(this._chkVecZ);
            this._grpVec.Controls.Add(this._chkVecY);
            this._grpVec.Controls.Add(this._chkVecX);
            resources.ApplyResources(this._grpVec, "_grpVec");
            this._grpVec.Name = "_grpVec";
            this._grpVec.TabStop = false;
            //
            // _chkVecAll
            //
            resources.ApplyResources(this._chkVecAll, "_chkVecAll");
            this._chkVecAll.Name = "_chkVecAll";
            this._chkVecAll.CheckedChanged += new System.EventHandler(this.Event_chkBaseAll_CheckedChanged);
            //
            // _chkVecZ
            //
            this._chkVecZ.Checked = true;
            this._chkVecZ.CheckState = System.Windows.Forms.CheckState.Checked;
            resources.ApplyResources(this._chkVecZ, "_chkVecZ");
            this._chkVecZ.Name = "_chkVecZ";
            this._chkVecZ.CheckedChanged += new System.EventHandler(this.Event_VectorElementCheckBox_CheckedChanged);
            this._chkVecZ.EnabledChanged += new System.EventHandler(this.Event_VectorElementCheckBox_CheckedChanged);
            //
            // _chkVecY
            //
            this._chkVecY.Checked = true;
            this._chkVecY.CheckState = System.Windows.Forms.CheckState.Checked;
            resources.ApplyResources(this._chkVecY, "_chkVecY");
            this._chkVecY.Name = "_chkVecY";
            this._chkVecY.CheckedChanged += new System.EventHandler(this.Event_VectorElementCheckBox_CheckedChanged);
            this._chkVecY.EnabledChanged += new System.EventHandler(this.Event_VectorElementCheckBox_CheckedChanged);
            //
            // _chkVecX
            //
            this._chkVecX.Checked = true;
            this._chkVecX.CheckState = System.Windows.Forms.CheckState.Checked;
            resources.ApplyResources(this._chkVecX, "_chkVecX");
            this._chkVecX.Name = "_chkVecX";
            this._chkVecX.CheckedChanged += new System.EventHandler(this.Event_VectorElementCheckBox_CheckedChanged);
            this._chkVecX.EnabledChanged += new System.EventHandler(this.Event_VectorElementCheckBox_CheckedChanged);
            //
            // _grpColor
            //
            this._grpColor.Controls.Add(this._chkColAll);
            this._grpColor.Controls.Add(this._chkColA);
            this._grpColor.Controls.Add(this._chkColB);
            this._grpColor.Controls.Add(this._chkColG);
            this._grpColor.Controls.Add(this._chkColR);
            resources.ApplyResources(this._grpColor, "_grpColor");
            this._grpColor.Name = "_grpColor";
            this._grpColor.TabStop = false;
            //
            // _chkColAll
            //
            resources.ApplyResources(this._chkColAll, "_chkColAll");
            this._chkColAll.Name = "_chkColAll";
            this._chkColAll.CheckedChanged += new System.EventHandler(this.Event_chkBaseAll_CheckedChanged);
            //
            // _chkColA
            //
            this._chkColA.Checked = true;
            this._chkColA.CheckState = System.Windows.Forms.CheckState.Checked;
            resources.ApplyResources(this._chkColA, "_chkColA");
            this._chkColA.Name = "_chkColA";
            this._chkColA.CheckedChanged += new System.EventHandler(this.Event_VectorElementCheckBox_CheckedChanged);
            this._chkColA.EnabledChanged += new System.EventHandler(this.Event_VectorElementCheckBox_CheckedChanged);
            //
            // _chkColB
            //
            this._chkColB.Checked = true;
            this._chkColB.CheckState = System.Windows.Forms.CheckState.Checked;
            resources.ApplyResources(this._chkColB, "_chkColB");
            this._chkColB.Name = "_chkColB";
            this._chkColB.CheckedChanged += new System.EventHandler(this.Event_VectorElementCheckBox_CheckedChanged);
            this._chkColB.EnabledChanged += new System.EventHandler(this.Event_VectorElementCheckBox_CheckedChanged);
            //
            // _chkColG
            //
            this._chkColG.Checked = true;
            this._chkColG.CheckState = System.Windows.Forms.CheckState.Checked;
            resources.ApplyResources(this._chkColG, "_chkColG");
            this._chkColG.Name = "_chkColG";
            this._chkColG.CheckedChanged += new System.EventHandler(this.Event_VectorElementCheckBox_CheckedChanged);
            this._chkColG.EnabledChanged += new System.EventHandler(this.Event_VectorElementCheckBox_CheckedChanged);
            //
            // _chkColR
            //
            this._chkColR.Checked = true;
            this._chkColR.CheckState = System.Windows.Forms.CheckState.Checked;
            resources.ApplyResources(this._chkColR, "_chkColR");
            this._chkColR.Name = "_chkColR";
            this._chkColR.CheckedChanged += new System.EventHandler(this.Event_VectorElementCheckBox_CheckedChanged);
            this._chkColR.EnabledChanged += new System.EventHandler(this.Event_VectorElementCheckBox_CheckedChanged);
            //
            // _btnPasetToSelectSet
            //
            resources.ApplyResources(this._btnPasetToSelectSet, "_btnPasetToSelectSet");
            this._btnPasetToSelectSet.Name = "_btnPasetToSelectSet";
            this._btnPasetToSelectSet.Click += new System.EventHandler(this.Event_BtnPasetToSelectSet_Click);
            //
            // _pnlAll
            //
            this._pnlAll.Controls.Add(this._grpVtxColor);
            this._pnlAll.Controls.Add(this._grpParts);
            this._pnlAll.Controls.Add(this._chkAll);
            this._pnlAll.Controls.Add(this._lblSourceTag);
            this._pnlAll.Controls.Add(this._picSource);
            this._pnlAll.Controls.Add(this._lblSource);
            this._pnlAll.Controls.Add(this._chkOverwriteDstAnim);
            this._pnlAll.Controls.Add(this._grpPicture);
            this._pnlAll.Controls.Add(this._grpVec);
            this._pnlAll.Controls.Add(this._grpColor);
            this._pnlAll.Controls.Add(this._grpWindow);
            this._pnlAll.Controls.Add(this._btnPasetToSelectSet);
            this._pnlAll.Controls.Add(this._grpTextBox);
            this._pnlAll.Controls.Add(this._grpMaterial);
            this._pnlAll.Controls.Add(this._grpAnimation);
            this._pnlAll.Controls.Add(this._grpBase);
            resources.ApplyResources(this._pnlAll, "_pnlAll");
            this._pnlAll.Name = "_pnlAll";
            //
            // _grpVtxColor
            //
            this._grpVtxColor.Controls.Add(this._lblVtxColNotice);
            this._grpVtxColor.Controls.Add(this._chkVtxAll);
            resources.ApplyResources(this._grpVtxColor, "_grpVtxColor");
            this._grpVtxColor.Name = "_grpVtxColor";
            this._grpVtxColor.TabStop = false;
            //
            // _lblVtxColNotice
            //
            this._lblVtxColNotice.BackColor = System.Drawing.SystemColors.Control;
            resources.ApplyResources(this._lblVtxColNotice, "_lblVtxColNotice");
            this._lblVtxColNotice.Name = "_lblVtxColNotice";
            this._ttpMain.SetToolTip(this._lblVtxColNotice, resources.GetString("_lblVtxColNotice.ToolTip"));
            //
            // _grpParts
            //
            this._grpParts.Controls.Add(this._chkPartsAll);
            resources.ApplyResources(this._grpParts, "_grpParts");
            this._grpParts.Name = "_grpParts";
            this._grpParts.TabStop = false;
            //
            // _chkPartsAll
            //
            resources.ApplyResources(this._chkPartsAll, "_chkPartsAll");
            this._chkPartsAll.Name = "_chkPartsAll";
            this._chkPartsAll.CheckedChanged += new System.EventHandler(this.Event_ParamaterCheckBox_CheckedChanged);
            this._chkPartsAll.EnabledChanged += new System.EventHandler(this.Event_ParamaterCheckBox_EnabledChanged);
            //
            // _chkAll
            //
            resources.ApplyResources(this._chkAll, "_chkAll");
            this._chkAll.Name = "_chkAll";
            this._chkAll.CheckedChanged += new System.EventHandler(this.Event_chkAll_CheckedChanged);
            //
            // _lblSourceTag
            //
            resources.ApplyResources(this._lblSourceTag, "_lblSourceTag");
            this._lblSourceTag.Name = "_lblSourceTag";
            //
            // _picSource
            //
            this._picSource.BackColor = System.Drawing.SystemColors.GradientInactiveCaption;
            resources.ApplyResources(this._picSource, "_picSource");
            this._picSource.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
            this._picSource.Name = "_picSource";
            this._picSource.TabStop = false;
            //
            // _lblSource
            //
            this._lblSource.BackColor = System.Drawing.SystemColors.GradientInactiveCaption;
            resources.ApplyResources(this._lblSource, "_lblSource");
            this._lblSource.Name = "_lblSource";
            //
            // _chkOverwriteDstAnim
            //
            resources.ApplyResources(this._chkOverwriteDstAnim, "_chkOverwriteDstAnim");
            this._chkOverwriteDstAnim.Name = "_chkOverwriteDstAnim";
            this._chkOverwriteDstAnim.CheckedChanged += new System.EventHandler(this.Event_ChkOverwriteDstAnim_CheckedChanged);
            //
            // PanePasteControlWindow
            //
            resources.ApplyResources(this, "$this");
            this.Controls.Add(this._pnlAll);
            this.Name = "PanePasteControlWindow";
            this.VisibleChanged += new System.EventHandler(this.Event_PanePasteControlWindow_VisibleChanged);
            this._grpBase.ResumeLayout(false);
            this._grpBase.PerformLayout();
            this._grpPicture.ResumeLayout(false);
            this._grpTextBox.ResumeLayout(false);
            this._grpWindow.ResumeLayout(false);
            this._grpMaterial.ResumeLayout(false);
            this._grpMaterial.PerformLayout();
            this._grpAnimation.ResumeLayout(false);
            this._grpAnimation.PerformLayout();
            this._grpVec.ResumeLayout(false);
            this._grpVec.PerformLayout();
            this._grpColor.ResumeLayout(false);
            this._grpColor.PerformLayout();
            this._pnlAll.ResumeLayout(false);
            this._pnlAll.PerformLayout();
            this._grpVtxColor.ResumeLayout(false);
            this._grpVtxColor.PerformLayout();
            this._grpParts.ResumeLayout(false);
            ((System.ComponentModel.ISupportInitialize)(this._picSource)).EndInit();
            this.ResumeLayout(false);

        }
        #endregion デザイナ生成コード

        #region フィールド
        IPane _srcPane = null;
        IPane[] _dstPaneSet = null;
        string _targetTagName = null;
        bool _isSrcPaneInAnimationSeparateMode = false;

        PaneParamaterCopyOption _paneParamaterCopyOption = new PaneParamaterCopyOption();
        #endregion フィールド

        #region プロパティ
        /// <summary>
        /// 貼り付け元ペインの情報
        /// </summary>
        IPane _SrcPane
        {
            get { return _srcPane; }
        }

        /// <summary>
        /// 貼り付け元ペインの区間タグ情報
        /// </summary>
        string _TargetTagName
        {
            get { return _targetTagName; }
            set { _targetTagName = value; }
        }

        /// <summary>
        /// クリップボードを取得します。
        /// </summary>
        ILEClipboard _ILEClipboard
        {
            get { return LECore.LayoutEditorCore.Scene.ILEClipboard; }
        }

        #endregion プロパティ


        /// <summary>
        /// コンストラクタ
        /// </summary>
        public PanePasteControlWindow()
        {
            InitializeComponent();
            InitializeProperty_();
        }

        /// <summary>
        /// ユーザ固有のGUI関連の初期化
        /// </summary>
        void InitializeProperty_()
        {

            // 基本
            // _chkBaseAll;
            _chkGroup.Tag = ParamaterKind.Group;
            _chkHierarchy.Tag = ParamaterKind.Hierarchy;
            _chkUserData.Tag = ParamaterKind.UserData;
            _chkUserComment.Tag = ParamaterKind.UserComment;
            _chkUserDataEx.Tag = ParamaterKind.UserDataEx;
            _chkRot.Tag = ParamaterKind.Rotate;
            _chkSize.Tag = ParamaterKind.Size;
            _chkScale.Tag = ParamaterKind.Scale;
            _chkPosition.Tag = ParamaterKind.Position;
            _chkTransparency.Tag = ParamaterKind.Transparency;
            _chkPaneBasicFlags.Tag = ParamaterKind.PaneBasicFlags;
            _chkMask.Tag = ParamaterKind.MaskAll;
            _chkDropShadow.Tag = ParamaterKind.DropShadowAll;

            // ピクチャー
            _chkPictTexCoord.Tag = ParamaterKind.TexCoords;
            _chkPictVtxColor.Tag = ParamaterKind.VtxColors;
            _chkPictShapeType.Tag = ParamaterKind.PictureShapeType;
            _chkPictProceduralShape.Tag = ParamaterKind.ProceduralShapeAll;

            // テキストボックス
            _chkTextBoxFontColor.Tag = ParamaterKind.FontColors;
            _chkTextBoxContents.Tag = ParamaterKind.ContentsText;
            _chkTextBoxFontSize.Tag = ParamaterKind.FontSize;
            _chkTextBoxFontBlank.Tag = ParamaterKind.FontBlank;
            _chkTextBoxStrBasePos.Tag = ParamaterKind.TextBasePosition;
            _chkTextBoxFont.Tag = ParamaterKind.FontFileName;
            _chkTextBoxShadow.Tag = ParamaterKind.TextShadow;
            _chkTextBoxPerCharTransform.Tag = ParamaterKind.PerCharTransform;
            _chkTextBoxExt.Tag = ParamaterKind.TextExtra;

            // ウインドウ
            _chkWndContentsArea.Tag = ParamaterKind.WindowContentsParamaters;
            _chkWndFrame.Tag = ParamaterKind.WindowFrame;

            // 部品全般
            _chkPartsAll.Tag = ParamaterKind.PartsAll;

            // マテリアル
            _chkMatDetails.Tag = ParamaterKind.Material_Details;
            _chkMatColorBlend.Tag = ParamaterKind.Material_ColorBlend;
            _chkMatTextures.Tag = ParamaterKind.Material_Textures;

            // アニメーション
            _chkAnmRlmc.Tag = ParamaterKind.Animation_MaterialColors | ParamaterKind.Animation_FontShadowColor;
            _chkAnmRlAlphaTest.Tag = ParamaterKind.Animation_AlphaTest;
            _chkAnmRlts.Tag = ParamaterKind.Animation_TextureSRT;
            _chkAnmEvalTimeOffset.Tag = ParamaterKind.Animation_PerCharacterTransform;

            _chkAnmRlIndirectTexture.Tag = ParamaterKind.Animation_IndirectTextureSRT;
            _chkAnmRltp.Tag = ParamaterKind.Animation_TexturePattern;
            _chkAnmRlvc.Tag = ParamaterKind.Animation_VertexColors;
            _chkAnmRlvi.Tag = ParamaterKind.Animation_Visivility;
            _chkAnmRlpa.Tag = ParamaterKind.Animation_PaneSRT;
            _chkAnmRlud.Tag = ParamaterKind.Animation_ExtUserData;
            _chkAnmRlma.Tag = ParamaterKind.Animation_MaskTextureSRT;
            _chkAnmRlds.Tag = ParamaterKind.Animation_DropShadow;
            _chkAnmRlps.Tag = ParamaterKind.Animation_ProceduralShape;
            _chkAnmRlIndirectTexture.Visible = LayoutEditorCore.PlatformDetail.IndirectTextureEnabled;

            _chkAnmWindow.Tag = ParamaterKind.Animation_Window;

            // ベクトル
            _chkVecZ.Tag = VectorElement.Z;
            _chkVecY.Tag = VectorElement.Y;
            _chkVecX.Tag = VectorElement.X;


            // カラー
            _chkColB.Tag = VectorElement.B;
            _chkColG.Tag = VectorElement.G;
            _chkColR.Tag = VectorElement.R;
            _chkColA.Tag = VectorElement.A;

            _chkVtxAll.Tag = ParamaterKind.AllVtxColor;

            // ダイアログで設定できない項目は無効にする
            _paneParamaterCopyOption.DisableOption( ParamaterKind.PictureEtc);
        }

        #region 貼り付け元ペインに対応したGUIの更新


        bool _SrcAndDstAreSamePaneKind
        {
            get
            {
                if( _SrcPane == null || _dstPaneSet == null || _dstPaneSet.Length == 0 )
                {
                    return false;
                }

                // 貼り付け対象が貼り付け元と同一種類ではないか、
                // 貼り付け対象が同一種類のグループではない場合は...
                bool bSamePaneKind =
                    _SrcPane.PaneKind == _dstPaneSet[0].PaneKind &&
                    PaneHelper.CheckPaneSetConsistOfSameKindPane( _dstPaneSet );

                return bSamePaneKind;
            }
        }

        void ResetPasetSourceInfo_()
        {
            // "設定されていません。\n選択ペインをコピー（Ctrl+C）して設定します。"
            _lblSource.Text = StringResMgr.Get("PASTE_SOURCE_NOT_NOT");
            _picSource.BackgroundImage = null;
        }

        /// <summary>
        /// すべてチェックチェックボックスの状態更新
        /// </summary>
        void UpdateCheckAllCheckBox_()
        {
            UpdateGroupBoxAllChecked_(_grpBase, _chkBaseAll);
            UpdateGroupBoxAllChecked_(_grpVec, _chkVecAll);
            UpdateGroupBoxAllChecked_(_grpColor, _chkColAll);
            UpdateGroupBoxAllChecked_(_grpAnimation, _chkAnimAll);
        }

        /// <summary>
        /// ピクチャペインの貼り付け制御チェックボックスの有効無効を設定する
        /// </summary>
        void UpdatePictureParameterCheckBoxEnabled_()
        {
            if (_SrcPane == null || _dstPaneSet == null || _SrcPane.IPicture == null)
            {
                return;
            }

            // 以下の条件で頂点カラーとテクスチャ座標が編集可能となる。
            // - 貼り付け元、貼り付け先どちらも通常形状の場合
            // - 貼り付け元が四角形で形状設定をコピーする設定になっている場合
            bool isNormalShape =
                _SrcPane.IPicture.ShapeType == LECore.Structures.SerializableObject.Lyt.ShapeType.NormalQuad &&
                (_dstPaneSet.All((dst) => (dst.IPicture != null) && (dst.IPicture.ShapeType == LECore.Structures.SerializableObject.Lyt.ShapeType.NormalQuad)) ||
                 _chkPictShapeType.Checked);

            _chkPictVtxColor.Enabled = isNormalShape;
            _chkPictTexCoord.Enabled = isNormalShape;
            _chkPictShapeType.Enabled = true;
        }

        void UpdatePropertyForSrcAndDst_( bool bDstAreSamePaneKind )
        {
            ISubScene subScene = LECore.LayoutEditorCore.Scene.CurrentISubScene;
            _chkOverwriteDstAnim.Checked = _paneParamaterCopyOption.OverwriteAnimation;

            bool isSeparateModeBaseValueEditable = subScene.IsAnimEditSeparateMode() && subScene.IsBaseValueEditable();
            if (_dstPaneSet == null || _dstPaneSet.Length == 0 || _dstPaneSet.Any((pane) => pane.IsReadOnlyLocked) || isSeparateModeBaseValueEditable)
            {
                if (_SrcPane == null)
                {
                    ResetPasetSourceInfo_();
                }

                _pnlAll.Enabled = false;
            }
            else
            {
                if( _SrcPane == null )
                {
                    _pnlAll.Enabled = false;
                    ResetPasetSourceInfo_();
                    return;
                }
                _pnlAll.Enabled = true;

                // 貼り付け元情報
                _lblSource.Text = string.Format("[ {0} ]", _SrcPane.PaneName, _SrcPane.PaneKind.ToString());
                _picSource.BackgroundImage = PaneItemImageHelper.GetPaneImage(_SrcPane.PaneKind, true);

                //-------------- チェック状態の更新
                // ベクトル要素の状態について更新します。
                UpdateGroupBoxChecked_VectorElement_( _grpVec );
                UpdateGroupBoxChecked_VectorElement_( _grpColor );
                　
                // パラメータ要素について
                UpdateGroupBoxChecked_ParamaterKind_( _grpBase );
                UpdateGroupBoxChecked_ParamaterKind_( _grpPicture );
                UpdateGroupBoxChecked_ParamaterKind_( _grpTextBox );
                UpdateGroupBoxChecked_ParamaterKind_( _grpWindow );
                UpdateGroupBoxChecked_ParamaterKind_( _grpParts );
                UpdateGroupBoxChecked_ParamaterKind_( _grpVtxColor );
                UpdateGroupBoxChecked_ParamaterKind_( _grpMaterial );
                UpdateGroupBoxChecked_ParamaterKind_( _grpAnimation );

                // すべてチェックチェックボックスの状態更新
                UpdateCheckAllCheckBox_();

                //-------------- 有効無効状態の更新
                _chkAnmRlpa.Enabled = PaneAnimationHelper.CheckPaneHasPaneAnmKey(_SrcPane, ParamaterKind.Animation_PaneSRT);
                _chkAnmRlvi.Enabled = PaneAnimationHelper.CheckPaneHasPaneAnmKey(_SrcPane, ParamaterKind.Animation_Visivility);
                _chkAnmRlvc.Enabled = PaneAnimationHelper.CheckPaneHasPaneAnmKey(_SrcPane, ParamaterKind.Animation_VertexColors);
                _chkAnmRlud.Enabled = PaneAnimationHelper.CheckPaneHasPaneAnmKey(_SrcPane, ParamaterKind.Animation_ExtUserData);
                _chkAnmWindow.Enabled = PaneAnimationHelper.CheckPaneHasPaneAnmKey(_SrcPane, ParamaterKind.Animation_Window);
                _chkAnmRlma.Enabled = PaneAnimationHelper.CheckPaneHasPaneAnmKey(_SrcPane, ParamaterKind.Animation_MaskTextureSRT);
                _chkAnmRlds.Enabled = PaneAnimationHelper.CheckPaneHasPaneAnmKey(_SrcPane, ParamaterKind.Animation_DropShadow);
                _chkAnmRlps.Enabled = PaneAnimationHelper.CheckPaneHasPaneAnmKey(_SrcPane, ParamaterKind.Animation_ProceduralShape);

                // ペインの種類に応じた パネル単位の 有効、無効の設定
                if (bDstAreSamePaneKind)
                {
                    _grpPicture.Enabled = _SrcPane.PaneKind == PaneKind.Picture;
                    _grpTextBox.Enabled = _SrcPane.PaneKind == PaneKind.Textbox;
                    _grpWindow.Enabled = _SrcPane.PaneKind == PaneKind.Window;
                    _grpParts.Enabled = _SrcPane.PaneKind == PaneKind.Parts;
                    _grpMaterial.Enabled = _SrcPane.IMaterial.Length != 0;

                    bool isSrcTextBoxPane = _SrcPane.PaneKind == PaneKind.Textbox;
                    bool isDestTextBoxPane = _dstPaneSet.All((dst) => dst.PaneKind == PaneKind.Textbox);
                    _chkMatTextures.Enabled = _grpMaterial.Enabled && !isSrcTextBoxPane && !isDestTextBoxPane;

                    _chkAnmRlts.Enabled =PaneAnimationHelper.CheckPaneHasPaneAnmKey(_SrcPane, ParamaterKind.Animation_TextureSRT);
                    _chkAnmEvalTimeOffset.Enabled = PaneAnimationHelper.CheckPaneHasPaneAnmKey(_SrcPane, ParamaterKind.Animation_PerCharacterTransform);
                    _chkAnmRlIndirectTexture.Enabled = PaneAnimationHelper.CheckPaneHasPaneAnmKey(_SrcPane, ParamaterKind.Animation_IndirectTextureSRT);
                    _chkAnmRltp.Enabled = PaneAnimationHelper.CheckPaneHasPaneAnmKey(_SrcPane, ParamaterKind.Animation_TexturePattern);

                    _chkAnmRlmc.Enabled =
                        PaneAnimationHelper.CheckPaneHasPaneAnmKey(_SrcPane, ParamaterKind.Animation_MaterialColors) |
                        PaneAnimationHelper.CheckPaneHasPaneAnmKey(_SrcPane, ParamaterKind.Animation_FontShadowColor);
                    _chkAnmRlAlphaTest.Enabled = PaneAnimationHelper.CheckPaneHasPaneAnmKey(_SrcPane, ParamaterKind.Animation_AlphaTest);

                    if (_SrcPane.PaneKind == PaneKind.Picture)
                    {
                        UpdatePictureParameterCheckBoxEnabled_();
                    }
                }
                else
                {
                    _grpPicture.Enabled = false;
                    _grpTextBox.Enabled = false;
                    _grpWindow.Enabled = false;
                    _grpParts.Enabled = false;

                    bool isSrcTextBoxPane = _SrcPane.PaneKind == PaneKind.Textbox;
                    bool isDestTextBoxPane = _dstPaneSet.All((dst) => dst.PaneKind == PaneKind.Textbox);

                    _chkAnmRlts.Enabled = !isDestTextBoxPane && PaneAnimationHelper.CheckPaneHasPaneAnmKey(_SrcPane, ParamaterKind.Animation_TextureSRT);
                    _chkAnmRltp.Enabled = !isDestTextBoxPane && PaneAnimationHelper.CheckPaneHasPaneAnmKey(_SrcPane, ParamaterKind.Animation_TexturePattern);

                    // src と dst がマテリアルを持つペインなら種類が別でもコピーを許可する。
                    bool srcMatOK = _SrcPane.PaneKind == PaneKind.Picture || _SrcPane.PaneKind == PaneKind.Window || _SrcPane.PaneKind == PaneKind.Textbox;
                    bool dstMatOK = _dstPaneSet.All((dst) => dst.PaneKind == PaneKind.Picture || dst.PaneKind == PaneKind.Window || dst.PaneKind == PaneKind.Textbox);

                    _chkAnmRlmc.Enabled = dstMatOK &&
                        PaneAnimationHelper.CheckPaneHasPaneAnmKey(_SrcPane, ParamaterKind.Animation_MaterialColors) |
                        PaneAnimationHelper.CheckPaneHasPaneAnmKey(_SrcPane, ParamaterKind.Animation_FontShadowColor);
                    _chkAnmRlAlphaTest.Enabled = dstMatOK &&
                        PaneAnimationHelper.CheckPaneHasPaneAnmKey(_SrcPane, ParamaterKind.Animation_AlphaTest);
                    _grpMaterial.Enabled = srcMatOK && dstMatOK;
                    _chkMatTextures.Enabled = _grpMaterial.Enabled && !isSrcTextBoxPane && !isDestTextBoxPane;
                }

                _grpVtxColor.Enabled = _SrcPane.IPaneExParamater is IVertexColor4Holder && _dstPaneSet.All((dst) => dst.IPaneExParamater is IVertexColor4Holder);

                // アニメーションすべてをチェックの有効無効
                _chkAnimAll.Enabled =
                    _chkAnmRlts.Enabled |
                    _chkAnmEvalTimeOffset.Enabled |
                    _chkAnmRlIndirectTexture.Enabled |
                    _chkAnmRltp.Enabled |
                    _chkAnmRlmc.Enabled |
                    _chkAnmRlAlphaTest.Enabled |
                    _chkAnmRlpa.Enabled |
                    _chkAnmRlvi.Enabled |
                    _chkAnmRlvc.Enabled |
                    _chkAnmRlud.Enabled |
                    _chkAnmRlma.Enabled |
                    _chkAnmRlds.Enabled |
                    _chkAnmRlps.Enabled |
                    _chkAnmWindow.Enabled;
            }

        }

        #endregion 貼り付け元ペインに対応したGUIの更新

        #region 貼り付け先ペインに対応したGUIの更新

        /// <summary>
        /// 同一ペイン種類のみ有効になる項目を設定します。
        /// </summary>
        void UpdateProperty_SetEnabledGUIForSamePaneKind_( bool bState )
        {
            _grpPicture.Enabled = bState;
            _grpTextBox.Enabled = bState;
            _grpWindow.Enabled = bState;
            _grpParts.Enabled = bState;
            _grpMaterial.Enabled = bState;

            _chkAnmRlmc.Enabled = bState;
            _chkAnmRlAlphaTest.Enabled = bState;
            _chkAnmRlvc.Enabled = bState;
            _chkAnmRltp.Enabled = bState;
            _chkAnmRlts.Enabled = bState;
            _chkAnmEvalTimeOffset.Enabled = bState;
            _chkAnmRlIndirectTexture.Enabled = bState;
            _chkAnmRlud.Enabled = bState;
            _chkAnmRlma.Enabled = bState;
            _chkAnmRlds.Enabled = bState;
            _chkAnmRlps.Enabled = bState;
            _chkAnmWindow.Enabled = bState;

        }

        /// <summary>
        /// グループボックス内の子チェックボックスについて
        /// チェックボックスのTag要素が対応する、
        /// ベクトル要素が有効に設定されているか判定し、状態を更新します。
        /// </summary>
        void UpdateGroupBoxChecked_VectorElement_( GroupBox gb )
        {
            foreach( Control ctrl in gb.Controls )
            {
                if( ctrl is CheckBox && ctrl.Tag is VectorElement )
                {
                    CheckBox cb = ctrl as CheckBox;
                    VectorElement kind = (VectorElement)cb.Tag;
                    cb.Checked = _paneParamaterCopyOption.IsVectorElementEnable( kind );
                }
            }
        }

        /// <summary>
        /// グループボックス内の子チェックボックスについて
        /// すべて同じチェック状態なら、allCheckBoxの状態を更新します。
        /// </summary>
        void UpdateGroupBoxAllChecked_(GroupBox gb, CheckBox allCheckBox)
        {
            bool? allState = null;
            foreach (Control ctrl in gb.Controls)
            {
                if (object.ReferenceEquals(ctrl, allCheckBox))
                {
                    continue;
                }

                if (ctrl is CheckBox && ctrl.Tag is VectorElement)
                {
                    CheckBox cb = ctrl as CheckBox;
                    if (allState == null)
                    {
                        allState = cb.Checked;
                    }

                    if (allState != cb.Checked)
                    {
                        // すべて同じチェック状態ではない。
                        return;
                    }
                }
            }

            if (allState != null)
            {
                allCheckBox.Checked = allState.Value;
            }
        }


        /// <summary>
        /// グループボックス内の子チェックボックスについて
        /// チェックボックスのTag要素が対応する、
        /// パラメータ要素が有効に設定されているか判定し、状態を更新します。
        /// </summary>
        void UpdateGroupBoxChecked_ParamaterKind_( GroupBox gb )
        {
            foreach( Control ctrl in gb.Controls )
            {
                if( ctrl is CheckBox && ctrl.Tag is ParamaterKind )
                {
                    CheckBox cb = ctrl as CheckBox;
                    ParamaterKind kind = (ParamaterKind)cb.Tag;
                    cb.Checked = _paneParamaterCopyOption.IsParamaterOptionEnable( kind );
                }
            }
        }
        #endregion 貼り付け先ペインに対応したGUIの更新

        /// <summary>
        /// GUIの更新
        /// </summary>
        public void UpdateProperty()
        {
            LEToolWindow.DbgReportUpdate( this );
            UpdatePropertyForSrcAndDst_( _SrcAndDstAreSamePaneKind );
        }

        /// <summary>
        /// 貼り付け元ペインの情報を更新します。
        /// </summary>
        void UpdateSrcPane_( SceneModifyEventArgs e )
        {
            ClipBoardPane clipBoardPane = e.Paramaters[0] as ClipBoardPane;

            // 単一ペインのみが貼り付けソースとして有効です。
            if( clipBoardPane != null &&
                clipBoardPane.PaneSet.Length == 1 )
            {
                // 本クラス用に完全な複製を作成します。
                IPane[] srcPaneSet =
                    PaneSetDupulicator.ClonePaneSet(
                    clipBoardPane.PaneSet,
                    PaneSetDupulicator.Option.CopyAll );
                Debug.Assert( srcPaneSet.Length == 1 );

                _srcPane = srcPaneSet[0];
                UpdatePropertyForSrcAndDst_(_SrcAndDstAreSamePaneKind);
                // OwnerSubScene をたどる必要があるので、clipBoardPane.PaneSet[0] を使います。
                _isSrcPaneInAnimationSeparateMode = PaneHelper.IsInSeparateMode(clipBoardPane.PaneSet[0]);

                _TargetTagName = LECore.LayoutEditorCore.Scene.CurrentISubScene?.CurrentTagName ?? String.Empty;
            }
            else
            {
                _srcPane = null;
                UpdatePropertyForSrcAndDst_(_SrcAndDstAreSamePaneKind);
                _isSrcPaneInAnimationSeparateMode = false;

                _targetTagName = null;
            }
        }

        /// <summary>
        /// キャプチャテクスチャを使用しているデータが存在する場合、貼り付け先にデータをコピー可能かどうかをチェックします。
        /// </summary>
        /// <returns></returns>
        IPane CheckPasteCaptureTextureCondition()
        {
            foreach (var mat in _SrcPane.IMaterial)
            {
                foreach (var texMap in mat.IMaterialTexMapSet.EnumerateCaptureRelatedTexMap())
                {
                    // コピー元はルートのサブシーンのみ対象となるため CurrentISubScene に属するテクスチャマネージャから探す。
                    if (SubSceneHelper.FindCaptureTextureRecursively(LECore.LayoutEditorCore.Scene.CurrentISubScene, texMap.TexImgName) != null)
                    {
                        // キャプチャテクスチャを使用しているマテリアルが確定
                        // 貼り付け先の親階層にキャプチャしている、キャプチャテクスチャを使用しているペインが存在しないかチェックする。
                        foreach (IPane dstPane in _dstPaneSet)
                        {
                            IPane capturedPane = PaneHelper.CheckHaveCapturedPaneInParentTree(dstPane);
                            if (capturedPane != null)
                            {
                                return capturedPane;
                            }
                        }
                    }
                }
            }

            return null;
        }

        #region LEToolWindow メンバ オーバーライド

        /// <summary>
        /// シーン更新イベントハンドラ
        /// </summary>
        public override void OnSceneModifyHandler(
            object sender,
            SceneModifyEventArgs e )
        {
            switch( e.Target )
            {
                case SceneModifyEventArgs.Kind.ClipBoardModify:
                    // クリップボードの更新
                    // 貼り付け元データを更新します。
                    UpdateSrcPane_(e);

                    // クリップボードが更新されたら貼り付けボタンを更新する
                    _btnPasetToSelectSet.Enabled = _ReadyForPaste;

                    // 貼り付け先(貼り付け方法)に関するGUIの更新をおこないます。
                    if (Visible)
                    {
                        UpdatePropertyForSrcAndDst_(_SrcAndDstAreSamePaneKind);
                    }
                    break;
                case SceneModifyEventArgs.Kind.SelectedSetModify:
                    // 選択セットの変更
                    // 貼り付け先データを更新します。
                    _dstPaneSet = e.Paramaters[0] as IPane[];
                    _btnPasetToSelectSet.Enabled = _ReadyForPaste;

                    // 貼り付け先(貼り付け方法)に関するGUIの更新をおこないます。
                    if (Visible)
                    {
                        UpdatePropertyForSrcAndDst_(_SrcAndDstAreSamePaneKind);
                    }
                    break;
            }
            base.OnSceneModifyHandler( sender, e );
        }

        public override Keys CustomShortcut { get { return Keys.F11; } }
        #endregion LEToolWindow メンバ オーバーライド

        #region GUI イベントハンドラ

        /// <summary>
        /// 可視状態変化ハンドラ
        /// </summary>
        private void Event_PanePasteControlWindow_VisibleChanged( object sender, System.EventArgs e )
        {
            if( this.Visible )
            {
                UpdateProperty();
            }
        }

        /// <summary>
        /// 貼り付け準備が整っているか取得します。
        /// </summary>
        bool _ReadyForPaste
        {
            get
            {
                return
                    _dstPaneSet != null && _dstPaneSet.Length != 0 &&
                    _SrcPane != null &&
                    PaneHelper.CheckPanesInSameAnimationSeparateMode(_isSrcPaneInAnimationSeparateMode, _dstPaneSet);
            }
        }

        /// <summary>
        /// 貼り付けボタン
        /// </summary>
        private void Event_BtnPasetToSelectSet_Click( object sender, System.EventArgs e )
        {
            if( _ReadyForPaste )
            {
                PaneParamaterCopyOption tmpOption = new PaneParamaterCopyOption(_paneParamaterCopyOption);
                tmpOption.EnableCopyAnimTargetTagOnly(_TargetTagName);

                PaneManipulator paneMnp = new PaneManipulator();
                LECore.LayoutEditorCore.Scene.CurrentISubScene.BeginMassiveModify();

                // テクスチャを張り付ける場合はコピー元のキャプチャテクスチャがコピー可能かどうかをチェックする。
                if (_paneParamaterCopyOption.IsParamaterOptionEnable(ParamaterKind.Material_Textures))
                {
                    IPane preventCopyPane = CheckPasteCaptureTextureCondition();

                    if (preventCopyPane != null)
                    {
                        string msg = StringResMgr.Get("PROP_MAT_TEX_MSG_COPY_MATERIAL_TEXTURE_FAILED_BECAUSE_CAPTURE_TEXTURE_IN_PARENT_TREE", preventCopyPane.PaneName);
                        MessageBox.Show(this, msg, LayoutEditor.StringResMgr.Get("PROP_MAT_CATEGORY_TEXTURE"), MessageBoxButtons.OK);
                        return;
                    }
                }

                foreach( IPane dstPane in _dstPaneSet )
                {
                    paneMnp.BindTarget( dstPane );
                    paneMnp.Copy( _SrcPane, tmpOption );
                    ProcessAfterPasting(dstPane);
                }
                LECore.LayoutEditorCore.Scene.CurrentISubScene.EndMassiveModify();
            }
            else
            {
                // コピー可能なときしか押せないはず。
                Debug.Assert( false );
            }
        }

        /// <summary>
        /// ペースト後の処理
        /// </summary>
        void ProcessAfterPasting(IPane dstPane)
        {
            // マスク用のキャプチャテクスチャを作成します。
            if (dstPane.IMask.IsMaskEnabled)
            {
                MaskManipulator maskMpn = new MaskManipulator();
                maskMpn.BindTarget(dstPane.IMask);
                maskMpn.CreateCaptureTextureForMask(dstPane, dstPane.OwnerSubScene.ITextureMgr);
            }
            // ドロップシャドウ用のキャプチャテクスチャを作成します。
            if (dstPane.IDropShadow.IsDropShadowEtcEnabled)
            {
                DropShadowManipulator dropShadowMpn = new DropShadowManipulator();
                dropShadowMpn.BindTarget(dstPane.IDropShadow);
                dropShadowMpn.CreateCaptureTextureForDropShadow(dstPane, dstPane.OwnerSubScene.ITextureMgr);
            }
        }

        /// <summary>
        /// チェックボックス,チェック状態変更
        /// </summary>
        private void Event_ParamaterCheckBox_CheckedChanged( object sender, System.EventArgs e )
        {
            Debug.Assert( sender is CheckBox );

            CheckBox cb = sender as CheckBox;
            ParamaterKind kindFlag = (ParamaterKind)cb.Tag;

            if (kindFlag == ParamaterKind.PictureShapeType)
            {
                UpdatePictureParameterCheckBoxEnabled_();
            }

            _paneParamaterCopyOption.SetOption( kindFlag, cb.Checked && cb.Enabled );

            if( _paneParamaterCopyOption.RepairInvalidState() )
            {
                UpdateProperty();
            }
        }

        /// <summary>
        /// チェックボックス、有効状態変更
        /// </summary>
        private void Event_ParamaterCheckBox_EnabledChanged( object sender, System.EventArgs e )
        {
            Debug.Assert( sender is CheckBox );

            CheckBox cb = sender as CheckBox;
            ParamaterKind kindFlag = (ParamaterKind)cb.Tag;

            _paneParamaterCopyOption.SetOption( kindFlag, cb.Checked && cb.Enabled );

            if( _paneParamaterCopyOption.RepairInvalidState() )
            {
                UpdateProperty();
            }
        }

        /// <summary>
        /// チェックボックス変更
        /// </summary>
        private void Event_VectorElementCheckBox_CheckedChanged( object sender, System.EventArgs e )
        {
            Debug.Assert( sender is CheckBox );

            CheckBox cb = sender as CheckBox;
            VectorElement kindFlag = (VectorElement)cb.Tag;

            _paneParamaterCopyOption.SetVectorElementOption( kindFlag, cb.Checked && cb.Enabled );

            UpdateCheckAllCheckBox_();
        }



        #region すべてをチェック
        /// <summary>
        /// チェックボックスを更新
        /// </summary>
        void CheckGroupBrotherCheckBoxAll_( GroupBox parent, bool bFlag )
        {
            // 親のグループボックス内の
            foreach( Control child in parent.Controls )
            {
                // 自分自身以外の、すべてのチェックボックスについて...
                if( child is CheckBox )
                {
                    if (child.Enabled)
                    {
                        CheckBox childCheckBox = child as CheckBox;
                        // 自分の Checked を設定します。
                        childCheckBox.Checked = bFlag;
                    }
                }
            }
        }

        /// <summary>
        /// すべてをチェック
        /// </summary>
        private void Event_chkBaseAll_CheckedChanged(object sender, EventArgs e)
        {
            CheckBox chk = sender as CheckBox;
            if (chk != null && chk.Parent is GroupBox)
            {
                CheckGroupBrotherCheckBoxAll_(chk.Parent as GroupBox, chk.Checked);
            }
        }

        /// <summary>
        /// すべてをチェック(全体)
        /// </summary>
        private void Event_chkAll_CheckedChanged(object sender, EventArgs e)
        {
            CheckBox chk = sender as CheckBox;
            if (chk != null)
            {
                CheckGroupBrotherCheckBoxAll_(_grpBase, chk.Checked);
                CheckGroupBrotherCheckBoxAll_(_grpPicture, chk.Checked);
                CheckGroupBrotherCheckBoxAll_(_grpTextBox, chk.Checked);
                CheckGroupBrotherCheckBoxAll_(_grpWindow, chk.Checked);
                CheckGroupBrotherCheckBoxAll_(_grpParts, chk.Checked);

                CheckGroupBrotherCheckBoxAll_(_grpMaterial, chk.Checked);

                CheckGroupBrotherCheckBoxAll_(_grpVec, chk.Checked);
                CheckGroupBrotherCheckBoxAll_(_grpColor, chk.Checked);

                CheckGroupBrotherCheckBoxAll_(_grpAnimation, chk.Checked);
            }
        }

        #endregion すべてをチェック

        /// <summary>
        /// 貼り付け先のアニメーションを上書きする。
        /// </summary>
        private void Event_ChkOverwriteDstAnim_CheckedChanged( object sender, System.EventArgs e )
        {
            _paneParamaterCopyOption.OverwriteAnimation = _chkOverwriteDstAnim.Checked;
        }

        #endregion GUI イベントハンドラ
    }
}
