﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using LayoutEditor.Structures.SerializableObject;

namespace LayoutEditor.Forms.ToolWindows.LayoutSettingWindow
{
    public partial class UserDataPage : LayoutSettingPage
    {
        public UserDataPage()
        {
            InitializeComponent();
        }

        internal override void UpdateProperty()
        {
            var subScene = LECore.LayoutEditorCore.Scene.CurrentISubScene;
            if (subScene == null)
            {
                this.Enabled = false;
                return;
            }
            else
            {
                this.Enabled = true;
            }

            IEnumerable<ExUserDataPreset> presets = OwnerToolWindow.ViewManager != null ? OwnerToolWindow.ViewManager.AppSetting.ProjectSettings.ExUserDataPresets : new List<ExUserDataPreset>();
            userDataPanel.Initialize(subScene.IUserDataHolder, false, false, false, presets, preset => preset.IsTargetSubScene());
            userDataPanel.UpdateProperty();
        }
    }
}
