﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections;
using System.Linq;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Diagnostics;
using System.Windows.Forms;
using System.Text.RegularExpressions;
using System.Text;
using System.Xml.Serialization;
using System.IO;
using System.Threading;
using System.Globalization;

namespace LayoutEditor.Forms.ToolWindows.CurveEditWindow
{
    using LECore;
    using LECore.Structures;
    using LECore.Structures.Core;
    using LECore.Structures.Core.Command;
    using LECore.Manipulator;
    using LECore.Save_Load;
    using LECore.Util;

    using LayoutEditor.Structures.SerializableObject;

    using TimiControlWindow;
    using common;
    using Controls;

    using ArrowKeySpeed = GraphView.GraphViewMouseState.ArrowKeySpeed;
    using LayoutEditor.Utility;

    /// <summary>
    /// CurveEditorControl の概要の説明です。
    /// </summary>
    public class CurveEditWindow :
        LEToolWindow
    {

        #region ---------------- フィールド：コントロール ----------------

        private TreeView _tvwTargetAttr;
        private GraphView _ctlGraphView;
        private ToolStrip _tspCurveEditor;
        private ToolStripDropDownButton _tdbEdit;
        private ToolStripMenuItem _tmiEditCut;
        private ToolStripMenuItem _tmiEditCopy;
        private ToolStripMenuItem _tmiEditPaste;
        private ToolStripMenuItem _tmiEditDelete;
        private ToolStripSeparator toolStripSeparator5;
        private ToolStripDropDownButton _tdbSelect;
        private ToolStripMenuItem _tmiSelectAllKey;
        private ToolStripDropDownButton _tdbView;
        private ToolStripMenuItem _tmiViewCurveAll;
        private ToolStripMenuItem _tmiViewSelectAll;
        private ToolStripMenuItem _tmiViewZoomIn;
        private ToolStripMenuItem _tmiViewZoomOut;
        private ToolStripMenuItem _tmiViewDrawInfinity;
        private ToolStripSeparator toolStripSeparator2;
        private ToolStripLabel _tlbCurve;
        private ToolStripDropDownButton _tdbCurvePreInfinity;
        private ToolStripMenuItem _tmiPreInfinityConstant;
        private ToolStripMenuItem _tmiPreInfinityCycle;
        private ToolStripDropDownButton _tdbCurvePostInfinity;
        private ToolStripMenuItem _tmiPostInfinityConstant;
        private ToolStripMenuItem _tmiPostInfinityCycle;
        private ToolStripSeparator toolStripSeparator1;
        private ToolStripDropDownButton _tdbSlope;
        private ToolStripMenuItem _tmiUnifySlopes;
        private ToolStripMenuItem _tmiBreakSlopes;
        private ToolStripMenuItem _tmiSetSlopeZero;
        private ToolStripMenuItem _tmiSetSlopeLiner;
        private ToolStripButton _tsbSetSlopeZero;
        private ToolStripButton _tsbSetSlopeLiner;
        private ToolStripPanel BottomToolStripPanel;
        private ToolStripPanel TopToolStripPanel;
        private ToolStripPanel RightToolStripPanel;
        private ToolStripPanel LeftToolStripPanel;
        private ToolStripContentPanel ContentPanel;
        private Panel _pnlTop;
        private ToolStripButton _tsbKeyAdd;
        private ToolStripMenuItem _tmiUndo;
        private ToolStripMenuItem _tmiRedo;
        private TimeControlPanel _pnlTimeControl;
        private TimeScaleControl _ctlTimeNumLine;
        private Panel _pnlBottom;
        private ToolStripSeparator toolStripSeparator6;
        private ToolStripButton _tsbSetSlopeSpline;
        private ToolStripButton _tsbSetSlopeStep;
        private ToolStripMenuItem _tmiViewFilter;
        private ToolStripButton _tsbPrevKey;
        private ToolStripButton _tsbNextKey;
        private ToolStripStringTextBox _ttbKeyTime;
        private ToolStripStringTextBox _ttbKeyValue;
        private Panel _pnlAttribute;
        private UIComboBox _cmbUserFilter;
        private Splitter _splBottomV;
        private Panel _pnlGraphBase;
        private ToolStripMenuItem _tmiShowSelectEnable;
        private ToolStripMenuItem _tmiShowOnlyActive;
        private ToolStripMenuItem _mniSetSlopeSpline;
        private ToolStripMenuItem _mniSetSlopeStep;
        private ToolStripSeparator toolStripSeparator7;
        private ToolStripMenuItem _tmiPasteAsRelativeValue;
        private ToolStripMenuItem _tmiTimeScale;
        private ToolStripButton _tsbAutoLoadEnabled;
        private ToolStripSeparator toolStripSeparator3;
        private ToolStripButton _tsbLoadFromSelectedSet;
        private ToolStripSeparator toolStripSeparator8;
        private ToolStripSeparator toolStripSeparator9;
        private ToolStripButton _tsbSetArrowKeySpeed;
        private ToolStripMenuItem _tmiViewFilterAdd;
        private ToolStripMenuItem _tmiViewFilterRemove;
        private ToolStripMenuItem _tmiViewFilterImport;
        private ToolStripMenuItem _tmiViewFilterExport;
        private ToolStripMenuItem _tmiViewFilterClear;
        private LayoutEditor.Controls.DockContentToolTip _ttpMain;
        private IContainer components;
        private ToolStripSeparator toolStripSeparator10;
        private ToolStripSeparator toolStripSeparator11;
        private ToolStripMenuItem _tmiLoadFromSelectedSet;
        private ToolStripSeparator toolStripSeparator12;
        private ToolStripSeparator _sepFilter;
        private ToolStripButton _tsbOperationModeNormal;
        private ToolStripButton _tsbOperationModeTweakNear;
        private ToolStripButton _tsbOperationModeInsert;
        private ToolStripButton _tsbOperationModeAdd;
        private ToolStripSeparator toolStripSeparator13;
        private ToolStripSeparator toolStripSeparator14;
        private PlayContorolPanel _ctlPlay;
        private UIRadioButton _radFilterCustom;
        private UIRadioButton _radFilterAnim;
        private UIRadioButton _radFilterBasic;
        private UIRadioButton _radFilterNone;
        private UIToolStripComboBox _cmbValueSnap;
        private ToolStripLabel _lblValueSnap;
        private ToolStripMenuItem _tmiViewAnimRange;
        private ToolStripMenuItem _tmiViewCurrentTimeCenter;
        private ToolStripSeparator toolStripSeparator4;
        private ToolStripButton _btnFitting;
        private ToolStripSeparator toolStripSeparator15;
        private ToolStripButton _btnBeforeAfterKey;
        private ToolStripButton _btnBeforeKeySnap;
        private ToolStripButton _btnAfterKeySnap;
        private System.Windows.Forms.TextBox _tbxEventLog;

        #region コンポーネント デザイナで生成されたコード
        /// <summary>
        /// デザイナ サポートに必要なメソッドです。このメソッドの内容を
        /// コード エディタで変更しないでください。
        /// </summary>
        private void InitializeComponent()
        {
            this.components = new System.ComponentModel.Container();
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(CurveEditWindow));
            this._tbxEventLog = new System.Windows.Forms.TextBox();
            this.BottomToolStripPanel = new System.Windows.Forms.ToolStripPanel();
            this.TopToolStripPanel = new System.Windows.Forms.ToolStripPanel();
            this.RightToolStripPanel = new System.Windows.Forms.ToolStripPanel();
            this.LeftToolStripPanel = new System.Windows.Forms.ToolStripPanel();
            this.ContentPanel = new System.Windows.Forms.ToolStripContentPanel();
            this._tvwTargetAttr = new System.Windows.Forms.TreeView();
            this._ctlGraphView = new LayoutEditor.Forms.ToolWindows.CurveEditWindow.GraphView();
            this._tspCurveEditor = new System.Windows.Forms.ToolStrip();
            this._tsbOperationModeNormal = new System.Windows.Forms.ToolStripButton();
            this._tsbOperationModeTweakNear = new System.Windows.Forms.ToolStripButton();
            this._tsbOperationModeInsert = new System.Windows.Forms.ToolStripButton();
            this._tsbOperationModeAdd = new System.Windows.Forms.ToolStripButton();
            this.toolStripSeparator13 = new System.Windows.Forms.ToolStripSeparator();
            this._ttbKeyTime = new ToolStripStringTextBox();
            this._ttbKeyValue = new ToolStripStringTextBox();
            this._lblValueSnap = new System.Windows.Forms.ToolStripLabel();
            this._cmbValueSnap = new LayoutEditor.Controls.UIToolStripComboBox();
            this.toolStripSeparator14 = new System.Windows.Forms.ToolStripSeparator();
            this._tdbSlope = new System.Windows.Forms.ToolStripDropDownButton();
            this._tmiUnifySlopes = new System.Windows.Forms.ToolStripMenuItem();
            this._tmiBreakSlopes = new System.Windows.Forms.ToolStripMenuItem();
            this._mniSetSlopeSpline = new System.Windows.Forms.ToolStripMenuItem();
            this._tmiSetSlopeLiner = new System.Windows.Forms.ToolStripMenuItem();
            this._tmiSetSlopeZero = new System.Windows.Forms.ToolStripMenuItem();
            this._mniSetSlopeStep = new System.Windows.Forms.ToolStripMenuItem();
            this._tsbPrevKey = new System.Windows.Forms.ToolStripButton();
            this._tsbNextKey = new System.Windows.Forms.ToolStripButton();
            this._tsbKeyAdd = new System.Windows.Forms.ToolStripButton();
            this.toolStripSeparator6 = new System.Windows.Forms.ToolStripSeparator();
            this._tsbSetSlopeSpline = new System.Windows.Forms.ToolStripButton();
            this._tsbSetSlopeLiner = new System.Windows.Forms.ToolStripButton();
            this._tsbSetSlopeZero = new System.Windows.Forms.ToolStripButton();
            this._tsbSetSlopeStep = new System.Windows.Forms.ToolStripButton();
            this.toolStripSeparator1 = new System.Windows.Forms.ToolStripSeparator();
            this._tdbEdit = new System.Windows.Forms.ToolStripDropDownButton();
            this._tmiUndo = new System.Windows.Forms.ToolStripMenuItem();
            this._tmiRedo = new System.Windows.Forms.ToolStripMenuItem();
            this._tmiEditCut = new System.Windows.Forms.ToolStripMenuItem();
            this._tmiEditCopy = new System.Windows.Forms.ToolStripMenuItem();
            this._tmiEditPaste = new System.Windows.Forms.ToolStripMenuItem();
            this._tmiEditDelete = new System.Windows.Forms.ToolStripMenuItem();
            this.toolStripSeparator7 = new System.Windows.Forms.ToolStripSeparator();
            this._tmiPasteAsRelativeValue = new System.Windows.Forms.ToolStripMenuItem();
            this.toolStripSeparator9 = new System.Windows.Forms.ToolStripSeparator();
            this._tmiTimeScale = new System.Windows.Forms.ToolStripMenuItem();
            this.toolStripSeparator5 = new System.Windows.Forms.ToolStripSeparator();
            this._tdbView = new System.Windows.Forms.ToolStripDropDownButton();
            this._tmiViewCurveAll = new System.Windows.Forms.ToolStripMenuItem();
            this._tmiViewSelectAll = new System.Windows.Forms.ToolStripMenuItem();
            this._tmiViewAnimRange = new System.Windows.Forms.ToolStripMenuItem();
            this._tmiViewCurrentTimeCenter = new System.Windows.Forms.ToolStripMenuItem();
            this._tmiViewZoomIn = new System.Windows.Forms.ToolStripMenuItem();
            this._tmiViewZoomOut = new System.Windows.Forms.ToolStripMenuItem();
            this.toolStripSeparator10 = new System.Windows.Forms.ToolStripSeparator();
            this._tmiViewDrawInfinity = new System.Windows.Forms.ToolStripMenuItem();
            this._tmiShowOnlyActive = new System.Windows.Forms.ToolStripMenuItem();
            this.toolStripSeparator11 = new System.Windows.Forms.ToolStripSeparator();
            this._tmiLoadFromSelectedSet = new System.Windows.Forms.ToolStripMenuItem();
            this.toolStripSeparator12 = new System.Windows.Forms.ToolStripSeparator();
            this._tmiViewFilter = new System.Windows.Forms.ToolStripMenuItem();
            this._tmiViewFilterAdd = new System.Windows.Forms.ToolStripMenuItem();
            this._tmiViewFilterRemove = new System.Windows.Forms.ToolStripMenuItem();
            this._tmiViewFilterClear = new System.Windows.Forms.ToolStripMenuItem();
            this._sepFilter = new System.Windows.Forms.ToolStripSeparator();
            this._tmiViewFilterImport = new System.Windows.Forms.ToolStripMenuItem();
            this._tmiViewFilterExport = new System.Windows.Forms.ToolStripMenuItem();
            this._tdbSelect = new System.Windows.Forms.ToolStripDropDownButton();
            this._tmiSelectAllKey = new System.Windows.Forms.ToolStripMenuItem();
            this._tmiShowSelectEnable = new System.Windows.Forms.ToolStripMenuItem();
            this.toolStripSeparator2 = new System.Windows.Forms.ToolStripSeparator();
            this._tlbCurve = new System.Windows.Forms.ToolStripLabel();
            this._tdbCurvePreInfinity = new System.Windows.Forms.ToolStripDropDownButton();
            this._tmiPreInfinityConstant = new System.Windows.Forms.ToolStripMenuItem();
            this._tmiPreInfinityCycle = new System.Windows.Forms.ToolStripMenuItem();
            this._tdbCurvePostInfinity = new System.Windows.Forms.ToolStripDropDownButton();
            this._tmiPostInfinityConstant = new System.Windows.Forms.ToolStripMenuItem();
            this._tmiPostInfinityCycle = new System.Windows.Forms.ToolStripMenuItem();
            this.toolStripSeparator3 = new System.Windows.Forms.ToolStripSeparator();
            this._tsbAutoLoadEnabled = new System.Windows.Forms.ToolStripButton();
            this._tsbLoadFromSelectedSet = new System.Windows.Forms.ToolStripButton();
            this.toolStripSeparator8 = new System.Windows.Forms.ToolStripSeparator();
            this._tsbSetArrowKeySpeed = new System.Windows.Forms.ToolStripButton();
            this.toolStripSeparator4 = new System.Windows.Forms.ToolStripSeparator();
            this._btnFitting = new System.Windows.Forms.ToolStripButton();
            this.toolStripSeparator15 = new System.Windows.Forms.ToolStripSeparator();
            this._btnBeforeAfterKey = new System.Windows.Forms.ToolStripButton();
            this._btnBeforeKeySnap = new System.Windows.Forms.ToolStripButton();
            this._btnAfterKeySnap = new System.Windows.Forms.ToolStripButton();
            this._pnlTop = new System.Windows.Forms.Panel();
            this._pnlGraphBase = new System.Windows.Forms.Panel();
            this._splBottomV = new System.Windows.Forms.Splitter();
            this._pnlAttribute = new System.Windows.Forms.Panel();
            this._radFilterCustom = new LayoutEditor.Controls.UIRadioButton();
            this._radFilterAnim = new LayoutEditor.Controls.UIRadioButton();
            this._radFilterBasic = new LayoutEditor.Controls.UIRadioButton();
            this._radFilterNone = new LayoutEditor.Controls.UIRadioButton();
            this._cmbUserFilter = new LayoutEditor.Controls.UIComboBox();
            this._pnlTimeControl = new LayoutEditor.Forms.ToolWindows.TimiControlWindow.TimeControlPanel();
            this._ctlTimeNumLine = new LayoutEditor.Forms.ToolWindows.CurveEditWindow.TimeScaleControl();
            this._pnlBottom = new System.Windows.Forms.Panel();
            this._ctlPlay = new LayoutEditor.Forms.ToolWindows.CurveEditWindow.PlayContorolPanel();
            this._ttpMain = new LayoutEditor.Controls.DockContentToolTip(this.components);
            this._tspCurveEditor.SuspendLayout();
            this._pnlTop.SuspendLayout();
            this._pnlGraphBase.SuspendLayout();
            this._pnlAttribute.SuspendLayout();
            this._pnlBottom.SuspendLayout();
            this.SuspendLayout();
            //
            // _tbxEventLog
            //
            resources.ApplyResources(this._tbxEventLog, "_tbxEventLog");
            this._tbxEventLog.Name = "_tbxEventLog";
            //
            // BottomToolStripPanel
            //
            resources.ApplyResources(this.BottomToolStripPanel, "BottomToolStripPanel");
            this.BottomToolStripPanel.Name = "BottomToolStripPanel";
            this.BottomToolStripPanel.Orientation = System.Windows.Forms.Orientation.Horizontal;
            this.BottomToolStripPanel.RowMargin = new System.Windows.Forms.Padding(3, 0, 0, 0);
            //
            // TopToolStripPanel
            //
            resources.ApplyResources(this.TopToolStripPanel, "TopToolStripPanel");
            this.TopToolStripPanel.Name = "TopToolStripPanel";
            this.TopToolStripPanel.Orientation = System.Windows.Forms.Orientation.Horizontal;
            this.TopToolStripPanel.RowMargin = new System.Windows.Forms.Padding(3, 0, 0, 0);
            //
            // RightToolStripPanel
            //
            resources.ApplyResources(this.RightToolStripPanel, "RightToolStripPanel");
            this.RightToolStripPanel.Name = "RightToolStripPanel";
            this.RightToolStripPanel.Orientation = System.Windows.Forms.Orientation.Horizontal;
            this.RightToolStripPanel.RowMargin = new System.Windows.Forms.Padding(3, 0, 0, 0);
            //
            // LeftToolStripPanel
            //
            resources.ApplyResources(this.LeftToolStripPanel, "LeftToolStripPanel");
            this.LeftToolStripPanel.Name = "LeftToolStripPanel";
            this.LeftToolStripPanel.Orientation = System.Windows.Forms.Orientation.Horizontal;
            this.LeftToolStripPanel.RowMargin = new System.Windows.Forms.Padding(3, 0, 0, 0);
            //
            // ContentPanel
            //
            resources.ApplyResources(this.ContentPanel, "ContentPanel");
            //
            // _tvwTargetAttr
            //
            resources.ApplyResources(this._tvwTargetAttr, "_tvwTargetAttr");
            this._tvwTargetAttr.BackColor = System.Drawing.SystemColors.Window;
            this._tvwTargetAttr.DrawMode = System.Windows.Forms.TreeViewDrawMode.OwnerDrawAll;
            this._tvwTargetAttr.FullRowSelect = true;
            this._tvwTargetAttr.Name = "_tvwTargetAttr";
            this._tvwTargetAttr.DrawNode += new System.Windows.Forms.DrawTreeNodeEventHandler(this.Event_TvwTargetAttr_DrawNode);
            this._tvwTargetAttr.BeforeSelect += new System.Windows.Forms.TreeViewCancelEventHandler(this.Event_TvwTargetAttr_BeforeSelect);
            this._tvwTargetAttr.MouseDown += new System.Windows.Forms.MouseEventHandler(this.Event_TvwTargetAttr_MouseDown);
            //
            // _ctlGraphView
            //
            this._ctlGraphView.CurrentTimeColor = System.Drawing.Color.DimGray;
            this._ctlGraphView.DispBeforeAfterKeyInfo = false;
            resources.ApplyResources(this._ctlGraphView, "_ctlGraphView");
            this._ctlGraphView.DrawInifinity = true;
            this._ctlGraphView.GraphValueSnap = LayoutEditor.Forms.ToolWindows.CurveEditWindow.GraphValueSnap.None;
            this._ctlGraphView.GridColor = System.Drawing.Color.Gray;
            this._ctlGraphView.MouseTweakMode = LayoutEditor.Forms.ToolWindows.CurveEditWindow.GraphView.GraphViewMouseTweakMode.Normal;
            this._ctlGraphView.Name = "_ctlGraphView";
            this._ctlGraphView.ParentWindow = null;
            this._ctlGraphView.Tag = "                           ";
            this._ctlGraphView.TargetAnmAttributeSet = null;
            this._ctlGraphView.ViewScale = new System.Drawing.SizeF(0.5F, 0.5F);
            //
            // _tspCurveEditor
            //
            this._tspCurveEditor.CanOverflow = false;
            this._tspCurveEditor.GripStyle = System.Windows.Forms.ToolStripGripStyle.Hidden;
            this._tspCurveEditor.ImageScalingSize = new System.Drawing.Size(20, 20);
            this._tspCurveEditor.Items.AddRange(new System.Windows.Forms.ToolStripItem[] {
            this._tsbOperationModeNormal,
            this._tsbOperationModeTweakNear,
            this._tsbOperationModeInsert,
            this._tsbOperationModeAdd,
            this.toolStripSeparator13,
            this._ttbKeyTime,
            this._ttbKeyValue,
            this._lblValueSnap,
            this._cmbValueSnap,
            this.toolStripSeparator14,
            this._tdbSlope,
            this._tsbPrevKey,
            this._tsbNextKey,
            this._tsbKeyAdd,
            this.toolStripSeparator6,
            this._tsbSetSlopeSpline,
            this._tsbSetSlopeLiner,
            this._tsbSetSlopeZero,
            this._tsbSetSlopeStep,
            this.toolStripSeparator1,
            this._tdbEdit,
            this.toolStripSeparator5,
            this._tdbView,
            this._tdbSelect,
            this.toolStripSeparator2,
            this._tlbCurve,
            this._tdbCurvePreInfinity,
            this._tdbCurvePostInfinity,
            this.toolStripSeparator3,
            this._tsbAutoLoadEnabled,
            this._tsbLoadFromSelectedSet,
            this.toolStripSeparator8,
            this._tsbSetArrowKeySpeed,
            this.toolStripSeparator4,
            this._btnFitting,
            this.toolStripSeparator15,
            this._btnBeforeAfterKey,
            this._btnBeforeKeySnap,
            this._btnAfterKeySnap});
            this._tspCurveEditor.LayoutStyle = System.Windows.Forms.ToolStripLayoutStyle.Flow;
            resources.ApplyResources(this._tspCurveEditor, "_tspCurveEditor");
            this._tspCurveEditor.Name = "_tspCurveEditor";
            //
            // _tsbOperationModeNormal
            //
            this._tsbOperationModeNormal.BackColor = System.Drawing.SystemColors.ControlLight;
            this._tsbOperationModeNormal.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Image;
            resources.ApplyResources(this._tsbOperationModeNormal, "_tsbOperationModeNormal");
            this._tsbOperationModeNormal.Margin = new System.Windows.Forms.Padding(2);
            this._tsbOperationModeNormal.Name = "_tsbOperationModeNormal";
            this._tsbOperationModeNormal.Click += new System.EventHandler(this.Event_tmiOperationModeNormal_Click);
            //
            // _tsbOperationModeTweakNear
            //
            this._tsbOperationModeTweakNear.BackColor = System.Drawing.SystemColors.ControlLight;
            this._tsbOperationModeTweakNear.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Image;
            resources.ApplyResources(this._tsbOperationModeTweakNear, "_tsbOperationModeTweakNear");
            this._tsbOperationModeTweakNear.Margin = new System.Windows.Forms.Padding(2);
            this._tsbOperationModeTweakNear.Name = "_tsbOperationModeTweakNear";
            this._tsbOperationModeTweakNear.Click += new System.EventHandler(this.Event_tmiOperationModeTewakNear_Click);
            //
            // _tsbOperationModeInsert
            //
            this._tsbOperationModeInsert.BackColor = System.Drawing.SystemColors.ControlLight;
            this._tsbOperationModeInsert.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Image;
            resources.ApplyResources(this._tsbOperationModeInsert, "_tsbOperationModeInsert");
            this._tsbOperationModeInsert.Margin = new System.Windows.Forms.Padding(2);
            this._tsbOperationModeInsert.Name = "_tsbOperationModeInsert";
            this._tsbOperationModeInsert.Click += new System.EventHandler(this.Event_tmiOperationModeInsert_Click);
            //
            // _tsbOperationModeAdd
            //
            this._tsbOperationModeAdd.BackColor = System.Drawing.SystemColors.ControlLight;
            this._tsbOperationModeAdd.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Image;
            resources.ApplyResources(this._tsbOperationModeAdd, "_tsbOperationModeAdd");
            this._tsbOperationModeAdd.Margin = new System.Windows.Forms.Padding(2);
            this._tsbOperationModeAdd.Name = "_tsbOperationModeAdd";
            this._tsbOperationModeAdd.Click += new System.EventHandler(this.Event_tmiOperationModeAdd_Click);
            //
            // toolStripSeparator13
            //
            this.toolStripSeparator13.Margin = new System.Windows.Forms.Padding(4, 0, 4, 0);
            this.toolStripSeparator13.Name = "toolStripSeparator13";
            resources.ApplyResources(this.toolStripSeparator13, "toolStripSeparator13");
            //
            // _ttbKeyTime
            //
            this._ttbKeyTime.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
            this._ttbKeyTime.Margin = new System.Windows.Forms.Padding(2, 2, 2, 0);
            this._ttbKeyTime.Name = "_ttbKeyTime";
            resources.ApplyResources(this._ttbKeyTime, "_ttbKeyTime");
            this._ttbKeyTime.Value = "";
            this._ttbKeyTime.ValueChanged += new System.EventHandler(this.Event_TbxSelKeyTime_ValueChanged);
            //
            // _ttbKeyValue
            //
            this._ttbKeyValue.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
            this._ttbKeyValue.Margin = new System.Windows.Forms.Padding(2, 2, 2, 0);
            this._ttbKeyValue.Name = "_ttbKeyValue";
            resources.ApplyResources(this._ttbKeyValue, "_ttbKeyValue");
            this._ttbKeyValue.Value = "";
            this._ttbKeyValue.ValueChanged += new System.EventHandler(this.Event_TbxSelKeyValue_ValueChanged);
            //
            // _lblValueSnap
            //
            resources.ApplyResources(this._lblValueSnap, "_lblValueSnap");
            this._lblValueSnap.Margin = new System.Windows.Forms.Padding(0, 2, 0, 1);
            this._lblValueSnap.Name = "_lblValueSnap";
            //
            // _cmbValueSnap
            //
            resources.ApplyResources(this._cmbValueSnap, "_cmbValueSnap");
            this._cmbValueSnap.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this._cmbValueSnap.Margin = new System.Windows.Forms.Padding(1, 1, 1, 0);
            this._cmbValueSnap.Name = "_cmbValueSnap";
            this._cmbValueSnap.SelectedIndexChanged += new System.EventHandler(this.Event_cmbValueSnap_SelectedIndexChanged);
            //
            // toolStripSeparator14
            //
            this.toolStripSeparator14.Margin = new System.Windows.Forms.Padding(4, 0, 4, 0);
            this.toolStripSeparator14.Name = "toolStripSeparator14";
            resources.ApplyResources(this.toolStripSeparator14, "toolStripSeparator14");
            //
            // _tdbSlope
            //
            this._tdbSlope.DropDownItems.AddRange(new System.Windows.Forms.ToolStripItem[] {
            this._tmiUnifySlopes,
            this._tmiBreakSlopes,
            this._mniSetSlopeSpline,
            this._tmiSetSlopeLiner,
            this._tmiSetSlopeZero,
            this._mniSetSlopeStep});
            resources.ApplyResources(this._tdbSlope, "_tdbSlope");
            this._tdbSlope.Name = "_tdbSlope";
            //
            // _tmiUnifySlopes
            //
            this._tmiUnifySlopes.Name = "_tmiUnifySlopes";
            resources.ApplyResources(this._tmiUnifySlopes, "_tmiUnifySlopes");
            this._tmiUnifySlopes.Click += new System.EventHandler(this.Event_MniUnifySlopes_Click);
            //
            // _tmiBreakSlopes
            //
            this._tmiBreakSlopes.Name = "_tmiBreakSlopes";
            resources.ApplyResources(this._tmiBreakSlopes, "_tmiBreakSlopes");
            this._tmiBreakSlopes.Click += new System.EventHandler(this.Event_MniBreakSlopes_Click);
            //
            // _mniSetSlopeSpline
            //
            this._mniSetSlopeSpline.Name = "_mniSetSlopeSpline";
            resources.ApplyResources(this._mniSetSlopeSpline, "_mniSetSlopeSpline");
            this._mniSetSlopeSpline.Click += new System.EventHandler(this.Event_TsbSetSlopeSpline_Click);
            //
            // _tmiSetSlopeLiner
            //
            this._tmiSetSlopeLiner.Name = "_tmiSetSlopeLiner";
            resources.ApplyResources(this._tmiSetSlopeLiner, "_tmiSetSlopeLiner");
            this._tmiSetSlopeLiner.Click += new System.EventHandler(this.Event_MniSetSlopeLiner_Click);
            //
            // _tmiSetSlopeZero
            //
            this._tmiSetSlopeZero.Name = "_tmiSetSlopeZero";
            resources.ApplyResources(this._tmiSetSlopeZero, "_tmiSetSlopeZero");
            this._tmiSetSlopeZero.Click += new System.EventHandler(this.Event_MniSetSlopeZero_Click);
            //
            // _mniSetSlopeStep
            //
            this._mniSetSlopeStep.Name = "_mniSetSlopeStep";
            resources.ApplyResources(this._mniSetSlopeStep, "_mniSetSlopeStep");
            this._mniSetSlopeStep.Click += new System.EventHandler(this.Event_TsbSetSlopeStep_Click);
            //
            // _tsbPrevKey
            //
            this._tsbPrevKey.BackColor = System.Drawing.SystemColors.Control;
            this._tsbPrevKey.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Image;
            resources.ApplyResources(this._tsbPrevKey, "_tsbPrevKey");
            this._tsbPrevKey.Margin = new System.Windows.Forms.Padding(2, 1, 2, 2);
            this._tsbPrevKey.Name = "_tsbPrevKey";
            this._tsbPrevKey.Click += new System.EventHandler(this.Event_BtnPrevKey_Click);
            //
            // _tsbNextKey
            //
            this._tsbNextKey.BackColor = System.Drawing.SystemColors.Control;
            this._tsbNextKey.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Image;
            resources.ApplyResources(this._tsbNextKey, "_tsbNextKey");
            this._tsbNextKey.Margin = new System.Windows.Forms.Padding(2, 1, 2, 2);
            this._tsbNextKey.Name = "_tsbNextKey";
            this._tsbNextKey.Click += new System.EventHandler(this.Event_BtnNextKey_Click);
            //
            // _tsbKeyAdd
            //
            this._tsbKeyAdd.BackColor = System.Drawing.SystemColors.Control;
            this._tsbKeyAdd.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Image;
            resources.ApplyResources(this._tsbKeyAdd, "_tsbKeyAdd");
            this._tsbKeyAdd.Margin = new System.Windows.Forms.Padding(8, 1, 0, 2);
            this._tsbKeyAdd.Name = "_tsbKeyAdd";
            this._tsbKeyAdd.Click += new System.EventHandler(this.Event_TdbKey_Click);
            //
            // toolStripSeparator6
            //
            this.toolStripSeparator6.Margin = new System.Windows.Forms.Padding(4, 0, 4, 0);
            this.toolStripSeparator6.Name = "toolStripSeparator6";
            resources.ApplyResources(this.toolStripSeparator6, "toolStripSeparator6");
            //
            // _tsbSetSlopeSpline
            //
            this._tsbSetSlopeSpline.BackColor = System.Drawing.SystemColors.Control;
            this._tsbSetSlopeSpline.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Image;
            resources.ApplyResources(this._tsbSetSlopeSpline, "_tsbSetSlopeSpline");
            this._tsbSetSlopeSpline.Margin = new System.Windows.Forms.Padding(2, 1, 2, 2);
            this._tsbSetSlopeSpline.Name = "_tsbSetSlopeSpline";
            this._tsbSetSlopeSpline.Click += new System.EventHandler(this.Event_TsbSetSlopeSpline_Click);
            //
            // _tsbSetSlopeLiner
            //
            this._tsbSetSlopeLiner.BackColor = System.Drawing.SystemColors.Control;
            this._tsbSetSlopeLiner.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Image;
            resources.ApplyResources(this._tsbSetSlopeLiner, "_tsbSetSlopeLiner");
            this._tsbSetSlopeLiner.Margin = new System.Windows.Forms.Padding(2, 1, 2, 2);
            this._tsbSetSlopeLiner.Name = "_tsbSetSlopeLiner";
            this._tsbSetSlopeLiner.Click += new System.EventHandler(this.Event_MniSetSlopeLiner_Click);
            //
            // _tsbSetSlopeZero
            //
            this._tsbSetSlopeZero.BackColor = System.Drawing.SystemColors.Control;
            this._tsbSetSlopeZero.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Image;
            resources.ApplyResources(this._tsbSetSlopeZero, "_tsbSetSlopeZero");
            this._tsbSetSlopeZero.Margin = new System.Windows.Forms.Padding(2, 1, 2, 2);
            this._tsbSetSlopeZero.Name = "_tsbSetSlopeZero";
            this._tsbSetSlopeZero.Click += new System.EventHandler(this.Event_MniSetSlopeZero_Click);
            //
            // _tsbSetSlopeStep
            //
            this._tsbSetSlopeStep.BackColor = System.Drawing.SystemColors.Control;
            this._tsbSetSlopeStep.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Image;
            resources.ApplyResources(this._tsbSetSlopeStep, "_tsbSetSlopeStep");
            this._tsbSetSlopeStep.Margin = new System.Windows.Forms.Padding(2, 1, 2, 2);
            this._tsbSetSlopeStep.Name = "_tsbSetSlopeStep";
            this._tsbSetSlopeStep.Click += new System.EventHandler(this.Event_TsbSetSlopeStep_Click);
            //
            // toolStripSeparator1
            //
            this.toolStripSeparator1.Margin = new System.Windows.Forms.Padding(4, 0, 4, 0);
            this.toolStripSeparator1.Name = "toolStripSeparator1";
            resources.ApplyResources(this.toolStripSeparator1, "toolStripSeparator1");
            //
            // _tdbEdit
            //
            this._tdbEdit.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Text;
            this._tdbEdit.DropDownItems.AddRange(new System.Windows.Forms.ToolStripItem[] {
            this._tmiUndo,
            this._tmiRedo,
            this._tmiEditCut,
            this._tmiEditCopy,
            this._tmiEditPaste,
            this._tmiEditDelete,
            this.toolStripSeparator7,
            this._tmiPasteAsRelativeValue,
            this.toolStripSeparator9,
            this._tmiTimeScale});
            resources.ApplyResources(this._tdbEdit, "_tdbEdit");
            this._tdbEdit.Name = "_tdbEdit";
            this._tdbEdit.DropDownOpening += new System.EventHandler(this.Event_TdbEdit_DropDownOpening);
            //
            // _tmiUndo
            //
            this._tmiUndo.Name = "_tmiUndo";
            resources.ApplyResources(this._tmiUndo, "_tmiUndo");
            this._tmiUndo.Click += new System.EventHandler(this.Event_TmiUndo_Click);
            //
            // _tmiRedo
            //
            this._tmiRedo.Name = "_tmiRedo";
            resources.ApplyResources(this._tmiRedo, "_tmiRedo");
            this._tmiRedo.Click += new System.EventHandler(this.Event_TmiRodo_Click);
            //
            // _tmiEditCut
            //
            this._tmiEditCut.Name = "_tmiEditCut";
            resources.ApplyResources(this._tmiEditCut, "_tmiEditCut");
            this._tmiEditCut.Click += new System.EventHandler(this.Event_MniEditTear_Click);
            //
            // _tmiEditCopy
            //
            this._tmiEditCopy.Name = "_tmiEditCopy";
            resources.ApplyResources(this._tmiEditCopy, "_tmiEditCopy");
            this._tmiEditCopy.Click += new System.EventHandler(this.Event_MniEditCopy_Click);
            //
            // _tmiEditPaste
            //
            this._tmiEditPaste.Name = "_tmiEditPaste";
            resources.ApplyResources(this._tmiEditPaste, "_tmiEditPaste");
            this._tmiEditPaste.Click += new System.EventHandler(this.Event_MniEditPaste_Click);
            //
            // _tmiEditDelete
            //
            this._tmiEditDelete.Name = "_tmiEditDelete";
            resources.ApplyResources(this._tmiEditDelete, "_tmiEditDelete");
            this._tmiEditDelete.Click += new System.EventHandler(this.Event_MniEditDelete_Click);
            //
            // toolStripSeparator7
            //
            this.toolStripSeparator7.Name = "toolStripSeparator7";
            resources.ApplyResources(this.toolStripSeparator7, "toolStripSeparator7");
            //
            // _tmiPasteAsRelativeValue
            //
            this._tmiPasteAsRelativeValue.Name = "_tmiPasteAsRelativeValue";
            resources.ApplyResources(this._tmiPasteAsRelativeValue, "_tmiPasteAsRelativeValue");
            this._tmiPasteAsRelativeValue.Click += new System.EventHandler(this.Event_TmiPasteAsRelativeValue_Click);
            //
            // toolStripSeparator9
            //
            this.toolStripSeparator9.Name = "toolStripSeparator9";
            resources.ApplyResources(this.toolStripSeparator9, "toolStripSeparator9");
            //
            // _tmiTimeScale
            //
            this._tmiTimeScale.Name = "_tmiTimeScale";
            resources.ApplyResources(this._tmiTimeScale, "_tmiTimeScale");
            this._tmiTimeScale.Click += new System.EventHandler(this.Event_TmiTimeScale_Click);
            //
            // toolStripSeparator5
            //
            this.toolStripSeparator5.Name = "toolStripSeparator5";
            resources.ApplyResources(this.toolStripSeparator5, "toolStripSeparator5");
            //
            // _tdbView
            //
            this._tdbView.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Text;
            this._tdbView.DropDownItems.AddRange(new System.Windows.Forms.ToolStripItem[] {
            this._tmiViewCurveAll,
            this._tmiViewSelectAll,
            this._tmiViewAnimRange,
            this._tmiViewCurrentTimeCenter,
            this._tmiViewZoomIn,
            this._tmiViewZoomOut,
            this.toolStripSeparator10,
            this._tmiViewDrawInfinity,
            this._tmiShowOnlyActive,
            this.toolStripSeparator11,
            this._tmiLoadFromSelectedSet,
            this.toolStripSeparator12,
            this._tmiViewFilter});
            resources.ApplyResources(this._tdbView, "_tdbView");
            this._tdbView.Name = "_tdbView";
            this._tdbView.DropDownOpening += new System.EventHandler(this.Event_MniView_Popup);
            //
            // _tmiViewCurveAll
            //
            this._tmiViewCurveAll.Name = "_tmiViewCurveAll";
            resources.ApplyResources(this._tmiViewCurveAll, "_tmiViewCurveAll");
            this._tmiViewCurveAll.Click += new System.EventHandler(this.Event_MniViewAll_Click);
            //
            // _tmiViewSelectAll
            //
            this._tmiViewSelectAll.Name = "_tmiViewSelectAll";
            resources.ApplyResources(this._tmiViewSelectAll, "_tmiViewSelectAll");
            this._tmiViewSelectAll.Click += new System.EventHandler(this.Event_MiViewSelectAll_Click);
            //
            // _tmiViewAnimRange
            //
            this._tmiViewAnimRange.Name = "_tmiViewAnimRange";
            resources.ApplyResources(this._tmiViewAnimRange, "_tmiViewAnimRange");
            this._tmiViewAnimRange.Click += new System.EventHandler(this.Event_MiViewAnimRange_Click);
            //
            // _tmiViewCurrentTimeCenter
            //
            this._tmiViewCurrentTimeCenter.Name = "_tmiViewCurrentTimeCenter";
            resources.ApplyResources(this._tmiViewCurrentTimeCenter, "_tmiViewCurrentTimeCenter");
            this._tmiViewCurrentTimeCenter.Click += new System.EventHandler(this.Event_MiViewCurrentTimeCenter_Click);
            //
            // _tmiViewZoomIn
            //
            this._tmiViewZoomIn.Name = "_tmiViewZoomIn";
            resources.ApplyResources(this._tmiViewZoomIn, "_tmiViewZoomIn");
            this._tmiViewZoomIn.Click += new System.EventHandler(this.Event_MniZoomIn_Click);
            //
            // _tmiViewZoomOut
            //
            this._tmiViewZoomOut.Name = "_tmiViewZoomOut";
            resources.ApplyResources(this._tmiViewZoomOut, "_tmiViewZoomOut");
            this._tmiViewZoomOut.Click += new System.EventHandler(this.Event_MniZoomOut_Click);
            //
            // toolStripSeparator10
            //
            this.toolStripSeparator10.Name = "toolStripSeparator10";
            resources.ApplyResources(this.toolStripSeparator10, "toolStripSeparator10");
            //
            // _tmiViewDrawInfinity
            //
            this._tmiViewDrawInfinity.Name = "_tmiViewDrawInfinity";
            resources.ApplyResources(this._tmiViewDrawInfinity, "_tmiViewDrawInfinity");
            this._tmiViewDrawInfinity.Click += new System.EventHandler(this.Event_MniDrawInfinity_Click);
            //
            // _tmiShowOnlyActive
            //
            this._tmiShowOnlyActive.Name = "_tmiShowOnlyActive";
            resources.ApplyResources(this._tmiShowOnlyActive, "_tmiShowOnlyActive");
            this._tmiShowOnlyActive.Click += new System.EventHandler(this.Event_TmiShowOnlyActive_Click);
            //
            // toolStripSeparator11
            //
            this.toolStripSeparator11.Name = "toolStripSeparator11";
            resources.ApplyResources(this.toolStripSeparator11, "toolStripSeparator11");
            //
            // _tmiLoadFromSelectedSet
            //
            this._tmiLoadFromSelectedSet.Name = "_tmiLoadFromSelectedSet";
            resources.ApplyResources(this._tmiLoadFromSelectedSet, "_tmiLoadFromSelectedSet");
            this._tmiLoadFromSelectedSet.Click += new System.EventHandler(this.Event_TsbLoadFromSelectedSet_Click);
            //
            // toolStripSeparator12
            //
            this.toolStripSeparator12.Name = "toolStripSeparator12";
            resources.ApplyResources(this.toolStripSeparator12, "toolStripSeparator12");
            //
            // _tmiViewFilter
            //
            this._tmiViewFilter.DropDownItems.AddRange(new System.Windows.Forms.ToolStripItem[] {
            this._tmiViewFilterAdd,
            this._tmiViewFilterRemove,
            this._tmiViewFilterClear,
            this._sepFilter,
            this._tmiViewFilterImport,
            this._tmiViewFilterExport});
            this._tmiViewFilter.Name = "_tmiViewFilter";
            resources.ApplyResources(this._tmiViewFilter, "_tmiViewFilter");
            this._tmiViewFilter.DropDownOpened += new System.EventHandler(this.Event_TmiViewFilter_DropDownOpened);
            //
            // _tmiViewFilterAdd
            //
            this._tmiViewFilterAdd.Name = "_tmiViewFilterAdd";
            resources.ApplyResources(this._tmiViewFilterAdd, "_tmiViewFilterAdd");
            this._tmiViewFilterAdd.Click += new System.EventHandler(this.Event_TmiViewFilterAdd_Click);
            //
            // _tmiViewFilterRemove
            //
            this._tmiViewFilterRemove.Name = "_tmiViewFilterRemove";
            resources.ApplyResources(this._tmiViewFilterRemove, "_tmiViewFilterRemove");
            this._tmiViewFilterRemove.Click += new System.EventHandler(this.Event_TmiViewFilterRemove_Click);
            //
            // _tmiViewFilterClear
            //
            this._tmiViewFilterClear.Name = "_tmiViewFilterClear";
            resources.ApplyResources(this._tmiViewFilterClear, "_tmiViewFilterClear");
            this._tmiViewFilterClear.Click += new System.EventHandler(this.Event_TmiViewFilterClear_Click);
            //
            // _sepFilter
            //
            this._sepFilter.Name = "_sepFilter";
            resources.ApplyResources(this._sepFilter, "_sepFilter");
            //
            // _tmiViewFilterImport
            //
            this._tmiViewFilterImport.Name = "_tmiViewFilterImport";
            resources.ApplyResources(this._tmiViewFilterImport, "_tmiViewFilterImport");
            this._tmiViewFilterImport.Click += new System.EventHandler(this.Event_TmiViewFilterImport_Click);
            //
            // _tmiViewFilterExport
            //
            this._tmiViewFilterExport.Name = "_tmiViewFilterExport";
            resources.ApplyResources(this._tmiViewFilterExport, "_tmiViewFilterExport");
            this._tmiViewFilterExport.Click += new System.EventHandler(this.Event_TmiViewFilterExport_Click);
            //
            // _tdbSelect
            //
            this._tdbSelect.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Text;
            this._tdbSelect.DropDownItems.AddRange(new System.Windows.Forms.ToolStripItem[] {
            this._tmiSelectAllKey,
            this._tmiShowSelectEnable});
            resources.ApplyResources(this._tdbSelect, "_tdbSelect");
            this._tdbSelect.Name = "_tdbSelect";
            this._tdbSelect.DropDownOpening += new System.EventHandler(this.Event_TdbSelect_DropDownOpening);
            //
            // _tmiSelectAllKey
            //
            this._tmiSelectAllKey.Name = "_tmiSelectAllKey";
            resources.ApplyResources(this._tmiSelectAllKey, "_tmiSelectAllKey");
            this._tmiSelectAllKey.Click += new System.EventHandler(this.Event_MniEditSelectAll_Click);
            //
            // _tmiShowSelectEnable
            //
            this._tmiShowSelectEnable.Name = "_tmiShowSelectEnable";
            resources.ApplyResources(this._tmiShowSelectEnable, "_tmiShowSelectEnable");
            this._tmiShowSelectEnable.Click += new System.EventHandler(this.Event_TmiShowSelectEnable_Click);
            //
            // toolStripSeparator2
            //
            this.toolStripSeparator2.Name = "toolStripSeparator2";
            resources.ApplyResources(this.toolStripSeparator2, "toolStripSeparator2");
            //
            // _tlbCurve
            //
            this._tlbCurve.Margin = new System.Windows.Forms.Padding(0, 2, 0, 2);
            this._tlbCurve.Name = "_tlbCurve";
            resources.ApplyResources(this._tlbCurve, "_tlbCurve");
            //
            // _tdbCurvePreInfinity
            //
            this._tdbCurvePreInfinity.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Image;
            this._tdbCurvePreInfinity.DropDownItems.AddRange(new System.Windows.Forms.ToolStripItem[] {
            this._tmiPreInfinityConstant,
            this._tmiPreInfinityCycle});
            resources.ApplyResources(this._tdbCurvePreInfinity, "_tdbCurvePreInfinity");
            this._tdbCurvePreInfinity.Name = "_tdbCurvePreInfinity";
            //
            // _tmiPreInfinityConstant
            //
            this._tmiPreInfinityConstant.Name = "_tmiPreInfinityConstant";
            resources.ApplyResources(this._tmiPreInfinityConstant, "_tmiPreInfinityConstant");
            this._tmiPreInfinityConstant.Click += new System.EventHandler(this.Event_MniCurvePreInfinity_Click);
            //
            // _tmiPreInfinityCycle
            //
            this._tmiPreInfinityCycle.Name = "_tmiPreInfinityCycle";
            resources.ApplyResources(this._tmiPreInfinityCycle, "_tmiPreInfinityCycle");
            this._tmiPreInfinityCycle.Click += new System.EventHandler(this.Event_MniCurvePreInfinity_Click);
            //
            // _tdbCurvePostInfinity
            //
            this._tdbCurvePostInfinity.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Image;
            this._tdbCurvePostInfinity.DropDownItems.AddRange(new System.Windows.Forms.ToolStripItem[] {
            this._tmiPostInfinityConstant,
            this._tmiPostInfinityCycle});
            resources.ApplyResources(this._tdbCurvePostInfinity, "_tdbCurvePostInfinity");
            this._tdbCurvePostInfinity.Name = "_tdbCurvePostInfinity";
            //
            // _tmiPostInfinityConstant
            //
            this._tmiPostInfinityConstant.Name = "_tmiPostInfinityConstant";
            resources.ApplyResources(this._tmiPostInfinityConstant, "_tmiPostInfinityConstant");
            this._tmiPostInfinityConstant.Click += new System.EventHandler(this.Event_MniCurvePostInfinity_Click);
            //
            // _tmiPostInfinityCycle
            //
            this._tmiPostInfinityCycle.Name = "_tmiPostInfinityCycle";
            resources.ApplyResources(this._tmiPostInfinityCycle, "_tmiPostInfinityCycle");
            this._tmiPostInfinityCycle.Click += new System.EventHandler(this.Event_MniCurvePostInfinity_Click);
            //
            // toolStripSeparator3
            //
            this.toolStripSeparator3.Margin = new System.Windows.Forms.Padding(4, 0, 4, 0);
            this.toolStripSeparator3.Name = "toolStripSeparator3";
            resources.ApplyResources(this.toolStripSeparator3, "toolStripSeparator3");
            //
            // _tsbAutoLoadEnabled
            //
            this._tsbAutoLoadEnabled.CheckOnClick = true;
            this._tsbAutoLoadEnabled.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Image;
            resources.ApplyResources(this._tsbAutoLoadEnabled, "_tsbAutoLoadEnabled");
            this._tsbAutoLoadEnabled.Name = "_tsbAutoLoadEnabled";
            this._tsbAutoLoadEnabled.CheckStateChanged += new System.EventHandler(this.Event_TsbAutoLoadEnabled_CheckStateChanged_);
            //
            // _tsbLoadFromSelectedSet
            //
            this._tsbLoadFromSelectedSet.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Image;
            resources.ApplyResources(this._tsbLoadFromSelectedSet, "_tsbLoadFromSelectedSet");
            this._tsbLoadFromSelectedSet.Name = "_tsbLoadFromSelectedSet";
            this._tsbLoadFromSelectedSet.Click += new System.EventHandler(this.Event_TsbLoadFromSelectedSet_Click);
            //
            // toolStripSeparator8
            //
            this.toolStripSeparator8.Margin = new System.Windows.Forms.Padding(4, 0, 4, 0);
            this.toolStripSeparator8.Name = "toolStripSeparator8";
            resources.ApplyResources(this.toolStripSeparator8, "toolStripSeparator8");
            //
            // _tsbSetArrowKeySpeed
            //
            this._tsbSetArrowKeySpeed.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Image;
            resources.ApplyResources(this._tsbSetArrowKeySpeed, "_tsbSetArrowKeySpeed");
            this._tsbSetArrowKeySpeed.Name = "_tsbSetArrowKeySpeed";
            this._tsbSetArrowKeySpeed.Click += new System.EventHandler(this.Event_TsbSetArrowKeySpeed_Click);
            //
            // toolStripSeparator4
            //
            this.toolStripSeparator4.Margin = new System.Windows.Forms.Padding(4, 0, 4, 0);
            this.toolStripSeparator4.Name = "toolStripSeparator4";
            resources.ApplyResources(this.toolStripSeparator4, "toolStripSeparator4");
            //
            // _btnFitting
            //
            this._btnFitting.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Image;
            this._btnFitting.Image = global::LayoutEditor.Properties.Resources.Animation_Fitting;
            resources.ApplyResources(this._btnFitting, "_btnFitting");
            this._btnFitting.Name = "_btnFitting";
            this._btnFitting.Click += new System.EventHandler(this.Event_btnFitting_Click);
            //
            // toolStripSeparator15
            //
            this.toolStripSeparator15.Name = "toolStripSeparator15";
            resources.ApplyResources(this.toolStripSeparator15, "toolStripSeparator15");
            //
            // _btnBeforeAfterKey
            //
            this._btnBeforeAfterKey.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Image;
            this._btnBeforeAfterKey.Image = global::LayoutEditor.Properties.Resources.Icon_PreviewSectionKey_Off;
            resources.ApplyResources(this._btnBeforeAfterKey, "_btnBeforeAfterKey");
            this._btnBeforeAfterKey.Name = "_btnBeforeAfterKey";
            this._btnBeforeAfterKey.Click += new System.EventHandler(this.Event_btnBeforeAfterKey_Click);
            //
            // _btnBeforeKeySnap
            //
            this._btnBeforeKeySnap.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Image;
            this._btnBeforeKeySnap.Image = global::LayoutEditor.Properties.Resources.Icon_SnapSectionKey_Before;
            resources.ApplyResources(this._btnBeforeKeySnap, "_btnBeforeKeySnap");
            this._btnBeforeKeySnap.Name = "_btnBeforeKeySnap";
            this._btnBeforeKeySnap.Click += new System.EventHandler(this.Event_btnBeforeKeySnap_Click);
            //
            // _btnAfterKeySnap
            //
            this._btnAfterKeySnap.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Image;
            this._btnAfterKeySnap.Image = global::LayoutEditor.Properties.Resources.Icon_SnapSectionKey_After;
            resources.ApplyResources(this._btnAfterKeySnap, "_btnAfterKeySnap");
            this._btnAfterKeySnap.Name = "_btnAfterKeySnap";
            this._btnAfterKeySnap.Click += new System.EventHandler(this.Event_btnAfterKeySnap_Click);
            //
            // _pnlTop
            //
            this._pnlTop.BackColor = System.Drawing.Color.DarkGray;
            this._pnlTop.Controls.Add(this._pnlGraphBase);
            this._pnlTop.Controls.Add(this._splBottomV);
            this._pnlTop.Controls.Add(this._pnlAttribute);
            resources.ApplyResources(this._pnlTop, "_pnlTop");
            this._pnlTop.Name = "_pnlTop";
            //
            // _pnlGraphBase
            //
            this._pnlGraphBase.BackColor = System.Drawing.Color.DarkGray;
            this._pnlGraphBase.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
            this._pnlGraphBase.Controls.Add(this._ctlGraphView);
            resources.ApplyResources(this._pnlGraphBase, "_pnlGraphBase");
            this._pnlGraphBase.Name = "_pnlGraphBase";
            //
            // _splBottomV
            //
            resources.ApplyResources(this._splBottomV, "_splBottomV");
            this._splBottomV.Name = "_splBottomV";
            this._splBottomV.TabStop = false;
            //
            // _pnlAttribute
            //
            this._pnlAttribute.BackColor = System.Drawing.SystemColors.Control;
            this._pnlAttribute.Controls.Add(this._radFilterCustom);
            this._pnlAttribute.Controls.Add(this._radFilterAnim);
            this._pnlAttribute.Controls.Add(this._radFilterBasic);
            this._pnlAttribute.Controls.Add(this._radFilterNone);
            this._pnlAttribute.Controls.Add(this._cmbUserFilter);
            this._pnlAttribute.Controls.Add(this._tvwTargetAttr);
            resources.ApplyResources(this._pnlAttribute, "_pnlAttribute");
            this._pnlAttribute.Name = "_pnlAttribute";
            //
            // _radFilterCustom
            //
            resources.ApplyResources(this._radFilterCustom, "_radFilterCustom");
            this._radFilterCustom.Name = "_radFilterCustom";
            this._radFilterCustom.TabStop = true;
            this._ttpMain.SetToolTip(this._radFilterCustom, resources.GetString("_radFilterCustom.ToolTip"));
            this._radFilterCustom.UseVisualStyleBackColor = true;
            this._radFilterCustom.CheckedChanged += new System.EventHandler(this.Event_FilterRadioButton_CheckedChanged);
            //
            // _radFilterAnim
            //
            resources.ApplyResources(this._radFilterAnim, "_radFilterAnim");
            this._radFilterAnim.Name = "_radFilterAnim";
            this._radFilterAnim.TabStop = true;
            this._ttpMain.SetToolTip(this._radFilterAnim, resources.GetString("_radFilterAnim.ToolTip"));
            this._radFilterAnim.UseVisualStyleBackColor = true;
            this._radFilterAnim.CheckedChanged += new System.EventHandler(this.Event_FilterRadioButton_CheckedChanged);
            //
            // _radFilterBasic
            //
            resources.ApplyResources(this._radFilterBasic, "_radFilterBasic");
            this._radFilterBasic.Name = "_radFilterBasic";
            this._radFilterBasic.TabStop = true;
            this._ttpMain.SetToolTip(this._radFilterBasic, resources.GetString("_radFilterBasic.ToolTip"));
            this._radFilterBasic.UseVisualStyleBackColor = true;
            this._radFilterBasic.CheckedChanged += new System.EventHandler(this.Event_FilterRadioButton_CheckedChanged);
            //
            // _radFilterNone
            //
            resources.ApplyResources(this._radFilterNone, "_radFilterNone");
            this._radFilterNone.Name = "_radFilterNone";
            this._radFilterNone.TabStop = true;
            this._ttpMain.SetToolTip(this._radFilterNone, resources.GetString("_radFilterNone.ToolTip"));
            this._radFilterNone.UseVisualStyleBackColor = true;
            this._radFilterNone.CheckedChanged += new System.EventHandler(this.Event_FilterRadioButton_CheckedChanged);
            //
            // _cmbUserFilter
            //
            resources.ApplyResources(this._cmbUserFilter, "_cmbUserFilter");
            this._cmbUserFilter.BackColor = System.Drawing.SystemColors.Window;
            this._cmbUserFilter.DrawMode = System.Windows.Forms.DrawMode.OwnerDrawFixed;
            this._cmbUserFilter.FormattingEnabled = true;
            this._cmbUserFilter.Name = "_cmbUserFilter";
            this._cmbUserFilter.SelectedItemData = null;
            this._ttpMain.SetToolTip(this._cmbUserFilter, resources.GetString("_cmbUserFilter.ToolTip"));
            this._cmbUserFilter.DrawItem += new System.Windows.Forms.DrawItemEventHandler(this.Event_CmbUserFilter_DrawItem);
            this._cmbUserFilter.SelectedIndexChanged += new System.EventHandler(this.Event_CmbUserFilter_SelectedIndexChanged);
            //
            // _pnlTimeControl
            //
            resources.ApplyResources(this._pnlTimeControl, "_pnlTimeControl");
            this._pnlTimeControl.Name = "_pnlTimeControl";
            //
            // _ctlTimeNumLine
            //
            resources.ApplyResources(this._ctlTimeNumLine, "_ctlTimeNumLine");
            this._ctlTimeNumLine.BackColor = System.Drawing.Color.White;
            this._ctlTimeNumLine.Name = "_ctlTimeNumLine";
            this._ctlTimeNumLine.BeginDrag += new System.EventHandler(this._ctlTimeNumLine_BeginDrag);
            this._ctlTimeNumLine.EndDrag += new System.EventHandler(this._ctlTimeNumLine_EndDrag);
            //
            // _pnlBottom
            //
            this._pnlBottom.BackColor = System.Drawing.SystemColors.ControlLight;
            this._pnlBottom.Controls.Add(this._ctlPlay);
            this._pnlBottom.Controls.Add(this._ctlTimeNumLine);
            this._pnlBottom.Controls.Add(this._pnlTimeControl);
            resources.ApplyResources(this._pnlBottom, "_pnlBottom");
            this._pnlBottom.Name = "_pnlBottom";
            //
            // _ctlPlay
            //
            resources.ApplyResources(this._ctlPlay, "_ctlPlay");
            this._ctlPlay.Name = "_ctlPlay";
            //
            // CurveEditWindow
            //
            resources.ApplyResources(this, "$this");
            this.Controls.Add(this._pnlTop);
            this.Controls.Add(this._tspCurveEditor);
            this.Controls.Add(this._pnlBottom);
            this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.SizableToolWindow;
            this.KeyPreview = true;
            this.Name = "CurveEditWindow";
            this.VisibleChanged += new System.EventHandler(this.Event_CurveEditWindow_VisibleChanged);
            this._tspCurveEditor.ResumeLayout(false);
            this._tspCurveEditor.PerformLayout();
            this._pnlTop.ResumeLayout(false);
            this._pnlGraphBase.ResumeLayout(false);
            this._pnlAttribute.ResumeLayout(false);
            this._pnlBottom.ResumeLayout(false);
            this.ResumeLayout(false);
            this.PerformLayout();

        }
        #endregion

        #endregion // ---------------- フィールド：コントロール ----------------

        #region フィールド

        // 編集対象のアトリビュート
        TargetAnmAttributeSet _targetAttrSet = new TargetAnmAttributeSet();

        // 選択カーブを自動的に表示するか？永続化されるパラメータです。
        bool _showSelectedEnable = true;
        bool _bPasteAsRelativeValue = true;

        // ノード生成と、生成したノードの検索を処理するクラス。
        AttributeTreeFactory _attributeTreeFactory = new AttributeTreeFactory();

        // アンメーションカーブ操作クラス
        AnmCurveManipulator _anmCurveMnp = new AnmCurveManipulator();
        // キーフレーム操作クラス
        AnmKeyFrameManipulator _currentKeyFrameMnp = new AnmKeyFrameManipulator();
        // サブシーン操作クラス
        SubSceneManipulator _subSceneMnp = new SubSceneManipulator();
        // 複数ノード選択管理クラス
        readonly MultiSelectTreeNodeMgr _multiSelectTreeNodeMgr;
        // 時間スケール調整ダイアログ
        Dialogs.TimeScaleEditDlg _timeScaleEditDlg;

        // 矢印キー移動量設定ダイアログ
        ArrowKeySpeedSettingsDlg _ArrowKeySpeedSettingsDlg = new ArrowKeySpeedSettingsDlg();

        // 編集対象のサブシーン
        private ISubScene _TargetSubScene = null;

        SolidBrush _ownerDrawBrush = new SolidBrush(Color.Black);
        Pen _ownerDrawPen = new Pen(Color.Black);

        Image _animCurveIcon = null;

        ShortcutHandler _shortcutHandler = null;

        // アニメーション再生を止めているかどうか
        private bool _IsPlayControlSuspended = false;

        #endregion フィールド

        #region プロパティ
        /// <summary>
        /// 操作対象キーフレーム
        /// </summary>
        IAnmKeyFrame _CurrentKeyFrame
        {
            get
            {
                IAnmKeyFrame[] keySet = _SelectedKeyFrameSet;
                if( keySet != null && keySet.Length != 0 )
                {
                    return keySet[0];
                }

                return null;
            }
        }

        /// <summary>
        /// 操作対象サブシーンを取得します。
        /// </summary>
        ISubScene _CurrentISubScene
        {
            get { return LECore.LayoutEditorCore.Scene.CurrentISubScene; }
        }

        /// <summary>
        /// 操作対象アニメーションカーブ
        /// </summary>
        IAnmCurve[] _TargetCurveSet
        {
            get { return _targetAttrSet._TargetCurveSet; }
        }

        /// <summary>
        /// 操作対象キーフレーム
        /// </summary>
        IAnmKeyFrame[] _TargetKeyFrameSet
        {
            get { return _targetAttrSet._TargetKeyFrameSet; }
        }

        /// <summary>
        /// 選択キーフレーム
        /// </summary>
        IAnmKeyFrame[] _SelectedKeyFrameSet
        {
            get { return _targetAttrSet._SelectedKeyFrameSet; }
        }

        /// <summary>
        /// 前後区間キーを表示するか
        /// </summary>
        bool DispBeforeAfterKeyInfo
        {
            get
            {
                return _ctlGraphView.DispBeforeAfterKeyInfo;
            }
            set
            {
                if (value)
                {
                    _btnBeforeAfterKey.Image = Properties.Resources.Icon_PreviewSectionKey_On;
                }
                else
                {
                    _btnBeforeAfterKey.Image = Properties.Resources.Icon_PreviewSectionKey_Off;
                }
                _ctlGraphView.DispBeforeAfterKeyInfo = value;
                _ctlGraphView.Invalidate();
            }
        }

        #endregion

        #region ----------------- 外部非公開メソッド -----------------

        /// <summary>
        /// キー選択変更ハンドラ
        /// </summary>
        void OnGraphViewKeyFrameSelectionChanged_( GraphView.ChangeEvent kind )
        {
            switch( kind )
            {
                case GraphView.ChangeEvent.KeySelectionChange:
                // 編集中のキーフレームの情報を更新
                ChangedCurrentAnmKeyFrameTextBoxView_();
                break;
                // 編集中のカーブの情報を更新
                case GraphView.ChangeEvent.TargetCurveChange:
                _ctlPlay.UpdateProperty();
                _pnlTimeControl.UpdateProperty();
                break;
                default:
                Debug.Assert( false );
                break;
            }
        }

        /// <summary>
        /// 前後のキーの時間を取得する関数
        /// </summary>
        bool GetNeighborKeyTimeFunction_(
            float currentTime,
            bool bPrev,
            ref float neighborTime )
        {
            // 対象キーを取得
            IAnmKeyFrame[] keySet = _TargetKeyFrameSet;
            if( keySet.Length <= 0 )
            {
                return false;
            }

            // 時間でソート
            AnmKeyFrameComparer comparer = new AnmKeyFrameComparer();
            Array.Sort( keySet, comparer );

            // 取得する情報に応じて...
            if( bPrev )
            {

                for( int i = keySet.Length - 1 ; i >= 0 ; i-- )
                {
                    if( currentTime > keySet[i].Time &&
                        GlobalTime.Inst.CheckInPlayRange( keySet[i].Time ) )
                    {
                        neighborTime = keySet[i].Time;
                        return true;
                    }
                }

                // 発見できなかったら最終キーを返すように試みる。
                for( int i = keySet.Length - 1 ; i >= 0 ; i-- )
                {
                    if( GlobalTime.Inst.AnimPlayEndTime >= keySet[i].Time )
                    {
                        neighborTime = keySet[i].Time;
                        return true;
                    }
                }
            }
            else
            {
                for( int i = 0 ; i < keySet.Length ; i++ )
                {
                    if( currentTime < keySet[i].Time &&
                        GlobalTime.Inst.CheckInPlayRange( keySet[i].Time ) )
                    {
                        neighborTime = keySet[i].Time;
                        return true;
                    }
                }

                // 発見できなかったら先頭キーを返すように試みる。
                for( int i = 0 ; i < keySet.Length ; i++ )
                {
                    if( GlobalTime.Inst.AnimPlayStartTime <= keySet[i].Time )
                    {
                        neighborTime = keySet[i].Time;
                        return true;
                    }
                }
            }
            // キーを発見できなかった。
            return false;
        }

        #endregion // ----------------- 外部非公開メソッド -----------------

        /// <summary>
        /// 選択中のカーブついて、キー生成を試みます
        /// </summary>
        public void CreateKeyFrameOnTargetCurve()
        {
            Debug.Assert(Visible);

            if (!_CurrentISubScene.IsAnimationEditable())
            {
                return;
            }

            IAnmCurve[] anmCurveSet = _TargetCurveSet;
            if (anmCurveSet.Length != 0)
            {
                _CurrentISubScene.BeginMassiveModify();
                foreach (IAnmCurve anmCurve in anmCurveSet)
                {
                    _anmCurveMnp.BindTarget(anmCurve);
                    _anmCurveMnp.MakeKeyFrameByCurrentState();
                }
                _CurrentISubScene.EndMassiveModify();
            }
        }

        /// <summary>
        /// カーブを全体表示します
        /// </summary>
        public void PreviewKeyAll(object args)
        {
            var paneSet = args as IEnumerable<IPane>;

            if (paneSet != null && _CurrentISubScene != null)
            {
                // ペインを選択状態にする
                _subSceneMnp.BindTarget(_CurrentISubScene);
                _subSceneMnp.BeginSelectSetChange();
                _subSceneMnp.ResetSelectedSet();
                foreach (IPane pane in paneSet)
                {
                    _subSceneMnp.SelectPanesByPaneRef(pane);
                }
                _subSceneMnp.EndSelectSetChange();

                // カーブエディタの選択状態を更新する
                {
                    // カーブエディタの対象ペインを更新します
                    Event_TsbLoadFromSelectedSet_Click(this, null);

                    // 対象のノードを一旦並列化
                    List<TreeNode> allNodeSet = new List<TreeNode>();
                    foreach (TreeNode node in _tvwTargetAttr.Nodes)
                    {
                        var nodes = GenericUtil.GetNodeRecursively<TreeNode>(node, (x) => x.Nodes.OfType<TreeNode>());
                        allNodeSet.AddRange(nodes);
                    }

                    // 並列化したノードから選択対象のアトリビュートを抽出
                    var attr = allNodeSet.Select<TreeNode, IAnmAttribute>(n => n.Tag as IAnmAttribute).Where(n => n.HasKey()).ToArray();
                    _targetAttrSet.SetTargetCurve(attr, IsAttributeValidToEdit_);

                    // アトリビュートから選択対象のノードを決める
                    TreeNode[] targetNodeSet = _multiSelectTreeNodeMgr.GetRelativeNodes(attr).ToArray();
                    _multiSelectTreeNodeMgr.SetActiveNode(targetNodeSet);
                }

                // カーブをフォーカスする
                Event_MniViewAll_Click(this, EventArgs.Empty);
            }
        }

        /// <summary>
        /// 指定したアトリビュートのカーブを表示対象にします
        /// </summary>
        public void ShowTargetAttributeCurve(IAnmAttribute[] attr)
        {
            // アトリビュートセットから対応するツリーノードの検索します
            Event_TsbLoadFromSelectedSet_Click(this, null); // カーブエディタの対象ペインを更新します
            TreeNode[] nodeSet = _multiSelectTreeNodeMgr.GetRelativeNodes(attr).ToArray();

            // 選択状態を変更します
            _multiSelectTreeNodeMgr.SetActiveNode(nodeSet);
            _targetAttrSet.SetTargetCurve(attr, IsAttributeValidToEdit_);

            // カーブをフォーカスする
            Event_MiViewSelectAll_Click(this, EventArgs.Empty);
        }

        #region 初期化、破壊
        /// <summary>
        /// コンストラクタ
        /// </summary>
        void InitializeImageList_()
        {
            Debug.Assert( _tvwTargetAttr.ImageList == null );

            _tvwTargetAttr.ImageList = new ImageList();
            _tvwTargetAttr.ImageList.ColorDepth = ColorDepth.Depth32Bit;

            _tvwTargetAttr.ImageList.Images.Add(ImageResMgr.GetManifestResourcePng("anm_attribute_notactive_16.png"));
            _tvwTargetAttr.ImageList.Images.Add(ImageResMgr.GetManifestResourcePng("anm_attributeset_notactive_16.png"));
            _tvwTargetAttr.ImageList.Images.Add(ImageResMgr.GetManifestResourcePng("anm_attribute_active_16.png"));
            _tvwTargetAttr.ImageList.Images.Add(ImageResMgr.GetManifestResourcePng("anm_attributeset_active_16.png"));

            _tvwTargetAttr.ImageList.Images.Add(ImageResMgr.GetManifestResourcePng("null_anim_hdn_16.png"));
            _tvwTargetAttr.ImageList.Images.Add(ImageResMgr.GetManifestResourcePng("null_anim_nrm_16.png"));
            _tvwTargetAttr.ImageList.Images.Add(ImageResMgr.GetManifestResourcePng("picture_anim_hdn_16.png"));
            _tvwTargetAttr.ImageList.Images.Add(ImageResMgr.GetManifestResourcePng("picture_anim_nrm_16.png"));
            _tvwTargetAttr.ImageList.Images.Add(ImageResMgr.GetManifestResourcePng("textbox_anim_hdn_16.png"));
            _tvwTargetAttr.ImageList.Images.Add(ImageResMgr.GetManifestResourcePng("textbox_anim_nrm_16.png"));
            _tvwTargetAttr.ImageList.Images.Add(ImageResMgr.GetManifestResourcePng("window_anim_hdn_16.png"));
            _tvwTargetAttr.ImageList.Images.Add(ImageResMgr.GetManifestResourcePng("window_anim_nrm_16.png"));
            _tvwTargetAttr.ImageList.Images.Add(ImageResMgr.GetManifestResourcePng("bounding_anim_hdn_16.png"));
            _tvwTargetAttr.ImageList.Images.Add(ImageResMgr.GetManifestResourcePng("bounding_anim_nrm_16.png"));
            _tvwTargetAttr.ImageList.Images.Add(ImageResMgr.GetManifestResourcePng("parts_anim_hdn_16.png"));
            _tvwTargetAttr.ImageList.Images.Add(ImageResMgr.GetManifestResourcePng("parts_anim_nrm_16.png"));
            _tvwTargetAttr.ImageList.Images.Add(ImageResMgr.GetManifestResourcePng("capture_anim_hdn_16.png"));
            _tvwTargetAttr.ImageList.Images.Add(ImageResMgr.GetManifestResourcePng("capture_anim_nrm_16.png"));
            _tvwTargetAttr.ImageList.Images.Add(ImageResMgr.GetManifestResourcePng("alignment_anim_hdn_16.png"));
            _tvwTargetAttr.ImageList.Images.Add(ImageResMgr.GetManifestResourcePng("alignment_anim_nrm_16.png"));
            _tvwTargetAttr.ImageList.Images.Add(ImageResMgr.GetManifestResourcePng("scissor_anim_hdn_16.png"));
            _tvwTargetAttr.ImageList.Images.Add(ImageResMgr.GetManifestResourcePng("scissor_anim_nrm_16.png"));

            _tvwTargetAttr.ImageList.Images.Add(PaneItemImageHelper.GetPaneImage(PaneKind.Null, false));
            _tvwTargetAttr.ImageList.Images.Add(PaneItemImageHelper.GetPaneImage(PaneKind.Null, true));
            _tvwTargetAttr.ImageList.Images.Add(PaneItemImageHelper.GetPaneImage(PaneKind.Picture, false));
            _tvwTargetAttr.ImageList.Images.Add(PaneItemImageHelper.GetPaneImage(PaneKind.Picture, true));
            _tvwTargetAttr.ImageList.Images.Add(PaneItemImageHelper.GetPaneImage(PaneKind.Textbox, false));
            _tvwTargetAttr.ImageList.Images.Add(PaneItemImageHelper.GetPaneImage(PaneKind.Textbox, true));
            _tvwTargetAttr.ImageList.Images.Add(PaneItemImageHelper.GetPaneImage(PaneKind.Window, false));
            _tvwTargetAttr.ImageList.Images.Add(PaneItemImageHelper.GetPaneImage(PaneKind.Window, true));
            _tvwTargetAttr.ImageList.Images.Add(PaneItemImageHelper.GetPaneImage(PaneKind.Bounding, false));
            _tvwTargetAttr.ImageList.Images.Add(PaneItemImageHelper.GetPaneImage(PaneKind.Bounding, true));
            _tvwTargetAttr.ImageList.Images.Add(PaneItemImageHelper.GetPaneImage(PaneKind.Parts, false));
            _tvwTargetAttr.ImageList.Images.Add(PaneItemImageHelper.GetPaneImage(PaneKind.Parts, true));
            _tvwTargetAttr.ImageList.Images.Add(PaneItemImageHelper.GetPaneImage(PaneKind.Capture, false));
            _tvwTargetAttr.ImageList.Images.Add(PaneItemImageHelper.GetPaneImage(PaneKind.Capture, true));
            _tvwTargetAttr.ImageList.Images.Add(PaneItemImageHelper.GetPaneImage(PaneKind.Alignment, false));
            _tvwTargetAttr.ImageList.Images.Add(PaneItemImageHelper.GetPaneImage(PaneKind.Alignment, true));
            _tvwTargetAttr.ImageList.Images.Add(PaneItemImageHelper.GetPaneImage(PaneKind.Scissor, false));
            _tvwTargetAttr.ImageList.Images.Add(PaneItemImageHelper.GetPaneImage(PaneKind.Scissor, true));

            _tvwTargetAttr.ImageList.Images.Add(ImageResMgr.GetManifestResourcePng("readonly_lock_curve.png"));
            _tvwTargetAttr.ImageList.Images.Add(ImageResMgr.GetManifestResourcePng("readonly_lock_curve_notactive.png"));

            // オーバーレイアイコン登録
            _tvwTargetAttr.ImageList.Images.Add(PaneItemImageHelper.GetAnimationOverrayIcon());
            int animationOverrayIconIndex = _tvwTargetAttr.ImageList.Images.Count - 1;
            OverlayIconHelper.ImageList_SetOverlayImage(_tvwTargetAttr.ImageList.Handle, animationOverrayIconIndex, AttributeTreeAppearanceUpdater.AnimationOverrayIconIdx);
        }

        /// <summary>
        ///
        /// </summary>
        private KeyValuePair<string, string>[] GetNodeTextConvertionMap_()
        {
            List<KeyValuePair<string, string>> nodeTextConvertionMap = new List<KeyValuePair<string, string>>();

            // 表記をコンパクトに短縮するための置換ルール
            nodeTextConvertionMap.AddRange(
                new KeyValuePair<string, string>[]
                {
                    new KeyValuePair<string,string>("Picture/", ""),
                    new KeyValuePair<string,string>("picture/", ""),
                    new KeyValuePair<string,string>("Window/", ""),
                    new KeyValuePair<string,string>("TextBox/", ""),
                    new KeyValuePair<string,string>("Material/", ""),
                    new KeyValuePair<string,string>("material/", ""),
                    new KeyValuePair<string,string>("Pane/", ""),
                    new KeyValuePair<string,string>("pane/", ""),
                    new KeyValuePair<string,string>("Texture_0/", ""),
                    new KeyValuePair<string,string>("Texture_1/", ""),
                    new KeyValuePair<string,string>("Texture_2/", ""),
                });

            // 日本語動作の際は日本語表記に訂正します。
            // 通常のローカライズ経路に乗せる必要はないため、ハードコードしています。
            if (Thread.CurrentThread.CurrentUICulture.Name == "ja-JP")
            {
                nodeTextConvertionMap.AddRange(
                    new KeyValuePair<string, string>[]
                    {
                        new KeyValuePair<string,string>("CharTransform", "文字毎の変換："),
                        new KeyValuePair<string,string>("TimeOffset", "時間オフセット"),
                        new KeyValuePair<string,string>("TimeWidth", "時間幅"),
                        new KeyValuePair<string,string>("ProceduralShape", "角丸"),
                        new KeyValuePair<string,string>("exp", "形状"),
                        new KeyValuePair<string,string>("radius", "角丸半径"),
                        new KeyValuePair<string,string>("innerStrokeSize", "境界線サイズ"),
                        new KeyValuePair<string,string>("innerStrokeColor", "境界線カラー"),
                        new KeyValuePair<string,string>("innerShadowColor", "ドロップシャドウ(内側)カラー"),
                        new KeyValuePair<string,string>("innerShadowAngle", "ドロップシャドウ(内側)角度"),
                        new KeyValuePair<string,string>("innerShadowDistance", "ドロップシャドウ(内側)距離"),
                        new KeyValuePair<string,string>("innerShadowSize", "ドロップシャドウ(内側)サイズ"),
                        new KeyValuePair<string,string>("colorOverlayColor", "カラーオーバーレイカラー"),
                        new KeyValuePair<string,string>("gradationOverlay", "グラデーションオーバーレイ"),
                        new KeyValuePair<string,string>("ControlPoint", "コントロールポイント"),
                        new KeyValuePair<string,string>("outerShadowColor", "ドロップシャドウ(外側)カラー"),
                        new KeyValuePair<string,string>("outerShadowAngle", "ドロップシャドウ(外側)角度"),
                        new KeyValuePair<string,string>("outerShadowDistance", "ドロップシャドウ(外側)距離"),
                        new KeyValuePair<string,string>("outerShadowSize", "ドロップシャドウ(外側)サイズ"),
                        new KeyValuePair<string,string>("DropShadow", "ドロップシャドウ効果"),
                        new KeyValuePair<string,string>("stroke", "境界線"),
                        new KeyValuePair<string,string>("outerGlow", "光彩"),
                        new KeyValuePair<string,string>("dropShadow", "ドロップシャドウ"),
                        new KeyValuePair<string,string>("Size", "サイズ"),
                        new KeyValuePair<string,string>("Spread", "スプレッド"),
                        new KeyValuePair<string,string>("Color", "カラー"),
                        new KeyValuePair<string,string>("Angle", "角度"),
                        new KeyValuePair<string,string>("Distance", "距離"),
                        new KeyValuePair<string,string>("Shadow", "影"),
                        new KeyValuePair<string,string>("pos", "位置"),
                        new KeyValuePair<string,string>("Picture", "ピクチャ"),
                        new KeyValuePair<string,string>("picture", "ピクチャ"),
                        new KeyValuePair<string,string>("pane", "ペイン"),
                        new KeyValuePair<string,string>("Pane", "ペイン"),
                        new KeyValuePair<string,string>("material", "マテリアル"),
                        new KeyValuePair<string,string>("TextBox", "テキストボックス"),
                        new KeyValuePair<string,string>("Window", "ウインドウ"),
                        new KeyValuePair<string,string>("size", "サイズ"),
                        new KeyValuePair<string,string>("scale", "スケール"),
                        new KeyValuePair<string,string>("transparency", "透明度"),
                        new KeyValuePair<string,string>("visible", "表示・非表示"),
                        new KeyValuePair<string,string>("Mask", "マスク"),
                        new KeyValuePair<string,string>("vertex_colors", "頂点カラー"),
                        new KeyValuePair<string,string>("vtx_col", "頂点カラー"),
                        new KeyValuePair<string,string>("rotate", "回転"),
                        new KeyValuePair<string,string>("WhiteColor", "白カラー"),
                        new KeyValuePair<string,string>("BlackColor", "黒カラー"),
                        new KeyValuePair<string,string>("TopColor", "上端カラー"),
                        new KeyValuePair<string,string>("BottomColor", "下端カラー"),
                        new KeyValuePair<string,string>("MaterialTexMap_", "テクスチャ"),
                        new KeyValuePair<string,string>("Texture_Mtx_", "テクスチャ行列"),
                        new KeyValuePair<string,string>("Texture_", "テクスチャ"),
                        new KeyValuePair<string,string>("IndirectMtx", "インダイレクト"),
                        new KeyValuePair<string,string>("AlphaTestValue", "アルファテスト"),
                        new KeyValuePair<string,string>("DetailedMaterial", "詳細マテリアル"),
                        new KeyValuePair<string,string>("Trans", "移動"),
                        new KeyValuePair<string,string>("Scale", "スケール"),
                        new KeyValuePair<string,string>("Rotate", "回転"),
                        new KeyValuePair<string,string>("TexPatternAnm_", "テクスチャパターン"),
                        new KeyValuePair<string,string>("AlphaTestValue", "アルファテスト"),
                        new KeyValuePair<string,string>("FrameSize", "フレームサイズ"),
                        new KeyValuePair<string,string>("Top", "上"),
                        new KeyValuePair<string,string>("Bottom", "下"),
                        new KeyValuePair<string,string>("Left", "左"),
                        new KeyValuePair<string,string>("Right", "右"),
                });
            }

            return nodeTextConvertionMap.ToArray();
        }

        /// <summary>
        /// コンストラクタ
        /// </summary>
        public CurveEditWindow()
        {
            // この呼び出しは、Windows.Forms フォーム デザイナで必要です。
            InitializeComponent();

            _ctlTimeNumLine.Initialize(GlobalTime.Inst);

            _ctlGraphView.OnChange
                += new GraphView.OnChangeHandler( OnGraphViewKeyFrameSelectionChanged_ );

            _ctlGraphView.OnMouseModeChange += new EventHandler( Event_CtlGraphView_OnMouseModeChange );

            // 編集対象を設定。
            this._targetAttrSet.ParentWindow = this;
            _ctlGraphView.TargetAnmAttributeSet = this._targetAttrSet;

            _ctlGraphView.ParentWindow = this;


            ChangedCurrentAnmKeyFrameTextBoxView_();


            _targetAttrSet.OnTargetCurveChange += OnTargetCurveChange_;

            _ctlPlay.GetNeighborKeyTimeFunc = new PlayContorolPanel.GetNeighborKeyTimeFunction( GetNeighborKeyTimeFunction_ );

            // ----------------- メニューアイテムTag関連の初期化
            _tmiPreInfinityCycle.Tag = AnmCurveInfinityType.Cycle;
            _tmiPreInfinityConstant.Tag = AnmCurveInfinityType.Constant;

            _tmiPostInfinityCycle.Tag = AnmCurveInfinityType.Cycle;
            _tmiPostInfinityConstant.Tag = AnmCurveInfinityType.Constant;

            // MultiSelectTreeNodeMg関連の初期化
            _multiSelectTreeNodeMgr = new MultiSelectTreeNodeMgr( _tvwTargetAttr );
            _multiSelectTreeNodeMgr.ChangeSelecetItemByMouse += SelectPaneByNodeSet_;
            _multiSelectTreeNodeMgr.CheckNodeContentSelected += CheckNodeContentSelected_;

            _multiSelectTreeNodeMgr.SetNodeApperanceSelected +=
                AttributeTreeAppearanceUpdater.SetNodeAppearenceSelected;
            _multiSelectTreeNodeMgr.ResetNodeApperanceSelected +=
                AttributeTreeAppearanceUpdater.ResetNodeAppearenceSelected;
            _multiSelectTreeNodeMgr.SelectRecursive = true;

            // コンストラクタで、初期値を設定します。
            // 関連するボタンの有効状態を正しく更新するために、
            // ハンドラを呼びたいためです。
            _tsbAutoLoadEnabled.Checked = true;

            // TreeNodeFactory関連
            _attributeTreeFactory.AttributeFilters.CurrentFilterStateChanged += AttributeFilters_CurrentFilterStateChanged_;
            _attributeTreeFactory.AttributeFilters.Clear();
            _attributeTreeFactory.DefaultBackColor = this._tvwTargetAttr.BackColor;
            _attributeTreeFactory.InitNodeTextConversionMap(GetNodeTextConvertionMap_());

            _radFilterNone.Tag = _attributeTreeFactory.AttributeFilters.AttributeFilterSet.FirstOrDefault((flt) => flt is NoneAttributeFilter);
            _radFilterBasic.Tag = _attributeTreeFactory.AttributeFilters.AttributeFilterSet.FirstOrDefault((flt) => flt is BasicPaneAttributeFilter);
            _radFilterAnim.Tag = _attributeTreeFactory.AttributeFilters.AttributeFilterSet.FirstOrDefault((flt) => flt is AnimatedAttributeFilter);

            _radFilterBasic.SetCheckedByTag(_attributeTreeFactory.AttributeFilters.CurrentFilter);
            _radFilterAnim.SetCheckedByTag(_attributeTreeFactory.AttributeFilters.CurrentFilter);

            _cmbValueSnap.Items.Add(new UIListControlItem(" -- ", GraphValueSnap.None));
            _cmbValueSnap.Items.Add(new UIListControlItem("0.01", GraphValueSnap._001));
            _cmbValueSnap.Items.Add(new UIListControlItem("0.1", GraphValueSnap._01));
            _cmbValueSnap.Items.Add(new UIListControlItem("1", GraphValueSnap._1));
            _cmbValueSnap.Items.Add(new UIListControlItem("10", GraphValueSnap._10));
            _cmbValueSnap.SelectedIndex = 0;

            // 時間範囲の設定
            SetTimeRange_( GlobalTime.Inst );


            // 時間スケール調整ダイアログの初期化
            _timeScaleEditDlg = new Dialogs.TimeScaleEditDlg( GetTargetAnmCurve_, SelectKeys_ );


            ToolStripMenuItemHelper.ToolStripMessageFilter.BindMessageFilter( _tspCurveEditor );

            // 画像リストの初期化
            InitializeImageList_();

            _animCurveIcon = ImageResMgr.GetManifestResourcePng("Filter_Anim.png");

            // フィッティングモードの初期設定
            toolStripSeparator4.Visible = false;
            _btnFitting.Visible = false;

            // 前後区間キー操作の初期設定
            toolStripSeparator15.Visible = false;
            _btnBeforeAfterKey.Visible = false;
            _btnBeforeKeySnap.Visible = false;
            _btnAfterKeySnap.Visible = false;

            // ドッキングウインドウ用のショートカットの自前処理の設定
            _shortcutHandler = new ShortcutHandler(_tspCurveEditor);

            // 有効状態の更新
            UpdateCurveEditorEnable_();
        }

        #region AttributeFilters関連ハンドラ
        /// <summary>
        /// AttributeFilters変更
        /// </summary>
        void AttributeFilters_CurrentFilterStateChanged_( AttributeFilterManager.EventKind kind )
        {
            switch( kind )
            {
                case AttributeFilterManager.EventKind.CurrentFilterChanged:
                {
                    SetTargetAttributeForcibly_(_targetAttrSet._TargetAttributeSet);
                    break;
                }
                case AttributeFilterManager.EventKind.FilterSetModified:
                {
                    UpdateAttributeFilterComboBox_();
                    break;
                }
                default:
                {
                    Debug.Assert( false );
                    break;
                }
            }
        }

        #endregion AttributeFilters関連ハンドラ

        #region MultiSelectTreeNodeMgr 関連

        /// <summary>
        /// 選択ノード変更の通知を受けて、
        /// ターゲットアトリビュートの情報を更新します。
        /// </summary>
        /// <param name="nodeSet"></param>
        void SelectPaneByNodeSet_( TreeNode[] nodeSet )
        {
            List<IAnmAttribute> attrSet = new List<IAnmAttribute>();

            foreach( TreeNode node in nodeSet )
            {
                // リーフノードのみを対象として選択処理します。
                if( node.Tag is IAnmAttribute )
                {
                    IAnmAttribute attribute = node.Tag as IAnmAttribute;
                    if( attribute.HasAnimationCurve )
                    {
                        attrSet.Add( attribute );
                    }
                }
            }

            _targetAttrSet.SetTargetCurve(attrSet.ToArray(), IsAttributeValidToEdit_);
        }

        /// <summary>
        /// TreeNode.Tagが編集対象か判断します。
        /// </summary>
        bool CheckNodeContentSelected_( TreeNode node )
        {
            if( node.Tag is IAnmAttribute )
            {
                IAnmCurve curve = ( node.Tag as IAnmAttribute ).ICurrentAnimationCurve;
                return _targetAttrSet.Contains( curve );
            }

            return false;
        }

        #endregion

        /// <summary>
        /// 対象カーブ変更ハンドラ
        /// SetTargetCurveToCurveInfoView_
        /// </summary>
        void OnTargetCurveChange_( object sender, EventArgs args )
        {
            TargetAnmAttributeSet targetSet = sender as TargetAnmAttributeSet;

            if( targetSet._TargetCurveSet.Length != 0 )
            {
                _ctlTimeNumLine.SetTraget(targetSet._TargetCurveSet, _CurrentISubScene?.IAnimFrameSectionSet?.TargetIAnimFrameSection);
                ChangedCurrentAnmKeyFrameTextBoxView_();
            }
            else
            {
                _ctlTimeNumLine.ResetTraget();
            }

            // GraphViewの再描画
            _ctlGraphView.Invalidate();
        }


        /// <summary>
        /// 使用されているリソースに後処理を実行します。
        /// </summary>
        protected override void Dispose( bool disposing )
        {
            base.Dispose( disposing );
        }
        #endregion 初期化、破壊

        #region ターゲットの設定

        #region キーフレーム情報の更新

        /// <summary>
        /// 小数点以下の桁数を取得します。
        /// </summary>
        int GetScale_(float keyVal)
        {
            string keyValString = keyVal.ToString().TrimEnd('0');

            int index = keyValString.IndexOf('.');
            if (index == -1)
            {
                return 0;
            }

            return keyValString.Substring(index + 1).Length;
        }

        /// <summary>
        /// フォーマット整形された、キー値文字列を取得します。
        /// </summary>
        string GetKeyValueFormatedText_(float keyVal)
        {
            // 小数桁は、最小で2桁、最大は制限せずに表示します。
            int scale = Math.Max(GetScale_(keyVal), 2);
            return string.Format("{0, 0:f" + scale.ToString() + "}", keyVal);
        }

        /// <summary>
        /// 現在の編集対象アニメーションカーブのキーフレーム情報をテキストボックスに表示します。
        /// </summary>
        void ChangedCurrentAnmKeyFrameTextBoxView_()
        {
            // 選択中のキーから、最初に選択されたキーの情報を表示します。
            IAnmKeyFrame key = _CurrentKeyFrame;
            if( key != null )
            {

                _ttbKeyTime.Enabled = true;
                _ttbKeyValue.Enabled = true;

                _ttbKeyTime.SetValue( key.Time.ToString() );
                _ttbKeyValue.SetValue(GetKeyValueFormatedText_(key.ValueAsFloat));

                _tsbPrevKey.Enabled = key.OwnerIAnmCurve.GetPrevKeyFrame( key ) != null;
                _tsbNextKey.Enabled = key.OwnerIAnmCurve.GetNextKeyFrame( key ) != null;
            }
            else
            {
                _ttbKeyTime.Enabled = false;
                _ttbKeyValue.Enabled = false;

                _tsbPrevKey.Enabled = false;
                _tsbNextKey.Enabled = false;
            }
        }


        #endregion キーフレーム情報の更新

        #region Viewの再構築処理

        /// <summary>
        /// 再構築する必要があるViewの再構築を行います。
        /// </summary>
        void RebuildAttributeTree_(
            IAnmAttribute[] targetAttrSet )
        {

            // アトリビュートツリー編集開始
            _tvwTargetAttr.BeginUpdate();
            _tvwTargetAttr.SuspendLayout();


            // ツリーノードの再構築
            _tvwTargetAttr.Nodes.Clear();
            List<TreeNode> newTree = _attributeTreeFactory.RebuildTreeView( targetAttrSet );
            foreach( TreeNode newNode in newTree )
            {
                _tvwTargetAttr.Nodes.Add( newNode );
            }

            // 選択状態の更新
            _multiSelectTreeNodeMgr.UpdateSelectedNodeByNodeContent();

            // ノード表示状態の更新
            AttributeTreeAppearanceUpdater.UpdateNodeKeyState(
                NodeFindFunction_, _targetAttrSet._AllAnmAttributeSet.ToArray());

            // ノード開閉の調整。
            UpdateTreeNodeCollapse_(_tvwTargetAttr);

            // アトリビュートツリー編集終了
            _tvwTargetAttr.ResumeLayout( true );
            _tvwTargetAttr.EndUpdate();
        }

        // ノード開閉を調整します。
        private void UpdateTreeNodeCollapse_(TreeView tvwTargetAttr)
        {
            // 必ず、ペイン基本は全開にしておく
            var paneNodes = PaneTreeViewHelper.GetAllNodeIf(_tvwTargetAttr, (node) => node.Tag is IPaneAttribute);
            foreach(var paneNode in paneNodes)
            {
                paneNode.ExpandAll();
                paneNode.EnsureVisible();
            }

            // アニメーションキーがあるノードはすべて開いておく。
            var animNodes = PaneTreeViewHelper.GetAllNodeIf(_tvwTargetAttr, (node) => node.Tag is IAnmAttribute && ((node.Tag as IAnmAttribute).HasKey()));
            foreach(TreeNode animNode in animNodes)
            {
                animNode.EnsureVisible();
            }
        }

        /// <summary>
        /// ノード検索関数
        /// </summary>
        /// <param name="curve"></param>
        /// <returns></returns>
        List<TreeNode> NodeFindFunction_( IAnmAttribute curve )
        {
            return _attributeTreeFactory.GetUpdatedNodeByContents( curve );
        }

        #endregion Viewの再構築処理

        /// <summary>
        /// 更新の必要があるか判定します。
        /// </summary>
        bool CheckNeedUpdate_( IAnmAttribute[] targetAttrSet )
        {
            IAnmAttribute[] currentAttributeSet = _targetAttrSet._TargetAttributeSet;

            if( targetAttrSet.Length != currentAttributeSet.Length )
            {
                return true;
            }

            foreach( IAnmAttribute attribute in targetAttrSet )
            {
                if( Array.IndexOf( currentAttributeSet, attribute ) == -1 )
                {
                    return true;
                }
            }

            // すべてが同一なので、更新の必要は無い
            return false;
        }

        /// <summary>
        ///
        /// </summary>
        void SetTargetAttribute_(IAnmAttribute[] targetAttrSet)
        {
            DoSetTargetAttribute_(targetAttrSet, false);
        }

        /// <summary>
        ///
        /// </summary>
        void SetTargetAttributeForcibly_(IAnmAttribute[] targetAttrSet)
        {
            DoSetTargetAttribute_(targetAttrSet, true);
        }

        /// <summary>
        /// 対象アトリビュートを設定します。
        /// リセット時にも使用されます。
        /// </summary>
        /// <param name="targetAttrSet"></param>
        void DoSetTargetAttribute_( IAnmAttribute[] targetAttrSet, bool forceUpdate)
        {
            // 更新の必要がなければ処理しません。
            if( !forceUpdate && !CheckNeedUpdate_( targetAttrSet ) )
            {
                return;
            }

            // ノードがあれば選択状態を保存しておきます。
            if (_tvwTargetAttr.Nodes.Count > 0)
            {
                _attributeTreeFactory.StoreState(
                    _targetAttrSet._TargetCurveSet, _tvwTargetAttr.Nodes);
            }

            // -------------- 過去の設定をリセット
            // -------------- 新しいターゲット情報を設定。
            _targetAttrSet.SetTargetAttribute(targetAttrSet, IsAttributeValidToEdit_);

            // -------------- ビューを再構築
            // ビューを再構築の必要があるか？
            if( this.Visible )
            {
                RebuildAttributeTree_( targetAttrSet );
            }
        }

        /// <summary>
        /// 編集対処かどうか判定します。
        /// </summary>
        private bool IsAttributeValidToEdit_(IAnmAttribute attr)
        {
            // アクティブな項目のみ表示するモードなら、アクティブか調べる
            if (_attributeTreeFactory.ShowActiveOnly && !attr.IsActiveAttribute)
            {
                return false;
            }

            // フィルタの対象ではないか調べる
            if (attr.ICurrentAnimationCurve != null)
            {
                if (_attributeTreeFactory.AttributeFilters.CurrentFilter != null &&
                    _attributeTreeFactory.AttributeFilters.CurrentFilter.Contains(attr))
                {
                    return false;
                }
            }

            return true;
        }

        /// <summary>
        /// カーブエディタの有効無効を更新します。
        /// </summary>
        private void UpdateCurveEditorEnable_()
        {
            bool enabled = IsEditable;
            _tspCurveEditor.Enabled = enabled;
            _ctlGraphView.Enabled = enabled;
            _pnlBottom.Enabled = enabled;
        }

        private bool IsEditable
        {
            get { return _TargetSubScene.IsAnimationEditable(); }
        }


        #endregion ターゲットの設定

        #region 状態更新(再描画)関連


        /// <summary>
        /// 再描画を行います。
        /// </summary>
        void UpdateProperty_()
        {
            LEToolWindow.DbgReportUpdate(this);

            // アトリビュートツリー周辺の更新
            UpdateAttributeFilter_();

            // グラフを再描画
            _ctlGraphView.Invalidate();

            // 時間目盛り表示を再描画
            _ctlTimeNumLine.Invalidate();

            // 編集中のキーフレームの情報を更新
            ChangedCurrentAnmKeyFrameTextBoxView_();

            // 時間コントロールを更新
            _pnlTimeControl.UpdateProperty();
            _ctlPlay.UpdateProperty();

            // メニュー関連を更新
            UpdateMenu_();
        }

        void UpdateAttributeFilter_()
        {
            _radFilterNone.SetCheckedByTag(_attributeTreeFactory.AttributeFilters.CurrentFilter);
            _radFilterBasic.SetCheckedByTag(_attributeTreeFactory.AttributeFilters.CurrentFilter);
            _radFilterAnim.SetCheckedByTag(_attributeTreeFactory.AttributeFilters.CurrentFilter);
            _radFilterCustom.Checked = !_radFilterNone.Checked && !_radFilterBasic.Checked && !_radFilterAnim.Checked;

            _cmbUserFilter.Enabled = _radFilterCustom.Checked;
        }

        /// <summary>
        /// メニュー表示状態を更新します。
        /// </summary>
        void UpdateMenu_()
        {
            _tsbOperationModeTweakNear.Checked = _ctlGraphView.MouseTweakMode == GraphView.GraphViewMouseTweakMode.TweakNear;
            _tsbOperationModeNormal.Checked = _ctlGraphView.MouseTweakMode == GraphView.GraphViewMouseTweakMode.Normal;
            _tsbOperationModeInsert.Checked = _ctlGraphView.MouseTweakMode == GraphView.GraphViewMouseTweakMode.InsertKeyToSelectedCurve;
            _tsbOperationModeAdd.Checked = _ctlGraphView.MouseTweakMode == GraphView.GraphViewMouseTweakMode.AddKeyToSelectedCurve;

            _tsbSetArrowKeySpeed.Checked = _ctlGraphView.ArrowKeySpeedSettings.Enabled;

            _cmbValueSnap.SelectByData(_ctlGraphView.GraphValueSnap);
        }

        /// <summary>
        /// フィッティングボタンの表示状態を更新します。
        /// </summary>
        void UpdateFittingBtn_(ISubScene subScene)
        {
            bool visible = subScene.IsAnimEditSeparateMode();

            toolStripSeparator4.Visible = visible;
            _btnFitting.Visible = visible;
        }

        /// <summary>
        /// 前後区間キー表示ボタンの表示状態を更新します。
        /// </summary>
        void UpdateBeforeAfterKeyBtn_(ISubScene subScene)
        {
            bool visible = subScene.IsAnimEditSeparateMode();

            toolStripSeparator15.Visible = visible;
            _btnBeforeAfterKey.Visible = visible;
            _btnBeforeKeySnap.Visible = visible;
            _btnAfterKeySnap.Visible = visible;

            _btnBeforeKeySnap.Enabled = this.DispBeforeAfterKeyInfo;
            _btnAfterKeySnap.Enabled = this.DispBeforeAfterKeyInfo;
        }

        /// <summary>
        /// 表示時間レンジを設定します。
        /// </summary>
        void SetTimeRange_( GlobalTime grobalTime )
        {
            // グローバル時間範囲パラメータの変更
            int anmStart = grobalTime.AnimStartTime;
            int anmEnd = grobalTime.AnimEndTime;
            int playStart = grobalTime.AnimPlayStartTime;
            int playEnd = grobalTime.AnimPlayEndTime;

            _ctlTimeNumLine.SetFrameRange( playStart, playEnd + 1 );

            // 時間コントロールのGUI更新
            _ctlPlay.UpdateProperty();
            _pnlTimeControl.UpdateProperty();
            _pnlTimeControl.Enabled = _CurrentISubScene != null;
        }

        /// <summary>
        /// ノードのオーナードロー
        /// </summary>
        private void Event_TvwTargetAttr_DrawNode(object sender, DrawTreeNodeEventArgs e)
        {
            if (!e.Node.IsVisible ||
                e.Node.Bounds.Bottom <= 0 ||
                e.Node.Bounds.Top >= e.Node.TreeView.Bottom)
            {
                e.DrawDefault = false;
                return;
            }

            e.DrawDefault = true;

            // 選択状態
            SizeF strSize = e.Graphics.MeasureString(e.Node.Text, e.Node.TreeView.Font);
            _ownerDrawBrush.Color = AttributeTreeAppearanceUpdater.GetNodeStateBGColor(e.Node);
            if (_ownerDrawBrush.Color != e.Node.TreeView.BackColor)
            {
                e.Graphics.FillRectangle(_ownerDrawBrush, Rectangle.FromLTRB(e.Bounds.Right - 12, e.Bounds.Top + 4, e.Bounds.Right- 4, e.Bounds.Bottom -4));
            }

            // 編集中カーブ
            _ownerDrawBrush.Color = AttributeTreeAppearanceUpdater.GetNodeTargetCurveBGColor(e.Node);
            if (_ownerDrawBrush.Color != e.Node.BackColor)
            {
                e.Graphics.FillRectangle(_ownerDrawBrush, Rectangle.FromLTRB(e.Bounds.Right - 12, e.Bounds.Top + 4, e.Bounds.Right - 4, e.Bounds.Bottom - 4));
            }

            // 読み取り専用
            _ownerDrawBrush.Color = AttributeTreeAppearanceUpdater.GetNodeReadonlyBGColor(e.Node);
            if (_ownerDrawPen.Color != e.Node.TreeView.BackColor)
            {
                e.Graphics.FillRectangle(_ownerDrawBrush, Rectangle.FromLTRB(e.Bounds.Right - 12, e.Bounds.Top + 4, e.Bounds.Right - 4, e.Bounds.Bottom - 4));
            }

            // Keyの有無...オーバーレイアイコンで表示するように変更
            _ownerDrawBrush.Color = AttributeTreeAppearanceUpdater.GetNodeKeyBGColor(e.Node);
            if (_ownerDrawBrush.Color != e.Node.TreeView.BackColor)
            {
                OverlayIconHelper.TreeViewOverlay(e.Node, AttributeTreeAppearanceUpdater.AnimationOverrayIconIdx);
            }
            else
            {
                OverlayIconHelper.TreeViewOverlay(e.Node, (uint)0);
            }

            // 要素カラー
            if (AttributeTreeAppearanceUpdater.GetNodeSelected(e.Node))
            {
                Color newColor = AttributeTreeAppearanceUpdater.GetNodeElmentBGColor(e.Node);
                _ownerDrawBrush.Color = newColor;
                e.Graphics.FillRectangle(_ownerDrawBrush, Rectangle.FromLTRB(e.Bounds.Right - 2, e.Bounds.Top, e.Bounds.Right, e.Bounds.Bottom));
            }
        }
        #endregion 状態更新(再描画)関連

        #region --------------- イベントハンドラ ---------------

        #region --------------- メニュー関連 ---------------

        #region 編集関連
        /// <summary>
        /// DropDownOpening
        /// </summary>
        private void Event_TdbEdit_DropDownOpening( object sender, EventArgs e )
        {
            _tmiPasteAsRelativeValue.Checked = _bPasteAsRelativeValue;
        }

        /// <summary>
        /// 取り消し
        /// </summary>
        private void Event_TmiUndo_Click( object sender, EventArgs e )
        {
            if( _CurrentISubScene == null )
            {
                return;
            }

            _subSceneMnp.BindTarget( _CurrentISubScene );
            _subSceneMnp.Undo();
        }

        /// <summary>
        /// やり直し
        /// </summary>
        private void Event_TmiRodo_Click( object sender, EventArgs e )
        {
            if( _CurrentISubScene == null )
            {
                return;
            }

            _subSceneMnp.BindTarget( _CurrentISubScene );
            _subSceneMnp.Redo();
        }

        /// <summary>
        /// フォーム中のテキストボックスにフォーカスがあるか調査します。
        /// </summary>
        bool CheckTextBoxFocused_( Control ctrl )
        {
            if( ctrl is TextBox && ctrl.Focused )
            {
                return true;
            }

            foreach( Control child in ctrl.Controls )
            {
                if( CheckTextBoxFocused_( child ) )
                {
                    return true;
                }
            }
            return false;
        }

        /// <summary>
        /// 削除
        /// </summary>
        private void Event_MniEditDelete_Click( object sender, System.EventArgs e )
        {
            // 選択アイテムを消去
            _targetAttrSet.BeginKeySelectChange();
            _targetAttrSet.DeleteSlectedKey();
            _targetAttrSet.EndKeySelectChange();
        }

        /// <summary>
        /// 切り取り
        /// </summary>
        private void Event_MniEditTear_Click( object sender, System.EventArgs e )
        {
            // 選択しているすべてのキーフレームをクリップボードにコピーします。
            Event_MniEditCopy_Click( sender, e );
            // 選択アイテムを消去
            Event_MniEditDelete_Click( sender, e );
        }

        /// <summary>
        /// コピー
        /// </summary>
        private void Event_MniEditCopy_Click( object sender, System.EventArgs e )
        {
            IAnmKeyFrame[]		keys			= _SelectedKeyFrameSet;
            IAnmAttribute[]	targetAttrSet	= GetTargetAttribute_();
            if( targetAttrSet.Length > 0 )
            {
                // LEClipboardAnmAttribute　配列を作成して、コピーします。
                LEClipboardAnmAttribute[] cbAttrSet = new LEClipboardAnmAttribute[targetAttrSet.Length];
                for( int i = 0 ; i < targetAttrSet.Length ; i++ )
                {
                    cbAttrSet[i] = new LEClipboardAnmAttribute( targetAttrSet[i], keys );
                }

                LECore.LayoutEditorCore.Scene.ILEClipboard.Copy( cbAttrSet );
            }
        }

        /// <summary>
        /// キーフレームを貼り付けます。
        /// </summary>
        void PasteKeyFrames_( IAnmAttribute dstAttribute, LEClipboardAnmAttribute srcAttribute, float timeOffset )
        {
            IAnmKeyFrame[] srcKeySet = srcAttribute.IKeyFrameSet;
            if( srcKeySet.Length > 0 )
            {
                _anmCurveMnp.BindTarget( dstAttribute.ICurrentAnimationCurve);

                // 時間オフセット、値オフセットを計算します。
                // Evaluate で得られれる値は表示スケールのかかった値のため、ViewScale で割って生の値を計算する。
                float dstRawValue = dstAttribute.ICurrentAnimationCurve.Evaluate(GlobalTime.Inst.Time) / dstAttribute.ICurrentAnimationCurve.ViewScale;
                float valueOffset = _bPasteAsRelativeValue ? dstRawValue - srcKeySet[0].ValueAsFloatNoEffect : 0.0f;

                foreach( IAnmKeyFrame key in srcKeySet )
                {
                    _anmCurveMnp.AddNewKey( key, timeOffset, valueOffset );
                }

                _anmCurveMnp.Update(true);
            }

            // 子供について再帰的に貼り付けを行います。
            for( int i = 0; i < srcAttribute.NumSubAttribute ; i++ )
            {
                PasteKeyFrames_( dstAttribute.FindSubAttributeByIdx( i ), srcAttribute.SubAttribute[i], timeOffset );
            }
        }

        /// <summary>
        /// 操作対象カーブの持ち主アトリビュートを集めます。
        /// </summary>
        IAnmAttribute[] GetTargetAttribute_()
        {
            // すべての操作対象カーブの持ち主アトリビュートを取得します。
            List<IAnmAttribute> targetAttrSet = new List<IAnmAttribute>();
            foreach( IAnmCurve curve in _targetAttrSet._TargetCurveSet )
            {
                IAnmAttribute result = _targetAttrSet.FindCurveOwnerAttribute( curve );
                if( result != null )
                {
                    targetAttrSet.Add( result );
                }
            }

            return targetAttrSet.ToArray();
        }

        /// <summary>
        /// アトリビュートセットを貼り付けます。
        /// srcAttrSetとdstAttrSetは同じ長さである必要があります。
        /// </summary>
        void PaseAttributeSet_( IAnmAttribute[] dstAttrSet, LEClipboardAnmAttribute[] srcAttrSet, float timeOffset )
        {
            Debug.Assert( srcAttrSet.Length == dstAttrSet.Length );

            // 貼り付けます。
            _CurrentISubScene.BeginMassiveModify();
            for( int i = 0 ; i < srcAttrSet.Length ; i++ )
            {
                if( LEClipboardAnmAttribute.CheckPasteValid( dstAttrSet[i], srcAttrSet[i] ) )
                {
                    PasteKeyFrames_( dstAttrSet[i], srcAttrSet[i], timeOffset );
                }
            }

            _CurrentISubScene.EndMassiveModify();
        }

        /// <summary>
        /// 貼り付け
        /// </summary>
        private void Event_MniEditPaste_Click( object sender, System.EventArgs e )
        {
            // 貼り付け元を取得します。
            LEClipboardAnmAttribute[] srcAttrSet =　
                LECore.LayoutEditorCore.Scene.ILEClipboard.Paste( typeof( LEClipboardAnmAttribute[] ) ) as LEClipboardAnmAttribute[];
            if( srcAttrSet != null )
            {
                // 貼り付け先を取得します。
                IAnmAttribute[] dstAttrSet = GetTargetAttribute_();

                // 実際にキーを持っている貼り付け元アトリビュート
                List<LEClipboardAnmAttribute> effectiveSrcAttrSet
                    = new List<LEClipboardAnmAttribute>();

                // 先頭キーフレームの位置から、時間オフセットを計算します。
                float keyFrameMinFrame = float.MaxValue;
                for( int i = 0 ; i < srcAttrSet.Length ; i++ )
                {
                    IAnmKeyFrame[] srcKeySet = srcAttrSet[i].IKeyFrameSet;
                    if( srcKeySet.Length > 0 )
                    {
                        keyFrameMinFrame = Math.Min( keyFrameMinFrame, srcKeySet[0].Time );
                        // キーフレームを持つアトリビュートのみを記憶します。
                        effectiveSrcAttrSet.Add( srcAttrSet[i] );
                    }
                }
                float timeOffset = GlobalTime.Inst.Time - keyFrameMinFrame;

                // まず、全体が貼り付けられそうなら...
                if( dstAttrSet.Length == srcAttrSet.Length )
                {
                    PaseAttributeSet_( dstAttrSet, srcAttrSet, timeOffset );
                }
                // だめなら、キーを持っている部分だけで、貼り付けを試みます。
                else if( dstAttrSet.Length == effectiveSrcAttrSet.Count )
                {
                    PaseAttributeSet_( dstAttrSet, effectiveSrcAttrSet.ToArray(), timeOffset );
                }
            }
        }


        /// <summary>
        /// 全体選択
        /// </summary>
        private void Event_MniEditSelectAll_Click( object sender, System.EventArgs e )
        {
            // _ctlGraphView.SelectAll();
            _targetAttrSet.BeginKeySelectChange();
            _targetAttrSet.SelectKey( _targetAttrSet._TargetKeyFrameSet );
            _targetAttrSet.EndKeySelectChange();

        }

        /// <summary>
        /// 相対値として貼り付ける
        /// </summary>
        private void Event_TmiPasteAsRelativeValue_Click( object sender, EventArgs e )
        {
            ToolStripMenuItem tmi = sender as ToolStripMenuItem;
            tmi.Checked = !tmi.Checked;

            _bPasteAsRelativeValue = tmi.Checked;
        }

        /// <summary>
        /// TimeScaleEditDlg に渡されるデリゲート用関数です。
        /// </summary>
        void SelectKeys_( IAnmKeyFrame[] keySet )
        {
            _targetAttrSet.BeginKeySelectChange();
            _targetAttrSet.ResetSelectKeyAll();
            _targetAttrSet.SelectKey( keySet );
            _targetAttrSet.EndKeySelectChange();
        }

        /// <summary>
        /// TimeScaleEditDlg に渡されるデリゲート用関数です。
        /// </summary>
        IAnmCurve[] GetTargetAnmCurve_()
        {
            return _targetAttrSet._TargetCurveSet;
        }

        /// <summary>
        /// 時間スケール調整
        /// </summary>
        private void Event_TmiTimeScale_Click( object sender, EventArgs e )
        {
            if (_timeScaleEditDlg.Visible)
            {
                // 一旦非表示にした後で Show して前面に表示する。
                _timeScaleEditDlg.Hide();
            }

            // ダイアログを開きます。
            _timeScaleEditDlg.Show();
        }

        #endregion 編集関連

        #region 表示関係

        /// <summary>
        /// ビュー：ポップアップ
        /// </summary>
        private void Event_MniView_Popup( object sender, EventArgs e )
        {
            // キー設定領域外の描画
            _tmiViewDrawInfinity.Checked = _ctlGraphView.DrawInifinity;
            _tmiShowOnlyActive.Checked = _attributeTreeFactory.ShowActiveOnly;
        }

        /// <summary>
        /// キーセットを含むようにビューを設定します。
        /// </summary>
        /// <param name="keySet"></param>
        void SetViewContainsKeySet_( IAnmKeyFrame[] keySet )
        {
            float minT = float.MaxValue;
            float maxT = float.MinValue;

            float minV = float.MaxValue;
            float maxV = float.MinValue;

            if( keySet.Length != 0 )
            {
                // キーをカーブごとにまとめる
                var keyMap = new Dictionary<IAnmCurve,List<IAnmKeyFrame>>();
                foreach (IAnmKeyFrame key in keySet)
                {
                    List<IAnmKeyFrame> keys;
                    if (!keyMap.TryGetValue(key.OwnerIAnmCurve, out keys))
                    {
                        keys = new List<IAnmKeyFrame>();
                        keys.Add(key);
                        keyMap.Add(key.OwnerIAnmCurve, keys);
                    }
                    else
                    {
                        keys.Add(key);
                    }
                }

                // カーブ毎のキーごとに...
                foreach (List<IAnmKeyFrame> curveKeys in keyMap.Values)
                {
                    curveKeys.Sort(delegate (IAnmKeyFrame key1, IAnmKeyFrame key2)
                    {
                        if (key2.Time - key1.Time > 0)
                        {
                            return -1;
                        }
                        else if (key2.Time - key1.Time < 0)
                        {
                            return 1;
                        }
                        else
                        {
                            return 0;
                        }
                    });

                    // キーが一つだけの場合は最初のキーの前と最後キーの後も追加で処理する。
                    if (curveKeys.Count == 1)
                    {
                        var prevKey = curveKeys[0].OwnerIAnmCurve.GetPrevKeyFrame(curveKeys[0]);
                        if (prevKey != null && !curveKeys.Contains(prevKey))
                        {
                            curveKeys.Insert(0, prevKey);
                        }

                        var nextKey = curveKeys[0].OwnerIAnmCurve.GetNextKeyFrame(curveKeys[curveKeys.Count -1]);
                        if (nextKey != null && !curveKeys.Contains(nextKey))
                        {
                            curveKeys.Add(nextKey);
                        }
                    }

                    if (curveKeys.Count == 1)
                    {
                        // 選択キーがひとつの場合
                        minT = Math.Min(curveKeys[0].Time, minT);
                        maxT = Math.Max(curveKeys[0].Time, maxT);

                        float val = curveKeys[0].ValueAsFloat;
                        minV = Math.Min(val, minV);
                        maxV = Math.Max(val, maxV);
                    }
                    else
                    {
                        // 選択キーが複数の場合
                        // カーブを評価しながら最大値、最小値を計算する。
                        for (int i = 0; i < curveKeys.Count - 1; i++)
                        {
                            // 適当に４分割くらい
                            float dTime = (curveKeys[i + 1].Time - curveKeys[i].Time) * 0.25f;
                            if (dTime <= float.Epsilon)
                            {
                                continue;
                            }

                            for (float time = curveKeys[i].Time; time <= curveKeys[i + 1].Time; time += dTime)
                            {
                                float val = curveKeys[i].OwnerIAnmCurve.Evaluate(time);

                                minT = Math.Min(time, minT);
                                maxT = Math.Max(time, maxT);

                                minV = Math.Min(val, minV);
                                maxV = Math.Max(val, maxV);
                            }
                        }
                    }
                }

                _ctlGraphView.SetViewParamaters( minT, maxT, minV, maxV, 0.8f );
            }
        }

        /// <summary>
        /// カーブ全体を表示
        /// </summary>
        private void Event_MniViewAll_Click( object sender, EventArgs e )
        {
            // キーセットを含むようにビューを設定します。
            SetViewContainsKeySet_( _TargetKeyFrameSet );
        }

        /// <summary>
        /// 選択範囲全体を表示
        /// </summary>
        private void Event_MiViewSelectAll_Click( object sender, System.EventArgs e )
        {

            IAnmKeyFrame[] selKeys = _SelectedKeyFrameSet;

            // 選択キーが存在しない場合は、操作対象すべてのキーで...
            if( selKeys.Length == 0 )
            {
                selKeys = _TargetKeyFrameSet;
            }

            // キーセットを含むようにビューを設定します。
            SetViewContainsKeySet_( selKeys );
        }

        /// <summary>
        /// 再生範囲を表示
        /// </summary>
        private void Event_MiViewAnimRange_Click(object sender, System.EventArgs e)
        {
            var time = GlobalTime.Inst;
            _ctlGraphView.SetViewParamatersH(time.AnimPlayStartTime, time.AnimPlayEndTime, 0.8f);
        }

        /// <summary>
        /// 現在時間を中央に表示
        /// </summary>
        private void Event_MiViewCurrentTimeCenter_Click(object sender, System.EventArgs e)
        {
            var time = GlobalTime.Inst;
            float halfTimeRange = _ctlGraphView.ViewRangeInGraphSpace * 0.5f;
            _ctlGraphView.SetViewParamatersH(time.Time - halfTimeRange, time.Time + halfTimeRange, 1.0f);
        }

        /// <summary>
        /// キー領域外の描画
        /// </summary>
        private void Event_MniDrawInfinity_Click( object sender, EventArgs e )
        {
            ToolStripMenuItem mi = sender as ToolStripMenuItem;

            // フラグを判定して、設定します。
            mi.Checked = !mi.Checked;
            _ctlGraphView.DrawInifinity = mi.Checked;
        }

        /// <summary>
        /// ズームイン
        /// </summary>
        private void Event_MniZoomIn_Click( object sender, EventArgs e )
        {
            _ctlGraphView.ZoomViewScale();
        }

        /// <summary>
        /// ズームアウト
        /// </summary>
        private void Event_MniZoomOut_Click( object sender, EventArgs e )
        {
            _ctlGraphView.PanViewScale();
        }

#endregion

#region カーブ関連
        /// <summary>
        /// 先頭キー以前の値
        /// </summary>
        private void Event_MniCurvePreInfinity_Click( object sender, EventArgs e )
        {
            if( _CurrentISubScene == null )
            {
                return;
            }

            ToolStripMenuItem mi = sender as ToolStripMenuItem;

            _CurrentISubScene.BeginMassiveModify();
            foreach( IAnmCurve curve in _TargetCurveSet )
            {
                if( curve.NumKeyFrame > 0 )
                {
                    _anmCurveMnp.BindTarget( curve );
                    _anmCurveMnp.PreInfinity = (AnmCurveInfinityType)mi.Tag;
                }
            }
            _CurrentISubScene.EndMassiveModify();
        }

        /// <summary>
        /// 最終キー以後の値
        /// </summary>
        private void Event_MniCurvePostInfinity_Click( object sender, EventArgs e )
        {
            if( _CurrentISubScene == null )
            {
                return;
            }

            ToolStripMenuItem mi = sender as ToolStripMenuItem;

            _CurrentISubScene.BeginMassiveModify();
            foreach( IAnmCurve curve in _TargetCurveSet )
            {
                if( curve.NumKeyFrame > 0 )
                {
                    _anmCurveMnp.BindTarget( curve );
                    _anmCurveMnp.PostInfinity = (AnmCurveInfinityType)mi.Tag;
                }
            }
            _CurrentISubScene.EndMassiveModify();

        }
#endregion

#region キー関係

        /// <summary>
        /// 更新処理デリゲータ
        /// </summary>
        delegate void ChangeKeyStatusFunc_( AnmKeyFrameManipulator keyMnp, object patams );

        /// <summary>
        /// 選択ペインのパラメータを更新します。
        /// </summary>
        void ChangeSelectedKeyStatus_( ChangeKeyStatusFunc_ ChangeKeyStatusFunc, object patams )
        {
            if( _CurrentISubScene != null )
            {
                _CurrentISubScene.BeginMassiveModify();

                foreach( IAnmKeyFrame key in _SelectedKeyFrameSet )
                {
                    _currentKeyFrameMnp.BindTarget( key );
                    ChangeKeyStatusFunc( _currentKeyFrameMnp, patams );
                }

                foreach( IAnmCurve curve in _TargetCurveSet )
                {
                    _anmCurveMnp.BindTarget( curve );
                    _anmCurveMnp.Update( true );
                }

                _CurrentISubScene.EndMassiveModify();
            }
        }

        /// <summary>
        /// キー作成
        /// </summary>
        private void Event_TdbKey_Click( object sender, EventArgs e )
        {
            CreateKeyFrameOnTargetCurve();
        }

#region スロープ関連
        /// <summary>
        /// 選択キーに対して、左右スロープの同期編集を設定します。
        /// </summary>
        private void Event_MniUnifySlopes_Click( object sender, System.EventArgs e )
        {
            ChangeKeyStatusFunc_ func =
                delegate( AnmKeyFrameManipulator keyMnp, object patams )
                {
                    _currentKeyFrameMnp.UnifyTangents = true;
                };

            ChangeSelectedKeyStatus_( func, null );
        }

        /// <summary>
        /// 選択キーに対して、左右スロープの同期編集を解除します。
        /// </summary>
        private void Event_MniBreakSlopes_Click( object sender, System.EventArgs e )
        {
            ChangeKeyStatusFunc_ func =
                delegate( AnmKeyFrameManipulator keyMnp, object patams )
                {
                    _currentKeyFrameMnp.UnifyTangents = false;
                };

            ChangeSelectedKeyStatus_( func, null );
        }

        /// <summary>
        /// 選択ペインの補間種類を設定します。
        /// </summary>
        void SetInterporationTypeToSelectedKey_( InterporationType type )
        {
            ChangeKeyStatusFunc_ func =
                delegate( AnmKeyFrameManipulator keyMnp, object patams )
                {
                    _currentKeyFrameMnp.InterporationType = (InterporationType)patams;
                    _currentKeyFrameMnp.UpdateSlope();
                };

            ChangeSelectedKeyStatus_( func, type );
        }

        /// <summary>
        /// スロープをスプラインに設定
        /// </summary>
        private void Event_TsbSetSlopeSpline_Click( object sender, EventArgs e )
        {
            SetInterporationTypeToSelectedKey_( InterporationType.Spline );
        }

        /// <summary>
        /// スロープをステップに設定
        /// </summary>
        private void Event_TsbSetSlopeStep_Click( object sender, EventArgs e )
        {
            SetInterporationTypeToSelectedKey_( InterporationType.Step );
        }

        /// <summary>
        /// スロープをゼロに設定します。
        /// </summary>
        private void Event_MniSetSlopeZero_Click( object sender, System.EventArgs e )
        {
            SetInterporationTypeToSelectedKey_( InterporationType.Zero );
        }

        /// <summary>
        /// スロープを線形補間用に設定します。
        /// </summary>
        private void Event_MniSetSlopeLiner_Click( object sender, System.EventArgs e )
        {
            SetInterporationTypeToSelectedKey_( InterporationType.Liner );
        }




#endregion スロープ関連
#endregion

#region 選択関連
        /// <summary>
        /// 選択：ドロップダウン
        /// </summary>
        private void Event_TdbSelect_DropDownOpening( object sender, EventArgs e )
        {
            _tmiShowSelectEnable.Checked = _showSelectedEnable;
        }

        /// <summary>
        /// 選択を自動的に表示
        /// </summary>
        private void Event_TmiShowSelectEnable_Click( object sender, EventArgs e )
        {
            ToolStripMenuItem tmi = sender as ToolStripMenuItem;
            tmi.Checked = !tmi.Checked;

            _showSelectedEnable = tmi.Checked;
        }
#endregion



#endregion --------------- メニュー関連 ---------------

#region --------------- TreeView関連 ---------------

        /// <summary>
        /// 選択前 ハンドラ
        /// ノードの選択状態は独自で管理するため、全てキャンセルします。
        /// </summary>
        private void Event_TvwTargetAttr_BeforeSelect( object sender, TreeViewCancelEventArgs e )
        {
            e.Cancel = true;
        }

        /// <summary>
        /// TreeView マウスダウン
        /// </summary>
        private void Event_TvwTargetAttr_MouseDown( object sender, System.Windows.Forms.MouseEventArgs e )
        {
            // 現在は何もしていません。
        }

#endregion TreeView関連

#region キーイベントハンドラ
        /// <summary>
        /// 修飾キーなし、キーハンドラ
        /// </summary>
        bool ProcessDialogKey_( Keys keyData )
        {
            // キーの挿入
            switch( keyData )
            {
                case Keys.S:
                // 選択中のカーブついて、キー生成を試みます
                CreateKeyFrameOnTargetCurve();
                // 子コントロールの規定の処理をスキップするために、true を返します。
                return true;
            }
            // 処理されなかった。
            return false;
        }

        /// <summary>
        /// 子コントロールに規定の処理が存在する場合は、ここでキー処理を行います。
        ///
        /// MEMO:
        ///
        /// ・TreeViewの規定の実装では S キーの IsInputKey(IsInputChar)
        ///   は flase したがって、特殊キーとして解釈されている。
        ///
        /// ・ここで、子コントロールのIsInputKeyをオーバーライドして、trueを返すようにする。
        ///   （特殊キーとして解釈させないことで、規定の処理をスキップさせることを想定している。）
        ///   しかし、ノード中から、Sで始まるノードを検索する規定の処理は実行されてしまう。
        ///   これを防ぐには、親Formの ProcessKeyPreview()でtrueを返して、子コントロールのキー処理が続行されない様に
        ///   する必要がある。
        ///
        /// ・今回は、親フォームで protected override bool ProcessDialogKey( Keys keyData )を オーバーライドして、
        ///   処理を横取りする。(プリプロセス処理を横取りする。)
        ///   こうすると、子コントロールのIsInputKey()をオーバーライドする必要がないため、
        ///   独自派生クラスを作成しなくてもよい。
        ///
        ///
        ///
        ///   参考：@IT   　
        ///
        ///   .NET TIPS Windowsアプリケーションでキー処理が行われる順序は？
        ///       http://www.atmarkit.co.jp/fdotnet/dotnettips/243winkeyproc/winkeyproc.html
        ///
        /// </summary>
        protected override bool ProcessDialogKey( Keys keyData )
        {
            // 編集不可のときは既定の処理を行います。
            if (!IsEditable)
            {
                return false;
            }

            // テキストボックスにフォーカスがある場合は、規定の処理を行います。
            if( CheckTextBoxFocused_( this ) )
            {
                return false;
            }

            // ズームイン・アウト操作時に、メニュー項目が表示されてしまう
            // のを回避しています。
            if( ( Control.ModifierKeys & Keys.Alt ) != 0 )
            {
                if( LECore.Win32.User32.GetKeyState( LECore.Win32.VK.VK_SPACE ) < 0 )
                {
                    return true;
                }
            }

            switch (keyData)
            {
                case Keys.Back:
                    Event_MniEditDelete_Click(this, EventArgs.Empty);
                    return true;
                case Keys.A:
                    Event_MniViewAll_Click(this, EventArgs.Empty);
                    return true;
                case Keys.F:
                    Event_MiViewSelectAll_Click(this, EventArgs.Empty);
                    return true;
                case Keys.S:
                    // 選択中のカーブついて、キー生成を試みます
                    CreateKeyFrameOnTargetCurve();
                    // 子コントロールの規定の処理をスキップするために、true を返します。
                    return true;
            }

            // 矢印キーは既定の処理を変更します。
            if( (keyData & Keys.KeyCode) == Keys.Up ||
                (keyData & Keys.KeyCode) == Keys.Down ||
                (keyData & Keys.KeyCode) == Keys.Left ||
                (keyData & Keys.KeyCode) == Keys.Right)
            {
                return false;
            }

            bool bDefaultResult = base.ProcessDialogKey( keyData );
            return bDefaultResult;
        }



        /// <summary>
        ///
        /// </summary>
        protected override bool ProcessCmdKey(ref Message msg, Keys keyData)
        {
            // 編集不可のときは既定の処理を行います。
            if (!IsEditable)
            {
                return false;
            }

            // テキストボックスにフォーカスがある場合は、規定の処理を行います。
            if (CheckTextBoxFocused_(this))
            {
                return false;
            }

            switch (keyData)
            {
                case Keys.Delete: // Delete はコマンドキー扱い
                    Event_MniEditDelete_Click(this, EventArgs.Empty);
                    return true;
                default:
                    if (_shortcutHandler.ProcessCmdKey(keyData))
                    {
                        return true;
                    }
                    break;
            }

            return base.ProcessCmdKey(ref msg, keyData);
        }

#endregion キーイベントハンドラ

#region テキストボックス

        /// <summary>
        /// テキストボックス(キー時間)の反映
        /// </summary>
        void ApplyTextBoxKeyTimeToData_()
        {
            if (string.IsNullOrEmpty(_ttbKeyTime.Text))
            {
                return;
            }

            IAnmKeyFrame[] keySet = _SelectedKeyFrameSet;
            if( keySet.Length != 0 )
            {
                _CurrentISubScene.BeginMassiveModify();

                List<IAnmCurve> ownerCurveSet = new List<IAnmCurve>();

                string valueString = _ttbKeyTime.Text.Trim();

                bool isPlusOffset = valueString.StartsWith("+=");
                bool isMuinusOffset = valueString.StartsWith("-=");
                bool isOffset = isPlusOffset || isMuinusOffset;
                valueString = valueString.Replace("=", "");

                // 加算オフセットの場合は、キー位置重複をさけるため、時間 t が大きい順に 処理を行います。
                if(isPlusOffset)
                {
                    keySet = keySet.Reverse().ToArray();
                }

                foreach (IAnmKeyFrame key in keySet)
                {
                    _currentKeyFrameMnp.BindTarget(key);
                    float time;
                    if (float.TryParse(valueString, out time))
                    {
                        _currentKeyFrameMnp.Modify(key.ValueAsFloat, isOffset ? key.Time + time : time);

                        if (!ownerCurveSet.Contains(key.OwnerIAnmCurve))
                        {
                            ownerCurveSet.Add(key.OwnerIAnmCurve);
                        }
                    }
                    else
                    {
                        // もとに戻します。
                        _ttbKeyTime.Text = key.Time.ToString();
                    }
                }

                // キーの持つ主カーブを更新する。
                foreach( IAnmCurve ownerCurve in ownerCurveSet )
                {
                    _anmCurveMnp.BindTarget( ownerCurve );
                    _anmCurveMnp.Update( true );
                }

                _CurrentISubScene.EndMassiveModify();
            }
        }

        /// <summary>
        /// テキストボックス(キー値)を反映
        /// </summary>
        void ApplyTextBoxKeyValueToData_()
        {
            if(string.IsNullOrEmpty(_ttbKeyValue.Value))
            {
                return;
            }

            IAnmKeyFrame[] keySet = _SelectedKeyFrameSet;
            if( keySet.Length != 0 )
            {
                List<IAnmCurve> ownerCurveSet = new List<IAnmCurve>();

                _CurrentISubScene.BeginMassiveModify();

                string valueString = _ttbKeyValue.Text.Trim();
                bool isOffset = valueString.StartsWith("+=") || valueString.StartsWith("-=");
                valueString = valueString.Replace("=", "");
                foreach (IAnmKeyFrame key in keySet)
                {
                    _currentKeyFrameMnp.BindTarget(key);

                    float newValue;
                    if (float.TryParse(valueString, out newValue))
                    {
                        _currentKeyFrameMnp.Modify(isOffset ? key.ValueAsFloat + newValue : newValue, key.Time);
                        if (!ownerCurveSet.Contains(key.OwnerIAnmCurve))
                        {
                            ownerCurveSet.Add(key.OwnerIAnmCurve);
                        }
                    }
                    else
                    {
                        // もとに戻します。
                        _ttbKeyValue.Value = GetKeyValueFormatedText_(key.ValueAsFloat);
                    }
                }

                // キーの持つ主カーブを更新する。
                foreach( IAnmCurve ownerCurve in ownerCurveSet )
                {
                    _anmCurveMnp.BindTarget( ownerCurve );
                    _anmCurveMnp.Update( true );
                }

                _CurrentISubScene.EndMassiveModify();
            }
        }

        /// <summary>
        /// テキストボックス(キー時間)
        /// </summary>
        private void Event_TbxSelKeyTime_ValueChanged( object sender, System.EventArgs e )
        {
            ApplyTextBoxKeyTimeToData_();
        }


        /// <summary>
        /// テキストボックス(キー値)
        /// </summary>
        private void Event_TbxSelKeyValue_ValueChanged( object sender, System.EventArgs e )
        {
            ApplyTextBoxKeyValueToData_();
        }

#endregion テキストボックス

#region キー情報ボタン
        /// <summary>
        /// 前のキー：ボタンハンドラ
        /// </summary>
        private void Event_BtnPrevKey_Click( object sender, System.EventArgs e )
        {
            IAnmKeyFrame[] selKeys = _SelectedKeyFrameSet;

            if( selKeys.Length != 0 )
            {
                IAnmKeyFrame selectedKey = selKeys[0];

                IAnmKeyFrame prevKey = selectedKey.OwnerIAnmCurve.GetPrevKeyFrame( selectedKey );
                if( prevKey != null )
                {
                    _anmCurveMnp.BindTarget( selectedKey.OwnerIAnmCurve );
                    _anmCurveMnp.ResetSelectedSet();
                    _anmCurveMnp.AddSelectedSet( prevKey );
                }
            }
        }

        /// <summary>
        /// 次のキー：ボタンハンドラ
        /// </summary>
        private void Event_BtnNextKey_Click( object sender, System.EventArgs e )
        {
            IAnmKeyFrame[] selKeys = _SelectedKeyFrameSet;


            if( selKeys.Length != 0 )
            {
                IAnmKeyFrame selectedKey = selKeys[0];

                IAnmKeyFrame prevKey = selectedKey.OwnerIAnmCurve.GetNextKeyFrame( selectedKey );
                if( prevKey != null )
                {
                    _anmCurveMnp.BindTarget( selectedKey.OwnerIAnmCurve );
                    _anmCurveMnp.ResetSelectedSet();
                    _anmCurveMnp.AddSelectedSet( prevKey );
                }
            }
        }

#endregion キー情報ボタン

#region マウスモード変更

        /// <summary>
        /// マウスモード変更イベント
        /// </summary>
        void Event_CtlGraphView_OnMouseModeChange( object sender, EventArgs e )
        {

        }

#endregion

#region その他のハンドラ
        /// <summary>
        /// 表示状態変更ハンドラ
        /// </summary>
        private void Event_CurveEditWindow_VisibleChanged( object sender, System.EventArgs e )
        {
            // 必要があれば、UIの再構築を行います。
            if( this.Visible )
            {
                RebuildAttributeTree_( _targetAttrSet._TargetAttributeSet );
            }
        }


        /// <summary>
        /// 選択セットを表示対象に設定する
        /// </summary>
        private void Event_TsbLoadFromSelectedSet_Click( object sender, EventArgs e )
        {
            if( _CurrentISubScene == null )
            {
                return;
            }

            IAnmAttribute[] selectedAttrSet = Array.ConvertAll<IPane, IAnmAttribute>(
                _CurrentISubScene.ISelectedSet.IPaneArray, delegate( IPane srcPane )
            {
                return srcPane as IAnmAttribute;
            } );

            SetTargetAttribute_( selectedAttrSet );
        }

        /// <summary>
        /// 矢印キー移動量の設定
        /// </summary>
        private void Event_TsbSetArrowKeySpeed_Click( object sender, EventArgs e )
        {
            // ダイアログの表示
            ArrowKeySpeedSettingsDlg dlg = _ArrowKeySpeedSettingsDlg;
            dlg.Location = Control.MousePosition;
            dlg.StartPosition = FormStartPosition.CenterParent;

            ArrowKeySpeed aks = _ctlGraphView.ArrowKeySpeedSettings;
            dlg.Set( aks.Enabled, aks._up, aks._down, aks._left, aks._right );

            if( dlg.ShowDialog( this ) == DialogResult.OK )
            {
                _ctlGraphView.ArrowKeySpeedSettings = new ArrowKeySpeed(
                            dlg.SpeedSettingsEnabled,
                            dlg.UpSpeed,
                            dlg.DownSpeed,
                            dlg.LeftSpeed,
                            dlg.RightSpeed );
            }
            _tsbSetArrowKeySpeed.Checked = _ctlGraphView.ArrowKeySpeedSettings.Enabled;
        }

#endregion その他のハンドラ

#endregion // --------------- イベントハンドラ ---------------

#region ILEToolWindow

#region ITimeChageEventListener メンバ

        /// <summary>
        /// 時間変更イベントハンドラ
        /// </summary>
        public override void OnTimeChangedHandler( int time, TimeChageEventType type )
        {
            switch( type )
            {
                case TimeChageEventType.RangeChanged:
                // グラフダイアログ
                SetTimeRange_( GlobalTime.Inst );
                break;
                case TimeChageEventType.Tick:
                UpdateProperty_();
                break;

            }
            base.OnTimeChangedHandler( time, type );
        }

#endregion ITimeChageEventListener メンバ

#region ISceneModifyListener メンバ

        /// <summary>
        /// キーが選択されている、カーブに対応するノードを表示状態に設定します。
        /// 最初に発見されたノードで処理を中断します。
        /// </summary>
        void EnsureVisibleSelectedCurveNode_()
        {
            if( _showSelectedEnable )
            {
                foreach( IAnmAttribute targetCurve in _targetAttrSet._TargetAnmAttributeSet )
                {
                    if( targetCurve.ICurrentAnimationCurve.NumSelectedKey != 0 )
                    {
                        List<TreeNode> nodeSet =
                            _attributeTreeFactory.GetUpdatedNodeByContents( targetCurve );
                        foreach( TreeNode node in nodeSet )
                        {
                            node.EnsureVisible();
                        }
                    }
                }
            }
        }

        /// <summary>
        /// シーン変更イベントハンドラ
        /// </summary>
        public override void OnSceneModifyHandler(
            object sender,
            SceneModifyEventArgs e )
        {
            switch( e.Target )
            {
                // ペイン更新
                case SceneModifyEventArgs.Kind.PaneAnimModify:
                case SceneModifyEventArgs.Kind.PaneAnimAddRemove:
                case SceneModifyEventArgs.Kind.PaneModify:
                {
                    // カーブエディタの更新
                    _tvwTargetAttr.BeginUpdate();

                    // 選択状態を更新します。
                    EnsureVisibleSelectedCurveNode_();

                    _ctlTimeNumLine.SetTraget(_targetAttrSet._TargetCurveSet, _CurrentISubScene?.IAnimFrameSectionSet?.TargetIAnimFrameSection);

                    AttributeTreeAppearanceUpdater.UpdateNodeKeyState(NodeFindFunction_, _targetAttrSet._AllAnmAttributeSet.ToArray());

                    _tvwTargetAttr.EndUpdate();

                    UpdateProperty_();
                    break;
                }
                // アニメーション編集モード変更
                case SceneModifyEventArgs.Kind.PaneAnimModeModify:
                {
                    // カーブエディタの有効無効を更新します
                    UpdateCurveEditorEnable_();

                    // フィッティングボタンの表示/非表示を切り替えます
                    UpdateFittingBtn_(sender as ISubScene);

                    // 前後区間キー表示ボタンの表示/非表示を切り替えます
                    UpdateBeforeAfterKeyBtn_(sender as ISubScene);

                    // ノードツリーを更新します。
                    SelectPaneByNodeSet_(_multiSelectTreeNodeMgr.SelectedNodeSet);

                    _tvwTargetAttr.Invalidate();

                    break;
                }
                // ペインアトリビュート変更
                case SceneModifyEventArgs.Kind.PaneAttrModify:
                {
                    // ノードツリーを更新します。
                    SetTargetAttributeForcibly_( this._targetAttrSet._TargetAttributeSet );
                    break;
                }
                // 選択セット変更ハンドラ
                case SceneModifyEventArgs.Kind.SelectedSetModify:
                {
                    // 選択変更時に、表示対象を更新する必要がある。
                    if( _tsbAutoLoadEnabled.Checked )
                    {
                        IPane[] selSet = e.Paramaters[0] as IPane[];
                        Debug.Assert( selSet != null );

                        List<IAnmAttribute> attrSet = new List<IAnmAttribute>();
                        foreach( IPane pane in selSet )
                        {
                            attrSet.Add( pane as IAnmAttribute );
                        }

                        // 対象を設定します。
                        // 内部でリセットが行われたあと、新たな対象が設定されます。
                        SetTargetAttribute_( attrSet.ToArray() );
                    }
                    else
                    {
                        // 現在のシーンに含まれない対象を消去して、再設定します。
                        List<IAnmAttribute> newAttrSet = new List<IAnmAttribute>( _targetAttrSet._TargetAttributeSet );
                        foreach( IPane pane in _targetAttrSet._TargetAttributeSet )
                        {
                            if (_CurrentISubScene == null ||
                                (pane != null && !_CurrentISubScene.IPaneArray.Contains(pane)))
                            {
                                newAttrSet.Remove( pane as IAnmAttribute );
                            }
                        }

                        if( newAttrSet.Count < _targetAttrSet._TargetAttributeSet.Length )
                        {
                            SetTargetAttribute_( newAttrSet.ToArray() );
                        }
                    }
                    break;
                }
                // カレントサブシーンの変更
                case SceneModifyEventArgs.Kind.CurrentSubSceneChanged:
                {
                    _targetAttrSet.SetTargetAnimFrameSection(null);
                    _ctlGraphView.Invalidate();

                    // フィッティングボタンの表示/非表示を切り替えます
                    UpdateFittingBtn_(_CurrentISubScene);

                    // 前後区間キー表示ボタンの表示/非表示を切り替えます
                    UpdateBeforeAfterKeyBtn_(_CurrentISubScene);

                    // UIの状態を更新します。
                    SetTimeRange_(GlobalTime.Inst);

                    // 編集対象のサブシーンを設定します。
                    _TargetSubScene = _CurrentISubScene;

                    // カーブエディタの有効無効を更新します
                    UpdateCurveEditorEnable_();

                    break;
                }
                case SceneModifyEventArgs.Kind.AnimSectionTagSet:
                case SceneModifyEventArgs.Kind.AnimSectionTagTarget:
                    {
                        if (GlobalTime.Inst.UseTargetFrameSectionRangeAsPlayRange)
                        {
                            // グラフダイアログ
                            SetTimeRange_(GlobalTime.Inst);
                        }

                        _targetAttrSet.SetTargetAnimFrameSection(_TargetSubScene != null ? _TargetSubScene.IAnimFrameSectionSet.TargetIAnimFrameSection : null);
                        _ctlTimeNumLine.SetTraget(_targetAttrSet._TargetCurveSet, _CurrentISubScene?.IAnimFrameSectionSet?.TargetIAnimFrameSection);
                        _ctlGraphView.Invalidate();

                        if (_CurrentISubScene.IsAnimEditSeparateMode())
                        {
                            if (_attributeTreeFactory.AttributeFilters.CurrentFilter != null &&
                                _attributeTreeFactory.AttributeFilters.CurrentFilter.IsUpdateTagChange)
                            {
                                // 対象の更新
                                SetTargetAttributeForcibly_(_targetAttrSet._TargetAttributeSet);
                            }
                            else
                            {
                                // 選択状態の更新
                                _tvwTargetAttr.BeginUpdate();

                                _targetAttrSet.BeginKeySelectChange();
                                _targetAttrSet.ResetSelectKeyAll();
                                _targetAttrSet.EndKeySelectChange();

                                // ツリービュー中のノードの表示を更新
                                AttributeTreeAppearanceUpdater.UpdateNodeKeyState(NodeFindFunction_, _targetAttrSet._AllAnmAttributeSet.ToArray());

                                _tvwTargetAttr.EndUpdate();
                            }
                        }

                        // カーブエディタの有効無効を更新します
                        UpdateCurveEditorEnable_();

                        break;
                    }
                case SceneModifyEventArgs.Kind.ClipBoardModify:
                // 何もしません。
                break;
                default:
                break;
            }
            base.OnSceneModifyHandler( sender, e );
        }

#endregion ISceneModifyListener メンバ

#region IAppEventListener メンバ
        public override void OnAppEvent(object sender, AppEventArgs args)
        {
            UpdateProperty_();
            base.OnAppEvent(sender, args);
        }
#endregion IAppEventListener

#region データ保存

        /// <summary>
        /// 矢印キー移動量についての状態を保存します。
        /// </summary>
        void SaveSettingArrowKeySpeed_( LEToolFormSetting setting, ArrowKeySpeed aks )
        {
            LEControlUserDataChunk data = null;
            data = new LEControlUserDataChunk( "ArrowKeySpeedEnabled", aks.Enabled.ToString() );
            setting.UserDataSet.Add( data );

            data = new LEControlUserDataChunk( "ArrowKeySpeedUp", aks._up.ToString() );
            setting.UserDataSet.Add( data );

            data = new LEControlUserDataChunk( "ArrowKeySpeedDown", aks._down.ToString() );
            setting.UserDataSet.Add( data );

            data = new LEControlUserDataChunk( "ArrowKeySpeedLeft", aks._left.ToString() );
            setting.UserDataSet.Add( data );

            data = new LEControlUserDataChunk( "ArrowKeySpeedRight", aks._right.ToString() );
            setting.UserDataSet.Add( data );
        }

        /// <summary>
        /// アトリビュートフィルタマネージャの状態を保存します。
        /// </summary>
        void SaveSettingAttributeFilter_( LEToolFormSetting setting, AttributeFilterManager afm )
        {
            //-----------------------------------
            // フィルタ名リストを生成します。
            {
                StringBuilder filterNameStr = new StringBuilder();
                foreach (CustomAttributeFilter af in afm.AttributeFilterSet.Where((a) => a is CustomAttributeFilter))
                {
                    filterNameStr.Append(af.Name + '\t');
                }

                var data = new LEControlUserDataChunk("AttributeFilterNameSet", filterNameStr.ToString());
                setting.UserDataSet.Add(data);
            }

            //-----------------------------------
            // フィルタ名リストを生成します。
            foreach (CustomAttributeFilter af in afm.AttributeFilterSet.Where((a) => a is CustomAttributeFilter))
            {
                StringBuilder filterPathStr = new StringBuilder();
                foreach (string filteredPath in af.FilteredPathSet)
                {
                    filterPathStr.Append(filteredPath + '\t');
                }

                string dataChunkName = string.Format("AttributeFilter_{0}", af.Name);
                setting.UserDataSet.Add(new LEControlUserDataChunk(dataChunkName, filterPathStr.ToString()));
            }

            //-----------------------------------
            // 現在のフィルタ。
            if (afm.CurrentFilter != null)
            {
                setting.UserDataSet.Add(new LEControlUserDataChunk("CurrentAttributeFilter", afm.CurrentFilter.Name));
            }
        }

        /// <summary>
        /// 保存(カーブエディタ固有の情報を保存します。)
        /// </summary>
        public override void SaveSetting(LEToolFormSetting setting, SaveSettingOption option)
        {
            if (option.AlsoSaveOtherThanWorkspace)
            {
                // _ctlGraphView.DrawInifinity
                LEControlUserDataChunk data = null;
                data = new LEControlUserDataChunk("DrawInifinity", _ctlGraphView.DrawInifinity.ToString());
                setting.UserDataSet.Add(data);

                data = new LEControlUserDataChunk("AttrTreeViewW", _pnlAttribute.Size.Width.ToString());
                setting.UserDataSet.Add(data);

                data = new LEControlUserDataChunk("ShowSelectedEnable", _showSelectedEnable.ToString());
                setting.UserDataSet.Add(data);

                data = new LEControlUserDataChunk("PasteAsRelativeValue", _bPasteAsRelativeValue.ToString());
                setting.UserDataSet.Add(data);

                data = new LEControlUserDataChunk("ShowActiveOnly", _attributeTreeFactory.ShowActiveOnly.ToString());
                setting.UserDataSet.Add(data);

                data = new LEControlUserDataChunk("OperationMode", _ctlGraphView.MouseTweakMode.ToString());
                setting.UserDataSet.Add(data);

                data = new LEControlUserDataChunk("GraphValueSnap", _ctlGraphView.GraphValueSnap.ToString());
                setting.UserDataSet.Add(data);

                data = new LEControlUserDataChunk("BeforeAfterKeySnap", this.DispBeforeAfterKeyInfo.ToString());
                setting.UserDataSet.Add(data);

                SaveSettingArrowKeySpeed_(setting, _ctlGraphView.ArrowKeySpeedSettings);

                SaveSettingAttributeFilter_(setting, _attributeTreeFactory.AttributeFilters);

                LEToolFormSetting subSetting = new LEToolFormSetting();

                // 時間スケール調整ダイアログ
                _timeScaleEditDlg.SaveSetting(subSetting, option);
                setting.SubSettingData.Add(subSetting);
            }

            base.SaveSetting(setting, option);
        }

        /// <summary>
        /// 矢印キー移動量についての状態を保存します。
        /// </summary>
        void LoadSettingArrowKeySpeed_( LEToolFormSetting setting )
        {
            bool bEnabled;
            float sU, sD;
            int sL, sR;

            setting.TryToFindUserBoolDataByName( "ArrowKeySpeedEnabled", out bEnabled );
            setting.TryToFindUserFloatDataByName( "ArrowKeySpeedUp", out sU );
            setting.TryToFindUserFloatDataByName( "ArrowKeySpeedDown", out sD );
            setting.TryToFindUserIntDataByName( "ArrowKeySpeedLeft", out sL );
            setting.TryToFindUserIntDataByName( "ArrowKeySpeedRight", out sR );

            if( ArrowKeySpeed.CheckParamatersValid( sU, sD, sL, sR ) )
            {
                _ctlGraphView.ArrowKeySpeedSettings = new ArrowKeySpeed( bEnabled, sU, sD, sL, sR );
            }
        }

        /// <summary>
        /// アトリビュートフィルタマネージャの状態を復元します。
        /// </summary>
        void LoadSettingAttributeFilter_( LEToolFormSetting setting )
        {
            AttributeFilterManager afm = _attributeTreeFactory.AttributeFilters;

            // フィルタ名リスト
            string filterNameSet;
            setting.TryToFindUserDataStrByName( "AttributeFilterNameSet", out filterNameSet );

            // フィルタ内容
            string[] filterNames = filterNameSet.Split( '\t' );
            foreach( string filterName in filterNames )
            {
                string dataChunkName = string.Format( "AttributeFilter_{0}", filterName );

                string filterPathStr;
                if( setting.TryToFindUserDataStrByName( dataChunkName, out filterPathStr ) )
                {
                    string[] filterPathSet = filterPathStr.Split( '\t' );
                    afm.Add( filterName, filterPathSet );
                }
            }

            // カレント復元
            string currentFilterName;
            if (setting.TryToFindUserDataStrByName("CurrentAttributeFilter", out currentFilterName))
            {
                var current = afm.FindFilterByName(currentFilterName);
                if (current != null)
                {
                    afm.CurrentFilter = current;
                }
            }
        }

        /// <summary>
        /// 読み込み(カーブエディタ固有の情報を読み込みます。)
        /// </summary
        public override void LoadSetting(LEToolFormSetting setting, LoadSettingOption option)
        {
            base.LoadSetting(setting, option);

            if (option.AlsoLoadOtherThanWorkspace)
            {
                bool bFlag = false;
                if (setting.TryToFindUserBoolDataByName("DrawInifinity", out bFlag))
                {
                    _ctlGraphView.DrawInifinity = bFlag;
                }
                if (setting.TryToFindUserBoolDataByName("ShowActiveOnly", out bFlag))
                {
                    _attributeTreeFactory.ShowActiveOnly = bFlag;
                }
                if (setting.TryToFindUserBoolDataByName("BeforeAfterKeySnap", out bFlag))
                {
                    this.DispBeforeAfterKeyInfo = bFlag;
                }


                LEControlUserDataChunk data = setting.FindUserDataByName("AttrTreeViewW");
                if (data != null)
                {
                    _pnlAttribute.Size = new Size(Int32.Parse(data.Value), _pnlAttribute.Size.Height);
                }

                setting.TryToFindUserBoolDataByName("ShowSelectedEnable", out _showSelectedEnable);
                setting.TryToFindUserBoolDataByName("PasteAsRelativeValue", out _bPasteAsRelativeValue);

                LoadSettingArrowKeySpeed_(setting);
                LoadSettingAttributeFilter_(setting);

                // 時間スケール調整ダイアログ
                LEToolFormSetting dlgSetting = setting.SubSettingData.Find(delegate (LEToolFormSetting subData)
                {
                    return subData.Name == _timeScaleEditDlg.LEWindowName;
                });
                if (dlgSetting != null)
                {
                    _timeScaleEditDlg.LoadSetting(dlgSetting, option);
                }

                // 操作モード
                {
                    string mouseTweakModeStr;
                    if (setting.TryToFindUserDataStrByName("OperationMode", out mouseTweakModeStr))
                    {
                        try
                        {
                            _ctlGraphView.MouseTweakMode = (GraphView.GraphViewMouseTweakMode)Enum.Parse(
                                typeof(GraphView.GraphViewMouseTweakMode), mouseTweakModeStr);
                        }
                        catch
                        {
                            // 失敗したらスルーします。
                        }
                    }

                    UpdateMenu_();
                }

                // 値スナップモード
                {
                    GraphValueSnap snapMode;
                    if (setting.TryToFindUserEnumDataByName<GraphValueSnap>("GraphValueSnap", out snapMode))
                    {
                        _ctlGraphView.GraphValueSnap = snapMode;
                    }
                }
            }

            UpdateProperty_();
        }

        /// <summary>
        /// 有効な項目だけ表示する
        /// </summary>
        private void Event_TmiShowOnlyActive_Click( object sender, EventArgs e )
        {
            ToolStripMenuItem tmi = sender as ToolStripMenuItem;
            tmi.Checked = !tmi.Checked;

            _attributeTreeFactory.ShowActiveOnly = tmi.Checked;

            // 項目ツリーを再構築します。
            SetTargetAttributeForcibly_(_targetAttrSet._TargetAttributeSet);
        }

#endregion データ保存

#region キー挿入モード変更

#endregion キー挿入モード変更

        public override Keys CustomShortcut { get { return Keys.F7; } }


#endregion ILEToolWindow

        /// <summary>
        /// フィルタの新規作成
        /// </summary>
        private void Event_TmiViewFilterAdd_Click( object sender, EventArgs e )
        {
            if (_targetAttrSet._TargetAttributeSet.Length <= 0)
            {
                return;
            }

            // ダイアログを表示して、選択させる。
            CreateAttributeFilterDlg cafd = new CreateAttributeFilterDlg();
            cafd.Setup(_attributeTreeFactory.AttributeFilters, _targetAttrSet );

            if( cafd.ShowDialog() == DialogResult.OK )
            {
                AttributeFilterManager afm = _attributeTreeFactory.AttributeFilters;
                if (afm.CheckValid(cafd.FiltereName, cafd.FilteredAttributeSet))
                {
                    afm.Add(cafd.FiltereName, cafd.FilteredAttributeSet);
                    afm.CurrentFilter = afm.AttributeFilterSet[afm.AttributeFilterSet.Count() - 1];

                    UpdateAttributeFilterComboBox_();
                }
            }
        }

        /// <summary>
        /// フィルタの削除
        /// 現在のフィルタを削除します。
        /// </summary>
        private void Event_TmiViewFilterRemove_Click( object sender, EventArgs e )
        {
            if( _attributeTreeFactory.AttributeFilters.CurrentFilter != null )
            {
                _attributeTreeFactory.AttributeFilters.Remove(
                    _attributeTreeFactory.AttributeFilters.CurrentFilter.Name );
            }
        }

        /// <summary>
        /// フィルタのクリア
        /// </summary>
        private void Event_TmiViewFilterClear_Click( object sender, EventArgs e )
        {
            string caption = StringResMgr.Get( "CURVEEDITOR_MSG_DLG_TITLE" );
            string text = StringResMgr.Get( "CURVEEDITOR_MSG_CLEAR_FILTERSET" );
            // 確認メッセージボックスを表示します。
            if( MessageBox.Show( text, caption, MessageBoxButtons.OKCancel ) == DialogResult.OK )
            {
                _attributeTreeFactory.AttributeFilters.Clear();
            }
        }

        /// <summary>
        /// フィルタリストのインポート
        /// </summary>
        private void Event_TmiViewFilterImport_Click( object sender, EventArgs e )
        {
            OpenFileDialog opd = new OpenFileDialog();
            opd.RestoreDirectory = true;
            opd.InitialDirectory = Environment.GetFolderPath(Environment.SpecialFolder.Desktop);
            opd.FileName = "filter_set";
            opd.DefaultExt = "xml";
            opd.Filter = string.Format("{0}. (*{1})|*{1}| all files (*.*)|*.*", AppConstants.CurveEditorFilterFileDesc, AppConstants.CurveEditorFilterFileExt);

            if( opd.ShowDialog() == DialogResult.OK )
            {
                try
                {
                    XmlSerializer xs = XmlSerializerCache.GetXmlSerializer(typeof(CustomAttributeFilter[]));
                    using (FileStream fs = new FileStream(opd.FileName, FileMode.Open))
                    {
                        var filters = XmlSerializerCache.Deserialize(xs, fs) as CustomAttributeFilter[];
                        if (filters != null)
                        {
                            AttributeFilterManager afm = _attributeTreeFactory.AttributeFilters;
                            foreach (var filter in filters)
                            {
                                if (afm.FindUserFilterByName(filter.Name) != null)
                                {
                                    afm.Remove(filter.Name);
                                }

                                afm.Add(filter.Name, filter.FilteredPathSet);
                            }
                        }
                    }
                }
                catch (Exception exp)
                {
                    MessageBox.Show(exp.ToString());
                }
            }
        }

        /// <summary>
        /// フィルタリストのエクスポート
        /// </summary>
        private void Event_TmiViewFilterExport_Click( object sender, EventArgs e )
        {
            AttributeFilterManager afm = _attributeTreeFactory.AttributeFilters;

            if( afm.AttributeFilterSet.Length > 0 )
            {
                SaveFileDialog sfd = new SaveFileDialog();
                sfd.RestoreDirectory = true;
                sfd.InitialDirectory = Environment.GetFolderPath(Environment.SpecialFolder.Desktop);
                sfd.FileName = "filter_set";
                sfd.DefaultExt = "xml";
                sfd.Filter = string.Format("{0}. (*{1})|*{1}| all files (*.*)|*.*", AppConstants.CurveEditorFilterFileDesc, AppConstants.CurveEditorFilterFileExt);

                if( sfd.ShowDialog() == DialogResult.OK )
                {
                    var filters = _attributeTreeFactory.AttributeFilters.AttributeFilterSet.Where(
                        (f) => f is CustomAttributeFilter).Cast<CustomAttributeFilter>().ToArray();
                    try
                    {
                        XmlSerializer xs = XmlSerializerCache.GetXmlSerializer(typeof(CustomAttributeFilter[]));
                        using (FileStream fs = new FileStream(sfd.FileName, FileMode.Create))
                        {
                            xs.Serialize(fs, filters);
                        }
                    }
                    catch (Exception exp)
                    {
                        MessageBox.Show(exp.ToString());
                    }
                }
            }
        }

        /// <summary>
        /// フィルタコンボボックス：選択インデックス変更
        /// </summary>
        private void Event_CmbUserFilter_SelectedIndexChanged( object sender, EventArgs e )
        {
            AttributeFilterManager afm = _attributeTreeFactory.AttributeFilters;
            if (_cmbUserFilter.SelectedItemData == null)
            {
                int prevIndex = _cmbUserFilter.SelectedIndex;

                // 新規作成を実行
                int preCount = afm.AttributeFilterSet.Count();
                Event_TmiViewFilterAdd_Click(null, null);

                // 新規作成されていなければ古いインデックスを選択する。
                if (afm.AttributeFilterSet.Count() == preCount)
                {
                    if (afm.CurrentFilter == null || afm.CurrentFilter.IsSystemDefault)
                    {
                        _cmbUserFilter.SelectedIndex = -1;
                    }
                    else
                    {
                        _cmbUserFilter.SetSelectedByData(afm.CurrentFilter.Name);
                    }
                }
            }
            else
            {
                // 現在のフィルタを変更
                IAttributeFilter af = afm.FindFilterByName(_cmbUserFilter.SelectedItemData as string);
                if (af != null)
                {
                    afm.CurrentFilter = af;
                }
            }
        }

        /// <summary>
        /// フィルタコンボボックスを更新します。
        /// </summary>
        void UpdateAttributeFilterComboBox_()
        {
            AttributeFilterManager afm = _attributeTreeFactory.AttributeFilters;

            _cmbUserFilter.BeginUpdate();
            _cmbUserFilter.Items.Clear();

            //--------------------------------
            // 登録します。
            IAttributeFilter[] filterSet = afm.AttributeFilterSet;
            for( int i = 0;i < filterSet.Length; i++ )
            {
                if (!filterSet[i].IsSystemDefault)
                {
                    _cmbUserFilter.Items.Add(new UIListControlItem(filterSet[i].Name, filterSet[i].Name));
                }
            }

            // 新規登録用ノード
            _cmbUserFilter.Items.Add(new UIListControlItem(StringResMgr.Get("CURVEEDITOR_FILTER_ADDNEW"), null));

            if ((afm.CurrentFilter is CustomAttributeFilter))
            {
                _cmbUserFilter.SetSelectedByData(afm.CurrentFilter.Name);
            }
            else
            {
                _cmbUserFilter.SelectedIndex = -1;
            }

            _cmbUserFilter.ExpandDropDownWidth();

            _cmbUserFilter.EndUpdate();
        }

        /// <summary>
        /// フィルタ関連：状態更新
        /// </summary>
        private void Event_TmiViewFilter_DropDownOpened( object sender, EventArgs e )
        {
            _tmiViewFilterAdd.Enabled = _targetAttrSet._TargetAttributeSet.Length > 0;
            _tmiViewFilterRemove.Enabled =
                _attributeTreeFactory.AttributeFilters.CurrentFilter != null &&
                _attributeTreeFactory.AttributeFilters.CurrentFilter is CustomAttributeFilter;
            _tmiViewFilterExport.Enabled =
                _attributeTreeFactory.AttributeFilters.AttributeFilterSet.Any((flt) => flt is CustomAttributeFilter);
        }

        /// <summary>
        /// 選択変更に伴って表示項目を更新する：ハンドラ
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void Event_TsbAutoLoadEnabled_CheckStateChanged_( object sender, EventArgs e )
        {
            _tsbLoadFromSelectedSet.Enabled = !_tsbAutoLoadEnabled.Checked;
            _tmiLoadFromSelectedSet.Enabled = !_tsbAutoLoadEnabled.Checked;
        }

        /// <summary>
        /// 再生を停止します。
        /// </summary>
        public void Stop()
        {
            if( _CurrentISubScene == _TargetSubScene )
            {
                //_pnlTimeControl.Stop();
                _ctlPlay.Stop();
            }
        }

        /// <summary>
        /// コンボオーナー描画
        /// </summary>
        private void Event_CmbUserFilter_DrawItem(object sender, DrawItemEventArgs e)
        {
            e.DrawBackground();

            //文字列を描画する
            if (e.Index == -1)
            {
                return;
            }

            string txt = _cmbUserFilter.Items[e.Index].ToString();
            var userFilter = _attributeTreeFactory.AttributeFilters.FindUserFilterByName(txt);
            if (userFilter != null)
            {
                txt = string.Format("{0}[{1}] ",StringResMgr.Get("TAG_CUSTOM"), txt);
            }

            _ownerDrawBrush.Color = Color.DimGray;
            float ym = (e.Bounds.Height - e.Graphics.MeasureString(txt, e.Font).Height) * 0.5f;
            e.Graphics.DrawString(txt, e.Font, _ownerDrawBrush, e.Bounds.X, e.Bounds.Y + ym);
        }

        /// <summary>
        /// マウス操作モード変更
        /// </summary>
        private void Event_tmiOperationModeNormal_Click(object sender, EventArgs e)
        {
            _ctlGraphView.MouseTweakMode = GraphView.GraphViewMouseTweakMode.Normal;
            UpdateMenu_();
        }

        /// <summary>
        /// マウス操作モード変更
        /// </summary>
        private void Event_tmiOperationModeAdd_Click(object sender, EventArgs e)
        {
            _ctlGraphView.MouseTweakMode = GraphView.GraphViewMouseTweakMode.AddKeyToSelectedCurve;
            UpdateMenu_();
        }

        /// <summary>
        /// マウス操作モード変更
        /// </summary>
        private void Event_tmiOperationModeInsert_Click(object sender, EventArgs e)
        {
            _ctlGraphView.MouseTweakMode = GraphView.GraphViewMouseTweakMode.InsertKeyToSelectedCurve;
            UpdateMenu_();
        }

        /// <summary>
        /// マウス操作モード変更
        /// </summary>
        private void Event_tmiOperationModeTewakNear_Click(object sender, EventArgs e)
        {
            _ctlGraphView.MouseTweakMode = GraphView.GraphViewMouseTweakMode.TweakNear;
            UpdateMenu_();
        }

        /// <summary>
        /// フィルタ種類変更イベント
        /// </summary>
        private void Event_FilterRadioButton_CheckedChanged(object sender, EventArgs e)
        {
            var rad = sender as UIRadioButton;
            var filter = rad.Tag as IAttributeFilter;
            var afm = _attributeTreeFactory.AttributeFilters;

            if (filter != null)
            {
                afm.CurrentFilter = filter;
            }
            else
            {
                filter = afm.FindFilterByName(_cmbUserFilter.SelectedItemData as string);
                afm.CurrentFilter = filter;
            }

            UpdateAttributeFilter_();
        }

        /// <summary>
        /// 値スナップモードの変更
        /// </summary>
        private void Event_cmbValueSnap_SelectedIndexChanged(object sender, EventArgs e)
        {
            var selectedItem = _cmbValueSnap.SelectedItem as UIListControlItem;
            if (selectedItem != null)
            {
                var newMode = (GraphValueSnap)selectedItem.Data;
                if (newMode != _ctlGraphView.GraphValueSnap)
                {
                    _ctlGraphView.GraphValueSnap = newMode;
                }
            }
        }

        /// <summary>
        /// フィッティングモードの変更
        /// </summary>
        private void Event_btnFitting_Click(object sender, EventArgs e)
        {
            DoFitting_();
        }

        /// <summary>
        /// フィッティングを行ないます
        /// </summary>
        private void DoFitting_()
        {
            _subSceneMnp.BindTarget(_CurrentISubScene);
            _subSceneMnp.FittingSection();
        }

        /// <summary>
        /// 前後区間キーの表示・非表示
        /// </summary>
        private void Event_btnBeforeAfterKey_Click(object sender, EventArgs e)
        {
            this.DispBeforeAfterKeyInfo = !this.DispBeforeAfterKeyInfo;

            UpdateBeforeAfterKeyBtn_(_CurrentISubScene);
        }

        /// <summary>
        /// 選択したキーを前区間の値にスナップ
        /// </summary>
        private void Event_btnBeforeKeySnap_Click(object sender, EventArgs e)
        {
            _subSceneMnp.BindTarget(_CurrentISubScene);
            _subSceneMnp.SnapBeforeKey(_TargetCurveSet);

            _ctlGraphView.Invalidate();
        }

        /// <summary>
        /// 選択したキーを後区間の値にスナップ
        /// </summary>
        private void Event_btnAfterKeySnap_Click(object sender, EventArgs e)
        {
            _subSceneMnp.BindTarget(_CurrentISubScene);
            _subSceneMnp.SnapAfterKey(_TargetCurveSet);

            _ctlGraphView.Invalidate();
        }

        /// <summary>
        /// タイムラインのドラッグ開始
        /// </summary>
        private void _ctlTimeNumLine_BeginDrag(object sender, EventArgs e)
        {
            if (_ctlPlay.IsPlaying)
            {
                // 一旦とめる
                _ctlPlay.Suspend();
                _IsPlayControlSuspended = true;
            }
        }

        /// <summary>
        /// タイムラインのドラッグ終了
        /// </summary>
        private void _ctlTimeNumLine_EndDrag(object sender, EventArgs e)
        {
            if (_IsPlayControlSuspended)
            {
                // 再開する
                _ctlPlay.Resume();
                _IsPlayControlSuspended = false;
            }
        }
    }
}
