﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Diagnostics;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;

using LayoutEditor.Controls;

using LECore;
using LECore.Util;
using NW4R.ColorPicker;

namespace LayoutEditor.Forms.ToolWindows.ColorSetWindow
{
    using LayoutEditor.Forms.Dialogs;
    using LECore.Structures;

    /// <summary>
    /// カラーピッカーダイアログクラス。
    /// </summary>
    public sealed class ColorPickerOKCancelDialog : LEBaseDlg
    {
        #region デザイナ変数

        private System.Windows.Forms.Timer tmrDisconnect;
        private Button _btnOK;
        private Button _btnCancel;
        private ColorEditPanel ctlColorPicker;
        private UIGuideStringTextBox _tbxComment;
        private Label _lblComment;
        private Label _lblColor;
        private System.ComponentModel.IContainer components;
        #endregion




        #region デザイナコード
        /// <summary>
        /// デザイナ サポートに必要なメソッドです。このメソッドの内容を
        /// コード エディタで変更しないでください。
        /// </summary>
        private void InitializeComponent()
        {
            this.components = new System.ComponentModel.Container();
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager( typeof( ColorPickerOKCancelDialog ) );
            this.tmrDisconnect = new System.Windows.Forms.Timer( this.components );
            this._btnOK = new System.Windows.Forms.Button();
            this._btnCancel = new System.Windows.Forms.Button();
            this._lblComment = new System.Windows.Forms.Label();
            this._lblColor = new System.Windows.Forms.Label();
            this._tbxComment = new LayoutEditor.Controls.UIGuideStringTextBox();
            this.ctlColorPicker = new LayoutEditor.Controls.ColorEditPanel();
            this.SuspendLayout();
            //
            // tmrDisconnect
            //
            this.tmrDisconnect.Interval = 200;
            //
            // _btnOK
            //
            resources.ApplyResources( this._btnOK, "_btnOK" );
            this._btnOK.Name = "_btnOK";
            this._btnOK.UseVisualStyleBackColor = true;
            this._btnOK.Click += new System.EventHandler( this.Event_BtnOK_Click );
            //
            // _btnCancel
            //
            resources.ApplyResources( this._btnCancel, "_btnCancel" );
            this._btnCancel.Name = "_btnCancel";
            this._btnCancel.UseVisualStyleBackColor = true;
            this._btnCancel.Click += new System.EventHandler( this.Event_BtnCancel_Click );
            //
            // _lblComment
            //
            resources.ApplyResources( this._lblComment, "_lblComment" );
            this._lblComment.Name = "_lblComment";
            //
            // _lblColor
            //
            resources.ApplyResources( this._lblColor, "_lblColor" );
            this._lblColor.Name = "_lblColor";
            //
            // _tbxComment
            //
            this._tbxComment.GuideStringColor = System.Drawing.Color.Gray;
            this._tbxComment.GuideText = "DefaultStrings";
            resources.ApplyResources( this._tbxComment, "_tbxComment" );
            this._tbxComment.Name = "_tbxComment";
            //
            // ctlColorPicker
            //
            this.ctlColorPicker.AllowDrop = true;
            resources.ApplyResources( this.ctlColorPicker, "ctlColorPicker" );
            this.ctlColorPicker.Name = "ctlColorPicker";
            //
            // ColorPickerOKCancelDialog
            //
            resources.ApplyResources( this, "$this" );
            this.Controls.Add( this._lblColor );
            this.Controls.Add( this._lblComment );
            this.Controls.Add( this._tbxComment );
            this.Controls.Add( this.ctlColorPicker );
            this.Controls.Add( this._btnCancel );
            this.Controls.Add( this._btnOK );
            this.Name = "ColorPickerOKCancelDialog";
            this.Shown += new System.EventHandler( this.Event_ColorPickerOKCancelDialog_Shown );
            this.FormClosing += new System.Windows.Forms.FormClosingEventHandler( this.Event_ColorPickerDialog_FormClosing );
            this.ResumeLayout( false );
            this.PerformLayout();

        }
        #endregion

        // ダイアログインスタンス＆アダプタ
        private static ColorPickerDialog  _dialog  = null;
        private static ColorPickerAdapter _adapter = null;

        // プロファイル情報
        private static Point   _location    = Point.Empty;
        private static Color[] _customColos = new Color[16];

        static public event EventHandler DialogClose;



        /// <summary>
        /// コンストラクタ。
        /// </summary>
        public ColorPickerOKCancelDialog()
        {
            InitializeComponent();

            // イベント登録
            tmrDisconnect.Tick += new EventHandler(Event_TmrDisconnect_Tick);
            _tbxComment.GuideText = StringResMgr.Get(
                "SYSTEM_TEXTBOX_GUIDE_INPUT",
                StringResMgr.Get( "TAG_COMMENT" ) );
        }

        /// <summary>
        /// カラー。
        /// </summary>
        public FloatColor Color
        {
            get { return ctlColorPicker.Color; }
            set
            {
                if (ctlColorPicker.Color != value)
                {
                    ctlColorPicker.Color = value;
                }
            }
        }

        /// <summary>
        /// コメント
        /// </summary>
        public string Comment
        {
            get { return _tbxComment.Text; }
            set
            {
                _tbxComment.Text = value;
            }
        }


        #region オーバーライド
        /// <summary>
        /// オーバーライド。
        /// </summary>
        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                if (components != null)
                {
                    components.Dispose();
                }
            }
            base.Dispose(disposing);
        }

        /// <summary>
        /// オーバーライド。
        /// </summary>
        protected override bool ProcessCmdKey(ref Message msg, Keys keyData)
        {
            // 既定の処理
            if (base.ProcessCmdKey(ref msg, keyData))
            {
                return true;
            }
           return base.ProcessCmdKey( ref msg, keyData );
            // メインフレームのショートカット処理
            // return TheApp.LayoutWindow.ProcessCommandKey(ref msg, keyData);
        }

        /// <summary>
        /// オーバーライド。
        /// </summary>
        protected override bool ProcessDialogKey(Keys keyData)
        {
            // Escキーで閉じる
            if (keyData == Keys.Escape)
            {
                Close();
            }
            return base.ProcessDialogKey(keyData);
        }

        /// <summary>
        /// オーバーライド。
        /// </summary>
        protected override void WndProc(ref Message m)
        {
            switch (m.Msg)
            {
            case LECore.Win32.WM.WM_MOUSEACTIVATE:
                // アダプタのロストフォーカス処理で切断されないようにする
                // 1:WM_MOUSEACTIVATE (ColorPicker)
                // 2:WM_KILLFOCUS (ColorPickerAdapter)
                // の順にメッセージが届くはず
                if (_adapter != null)
                {
                    _adapter.HandleLostFocus = false;
                }
                break;
            }
            base.WndProc(ref m);
        }

        /// <summary>
        /// オーバーライド。
        /// </summary>
        protected override void OnDeactivate(EventArgs e)
        {
            // Close後も呼ばれるのでインスタンスの有無を見て判断
            if (_dialog != null)
            {
                // 接続解除開始
                if (!tmrDisconnect.Enabled)
                {
                    tmrDisconnect.Start();
                }
            }

            base.OnDeactivate(e);
        }
        #endregion

        #region イベントハンドラ

        /// <summary>
        /// 閉じる途中ハンドラ。
        /// </summary>
        private void Event_ColorPickerDialog_FormClosing( object sender, FormClosingEventArgs e )
        {
            // タイマー停止
            tmrDisconnect.Stop();
            _location = this.DesktopLocation;

            // イベント通知
            if( DialogClose != null )
            {
                DialogClose( this, null );
            }
        }

        /// <summary>
        /// イベントハンドラ。
        /// </summary>
        private void Event_TmrDisconnect_Tick(object sender, EventArgs e)
        {
            Close();
        }

        /// <summary>
        /// OKボタンハンドラ
        /// </summary>
        private void Event_BtnOK_Click( object sender, EventArgs e )
        {
            DialogResult = DialogResult.OK;
        }

        /// <summary>
        /// キャンセルボタンハンドラ
        /// </summary>
        private void Event_BtnCancel_Click( object sender, EventArgs e )
        {
            DialogResult = DialogResult.Cancel;
        }

        /// <summary>
        /// 表示後、初期化ハンドラ
        /// </summary>
        private void Event_ColorPickerOKCancelDialog_Shown( object sender, EventArgs e )
        {
            // イベントは、Load => VisibleChanged => Shown と呼ばれる。
            // Focusの変更は、Shownのタイミングで初めて有効に作用する。
            if( _tbxComment.Text != string.Empty )
            {
                _tbxComment.Focus();
                _tbxComment.SelectAll();
            }
        }

        #endregion











    }
}
